/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.kafka.connect.runtime.isolation.LazyLoadScanner;
import org.apache.kafka.connect.runtime.isolation.PluginClassLoader;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.apache.kafka.connect.runtime.isolation.VersionedPluginLoadingException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(DelegatingClassLoader.class);
    private final ConcurrentMap<String, SortedMap<PluginDesc<?>, ClassLoader>> pluginLoaders;
    private final ConcurrentMap<String, String> aliases;
    private final ConcurrentMap<String, Object> lazyLoadLocks = new ConcurrentHashMap<String, Object>();
    private LazyLoadScanner lazyLoadScanner;

    public DelegatingClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.pluginLoaders = new ConcurrentHashMap();
        this.aliases = new ConcurrentHashMap<String, String>();
    }

    public DelegatingClassLoader() {
        this(DelegatingClassLoader.class.getClassLoader());
    }

    PluginClassLoader pluginClassLoader(String name, VersionRange range) {
        if (!PluginUtils.shouldLoadInIsolation(name)) {
            return null;
        }
        this.lazyLoadIfRequired(name);
        SortedMap inner = (SortedMap)this.pluginLoaders.get(name);
        if (inner == null) {
            return null;
        }
        ClassLoader pluginLoader = this.findPluginLoader(inner, name, range);
        return pluginLoader instanceof PluginClassLoader ? (PluginClassLoader)pluginLoader : null;
    }

    PluginClassLoader pluginClassLoader(String name) {
        return this.pluginClassLoader(name, null);
    }

    ClassLoader loader(String classOrAlias, VersionRange range) {
        String fullName = this.aliases.getOrDefault(classOrAlias, classOrAlias);
        URLClassLoader classLoader = this.pluginClassLoader(fullName, range);
        if (classLoader == null) {
            classLoader = this;
        }
        log.debug("Got plugin class loader: '{}' for connector: {}", (Object)classLoader, (Object)classOrAlias);
        return classLoader;
    }

    ClassLoader loader(String classOrAlias) {
        return this.loader(classOrAlias, null);
    }

    ClassLoader connectorLoader(String connectorClassOrAlias) {
        return this.loader(connectorClassOrAlias);
    }

    String resolveFullClassName(String classOrAlias) {
        return this.aliases.getOrDefault(classOrAlias, classOrAlias);
    }

    String latestVersion(String classOrAlias) {
        if (classOrAlias == null) {
            return null;
        }
        String fullName = this.aliases.getOrDefault(classOrAlias, classOrAlias);
        SortedMap inner = (SortedMap)this.pluginLoaders.get(fullName);
        if (inner == null) {
            return null;
        }
        return ((PluginDesc)inner.lastKey()).version();
    }

    private ClassLoader findPluginLoader(SortedMap<PluginDesc<?>, ClassLoader> loaders, String pluginName, VersionRange range) {
        if (range != null) {
            if (null != range.getRecommendedVersion()) {
                throw new VersionedPluginLoadingException(String.format("A soft version range is not supported for plugin loading, this is an internal error as connect should automatically convert soft ranges to hard ranges. Provided soft version: %s ", range));
            }
            Object version = null;
            ClassLoader loader = null;
            for (Map.Entry<PluginDesc<?>, ClassLoader> entry : loaders.entrySet()) {
                if (!range.containsVersion((ArtifactVersion)entry.getKey().encodedVersion())) continue;
                loader = entry.getValue();
            }
            if (loader == null) {
                List<String> availableVersions = loaders.keySet().stream().map(PluginDesc::version).collect(Collectors.toList());
                throw new VersionedPluginLoadingException(String.format("Plugin %s not found that matches the version range %s, available versions: %s", pluginName, range, availableVersions), availableVersions);
            }
            return loader;
        }
        return (ClassLoader)loaders.get(loaders.lastKey());
    }

    public void installDiscoveredPlugins(PluginScanResult scanResult) {
        Map<String, SortedMap<PluginDesc<?>, ClassLoader>> computedLoaders = DelegatingClassLoader.computePluginLoaders(scanResult);
        computedLoaders.forEach((name, pluginDesc) -> this.pluginLoaders.computeIfAbsent((String)name, k -> new TreeMap()).putAll(pluginDesc));
        for (String pluginClassName : computedLoaders.keySet()) {
            log.info("Added plugin '{}':{}", (Object)pluginClassName, computedLoaders.get(pluginClassName).lastKey());
        }
        Map<String, String> computedAliases = PluginUtils.computeAliases(scanResult);
        this.aliases.putAll(computedAliases);
        for (Map.Entry<String, String> alias : computedAliases.entrySet()) {
            log.info("Added alias '{}' to plugin '{}'", (Object)alias.getKey(), (Object)alias.getValue());
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadVersionedPluginClass(name, null, resolve);
    }

    protected Class<?> loadVersionedPluginClass(String name, VersionRange range, boolean resolve) throws VersionedPluginLoadingException, ClassNotFoundException {
        Class<?> plugin;
        String fullName = this.aliases.getOrDefault(name, name);
        PluginClassLoader pluginLoader = this.pluginClassLoader(fullName, range);
        if (pluginLoader != null) {
            log.trace("Retrieving loaded class '{}' from '{}'", (Object)name, (Object)pluginLoader);
            plugin = pluginLoader.loadClass(fullName, resolve);
        } else {
            plugin = super.loadClass(fullName, resolve);
            if (range == null) {
                return plugin;
            }
            this.verifyClasspathVersionedPlugin(name, plugin, range);
        }
        return plugin;
    }

    private void verifyClasspathVersionedPlugin(String name, Class<?> plugin, VersionRange range) throws VersionedPluginLoadingException {
        SortedMap scannedPlugin = (SortedMap)this.pluginLoaders.get(name);
        if (scannedPlugin == null) {
            throw new VersionedPluginLoadingException(String.format("Plugin %s is not part of Connect's plugin loading mechanism (ClassPath or Plugin Path)", name));
        }
        List classpathPlugins = scannedPlugin.keySet().stream().filter(pluginDesc -> pluginDesc.location().equals("classpath")).collect(Collectors.toList());
        if (classpathPlugins.size() > 1) {
            throw new VersionedPluginLoadingException(String.format("Plugin %s has multiple versions specified in class path, only one version is allowed in class path for loading a plugin with version range", name));
        }
        if (classpathPlugins.isEmpty()) {
            throw new VersionedPluginLoadingException("Invalid plugin found in classpath");
        }
        String pluginVersion = ((PluginDesc)classpathPlugins.get(0)).version();
        if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(pluginVersion))) {
            throw new VersionedPluginLoadingException(String.format("Plugin %s has version %s which does not match the required version range %s", name, pluginVersion, range), Collections.singletonList(pluginVersion));
        }
    }

    private static Map<String, SortedMap<PluginDesc<?>, ClassLoader>> computePluginLoaders(PluginScanResult plugins) {
        HashMap pluginLoaders = new HashMap();
        plugins.forEach(pluginDesc -> pluginLoaders.computeIfAbsent(pluginDesc.className(), k -> new TreeMap()).put(pluginDesc, pluginDesc.loader()));
        return pluginLoaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyLoadIfRequired(String name) {
        if (this.lazyLoadScanner == null || this.lazyLoadScanner.pluginSource(name) == null) {
            return;
        }
        String pluginSourceLocation = this.lazyLoadScanner.pluginSource(name).toString();
        Object lock = this.lazyLoadLocks.putIfAbsent(pluginSourceLocation, new Object());
        Object v = this.lazyLoadLocks.get(pluginSourceLocation);
        synchronized (v) {
            if (lock == null) {
                this.installDiscoveredPlugins(this.lazyLoadScanner.discoverPlugins(name));
            } else {
                log.info("Plugins from locations {} already lazy loaded not reloading the plugin", (Object)pluginSourceLocation);
            }
        }
    }

    public void lazyLoadPlugins(LazyLoadScanner lazyLoadScanner) {
        this.lazyLoadScanner = lazyLoadScanner;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

