/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.events;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.connect.runtime.ConnectMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataPublisherMetrics {
    private static final Logger log = LoggerFactory.getLogger(MetadataPublisherMetrics.class);
    private static volatile MetadataPublisherMetrics instance;
    private final ConnectMetrics.MetricGroup metricGroup;
    private final Map<String, Sensor> taggedSensors = new ConcurrentHashMap<String, Sensor>();

    private MetadataPublisherMetrics(ConnectMetrics connectMetrics) {
        this.metricGroup = connectMetrics.group("metadata-publisher-metrics", new String[0]);
    }

    private Sensor createTaggedOperationsSensor(Map<String, String> tags) {
        String sensorKey = "operations:" + tags.hashCode();
        return this.taggedSensors.computeIfAbsent(sensorKey, key -> {
            Sensor sensor = this.metricGroup.sensor((String)key);
            MetricName metricName = this.metricGroup.metrics().metricName("operations", this.metricGroup.groupId().groupName(), "Metadata publish operations with tags", tags);
            sensor.add(metricName, (MeasurableStat)new CumulativeSum());
            return sensor;
        });
    }

    private Sensor createTaggedLatencySensor(Map<String, String> tags) {
        String sensorKey = "latency:" + tags.hashCode();
        return this.taggedSensors.computeIfAbsent(sensorKey, key -> {
            Sensor sensor = this.metricGroup.sensor((String)key);
            MetricName avgMetricName = this.metricGroup.metrics().metricName("latency-avg", this.metricGroup.groupId().groupName(), "Avg metadata publish latency with tags", tags);
            sensor.add(avgMetricName, (MeasurableStat)new Avg());
            MetricName maxMetricName = this.metricGroup.metrics().metricName("latency-max", this.metricGroup.groupId().groupName(), "Maximum metadata publish latency with tags", tags);
            sensor.add(maxMetricName, (MeasurableStat)new Max());
            double maxTotalTimeMs = 100000.0;
            int totalBucketSizeInBytes = 4000;
            Percentile p50 = new Percentile(this.metricGroup.metrics().metricName("latency-p50", this.metricGroup.groupId().groupName(), "50th percentile metadata publish latency", tags), 50.0);
            Percentile p95 = new Percentile(this.metricGroup.metrics().metricName("latency-p95", this.metricGroup.groupId().groupName(), "95th percentile metadata publish latency", tags), 95.0);
            Percentile p99 = new Percentile(this.metricGroup.metrics().metricName("latency-p99", this.metricGroup.groupId().groupName(), "99th percentile metadata publish latency", tags), 99.0);
            sensor.add((CompoundStat)new Percentiles(totalBucketSizeInBytes, maxTotalTimeMs, Percentiles.BucketSizing.LINEAR, new Percentile[]{p50, p95, p99}));
            return sensor;
        });
    }

    private Sensor createTaggedPayloadSizeSensor(Map<String, String> tags) {
        String sensorKey = "payload-size:" + tags.hashCode();
        return this.taggedSensors.computeIfAbsent(sensorKey, key -> {
            Sensor sensor = this.metricGroup.sensor((String)key);
            MetricName metricName = this.metricGroup.metrics().metricName("payload-size", this.metricGroup.groupId().groupName(), "Metadata publish payload size with tags", tags);
            sensor.add(metricName, (MeasurableStat)new CumulativeSum());
            return sensor;
        });
    }

    public void record(boolean success, String operationType, long latencyMs, String compressionType, int eventCount, int responseCode, long payloadSizeBytes) {
        try {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("operation-type", operationType);
            tags.put("success", String.valueOf(success));
            tags.put("response-code", String.valueOf(responseCode));
            tags.put("compression-type", compressionType != null ? compressionType : "none");
            Sensor taggedOperationsSensor = this.createTaggedOperationsSensor(tags);
            taggedOperationsSensor.record((double)eventCount);
            Sensor taggedLatencySensor = this.createTaggedLatencySensor(tags);
            taggedLatencySensor.record((double)latencyMs);
            Sensor taggedPayloadSizeSensor = this.createTaggedPayloadSizeSensor(tags);
            taggedPayloadSizeSensor.record((double)payloadSizeBytes);
        }
        catch (Exception e) {
            log.debug("Failed to record metrics", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize(ConnectMetrics connectMetrics) {
        if (instance != null) return;
        Class<MetadataPublisherMetrics> clazz = MetadataPublisherMetrics.class;
        synchronized (MetadataPublisherMetrics.class) {
            if (instance != null) return;
            instance = new MetadataPublisherMetrics(connectMetrics);
            log.info("MetadataPublisherMetrics initialized with tagged sensors for operations, latency, and payload size");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static MetadataPublisherMetrics getInstance() {
        if (instance == null) {
            throw new IllegalStateException("MetadataPublisherMetrics not initialized. Call initialize() first.");
        }
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }
}

