/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.CellState;

public class Cell {
    private final int cellId;
    private final Set<Integer> brokers;
    private final CellState cellState;
    private final short minSize;
    private final short maxSize;

    public static int getImplicitBrokerCellId(int brokerId, int cellSize) {
        return brokerId / cellSize;
    }

    public Cell(int cellId, Set<Integer> brokers, CellState state, short minSize, short maxSize) {
        this.cellId = cellId;
        this.brokers = Collections.unmodifiableSet(brokers);
        this.cellState = state;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    public int cellId() {
        return this.cellId;
    }

    public short minSize() {
        return this.minSize;
    }

    public short maxSize() {
        return this.maxSize;
    }

    public CellState state() {
        return this.cellState;
    }

    public Set<Integer> brokers() {
        return this.brokers;
    }

    public List<Integer> brokersList() {
        return this.brokers.stream().sorted().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell that = (Cell)o;
        return this.cellId == that.cellId() && this.minSize == that.minSize() && this.maxSize == that.maxSize() && this.cellState == that.state() && this.brokers.equals(that.brokers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cellId, this.minSize, this.maxSize, this.cellState, this.brokers});
    }

    public String toString() {
        return "Cell{cellId=" + this.cellId + ", brokers=" + this.brokers.toString() + ", state=" + (Object)((Object)this.cellState) + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize + "}";
    }
}

