/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterBrokerHealthRequestData
implements ApiMessage {
    List<Integer> brokerIds;
    String reason;
    byte componentCode;
    byte statusCode;
    boolean force;
    long brokerEpoch;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("broker_ids", new CompactArrayOf(Type.INT32), "The list of brokers to alter health status for."), new Field("reason", Type.COMPACT_STRING, "A unique tagged explanation for altering a broker's health."), new Field("status_code", Type.INT8, "What health status we want to set the broker to. One of DEGRADED (0) or HEALTHY (1)."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("broker_ids", new CompactArrayOf(Type.INT32), "The list of brokers to alter health status for."), new Field("reason", Type.COMPACT_STRING, "A unique tagged explanation for altering a broker's health."), new Field("status_code", Type.INT8, "What health status we want to set the broker to. One of DEGRADED (0) or HEALTHY (1)."), new Field("force", Type.BOOLEAN, "Apply the new state forcefully and ignore validation failures. Ex: It can be used to force demotion when the configured limit has been reached."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 5;

    public AlterBrokerHealthRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterBrokerHealthRequestData() {
        this.brokerIds = new ArrayList<Integer>(0);
        this.reason = "";
        this.componentCode = 0;
        this.statusCode = 0;
        this.force = false;
        this.brokerEpoch = -1L;
    }

    @Override
    public short apiKey() {
        return 10019;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokerIds was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.brokerIds = newCollection;
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field reason was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field reason had invalid length " + length);
        }
        this.reason = _readable.readString(length);
        this.componentCode = _version >= 2 ? _readable.readByte() : (byte)0;
        this.statusCode = _readable.readByte();
        this.force = _version >= 1 ? _readable.readByte() != 0 : false;
        this.brokerEpoch = -1L;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block4: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 10000: {
                    if (_version >= 5) {
                        this.brokerEpoch = _readable.readLong();
                        continue block4;
                    }
                    throw new RuntimeException("Tag 10000 is not valid for version " + _version);
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.brokerIds.size() + 1);
        for (Integer brokerIdsElement : this.brokerIds) {
            _writable.writeInt(brokerIdsElement);
        }
        byte[] _stringBytes = _cache.getSerializedValue(this.reason);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        if (_version >= 2) {
            _writable.writeByte(this.componentCode);
        } else if (this.componentCode != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default componentCode at version " + _version);
        }
        _writable.writeByte(this.statusCode);
        if (_version >= 1) {
            _writable.writeByte(this.force ? (byte)1 : 0);
        }
        if (_version >= 5 && this.brokerEpoch != -1L) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, 10000);
        if (_version >= 5 && this.brokerEpoch != -1L) {
            _writable.writeUnsignedVarint(10000);
            _writable.writeUnsignedVarint(8);
            _writable.writeLong(this.brokerEpoch);
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.brokerIds.size() + 1));
        _size.addBytes(this.brokerIds.size() * 4);
        byte[] _stringBytes = this.reason.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'reason' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.reason, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        if (_version >= 2) {
            _size.addBytes(1);
        }
        _size.addBytes(1);
        if (_version >= 1) {
            _size.addBytes(1);
        }
        if (_version >= 5 && this.brokerEpoch != -1L) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(8);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterBrokerHealthRequestData)) {
            return false;
        }
        AlterBrokerHealthRequestData other = (AlterBrokerHealthRequestData)obj;
        if (this.brokerIds == null ? other.brokerIds != null : !this.brokerIds.equals(other.brokerIds)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        if (this.componentCode != other.componentCode) {
            return false;
        }
        if (this.statusCode != other.statusCode) {
            return false;
        }
        if (this.force != other.force) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.brokerIds == null ? 0 : this.brokerIds.hashCode());
        hashCode = 31 * hashCode + (this.reason == null ? 0 : this.reason.hashCode());
        hashCode = 31 * hashCode + this.componentCode;
        hashCode = 31 * hashCode + this.statusCode;
        hashCode = 31 * hashCode + (this.force ? 1231 : 1237);
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        return hashCode;
    }

    @Override
    public AlterBrokerHealthRequestData duplicate() {
        AlterBrokerHealthRequestData _duplicate = new AlterBrokerHealthRequestData();
        ArrayList<Integer> newBrokerIds = new ArrayList<Integer>(this.brokerIds.size());
        for (Integer _element : this.brokerIds) {
            newBrokerIds.add(_element);
        }
        _duplicate.brokerIds = newBrokerIds;
        _duplicate.reason = this.reason;
        _duplicate.componentCode = this.componentCode;
        _duplicate.statusCode = this.statusCode;
        _duplicate.force = this.force;
        _duplicate.brokerEpoch = this.brokerEpoch;
        return _duplicate;
    }

    public String toString() {
        return "AlterBrokerHealthRequestData(brokerIds=" + MessageUtil.deepToString(this.brokerIds.iterator()) + ", reason=" + (this.reason == null ? "null" : "'" + this.reason.toString() + "'") + ", componentCode=" + this.componentCode + ", statusCode=" + this.statusCode + ", force=" + (this.force ? "true" : "false") + ", brokerEpoch=" + this.brokerEpoch + ")";
    }

    public List<Integer> brokerIds() {
        return this.brokerIds;
    }

    public String reason() {
        return this.reason;
    }

    public byte componentCode() {
        return this.componentCode;
    }

    public byte statusCode() {
        return this.statusCode;
    }

    public boolean force() {
        return this.force;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterBrokerHealthRequestData setBrokerIds(List<Integer> v) {
        this.brokerIds = v;
        return this;
    }

    public AlterBrokerHealthRequestData setReason(String v) {
        this.reason = v;
        return this;
    }

    public AlterBrokerHealthRequestData setComponentCode(byte v) {
        this.componentCode = v;
        return this;
    }

    public AlterBrokerHealthRequestData setStatusCode(byte v) {
        this.statusCode = v;
        return this;
    }

    public AlterBrokerHealthRequestData setForce(boolean v) {
        this.force = v;
        return this;
    }

    public AlterBrokerHealthRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("broker_ids", new CompactArrayOf(Type.INT32), "The list of brokers to alter health status for."), new Field("reason", Type.COMPACT_STRING, "A unique tagged explanation for altering a broker's health."), new Field("component_code", Type.INT8, "Which component of broker health we want to modify. One of UNSPECIFIED (0), STORAGE (1), NETWORK (2), or EXTERNAL_CONNECTIVITY_STARTUP (3)."), new Field("status_code", Type.INT8, "What health status we want to set the broker to. One of DEGRADED (0) or HEALTHY (1)."), new Field("force", Type.BOOLEAN, "Apply the new state forcefully and ignore validation failures. Ex: It can be used to force demotion when the configured limit has been reached."), Field.TaggedFieldsSection.of(new Object[0])));
        SCHEMA_5 = new Schema(new Field("broker_ids", new CompactArrayOf(Type.INT32), "The list of brokers to alter health status for."), new Field("reason", Type.COMPACT_STRING, "A unique tagged explanation for altering a broker's health."), new Field("component_code", Type.INT8, "Which component of broker health we want to modify. One of UNSPECIFIED (0), STORAGE (1), NETWORK (2), or EXTERNAL_CONNECTIVITY_STARTUP (3)."), new Field("status_code", Type.INT8, "What health status we want to set the broker to. One of DEGRADED (0) or HEALTHY (1)."), new Field("force", Type.BOOLEAN, "Apply the new state forcefully and ignore validation failures. Ex: It can be used to force demotion when the configured limit has been reached."), Field.TaggedFieldsSection.of(10000, new Field("broker_epoch", Type.INT64, "The broker epoch assigned by the controller.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }
}

