/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AssignTenantsToCellRequestData
implements ApiMessage {
    List<TenantToCellAssignment> tenantsToAssign;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("tenants_to_assign", new CompactArrayOf(TenantToCellAssignment.SCHEMA_0), "List of tenant to cell assignments, this is an incremental request, given list of tenants would be added to the existing list of the tenants of the given cells."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("tenants_to_assign", new CompactArrayOf(TenantToCellAssignment.SCHEMA_1), "List of tenant to cell assignments, this is an incremental request, given list of tenants would be added to the existing list of the tenants of the given cells."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public AssignTenantsToCellRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AssignTenantsToCellRequestData() {
        this.tenantsToAssign = new ArrayList<TenantToCellAssignment>(0);
    }

    @Override
    public short apiKey() {
        return 10031;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field tenantsToAssign was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TenantToCellAssignment> newCollection = new ArrayList<TenantToCellAssignment>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TenantToCellAssignment(_readable, _version, _context));
        }
        this.tenantsToAssign = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.tenantsToAssign.size() + 1);
        for (TenantToCellAssignment tenantsToAssignElement : this.tenantsToAssign) {
            tenantsToAssignElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.tenantsToAssign.size() + 1));
        for (TenantToCellAssignment tenantsToAssignElement : this.tenantsToAssign) {
            tenantsToAssignElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AssignTenantsToCellRequestData)) {
            return false;
        }
        AssignTenantsToCellRequestData other = (AssignTenantsToCellRequestData)obj;
        if (this.tenantsToAssign == null ? other.tenantsToAssign != null : !this.tenantsToAssign.equals(other.tenantsToAssign)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.tenantsToAssign == null ? 0 : this.tenantsToAssign.hashCode());
        return hashCode;
    }

    @Override
    public AssignTenantsToCellRequestData duplicate() {
        AssignTenantsToCellRequestData _duplicate = new AssignTenantsToCellRequestData();
        ArrayList<TenantToCellAssignment> newTenantsToAssign = new ArrayList<TenantToCellAssignment>(this.tenantsToAssign.size());
        for (TenantToCellAssignment _element : this.tenantsToAssign) {
            newTenantsToAssign.add(_element.duplicate());
        }
        _duplicate.tenantsToAssign = newTenantsToAssign;
        return _duplicate;
    }

    public String toString() {
        return "AssignTenantsToCellRequestData(tenantsToAssign=" + MessageUtil.deepToString(this.tenantsToAssign.iterator()) + ")";
    }

    public List<TenantToCellAssignment> tenantsToAssign() {
        return this.tenantsToAssign;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AssignTenantsToCellRequestData setTenantsToAssign(List<TenantToCellAssignment> v) {
        this.tenantsToAssign = v;
        return this;
    }

    public static class TenantToCellAssignment
    implements Message {
        String tenantId;
        int cellId;
        List<Integer> cellIds;
        boolean force;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("tenant_id", Type.COMPACT_STRING, "The unique id of the tenant"), new Field("cell_id", Type.INT32, "The unique id of the cell."), new Field("force", Type.BOOLEAN, "Assign the tenant even if it is being assigned to or from quarantined cells, default value is set to false"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("tenant_id", Type.COMPACT_STRING, "The unique id of the tenant"), new Field("cell_ids", new CompactArrayOf(Type.INT32), "The ids of the cells where tenant is to be assigned."), new Field("force", Type.BOOLEAN, "Assign the tenant even if it is being assigned to or from quarantined cells, default value is set to false"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public TenantToCellAssignment(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TenantToCellAssignment() {
            this.tenantId = "";
            this.cellId = 0;
            this.cellIds = new ArrayList<Integer>(0);
            this.force = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TenantToCellAssignment");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field tenantId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field tenantId had invalid length " + length);
            }
            this.tenantId = _readable.readString(length);
            this.cellId = _version <= 0 ? _readable.readInt() : 0;
            if (_version >= 1) {
                int arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field cellIds was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.cellIds = newCollection;
            } else {
                this.cellIds = new ArrayList<Integer>(0);
            }
            this.force = _readable.readByte() != 0;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.tenantId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version <= 0) {
                _writable.writeInt(this.cellId);
            } else if (this.cellId != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default cellId at version " + _version);
            }
            if (_version >= 1) {
                _writable.writeUnsignedVarint(this.cellIds.size() + 1);
                _stringBytes = this.cellIds.iterator();
                while (_stringBytes.hasNext()) {
                    Integer cellIdsElement = (Integer)_stringBytes.next();
                    _writable.writeInt(cellIdsElement);
                }
            } else if (!this.cellIds.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default cellIds at version " + _version);
            }
            _writable.writeByte(this.force ? (byte)1 : 0);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TenantToCellAssignment");
            }
            byte[] _stringBytes = this.tenantId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'tenantId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.tenantId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (_version <= 0) {
                _size.addBytes(4);
            }
            if (_version >= 1) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.cellIds.size() + 1));
                _size.addBytes(this.cellIds.size() * 4);
            }
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TenantToCellAssignment)) {
                return false;
            }
            TenantToCellAssignment other = (TenantToCellAssignment)obj;
            if (this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId)) {
                return false;
            }
            if (this.cellId != other.cellId) {
                return false;
            }
            if (this.cellIds == null ? other.cellIds != null : !this.cellIds.equals(other.cellIds)) {
                return false;
            }
            if (this.force != other.force) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.tenantId == null ? 0 : this.tenantId.hashCode());
            hashCode = 31 * hashCode + this.cellId;
            hashCode = 31 * hashCode + (this.cellIds == null ? 0 : this.cellIds.hashCode());
            hashCode = 31 * hashCode + (this.force ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public TenantToCellAssignment duplicate() {
            TenantToCellAssignment _duplicate = new TenantToCellAssignment();
            _duplicate.tenantId = this.tenantId;
            _duplicate.cellId = this.cellId;
            ArrayList<Integer> newCellIds = new ArrayList<Integer>(this.cellIds.size());
            for (Integer _element : this.cellIds) {
                newCellIds.add(_element);
            }
            _duplicate.cellIds = newCellIds;
            _duplicate.force = this.force;
            return _duplicate;
        }

        public String toString() {
            return "TenantToCellAssignment(tenantId=" + (this.tenantId == null ? "null" : "'" + this.tenantId.toString() + "'") + ", cellId=" + this.cellId + ", cellIds=" + MessageUtil.deepToString(this.cellIds.iterator()) + ", force=" + (this.force ? "true" : "false") + ")";
        }

        public String tenantId() {
            return this.tenantId;
        }

        public int cellId() {
            return this.cellId;
        }

        public List<Integer> cellIds() {
            return this.cellIds;
        }

        public boolean force() {
            return this.force;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TenantToCellAssignment setTenantId(String v) {
            this.tenantId = v;
            return this;
        }

        public TenantToCellAssignment setCellId(int v) {
            this.cellId = v;
            return this;
        }

        public TenantToCellAssignment setCellIds(List<Integer> v) {
            this.cellIds = v;
            return this;
        }

        public TenantToCellAssignment setForce(boolean v) {
            this.force = v;
            return this;
        }
    }
}

