/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.common.message.AlterCellMigrationRequestData;
import org.apache.kafka.common.message.AlterCellResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterCellResponse;
import org.apache.kafka.common.requests.ApiError;

public class AlterCellMigrationRequest
extends AbstractRequest {
    private final AlterCellMigrationRequestData data;

    AlterCellMigrationRequest(AlterCellMigrationRequestData data, short version) {
        super(ApiKeys.ALTER_CELL_MIGRATION, version);
        this.data = data;
    }

    @Override
    public AlterCellMigrationRequestData data() {
        return this.data;
    }

    public byte state() {
        return this.data.state();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t) {
        ApiError apiError = ApiError.fromThrowable(t);
        return new AlterCellResponse(new AlterCellResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
    }

    public static AlterCellMigrationRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AlterCellMigrationRequest(new AlterCellMigrationRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterCellMigrationRequest> {
        private final AlterCellMigrationRequestData data;

        public Builder() {
            super(ApiKeys.ALTER_CELL_MIGRATION);
            this.data = new AlterCellMigrationRequestData();
        }

        public Builder(AlterCellMigrationRequestData data) {
            super(ApiKeys.ALTER_CELL_MIGRATION);
            this.data = data;
        }

        public Builder setState(CellMigrationState state) {
            this.data.setState(state.code());
            return this;
        }

        @Override
        public AlterCellMigrationRequest build(short version) {
            return new AlterCellMigrationRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

