/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import java.util.Iterator;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.server.quota.ClientQuotaClusterDescriber;

public class ZkClientQuotaClusterDescriber
implements ClientQuotaClusterDescriber {
    private final Cluster cluster;

    public ZkClientQuotaClusterDescriber(Cluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public Iterator<String> topicNames() {
        return this.cluster.topics().iterator();
    }

    @Override
    public Iterator<ClientQuotaClusterDescriber.Partition> partitionsForTopic(String topicName) {
        return new PartitionIterator(this.cluster.partitionsForTopic(topicName).iterator());
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public static class PartitionIterator
    implements Iterator<ClientQuotaClusterDescriber.Partition> {
        private final Iterator<PartitionInfo> iterator;

        public PartitionIterator(Iterator<PartitionInfo> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ClientQuotaClusterDescriber.Partition next() {
            PartitionInfo partitionInfo = this.iterator.next();
            int leaderId = partitionInfo.leader() == null ? -1 : partitionInfo.leader().id();
            return new ClientQuotaClusterDescriber.Partition(partitionInfo.partition(), leaderId);
        }
    }
}

