/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.Confluent;

public class NewPartitionReassignment {
    private final List<Integer> targetReplicas;
    private final List<Integer> targetObservers;

    @Confluent
    public static NewPartitionReassignment ofReplicasAndObservers(List<Integer> replicas, List<Integer> observers) {
        return new NewPartitionReassignment(replicas, observers);
    }

    public NewPartitionReassignment(List<Integer> targetReplicas) {
        this(targetReplicas, Collections.emptyList());
    }

    private NewPartitionReassignment(List<Integer> targetReplicas, List<Integer> targetObservers) {
        if (targetReplicas == null || targetReplicas.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a new partition reassignment without any replicas");
        }
        if (targetObservers == null) {
            throw new IllegalArgumentException("Cannot create a new partition reassignment with null observers");
        }
        this.targetReplicas = Collections.unmodifiableList(new ArrayList<Integer>(targetReplicas));
        this.targetObservers = Collections.unmodifiableList(new ArrayList<Integer>(targetObservers));
    }

    public List<Integer> targetReplicas() {
        return this.targetReplicas;
    }

    @Confluent
    public List<Integer> targetObservers() {
        return this.targetObservers;
    }
}

