/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.common.message.DeleteTenantsRequestData;
import org.apache.kafka.common.message.DeleteTenantsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DeleteTenantsResponse;

public class DeleteTenantsRequest
extends AbstractRequest {
    private final DeleteTenantsRequestData data;

    DeleteTenantsRequest(DeleteTenantsRequestData data, short version) {
        super(ApiKeys.DELETE_TENANTS, version);
        this.validate(data);
        this.data = data;
    }

    List<String> getTenants() {
        return this.data.tenants();
    }

    @Override
    public DeleteTenantsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t2) {
        ApiError err = ApiError.fromThrowable(t2);
        return new DeleteTenantsResponse(new DeleteTenantsResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(err.error().code()).setErrorMessage(err.message()));
    }

    public static DeleteTenantsRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DeleteTenantsRequest(new DeleteTenantsRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    private void validate(DeleteTenantsRequestData data) {
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteTenantsRequest> {
        private final DeleteTenantsRequestData data;

        public Builder() {
            super(ApiKeys.DELETE_TENANTS);
            this.data = new DeleteTenantsRequestData();
        }

        public Builder(DeleteTenantsRequestData data) {
            super(ApiKeys.DELETE_TENANTS);
            this.data = data;
        }

        public Builder setTenants(List<String> tenants) {
            this.data.setTenants(tenants);
            return this;
        }

        @Override
        public DeleteTenantsRequest build(short version) {
            return new DeleteTenantsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

