/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;

public class TenantRequestSensors {
    private final Sensor requestRate;

    public TenantRequestSensors(Sensor requestRate) {
        this.requestRate = requestRate;
    }

    public void recordRequest(long currentTimeMs) {
        this.requestRate.record(1.0, currentTimeMs, false);
    }

    public boolean requestSensorsExpired(Metrics metrics) {
        return TenantRequestSensors.isExpired(metrics, this.requestRate);
    }

    public static boolean isExpired(Metrics metrics, Sensor sensor) {
        return metrics.getSensor(sensor.name()) != sensor;
    }
}

