/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.auth.plain;

import io.confluent.kafka.security.auth.plain.DynamicPlainCredential;
import io.confluent.kafka.security.auth.plain.DynamicPlainLoginCallbackHandler;
import io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.JaasContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DynamicPlainLoginModuleTest {
    private final Subject subject = new Subject();
    private final DynamicPlainLoginCallbackHandler loginCallbackHandler = new DynamicPlainLoginCallbackHandler();
    private final DynamicPlainLoginModule loginModule = new DynamicPlainLoginModule();
    private DynamicPlainCredential credential = this.credential("alice", "alice-password");
    private JaasContext jaasContext;

    @BeforeEach
    public void setup() {
        String jaasConfig = "io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule required username_config=\"test.username\" password_config=\"test.password\";";
        this.jaasContext = JaasContext.loadClientContext(Collections.singletonMap("sasl.jaas.config", new Password(jaasConfig)));
        this.loginCallbackHandler.configure(this.credentialConfigs(this.credential), "PLAIN", this.jaasContext.configurationEntries());
    }

    @Test
    public void testLoginSequence() throws Exception {
        Assertions.assertThrows(IllegalStateException.class, () -> ((DynamicPlainLoginModule)this.loginModule).login());
        Assertions.assertThrows(IllegalStateException.class, () -> ((DynamicPlainLoginModule)this.loginModule).commit());
        Assertions.assertEquals(Collections.emptySet(), this.subject.getPrivateCredentials());
        Assertions.assertTrue(() -> ((DynamicPlainLoginModule)this.loginModule).logout());
        Assertions.assertTrue((boolean)this.loginModule.abort());
        Map<String, ?> options = this.jaasOptions();
        this.loginModule.initialize(this.subject, (CallbackHandler)this.loginCallbackHandler, Collections.emptyMap(), options);
        Assertions.assertEquals(Collections.emptySet(), this.subject.getPrivateCredentials());
        Assertions.assertThrows(IllegalStateException.class, () -> this.loginModule.initialize(this.subject, (CallbackHandler)this.loginCallbackHandler, Collections.emptyMap(), options));
        this.loginModule.login();
        Assertions.assertEquals(Collections.emptySet(), this.subject.getPrivateCredentials());
        Assertions.assertThrows(IllegalStateException.class, () -> ((DynamicPlainLoginModule)this.loginModule).login());
        this.loginModule.commit();
        this.verifyCredential(this.credential);
        Assertions.assertThrows(IllegalStateException.class, () -> ((DynamicPlainLoginModule)this.loginModule).commit());
        Assertions.assertThrows(IllegalStateException.class, () -> ((DynamicPlainLoginModule)this.loginModule).login());
        Assertions.assertTrue((boolean)this.loginModule.abort());
        this.loginModule.logout();
        Assertions.assertTrue(() -> ((DynamicPlainLoginModule)this.loginModule).logout());
        Assertions.assertTrue((boolean)this.loginModule.abort());
        Assertions.assertThrows(IllegalStateException.class, () -> ((DynamicPlainLoginModule)this.loginModule).commit());
        this.verifyCredential(this.credential);
        this.loginModule.login();
        this.verifyCredential(this.credential);
        this.loginModule.abort();
        this.verifyCredential(this.credential);
        Assertions.assertThrows(IllegalStateException.class, () -> ((DynamicPlainLoginModule)this.loginModule).commit());
        this.loginModule.login();
        this.loginModule.commit();
        this.verifyCredential(this.credential);
    }

    @Test
    public void testCredentialRotation() throws Exception {
        Map<String, ?> options = this.jaasOptions();
        this.loginModule.initialize(this.subject, (CallbackHandler)this.loginCallbackHandler, Collections.emptyMap(), options);
        this.loginModule.login();
        this.loginModule.commit();
        this.verifyCredential(this.credential);
        DynamicPlainCredential oldCredential = this.credential;
        this.credential = this.credential("bob", "bob-password");
        this.loginCallbackHandler.reconfigure(this.credentialConfigs(this.credential));
        this.loginModule.logout();
        this.verifyCredential(oldCredential);
        this.loginModule.login();
        this.verifyCredential(oldCredential);
        this.loginModule.commit();
        this.verifyCredential(this.credential);
    }

    private void verifyCredential(DynamicPlainCredential credential) {
        Assertions.assertEquals(Collections.emptySet(), this.subject.getPublicCredentials());
        Assertions.assertEquals(Collections.singleton(credential), this.subject.getPrivateCredentials());
        Assertions.assertEquals(Collections.singleton(credential), this.subject.getPrivateCredentials(DynamicPlainCredential.class));
    }

    private Map<String, ?> jaasOptions() {
        return ((AppConfigurationEntry)this.jaasContext.configurationEntries().get(0)).getOptions();
    }

    private Map<String, String> credentialConfigs(DynamicPlainCredential credential) {
        HashMap<String, String> configs = new HashMap<String, String>(2);
        configs.put("test.username", credential.username());
        configs.put("test.password", new String(credential.password()));
        return configs;
    }

    private DynamicPlainCredential credential(String username, String password) {
        return new DynamicPlainCredential(username, password.toCharArray());
    }
}

