/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.clients.admin.internals.ListConsumerGroupOffsetsHandler;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListConsumerGroupOffsetsHandlerTest {
    private final LogContext logContext = new LogContext();
    private final int throttleMs = 10;
    private final String groupZero = "group0";
    private final String groupOne = "group1";
    private final String groupTwo = "group2";
    private final List<String> groups = Arrays.asList("group0", "group1", "group2");
    private final TopicPartition t0p0 = new TopicPartition("t0", 0);
    private final TopicPartition t0p1 = new TopicPartition("t0", 1);
    private final TopicPartition t1p0 = new TopicPartition("t1", 0);
    private final TopicPartition t1p1 = new TopicPartition("t1", 1);
    private final TopicPartition t2p0 = new TopicPartition("t2", 0);
    private final TopicPartition t2p1 = new TopicPartition("t2", 1);
    private final TopicPartition t2p2 = new TopicPartition("t2", 2);
    private final Map<String, ListConsumerGroupOffsetsSpec> singleRequestMap = Collections.singletonMap("group0", new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(this.t0p0, this.t0p1, this.t1p0, this.t1p1)));
    private final Map<String, ListConsumerGroupOffsetsSpec> batchedRequestMap = Map.of("group0", new ListConsumerGroupOffsetsSpec().topicPartitions(Collections.singletonList(this.t0p0)), "group1", new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(this.t0p0, this.t1p0, this.t1p1)), "group2", new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(this.t0p0, this.t1p0, this.t1p1, this.t2p0, this.t2p1, this.t2p2)));

    @Test
    public void testBuildRequest() {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(this.singleRequestMap, false, this.logContext);
        OffsetFetchRequest request = (OffsetFetchRequest)handler.buildBatchedRequest(this.coordinatorKeys("group0")).build();
        Assertions.assertEquals((Object)"group0", (Object)((OffsetFetchRequestData.OffsetFetchRequestGroup)request.data().groups().get(0)).groupId());
        Assertions.assertEquals((int)2, (int)((OffsetFetchRequestData.OffsetFetchRequestGroup)request.data().groups().get(0)).topics().size());
        Assertions.assertEquals((int)2, (int)((OffsetFetchRequestData.OffsetFetchRequestTopics)((OffsetFetchRequestData.OffsetFetchRequestGroup)request.data().groups().get(0)).topics().get(0)).partitionIndexes().size());
        Assertions.assertEquals((int)2, (int)((OffsetFetchRequestData.OffsetFetchRequestTopics)((OffsetFetchRequestData.OffsetFetchRequestGroup)request.data().groups().get(0)).topics().get(1)).partitionIndexes().size());
    }

    @Test
    public void testBuildRequestWithMultipleGroups() {
        HashMap<String, ListConsumerGroupOffsetsSpec> requestMap = new HashMap<String, ListConsumerGroupOffsetsSpec>(this.batchedRequestMap);
        String groupThree = "group3";
        requestMap.put(groupThree, new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(new TopicPartition("t3", 0), new TopicPartition("t3", 1))));
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(requestMap, false, this.logContext);
        OffsetFetchRequest request1 = (OffsetFetchRequest)handler.buildBatchedRequest(this.coordinatorKeys("group0", "group1", "group2")).build();
        Assertions.assertEquals(Set.of("group0", "group1", "group2"), this.requestGroups(request1));
        OffsetFetchRequest request2 = (OffsetFetchRequest)handler.buildBatchedRequest(this.coordinatorKeys(groupThree)).build();
        Assertions.assertEquals(Set.of(groupThree), this.requestGroups(request2));
        HashMap builtRequests = new HashMap();
        request1.groupIdsToPartitions().forEach((group, partitions) -> builtRequests.put(group, new ListConsumerGroupOffsetsSpec().topicPartitions((Collection)partitions)));
        request2.groupIdsToPartitions().forEach((group, partitions) -> builtRequests.put(group, new ListConsumerGroupOffsetsSpec().topicPartitions((Collection)partitions)));
        Assertions.assertEquals(requestMap, builtRequests);
        Map groupIdsToTopics = request1.groupIdsToTopics();
        Assertions.assertEquals((int)3, (int)groupIdsToTopics.size());
        Assertions.assertEquals((int)1, (int)((List)groupIdsToTopics.get("group0")).size());
        Assertions.assertEquals((int)2, (int)((List)groupIdsToTopics.get("group1")).size());
        Assertions.assertEquals((int)3, (int)((List)groupIdsToTopics.get("group2")).size());
        Assertions.assertEquals((int)1, (int)((OffsetFetchRequestData.OffsetFetchRequestTopics)((List)groupIdsToTopics.get("group0")).get(0)).partitionIndexes().size());
        Assertions.assertEquals((int)1, (int)((OffsetFetchRequestData.OffsetFetchRequestTopics)((List)groupIdsToTopics.get("group1")).get(0)).partitionIndexes().size());
        Assertions.assertEquals((int)2, (int)((OffsetFetchRequestData.OffsetFetchRequestTopics)((List)groupIdsToTopics.get("group1")).get(1)).partitionIndexes().size());
        Assertions.assertEquals((int)1, (int)((OffsetFetchRequestData.OffsetFetchRequestTopics)((List)groupIdsToTopics.get("group2")).get(0)).partitionIndexes().size());
        Assertions.assertEquals((int)2, (int)((OffsetFetchRequestData.OffsetFetchRequestTopics)((List)groupIdsToTopics.get("group2")).get(1)).partitionIndexes().size());
        Assertions.assertEquals((int)3, (int)((OffsetFetchRequestData.OffsetFetchRequestTopics)((List)groupIdsToTopics.get("group2")).get(2)).partitionIndexes().size());
        groupIdsToTopics = request2.groupIdsToTopics();
        Assertions.assertEquals((int)1, (int)groupIdsToTopics.size());
        Assertions.assertEquals((int)1, (int)((List)groupIdsToTopics.get(groupThree)).size());
        Assertions.assertEquals((int)2, (int)((OffsetFetchRequestData.OffsetFetchRequestTopics)((List)groupIdsToTopics.get(groupThree)).get(0)).partitionIndexes().size());
    }

    @Test
    public void testBuildRequestBatchGroups() {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(this.batchedRequestMap, false, this.logContext);
        Collection requests = handler.buildRequest(1, this.coordinatorKeys("group0", "group1", "group2"));
        Assertions.assertEquals((int)1, (int)requests.size());
        Assertions.assertEquals(Set.of("group0", "group1", "group2"), this.requestGroups((OffsetFetchRequest)((AdminApiHandler.RequestAndKeys)requests.iterator().next()).request.build()));
    }

    @Test
    public void testBuildRequestDoesNotBatchGroup() {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(this.batchedRequestMap, false, this.logContext);
        ((CoordinatorStrategy)handler.lookupStrategy()).disableBatch();
        Collection requests = handler.buildRequest(1, this.coordinatorKeys("group0", "group1", "group2"));
        Assertions.assertEquals((int)3, (int)requests.size());
        Assertions.assertEquals(Set.of(Set.of("group0"), Set.of("group1"), Set.of("group2")), requests.stream().map(requestAndKey -> this.requestGroups((OffsetFetchRequest)requestAndKey.request.build())).collect(Collectors.toSet()));
    }

    @Test
    public void testSuccessfulHandleResponse() {
        HashMap<TopicPartition, OffsetAndMetadata> expected = new HashMap<TopicPartition, OffsetAndMetadata>();
        this.assertCompleted(this.handleWithError(Errors.NONE), expected);
    }

    @Test
    public void testSuccessfulHandleResponseWithOnePartitionError() {
        Map<TopicPartition, OffsetAndMetadata> expectedResult = Collections.singletonMap(this.t0p0, new OffsetAndMetadata(10L));
        this.assertCompleted(this.handleWithPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION), expectedResult);
        this.assertCompleted(this.handleWithPartitionError(Errors.TOPIC_AUTHORIZATION_FAILED), expectedResult);
        this.assertCompleted(this.handleWithPartitionError(Errors.UNSTABLE_OFFSET_COMMIT), expectedResult);
    }

    @Test
    public void testSuccessfulHandleResponseWithOnePartitionErrorWithMultipleGroups() {
        Map<TopicPartition, OffsetAndMetadata> offsetAndMetadataMapZero = Collections.singletonMap(this.t0p0, new OffsetAndMetadata(10L));
        Map<TopicPartition, OffsetAndMetadata> offsetAndMetadataMapOne = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(10L));
        Map<TopicPartition, OffsetAndMetadata> offsetAndMetadataMapTwo = Collections.singletonMap(this.t2p2, new OffsetAndMetadata(10L));
        Map<String, Map<TopicPartition, OffsetAndMetadata>> expectedResult = Map.of("group0", offsetAndMetadataMapZero, "group1", offsetAndMetadataMapOne, "group2", offsetAndMetadataMapTwo);
        this.assertCompletedForMultipleGroups(this.handleWithPartitionErrorMultipleGroups(Errors.UNKNOWN_TOPIC_OR_PARTITION), expectedResult);
        this.assertCompletedForMultipleGroups(this.handleWithPartitionErrorMultipleGroups(Errors.TOPIC_AUTHORIZATION_FAILED), expectedResult);
        this.assertCompletedForMultipleGroups(this.handleWithPartitionErrorMultipleGroups(Errors.UNSTABLE_OFFSET_COMMIT), expectedResult);
    }

    @Test
    public void testSuccessfulHandleResponseWithMultipleGroups() {
        HashMap<String, Map<TopicPartition, OffsetAndMetadata>> expected = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
        Map<String, Errors> errorMap = this.errorMap(this.groups, Errors.NONE);
        this.assertCompletedForMultipleGroups(this.handleWithErrorWithMultipleGroups(errorMap, this.batchedRequestMap), expected);
    }

    @Test
    public void testUnmappedHandleResponse() {
        this.assertUnmapped(this.handleWithError(Errors.COORDINATOR_NOT_AVAILABLE));
        this.assertUnmapped(this.handleWithError(Errors.NOT_COORDINATOR));
    }

    @Test
    public void testUnmappedHandleResponseWithMultipleGroups() {
        HashMap<String, Errors> errorMap = new HashMap<String, Errors>();
        errorMap.put("group0", Errors.NOT_COORDINATOR);
        errorMap.put("group1", Errors.COORDINATOR_NOT_AVAILABLE);
        errorMap.put("group2", Errors.NOT_COORDINATOR);
        this.assertUnmappedWithMultipleGroups(this.handleWithErrorWithMultipleGroups(errorMap, this.batchedRequestMap));
    }

    @Test
    public void testRetriableHandleResponse() {
        this.assertRetriable(this.handleWithError(Errors.COORDINATOR_LOAD_IN_PROGRESS));
    }

    @Test
    public void testRetriableHandleResponseWithMultipleGroups() {
        Map<String, Errors> errorMap = this.errorMap(this.groups, Errors.COORDINATOR_LOAD_IN_PROGRESS);
        this.assertRetriable(this.handleWithErrorWithMultipleGroups(errorMap, this.batchedRequestMap));
    }

    @Test
    public void testFailedHandleResponse() {
        this.assertFailed(GroupAuthorizationException.class, this.handleWithError(Errors.GROUP_AUTHORIZATION_FAILED));
        this.assertFailed(GroupIdNotFoundException.class, this.handleWithError(Errors.GROUP_ID_NOT_FOUND));
        this.assertFailed(InvalidGroupIdException.class, this.handleWithError(Errors.INVALID_GROUP_ID));
    }

    @Test
    public void testFailedHandleResponseWithMultipleGroups() {
        HashMap<String, Errors> errorMap = new HashMap<String, Errors>();
        errorMap.put("group0", Errors.GROUP_AUTHORIZATION_FAILED);
        errorMap.put("group1", Errors.GROUP_ID_NOT_FOUND);
        errorMap.put("group2", Errors.INVALID_GROUP_ID);
        HashMap<String, Class<? extends Throwable>> groupToExceptionMap = new HashMap<String, Class<? extends Throwable>>();
        groupToExceptionMap.put("group0", GroupAuthorizationException.class);
        groupToExceptionMap.put("group1", GroupIdNotFoundException.class);
        groupToExceptionMap.put("group2", InvalidGroupIdException.class);
        this.assertFailedForMultipleGroups(groupToExceptionMap, this.handleWithErrorWithMultipleGroups(errorMap, this.batchedRequestMap));
    }

    private OffsetFetchResponse buildResponse(Errors error) {
        return new OffsetFetchResponse(10, Collections.singletonMap("group0", error), Collections.singletonMap("group0", new HashMap()));
    }

    private OffsetFetchResponse buildResponseWithMultipleGroups(Map<String, Errors> errorMap, Map<String, Map<TopicPartition, OffsetFetchResponse.PartitionData>> responseData) {
        return new OffsetFetchResponse(10, errorMap, responseData);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleWithErrorWithMultipleGroups(Map<String, Errors> errorMap, Map<String, ListConsumerGroupOffsetsSpec> groupSpecs) {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(groupSpecs, false, this.logContext);
        HashMap<String, Map<TopicPartition, OffsetFetchResponse.PartitionData>> responseData = new HashMap<String, Map<TopicPartition, OffsetFetchResponse.PartitionData>>();
        for (String group : errorMap.keySet()) {
            responseData.put(group, new HashMap());
        }
        OffsetFetchResponse response = this.buildResponseWithMultipleGroups(errorMap, responseData);
        return handler.handleResponse(new Node(1, "host", 1234), errorMap.keySet().stream().map(CoordinatorKey::byGroupId).collect(Collectors.toSet()), (AbstractResponse)response);
    }

    private OffsetFetchResponse buildResponseWithPartitionError(Errors error) {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        responseData.put(this.t0p0, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", Errors.NONE));
        responseData.put(this.t0p1, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", error));
        return new OffsetFetchResponse(Errors.NONE, responseData);
    }

    private OffsetFetchResponse buildResponseWithPartitionErrorWithMultipleGroups(Errors error) {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseDataZero = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        responseDataZero.put(this.t0p0, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", Errors.NONE));
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseDataOne = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        responseDataOne.put(this.t0p0, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", error));
        responseDataOne.put(this.t1p0, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", error));
        responseDataOne.put(this.t1p1, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", Errors.NONE));
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseDataTwo = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        responseDataTwo.put(this.t0p0, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", error));
        responseDataTwo.put(this.t1p0, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", error));
        responseDataTwo.put(this.t1p1, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", error));
        responseDataTwo.put(this.t2p0, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", error));
        responseDataTwo.put(this.t2p1, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", error));
        responseDataTwo.put(this.t2p2, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", Errors.NONE));
        Map responseData = Map.of("group0", responseDataZero, "group1", responseDataOne, "group2", responseDataTwo);
        Map<String, Errors> errorMap = this.errorMap(this.groups, Errors.NONE);
        return new OffsetFetchResponse(0, errorMap, responseData);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleWithPartitionError(Errors error) {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(this.singleRequestMap, false, this.logContext);
        OffsetFetchResponse response = this.buildResponseWithPartitionError(error);
        return handler.handleResponse(new Node(1, "host", 1234), Collections.singleton(CoordinatorKey.byGroupId((String)"group0")), (AbstractResponse)response);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleWithPartitionErrorMultipleGroups(Errors error) {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(this.batchedRequestMap, false, this.logContext);
        OffsetFetchResponse response = this.buildResponseWithPartitionErrorWithMultipleGroups(error);
        return handler.handleResponse(new Node(1, "host", 1234), this.coordinatorKeys("group0", "group1", "group2"), (AbstractResponse)response);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleWithError(Errors error) {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(this.singleRequestMap, false, this.logContext);
        OffsetFetchResponse response = this.buildResponse(error);
        return handler.handleResponse(new Node(1, "host", 1234), Collections.singleton(CoordinatorKey.byGroupId((String)"group0")), (AbstractResponse)response);
    }

    private void assertUnmapped(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.singletonList(CoordinatorKey.byGroupId((String)"group0")), (Object)result.unmappedKeys);
    }

    private void assertUnmappedWithMultipleGroups(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(this.coordinatorKeys("group0", "group1", "group2"), new HashSet(result.unmappedKeys));
    }

    private void assertRetriable(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
    }

    private void assertCompleted(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result, Map<TopicPartition, OffsetAndMetadata> expected) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group0");
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.completedKeys.keySet());
        Assertions.assertEquals(expected, result.completedKeys.get(key));
    }

    private void assertCompletedForMultipleGroups(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result, Map<String, Map<TopicPartition, OffsetAndMetadata>> expected) {
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        for (String g : expected.keySet()) {
            CoordinatorKey key = CoordinatorKey.byGroupId((String)g);
            Assertions.assertTrue((boolean)result.completedKeys.containsKey(key));
            Assertions.assertEquals(expected.get(g), result.completedKeys.get(key));
        }
    }

    private void assertFailed(Class<? extends Throwable> expectedExceptionType, AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group0");
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.failedKeys.keySet());
        Assertions.assertInstanceOf(expectedExceptionType, result.failedKeys.get(key));
    }

    private void assertFailedForMultipleGroups(Map<String, Class<? extends Throwable>> groupToExceptionMap, AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        for (String g : groupToExceptionMap.keySet()) {
            CoordinatorKey key = CoordinatorKey.byGroupId((String)g);
            Assertions.assertTrue((boolean)result.failedKeys.containsKey(key));
            Assertions.assertInstanceOf(groupToExceptionMap.get(g), result.failedKeys.get(key));
        }
    }

    private Set<CoordinatorKey> coordinatorKeys(String ... groups) {
        return Stream.of(groups).map(CoordinatorKey::byGroupId).collect(Collectors.toSet());
    }

    private Set<String> requestGroups(OffsetFetchRequest request) {
        return request.data().groups().stream().map(OffsetFetchRequestData.OffsetFetchRequestGroup::groupId).collect(Collectors.toSet());
    }

    private Map<String, Errors> errorMap(Collection<String> groups, Errors error) {
        return groups.stream().collect(Collectors.toMap(Function.identity(), unused -> error));
    }
}

