/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.HashSet;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class ApiMessageTypeTest {
    @Test
    public void testFromApiKey() {
        for (ApiMessageType type : ApiMessageType.values()) {
            ApiMessageType type2 = ApiMessageType.fromApiKey((short)type.apiKey());
            Assertions.assertEquals((Object)type2, (Object)type);
        }
    }

    @Test
    public void testInvalidFromApiKey() {
        try {
            ApiMessageType.fromApiKey((short)-1);
            Assertions.fail((String)"expected to get an UnsupportedVersionException");
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            // empty catch block
        }
    }

    @Test
    public void testUniqueness() {
        HashSet<Short> ids = new HashSet<Short>();
        HashSet<String> requestNames = new HashSet<String>();
        HashSet<String> responseNames = new HashSet<String>();
        int apiKeysWithNoValidVersionCount = 0;
        for (ApiMessageType type : ApiMessageType.values()) {
            Assertions.assertFalse((boolean)ids.contains(type.apiKey()), (String)("found two ApiMessageType objects with id " + type.apiKey()));
            ids.add(type.apiKey());
            ApiKeys apiKey = ApiKeys.forId((int)type.apiKey());
            if (apiKey.hasValidVersion()) {
                String requestName = type.newRequest().getClass().getSimpleName();
                Assertions.assertFalse((boolean)requestNames.contains(requestName), (String)("found two ApiMessageType objects with requestName " + requestName));
                requestNames.add(requestName);
                String responseName = type.newResponse().getClass().getSimpleName();
                Assertions.assertFalse((boolean)responseNames.contains(responseName), (String)("found two ApiMessageType objects with responseName " + responseName));
                responseNames.add(responseName);
                continue;
            }
            ++apiKeysWithNoValidVersionCount;
        }
        Assertions.assertEquals((int)ApiMessageType.values().length, (int)ids.size());
        int expectedNamesCount = ApiMessageType.values().length - apiKeysWithNoValidVersionCount;
        Assertions.assertEquals((int)expectedNamesCount, (int)requestNames.size());
        Assertions.assertEquals((int)expectedNamesCount, (int)responseNames.size());
    }

    @Test
    public void testHeaderVersion() {
        Assertions.assertEquals((short)1, (short)ApiMessageType.PRODUCE.requestHeaderVersion((short)0));
        Assertions.assertEquals((short)0, (short)ApiMessageType.PRODUCE.responseHeaderVersion((short)0));
        Assertions.assertEquals((short)1, (short)ApiMessageType.PRODUCE.requestHeaderVersion((short)1));
        Assertions.assertEquals((short)0, (short)ApiMessageType.PRODUCE.responseHeaderVersion((short)1));
        Assertions.assertEquals((short)1, (short)ApiMessageType.CREATE_TOPICS.requestHeaderVersion((short)4));
        Assertions.assertEquals((short)0, (short)ApiMessageType.CREATE_TOPICS.responseHeaderVersion((short)4));
        Assertions.assertEquals((short)2, (short)ApiMessageType.CREATE_TOPICS.requestHeaderVersion((short)5));
        Assertions.assertEquals((short)1, (short)ApiMessageType.CREATE_TOPICS.responseHeaderVersion((short)5));
    }

    @Test
    public void testHeaderVersionWithNoValidVersion() {
        for (ApiMessageType messageType : ApiMessageType.values()) {
            if (messageType.lowestSupportedVersion() <= messageType.highestSupportedVersion(true)) continue;
            Assertions.assertThrows(UnsupportedVersionException.class, () -> messageType.requestHeaderVersion((short)0));
            Assertions.assertThrows(UnsupportedVersionException.class, () -> messageType.responseHeaderVersion((short)0));
        }
    }

    @Test
    public void testAllVersionsHaveSchemas() {
        for (ApiMessageType type : ApiMessageType.values()) {
            Schema schema;
            int i;
            Assertions.assertTrue((type.lowestSupportedVersion() >= 0 ? 1 : 0) != 0);
            Assertions.assertEquals((int)type.requestSchemas().length, (int)type.responseSchemas().length, (String)("request and response schemas must be the same length for " + type.name()));
            for (i = 0; i < type.requestSchemas().length; ++i) {
                schema = type.requestSchemas()[i];
                if (i >= type.lowestSupportedVersion()) {
                    Assertions.assertNotNull((Object)schema);
                    continue;
                }
                Assertions.assertNull((Object)schema);
            }
            for (i = 0; i < type.responseSchemas().length; ++i) {
                schema = type.responseSchemas()[i];
                if (i >= type.lowestSupportedVersion()) {
                    Assertions.assertNotNull((Object)schema);
                    continue;
                }
                Assertions.assertNull((Object)schema);
            }
            Assertions.assertEquals((int)(type.highestSupportedVersion(true) + 1), (int)type.requestSchemas().length);
        }
    }

    @Test
    public void testApiIdsArePositive() {
        for (ApiMessageType type : ApiMessageType.values()) {
            Assertions.assertTrue((type.apiKey() >= 0 ? 1 : 0) != 0);
        }
    }
}

