/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.net.InetAddress;
import java.util.function.Function;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;

public class TransformRequestContext
extends RequestContext {
    private final Function<? super AbstractResponse, ? extends AbstractResponse> responseTransformer;

    public TransformRequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, PathAwareSniHostName sniHostName, boolean fromPrivilegedListener) {
        this(header, connectionId, clientAddress, principal, listenerName, securityProtocol, clientInformation, sniHostName, fromPrivilegedListener, Function.identity());
    }

    public TransformRequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, PathAwareSniHostName sniHostName, boolean fromPrivilegedListener, Function<? super AbstractResponse, ? extends AbstractResponse> responseTransformer) {
        super(header, connectionId, clientAddress, principal, listenerName, securityProtocol, clientInformation, sniHostName, fromPrivilegedListener);
        this.responseTransformer = responseTransformer;
    }

    public RequestContext.ResponseSend buildResponseSend(AbstractResponse body) {
        AbstractResponse transformed = this.responseTransformer.apply((AbstractResponse)body);
        return new RequestContext.ResponseSend(transformed.toSend(this.header.toResponseHeader(), this.apiVersion()), transformed);
    }
}

