/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CloseableVerificationKeyResolver;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.common.security.oauthbearer.internals.secured.VerificationKeyResolverFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class VerificationKeyResolverFactoryTest
extends OAuthBearerTest {
    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls");
    }

    @Test
    public void testConfigureRefreshingFileVerificationKeyResolver() throws Exception {
        File tmpDir = this.createTempDir("access-token");
        File verificationKeyFile = this.createTempFile(tmpDir, "access-token-", ".json", "{}");
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", verificationKeyFile.toURI().toString());
        Map<String, String> configs = Collections.singletonMap("sasl.oauthbearer.jwks.endpoint.url", verificationKeyFile.toURI().toString());
        Map jaasConfig = Collections.emptyMap();
        CloseableVerificationKeyResolver verificationKeyResolver = VerificationKeyResolverFactory.create(configs, jaasConfig);
        if (verificationKeyResolver != null) {
            verificationKeyResolver.close();
        }
    }

    @Test
    public void testConfigureRefreshingFileVerificationKeyResolverWithInvalidDirectory() {
        String file = new File("/tmp/this-directory-does-not-exist/foo.json").toURI().toString();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", file);
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.jwks.endpoint.url", file);
        Map jaasConfig = Collections.emptyMap();
        this.assertThrowsWithMessage(ConfigException.class, () -> VerificationKeyResolverFactory.create((Map)configs, (Map)jaasConfig), "that doesn't exist");
    }

    @Test
    public void testConfigureRefreshingFileVerificationKeyResolverWithInvalidFile() throws Exception {
        File tmpDir = this.createTempDir("this-directory-does-exist");
        File verificationKeyFile = new File(tmpDir, "this-file-does-not-exist.json");
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", verificationKeyFile.toURI().toString());
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.jwks.endpoint.url", verificationKeyFile.toURI().toString());
        Map jaasConfig = Collections.emptyMap();
        this.assertThrowsWithMessage(ConfigException.class, () -> VerificationKeyResolverFactory.create((Map)configs, (Map)jaasConfig), "that doesn't exist");
    }

    @Test
    public void testSaslOauthbearerTokenEndpointUrlIsNotAllowed() throws Exception {
        File tmpDir = this.createTempDir("not_allowed");
        File verificationKeyFile = new File(tmpDir, "not_allowed.json");
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.jwks.endpoint.url", verificationKeyFile.toURI().toString());
        this.assertThrowsWithMessage(ConfigException.class, () -> VerificationKeyResolverFactory.create((Map)configs, Collections.emptyMap()), "org.apache.kafka.sasl.oauthbearer.allowed.urls");
    }
}

