/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.metrics.ApiSensors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ApiSensorsTest {
    private Metrics metrics;

    @BeforeEach
    public void setUp() {
        this.metrics = new Metrics();
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testApiSensorsExpired() {
        HashMap<Errors, Sensor> errorSensors = new HashMap<Errors, Sensor>();
        errorSensors.put(Errors.CLUSTER_AUTHORIZATION_FAILED, this.metrics.sensor("error"));
        ApiSensors apiSensors = new ApiSensors(this.metrics.sensor("a"), this.metrics.sensor("b"), this.metrics.sensor("c"), this.metrics.sensor("d"));
        Assertions.assertFalse((boolean)apiSensors.requestSensorsExpired(this.metrics));
        Assertions.assertEquals(errorSensors.keySet(), (Object)apiSensors.errorsWithoutSensors(this.metrics, errorSensors.keySet()));
        apiSensors.addErrorSensors(errorSensors);
        Assertions.assertEquals(Collections.emptySet(), (Object)apiSensors.errorsWithoutSensors(this.metrics, errorSensors.keySet()));
        this.metrics.removeSensor("a");
        Assertions.assertTrue((boolean)apiSensors.requestSensorsExpired(this.metrics));
        this.metrics.removeSensor("error");
        Assertions.assertEquals(errorSensors.keySet(), (Object)apiSensors.errorsWithoutSensors(this.metrics, errorSensors.keySet()));
    }
}

