/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.utils.Utils;

@InterfaceStability.Evolving
public class MirrorTopicDescription {
    private final String linkName;
    private final Uuid linkId;
    private final String sourceTopic;
    private final int numPartitions;
    private final State state;
    private final long stateTimeMs;
    private final List<Long> stoppedLogEndOffsets;
    private final List<Integer> stoppedEpochs;
    private final Uuid sourceTopicId;
    private final MirrorTopicError mirrorTopicError;
    private final List<ClusterLinkTaskError> mirrorStateTransitionErrors;
    private final long stoppedSequenceNumber;
    private final Uuid localTopicId;

    public MirrorTopicDescription(String linkName, Uuid linkId, String sourceTopic, int numPartitions, State state, long stateTimeMs, List<Long> stoppedLogEndOffsets, Uuid sourceTopicId, MirrorTopicError mirrorTopicError) {
        this(linkName, linkId, sourceTopic, numPartitions, state, stateTimeMs, stoppedLogEndOffsets, sourceTopicId, MirrorTopicError.errorOrDefault(mirrorTopicError, state == State.FAILED), Collections.emptyList());
    }

    public MirrorTopicDescription(String linkName, Uuid linkId, String sourceTopic, int numPartitions, State state, long stateTimeMs, List<Long> stoppedLogEndOffsets, Uuid sourceTopicId, MirrorTopicError mirrorTopicError, List<ClusterLinkTaskError> mirrorStateTransitionErrors) {
        this(linkName, linkId, sourceTopic, numPartitions, state, stateTimeMs, stoppedLogEndOffsets, Collections.emptyList(), sourceTopicId, mirrorTopicError, mirrorStateTransitionErrors, 0L, Uuid.ZERO_UUID);
    }

    public MirrorTopicDescription(String linkName, Uuid linkId, String sourceTopic, int numPartitions, State state, long stateTimeMs, List<Long> stoppedLogEndOffsets, List<Integer> stoppedEpochs, Uuid sourceTopicId, MirrorTopicError mirrorTopicError, List<ClusterLinkTaskError> mirrorStateTransitionErrors, long stoppedSequenceNumber, Uuid localTopicId) {
        this.linkName = Objects.requireNonNull(linkName);
        this.linkId = Objects.requireNonNull(linkId);
        this.sourceTopic = Objects.requireNonNull(sourceTopic);
        this.numPartitions = numPartitions;
        this.state = Objects.requireNonNull(state);
        this.stateTimeMs = stateTimeMs;
        this.stoppedLogEndOffsets = Objects.requireNonNull(stoppedLogEndOffsets);
        this.stoppedEpochs = stoppedEpochs == null ? Collections.emptyList() : stoppedEpochs;
        this.sourceTopicId = sourceTopicId;
        this.mirrorTopicError = MirrorTopicError.errorOrDefault(mirrorTopicError, state == State.FAILED);
        this.mirrorStateTransitionErrors = mirrorStateTransitionErrors;
        this.stoppedSequenceNumber = stoppedSequenceNumber;
        this.localTopicId = localTopicId;
    }

    public String linkName() {
        return this.linkName;
    }

    @Deprecated
    public UUID linkId() {
        return Utils.toJavaUuid(this.linkId);
    }

    public Uuid clusterLinkId() {
        return this.linkId;
    }

    @Deprecated
    public String mirrorTopic() {
        return this.sourceTopic;
    }

    public String sourceTopic() {
        return this.sourceTopic;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public State state() {
        return this.state;
    }

    public long stateTimeMs() {
        return this.stateTimeMs;
    }

    public List<Long> stoppedLogEndOffsets() {
        return this.stoppedLogEndOffsets;
    }

    public List<Integer> stoppedEpochs() {
        return this.stoppedEpochs;
    }

    public Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    public MirrorTopicError mirrorTopicError() {
        return this.mirrorTopicError;
    }

    public List<ClusterLinkTaskError> mirrorStateTransitionErrors() {
        return this.mirrorStateTransitionErrors;
    }

    public long stoppedSequenceNumber() {
        return this.stoppedSequenceNumber;
    }

    public Uuid localTopicId() {
        return this.localTopicId;
    }

    public String toString() {
        return "(linkName=" + this.linkName + ", linkId=" + String.valueOf(this.linkId) + ", sourceTopic=" + this.sourceTopic + ", numPartitions=" + this.numPartitions + ", state=" + String.valueOf((Object)this.state) + ", stateTimeMs=" + this.stateTimeMs + ", stoppedLogEndOffsets=" + String.valueOf(this.stoppedLogEndOffsets) + ", stoppedEpochs=" + String.valueOf(this.stoppedEpochs) + ", sourceTopicId=" + String.valueOf(this.sourceTopicId) + ", mirrorStateTransitionErrors=" + String.valueOf(this.mirrorStateTransitionErrors) + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber + ", localTopicId=" + String.valueOf(this.localTopicId) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MirrorTopicDescription that = (MirrorTopicDescription)o;
        return Objects.equals(this.linkName, that.linkName) && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.sourceTopic, that.sourceTopic) && Objects.equals(this.numPartitions, that.numPartitions) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.stateTimeMs, that.stateTimeMs) && Objects.equals(this.stoppedLogEndOffsets, that.stoppedLogEndOffsets) && Objects.equals(this.sourceTopicId, that.sourceTopicId) && Objects.equals((Object)this.mirrorTopicError, (Object)that.mirrorTopicError) && Objects.equals(this.mirrorStateTransitionErrors, that.mirrorStateTransitionErrors) && this.stoppedSequenceNumber == that.stoppedSequenceNumber && Objects.equals(this.localTopicId, that.localTopicId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.linkName, this.linkId, this.sourceTopic, this.numPartitions, this.state, this.stateTimeMs, this.sourceTopicId, this.mirrorTopicError, this.mirrorStateTransitionErrors, this.stoppedSequenceNumber, this.localTopicId});
    }

    public static enum State {
        UNKNOWN,
        ACTIVE,
        PENDING_STOPPED,
        STOPPED,
        FAILED,
        PAUSED,
        SOURCE_UNAVAILABLE,
        LINK_FAILED,
        LINK_PAUSED,
        PENDING_MIRROR,
        PENDING_SYNCHRONIZE,
        PENDING_REPAIR,
        PENDING_SETUP_FOR_RESTORE,
        PENDING_RESTORE;

    }
}

