/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;

public class FindCoordinatorRequest
extends AbstractRequest {
    public static final short MIN_BATCHED_VERSION = 4;
    private final FindCoordinatorRequestData data;

    private FindCoordinatorRequest(FindCoordinatorRequestData data, short version) {
        super(ApiKeys.FIND_COORDINATOR, version);
        this.data = data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        FindCoordinatorResponseData response = new FindCoordinatorResponseData();
        if (this.version() >= 2) {
            response.setThrottleTimeMs(throttleTimeMs);
        }
        Errors error = Errors.forException(e);
        if (this.version() < 4) {
            return FindCoordinatorResponse.prepareOldResponse(error, Node.noNode());
        }
        return FindCoordinatorResponse.prepareErrorResponse(error, this.data.coordinatorKeys());
    }

    public static FindCoordinatorRequest parse(Readable readable, short version, MessageContext context) {
        return new FindCoordinatorRequest(new FindCoordinatorRequestData(readable, version, context), version);
    }

    @Override
    public FindCoordinatorRequestData data() {
        return this.data;
    }

    public static enum CoordinatorType {
        GROUP(0),
        TRANSACTION(1),
        SHARE(2),
        MIRROR_TOPIC(-2),
        CLUSTER_LINK(-1);

        final byte id;

        private CoordinatorType(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static CoordinatorType forId(byte id) {
            switch (id) {
                case 0: {
                    return GROUP;
                }
                case 1: {
                    return TRANSACTION;
                }
                case 2: {
                    return SHARE;
                }
                case -2: {
                    return MIRROR_TOPIC;
                }
                case -1: {
                    return CLUSTER_LINK;
                }
            }
            throw new InvalidRequestException("Unknown coordinator type received: " + id);
        }
    }

    public static class NoBatchedFindCoordinatorsException
    extends UnsupportedVersionException {
        private static final long serialVersionUID = 1L;

        public NoBatchedFindCoordinatorsException(String message) {
            super(message);
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<FindCoordinatorRequest> {
        private final FindCoordinatorRequestData data;

        public Builder(FindCoordinatorRequestData data) {
            super(ApiKeys.FIND_COORDINATOR);
            this.data = data;
        }

        @Override
        public FindCoordinatorRequest build(short version) {
            if (version < 1 && this.data.keyType() == CoordinatorType.TRANSACTION.id()) {
                throw new UnsupportedVersionException("Cannot create a v" + version + " FindCoordinator request because we require features supported only in 2 or later.");
            }
            int batchedKeys = this.data.coordinatorKeys().size();
            if (version < 4) {
                if (batchedKeys > 1) {
                    throw new NoBatchedFindCoordinatorsException("Cannot create a v" + version + " FindCoordinator request because we require features supported only in 4 or later.");
                }
                if (batchedKeys == 1) {
                    this.data.setKey(this.data.coordinatorKeys().get(0));
                    this.data.setCoordinatorKeys(Collections.emptyList());
                }
            } else if (batchedKeys == 0 && this.data.key() != null) {
                this.data.setCoordinatorKeys(Collections.singletonList(this.data.key()));
                this.data.setKey("");
            }
            return new FindCoordinatorRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }

        public FindCoordinatorRequestData data() {
            return this.data;
        }
    }
}

