/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.RemoveRaftVoterResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class RemoveRaftVoterResponse
extends AbstractResponse {
    private final RemoveRaftVoterResponseData data;

    public RemoveRaftVoterResponse(RemoveRaftVoterResponseData data) {
        super(ApiKeys.REMOVE_RAFT_VOTER);
        this.data = data;
    }

    @Override
    public RemoveRaftVoterResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        if (this.data.errorCode() != Errors.NONE.code()) {
            return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
        }
        return Collections.emptyMap();
    }

    public static RemoveRaftVoterResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new RemoveRaftVoterResponse(new RemoveRaftVoterResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

