/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import io.confluent.kafka.clients.CellLoadResult;
import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafka.clients.DescribeCellLoadOptions;
import io.confluent.kafka.clients.DescribeNetworkOptions;
import io.confluent.kafka.clients.DescribeNetworkResult;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.admin.AbortTransactionResult;
import org.apache.kafka.clients.admin.AbortTransactionSpec;
import org.apache.kafka.clients.admin.AddRaftVoterOptions;
import org.apache.kafka.clients.admin.AddRaftVoterResult;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AdminClientUnitTestEnv;
import org.apache.kafka.clients.admin.AlterBrokerHealthOptions;
import org.apache.kafka.clients.admin.AlterBrokerHealthResult;
import org.apache.kafka.clients.admin.AlterBrokerHealthSpec;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsOptions;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.AlterShareGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterStreamsGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.BalancerSelfHealMode;
import org.apache.kafka.clients.admin.BalancerStatus;
import org.apache.kafka.clients.admin.BalancerStatusDescription;
import org.apache.kafka.clients.admin.BrokerAdditionDescription;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.BrokerHealthStatusResult;
import org.apache.kafka.clients.admin.BrokerRemovalDescription;
import org.apache.kafka.clients.admin.BrokerRemovalError;
import org.apache.kafka.clients.admin.BrokerReplicaExclusionStatus;
import org.apache.kafka.clients.admin.BrokerShutdownStatus;
import org.apache.kafka.clients.admin.ClassicGroupDescription;
import org.apache.kafka.clients.admin.ClientMetricsResourceListing;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ClusterLinkSwitchoverStatusDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.ComputeEvenClusterLoadPlanOptions;
import org.apache.kafka.clients.admin.ComputeEvenClusterLoadPlanResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.CreateClusterLinksResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteShareGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteShareGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteStreamsGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteStreamsGroupsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeBalancerStatusOptions;
import org.apache.kafka.clients.admin.DescribeBalancerStatusResult;
import org.apache.kafka.clients.admin.DescribeBrokerAdditionsResult;
import org.apache.kafka.clients.admin.DescribeBrokerHealthOptions;
import org.apache.kafka.clients.admin.DescribeBrokerHealthResult;
import org.apache.kafka.clients.admin.DescribeBrokerRemovalsResult;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsOptions;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.DescribeClassicGroupsResult;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeClusterLinksOptions;
import org.apache.kafka.clients.admin.DescribeClusterLinksResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeEvenClusterLoadStatusOptions;
import org.apache.kafka.clients.admin.DescribeEvenClusterLoadStatusResult;
import org.apache.kafka.clients.admin.DescribeFeaturesOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsResult;
import org.apache.kafka.clients.admin.DescribeProducersOptions;
import org.apache.kafka.clients.admin.DescribeProducersResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeShareGroupsResult;
import org.apache.kafka.clients.admin.DescribeStreamsGroupsResult;
import org.apache.kafka.clients.admin.DescribeSwitchoverStatusResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.DescribeTransactionsResult;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.EndpointType;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;
import org.apache.kafka.clients.admin.EvenClusterLoadStatusDescription;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.ExclusionOpResult;
import org.apache.kafka.clients.admin.ExclusionOperationError;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FenceProducersResult;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListClientMetricsResourcesResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.ListClusterLinksResult;
import org.apache.kafka.clients.admin.ListConfigResourcesOptions;
import org.apache.kafka.clients.admin.ListConfigResourcesResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListGroupsOptions;
import org.apache.kafka.clients.admin.ListGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListStreamsGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListStreamsGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListStreamsGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.ListTransactionsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.MemberAssignment;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;
import org.apache.kafka.clients.admin.ProducerState;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.RaftVoterEndpoint;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveBrokersOptions;
import org.apache.kafka.clients.admin.RemoveBrokersResult;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.RemoveRaftVoterOptions;
import org.apache.kafka.clients.admin.RemoveRaftVoterResult;
import org.apache.kafka.clients.admin.ReplicaInfo;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.admin.ResolveOffsetRangeOptions;
import org.apache.kafka.clients.admin.ResolveOffsetRangeResult;
import org.apache.kafka.clients.admin.ResolveOffsetRangeSpec;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.ShareGroupDescription;
import org.apache.kafka.clients.admin.ShareMemberAssignment;
import org.apache.kafka.clients.admin.ShareMemberDescription;
import org.apache.kafka.clients.admin.StreamsGroupDescription;
import org.apache.kafka.clients.admin.StreamsGroupMemberAssignment;
import org.apache.kafka.clients.admin.StreamsGroupMemberDescription;
import org.apache.kafka.clients.admin.StreamsGroupSubtopologyDescription;
import org.apache.kafka.clients.admin.SupportedVersionRange;
import org.apache.kafka.clients.admin.TerminateTransactionOptions;
import org.apache.kafka.clients.admin.TerminateTransactionResult;
import org.apache.kafka.clients.admin.TieredFragmentType;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.admin.TransactionDescription;
import org.apache.kafka.clients.admin.TransactionListing;
import org.apache.kafka.clients.admin.TransactionState;
import org.apache.kafka.clients.admin.TriggerEvenClusterLoadOptions;
import org.apache.kafka.clients.admin.TriggerEvenClusterLoadResult;
import org.apache.kafka.clients.admin.UnregisterBrokerOptions;
import org.apache.kafka.clients.admin.UnregisterBrokerResult;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UserScramCredentialDeletion;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.clients.admin.UserScramCredentialsDescription;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.AdminRequestInterceptor;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.ClassicGroupState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.TopicIdAndPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.BalancerLoadError;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.errors.BalancerOperationFailedException;
import org.apache.kafka.common.errors.BrokerRemovalInProgressException;
import org.apache.kafka.common.errors.BrokerRemovedException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkExistsException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.DuplicateVoterException;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.errors.InsufficientRebalancePlanMetricsException;
import org.apache.kafka.common.errors.InvalidBrokerRemovalException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LogDirNotFoundException;
import org.apache.kafka.common.errors.MismatchedEndpointTypeException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.RebalancePlanComputationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.TransactionalIdAuthorizationException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnrepresentableBrokerIdException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.errors.VoterNotFoundException;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.AddRaftVoterRequestData;
import org.apache.kafka.common.message.AddRaftVoterResponseData;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsResponseData;
import org.apache.kafka.common.message.AlterMirrorsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.message.AlterShareGroupOffsetsResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.ComputeEvenClusterLoadPlanResponseData;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.message.DeleteShareGroupOffsetsRequestData;
import org.apache.kafka.common.message.DeleteShareGroupOffsetsResponseData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeBalancerStatusResponseData;
import org.apache.kafka.common.message.DescribeBrokerAdditionsResponseData;
import org.apache.kafka.common.message.DescribeBrokerHealthResponseData;
import org.apache.kafka.common.message.DescribeBrokerRemovalsResponseData;
import org.apache.kafka.common.message.DescribeBrokerReplicaExclusionsResponseData;
import org.apache.kafka.common.message.DescribeCellLoadResponseData;
import org.apache.kafka.common.message.DescribeClusterLinksResponseData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.DescribeEvenClusterLoadStatusResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.DescribeMirrorsResponseData;
import org.apache.kafka.common.message.DescribeNetworkResponseData;
import org.apache.kafka.common.message.DescribeProducersResponseData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.DescribeShareGroupOffsetsRequestData;
import org.apache.kafka.common.message.DescribeShareGroupOffsetsResponseData;
import org.apache.kafka.common.message.DescribeSwitchoverStatusResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsRequestData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.InitProducerIdResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListClusterLinksResponseData;
import org.apache.kafka.common.message.ListConfigResourcesResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.RemoveBrokersRequestData;
import org.apache.kafka.common.message.RemoveBrokersResponseData;
import org.apache.kafka.common.message.RemoveRaftVoterRequestData;
import org.apache.kafka.common.message.RemoveRaftVoterResponseData;
import org.apache.kafka.common.message.ReplicaStatusResponseData;
import org.apache.kafka.common.message.ResolveOffsetRangeResponseData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.message.StreamsGroupDescribeResponseData;
import org.apache.kafka.common.message.TriggerEvenClusterLoadResponseData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.message.WriteTxnMarkersResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.BalancerOperationOverriddenException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddRaftVoterRequest;
import org.apache.kafka.common.requests.AddRaftVoterResponse;
import org.apache.kafka.common.requests.AlterBrokerHealthResponse;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsResponse;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterMirrorsResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.apache.kafka.common.requests.AlterShareGroupOffsetsResponse;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ComputeEvenClusterLoadPlanResponse;
import org.apache.kafka.common.requests.ConsumerGroupDescribeRequest;
import org.apache.kafka.common.requests.ConsumerGroupDescribeResponse;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteClusterLinksResponse;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteShareGroupOffsetsRequest;
import org.apache.kafka.common.requests.DeleteShareGroupOffsetsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeBalancerStatusResponse;
import org.apache.kafka.common.requests.DescribeBrokerAdditionsResponse;
import org.apache.kafka.common.requests.DescribeBrokerHealthResponse;
import org.apache.kafka.common.requests.DescribeBrokerRemovalsResponse;
import org.apache.kafka.common.requests.DescribeBrokerReplicaExclusionsResponse;
import org.apache.kafka.common.requests.DescribeCellLoadResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeClusterLinksResponse;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeEvenClusterLoadStatusResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.requests.DescribeMirrorsResponse;
import org.apache.kafka.common.requests.DescribeNetworkResponse;
import org.apache.kafka.common.requests.DescribeProducersRequest;
import org.apache.kafka.common.requests.DescribeProducersResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.DescribeShareGroupOffsetsRequest;
import org.apache.kafka.common.requests.DescribeShareGroupOffsetsResponse;
import org.apache.kafka.common.requests.DescribeSwitchoverStatusResponse;
import org.apache.kafka.common.requests.DescribeTopicPartitionsResponse;
import org.apache.kafka.common.requests.DescribeTransactionsRequest;
import org.apache.kafka.common.requests.DescribeTransactionsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListClusterLinksResponse;
import org.apache.kafka.common.requests.ListConfigResourcesRequest;
import org.apache.kafka.common.requests.ListConfigResourcesResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.ListTransactionsRequest;
import org.apache.kafka.common.requests.ListTransactionsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.apache.kafka.common.requests.RemoveBrokersResponse;
import org.apache.kafka.common.requests.RemoveRaftVoterRequest;
import org.apache.kafka.common.requests.RemoveRaftVoterResponse;
import org.apache.kafka.common.requests.ReplicaStatusResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.ResolveOffsetRangeResponse;
import org.apache.kafka.common.requests.ShareGroupDescribeResponse;
import org.apache.kafka.common.requests.StreamsGroupDescribeResponse;
import org.apache.kafka.common.requests.TriggerEvenClusterLoadResponse;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.telemetry.internals.ClientTelemetryReporter;
import org.apache.kafka.common.telemetry.internals.ClientTelemetrySender;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockMetricsReporter;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=120L)
public class KafkaAdminClientTest {
    private static final Logger log = LoggerFactory.getLogger(KafkaAdminClientTest.class);
    private static final String GROUP_ID = "group-0";
    public static final Uuid REPLICA_DIRECTORY_ID = Uuid.randomUuid();
    private final int defaultControllerId = 0;
    private static final AclBinding ACL1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
    private static final AclBinding ACL2 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic4", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.DENY));
    private static final AclBindingFilter FILTER1 = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.LITERAL), new AccessControlEntryFilter("User:ANONYMOUS", null, AclOperation.ANY, AclPermissionType.ANY));
    private static final AclBindingFilter FILTER2 = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.LITERAL), new AccessControlEntryFilter("User:bob", null, AclOperation.ANY, AclPermissionType.ANY));
    private static final AclBindingFilter UNKNOWN_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.UNKNOWN, null, PatternType.LITERAL), new AccessControlEntryFilter("User:bob", null, AclOperation.ANY, AclPermissionType.ANY));

    @AfterAll
    public static void tearDown() throws Exception {
        TestUtils.verifyNoUnexpectedThreads();
    }

    @Test
    public void testDefaultApiTimeoutAndRequestTimeoutConflicts() {
        AdminClientConfig config = KafkaAdminClientTest.newConfMap("default.api.timeout.ms", "500");
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> KafkaAdminClient.createInternal((AdminClientConfig)config, null));
        Assertions.assertInstanceOf(ConfigException.class, (Object)exception.getCause());
    }

    @Test
    public void testParseDescribeClusterResponseWithError() {
        Assertions.assertThrows(MismatchedEndpointTypeException.class, () -> KafkaAdminClient.parseDescribeClusterResponse((DescribeClusterResponseData)new DescribeClusterResponseData().setErrorCode(Errors.MISMATCHED_ENDPOINT_TYPE.code()).setErrorMessage("The request was sent to an endpoint of type BROKER, but we wanted an endpoint of type CONTROLLER")));
    }

    @Test
    public void testParseDescribeClusterResponseWithUnexpectedEndpointType() {
        Assertions.assertThrows(MismatchedEndpointTypeException.class, () -> KafkaAdminClient.parseDescribeClusterResponse((DescribeClusterResponseData)new DescribeClusterResponseData().setEndpointType(EndpointType.BROKER.id())));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testParseSuccessfulDescribeClusterResponse(boolean includeController) {
        Cluster cluster = KafkaAdminClient.parseDescribeClusterResponse((DescribeClusterResponseData)new DescribeClusterResponseData().setControllerId(includeController ? 0 : -1).setEndpointType(EndpointType.CONTROLLER.id()).setClusterId("Ek8tjqq1QBWfnaoyHFZqDg").setBrokers(new DescribeClusterResponseData.DescribeClusterBrokerCollection(Arrays.asList(new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(0).setHost("controller0.com").setPort(9092), new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(1).setHost("controller1.com").setPort(9092), new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(2).setHost("controller2.com").setPort(9092)).iterator())));
        if (includeController) {
            Assertions.assertNotNull((Object)cluster.controller());
            Assertions.assertEquals((int)0, (int)cluster.controller().id());
        } else {
            Assertions.assertNull((Object)cluster.controller());
        }
        Assertions.assertEquals((Object)"Ek8tjqq1QBWfnaoyHFZqDg", (Object)cluster.clusterResource().clusterId());
        Assertions.assertEquals(new HashSet<Node>(Arrays.asList(new Node(0, "controller0.com", 9092), new Node(1, "controller1.com", 9092), new Node(2, "controller2.com", 9092))), new HashSet(cluster.nodes()));
    }

    @Test
    public void testGetOrCreateListValue() {
        HashMap map = new HashMap();
        List fooList = KafkaAdminClient.getOrCreateListValue(map, (Object)"foo");
        Assertions.assertNotNull((Object)fooList);
        fooList.add("a");
        fooList.add("b");
        List fooList2 = KafkaAdminClient.getOrCreateListValue(map, (Object)"foo");
        Assertions.assertEquals((Object)fooList, (Object)fooList2);
        Assertions.assertTrue((boolean)fooList2.contains("a"));
        Assertions.assertTrue((boolean)fooList2.contains("b"));
        List barList = KafkaAdminClient.getOrCreateListValue(map, (Object)"bar");
        Assertions.assertNotNull((Object)barList);
        Assertions.assertTrue((boolean)barList.isEmpty());
    }

    @Test
    public void testCalcTimeoutMsRemainingAsInt() {
        Assertions.assertEquals((int)0, (int)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)1000L, (long)1000L));
        Assertions.assertEquals((int)100, (int)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)1000L, (long)1100L));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)0L, (long)Long.MAX_VALUE));
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)Long.MAX_VALUE, (long)0L));
    }

    @Test
    public void testPrettyPrintException() {
        Assertions.assertEquals((Object)"Null exception.", (Object)KafkaAdminClient.prettyPrintException(null));
        Assertions.assertEquals((Object)"TimeoutException", (Object)KafkaAdminClient.prettyPrintException((Throwable)new TimeoutException()));
        Assertions.assertEquals((Object)"TimeoutException: The foobar timed out.", (Object)KafkaAdminClient.prettyPrintException((Throwable)new TimeoutException("The foobar timed out.")));
    }

    private static Map<String, Object> newStrMap(String ... vals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrap.servers", "localhost:8121");
        map.put("request.timeout.ms", "1000");
        if (vals.length % 2 != 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < vals.length; i += 2) {
            map.put(vals[i], vals[i + 1]);
        }
        return map;
    }

    private static AdminClientConfig newConfMap(String ... vals) {
        return new AdminClientConfig(KafkaAdminClientTest.newStrMap(vals));
    }

    @Test
    public void testGenerateClientId() {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            String id = KafkaAdminClient.generateClientId((AdminClientConfig)KafkaAdminClientTest.newConfMap("client.id", ""));
            Assertions.assertFalse((boolean)ids.contains(id), (String)("Got duplicate id " + id));
            ids.add(id);
        }
        Assertions.assertEquals((Object)"myCustomId", (Object)KafkaAdminClient.generateClientId((AdminClientConfig)KafkaAdminClientTest.newConfMap("client.id", "myCustomId")));
    }

    @Test
    public void testMetricsReporterAutoGeneratedClientId() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        KafkaAdminClient admin = (KafkaAdminClient)AdminClient.create((Properties)props);
        MockMetricsReporter mockMetricsReporter = (MockMetricsReporter)admin.metrics.reporters().get(0);
        Assertions.assertEquals((Object)admin.getClientId(), (Object)mockMetricsReporter.clientId);
        Assertions.assertEquals((int)1, (int)admin.metrics.reporters().size());
        admin.close();
    }

    @Test
    public void testDisableJmxReporter() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", "");
        KafkaAdminClient admin = (KafkaAdminClient)AdminClient.create((Properties)props);
        Assertions.assertTrue((boolean)admin.metrics.reporters().isEmpty());
        admin.close();
    }

    @Test
    public void testExplicitlyEnableJmxReporter() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", "org.apache.kafka.common.metrics.JmxReporter");
        KafkaAdminClient admin = (KafkaAdminClient)AdminClient.create((Properties)props);
        Assertions.assertEquals((int)1, (int)admin.metrics.reporters().size());
        admin.close();
    }

    @Test
    public void testExplicitlyEnableTelemetryReporter() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("enable.metrics.push", "true");
        try (KafkaAdminClient admin = (KafkaAdminClient)AdminClient.create((Properties)props);){
            List telemetryReporterList = admin.metrics.reporters().stream().filter(r -> r instanceof ClientTelemetryReporter).map(r -> (ClientTelemetryReporter)r).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)telemetryReporterList.size());
        }
    }

    @Test
    public void testTelemetryReporterIsDisabledByDefault() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        try (KafkaAdminClient admin = (KafkaAdminClient)AdminClient.create((Properties)props);){
            List telemetryReporterList = admin.metrics.reporters().stream().filter(r -> r instanceof ClientTelemetryReporter).map(r -> (ClientTelemetryReporter)r).collect(Collectors.toList());
            Assertions.assertTrue((boolean)telemetryReporterList.isEmpty());
        }
    }

    private static Cluster mockCluster(int numNodes, int controllerIndex) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.put(i, new Node(i, "localhost", 8121 + i));
        }
        return new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(controllerIndex));
    }

    private static Cluster mockBootstrapCluster() {
        return Cluster.bootstrap((List)ClientUtils.parseAndValidateAddresses(Collections.singletonList("localhost:8121"), (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS));
    }

    private static AdminClientUnitTestEnv mockClientEnv(String ... configVals) {
        return new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(3, 0), configVals);
    }

    private static AdminClientUnitTestEnv mockClientEnv(Time time, String ... configVals) {
        return new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0), configVals);
    }

    @Test
    public void testCloseAdminClient() {
        AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);
        if (env != null) {
            env.close();
        }
    }

    @Test
    @Timeout(value=10L)
    public void testCloseAdminClientInCallback() throws InterruptedException {
        MockTime time = new MockTime();
        AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0));
        ListTopicsResult result = env.adminClient().listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(1000)));
        KafkaFuture kafkaFuture = result.listings();
        Semaphore callbackCalled = new Semaphore(0);
        kafkaFuture.whenComplete((topicListings, throwable) -> {
            env.close();
            callbackCalled.release();
        });
        time.sleep(2000L);
        callbackCalled.acquire();
    }

    @Test
    public void testAdminClientFailureWhenClosed() {
        MockTime time = new MockTime();
        AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0));
        env.adminClient().close();
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all().get());
        Assertions.assertInstanceOf(IllegalStateException.class, (Object)e.getCause(), (String)("Expected an IllegalStateException error, but got " + Utils.stackTrace((Throwable)e)));
    }

    private static OffsetDeleteResponse prepareOffsetDeleteResponse(Errors error) {
        return new OffsetDeleteResponse(new OffsetDeleteResponseData().setErrorCode(error.code()).setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection()));
    }

    private static OffsetDeleteResponse prepareOffsetDeleteResponse(String topic, int partition, Errors error) {
        return new OffsetDeleteResponse(new OffsetDeleteResponseData().setErrorCode(Errors.NONE.code()).setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(Stream.of(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topic).setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(partition).setErrorCode(error.code())).iterator()))).collect(Collectors.toList()).iterator())));
    }

    private static OffsetCommitResponse prepareOffsetCommitResponse(TopicPartition tp, Errors error) {
        HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
        responseData.put(tp, error);
        return new OffsetCommitResponse(0, responseData);
    }

    private static CreateTopicsResponse prepareCreateTopicsResponse(String topicName, Errors error) {
        CreateTopicsResponseData data = new CreateTopicsResponseData();
        data.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(topicName).setErrorCode(error.code()));
        return new CreateTopicsResponse(data);
    }

    public static CreateTopicsResponse prepareCreateTopicsResponse(int throttleTimeMs, CreateTopicsResponseData.CreatableTopicResult ... topics) {
        CreateTopicsResponseData data = new CreateTopicsResponseData().setThrottleTimeMs(throttleTimeMs).setTopics(new CreateTopicsResponseData.CreatableTopicResultCollection(Arrays.stream(topics).iterator()));
        return new CreateTopicsResponse(data);
    }

    private static AlterBrokerReplicaExclusionsResponse prepareAlterBrokerReplicaExclusionsResponse(Errors topLevelError) {
        AlterBrokerReplicaExclusionsResponseData data = new AlterBrokerReplicaExclusionsResponseData();
        data.setErrorMessage(topLevelError.exception().getMessage());
        data.setErrorCode(topLevelError.code());
        data.setWasApplied(false);
        data.setBrokerExclusions(Arrays.asList(new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setReason("maintenance").setExclusionOperationCode(ExclusionOp.OpType.SET.id()).setExclusionErrorMessage(topLevelError.exception().getMessage()).setExclusionErrorCode(topLevelError.code()).setBrokerId(1), new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setReason("maintenance").setExclusionOperationCode(ExclusionOp.OpType.DELETE.id()).setExclusionErrorMessage(topLevelError.exception().getMessage()).setExclusionErrorCode(topLevelError.code()).setBrokerId(2)));
        return new AlterBrokerReplicaExclusionsResponse(data);
    }

    private static AlterBrokerReplicaExclusionsResponse prepareAlterBrokerReplicaExclusionsResponse(Map<Integer, ApiException> brokerIdToException, Map<Integer, ExclusionOp> operations) {
        AlterBrokerReplicaExclusionsResponseData data = new AlterBrokerReplicaExclusionsResponseData();
        data.setErrorCode(Errors.NONE.code());
        data.setWasApplied(brokerIdToException.isEmpty());
        ArrayList<AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse> exclusions = new ArrayList<AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse>();
        for (Map.Entry<Integer, ExclusionOp> exclusionOpEntry : operations.entrySet()) {
            int brokerId = exclusionOpEntry.getKey();
            AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse response = new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse();
            ApiException exception = brokerIdToException.get(brokerId);
            if (exception != null) {
                response = response.setExclusionErrorCode(Errors.forException((Throwable)exception).code()).setExclusionErrorMessage(exception.getMessage());
            }
            response.setReason(exclusionOpEntry.getValue().reason()).setExclusionOperationCode(exclusionOpEntry.getValue().opType().id()).setBrokerId(brokerId);
            exclusions.add(response);
        }
        data.setBrokerExclusions(exclusions);
        return new AlterBrokerReplicaExclusionsResponse(data);
    }

    private static DescribeBrokerReplicaExclusionsResponse prepareDescribeBrokerReplicaExclusionsResponse(Errors topLevelError) {
        DescribeBrokerReplicaExclusionsResponseData data = new DescribeBrokerReplicaExclusionsResponseData();
        data.setErrorMessage(topLevelError.exception().getMessage());
        data.setErrorCode(topLevelError.code());
        DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponseCollection exclusions = new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponseCollection();
        exclusions.add((ImplicitLinkedHashCollection.Element)new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(1).setReason("maintenance"));
        exclusions.add((ImplicitLinkedHashCollection.Element)new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(2).setReason("maintenance"));
        data.setExcludedBrokers(exclusions);
        return new DescribeBrokerReplicaExclusionsResponse(data);
    }

    private static DescribeBrokerReplicaExclusionsResponse prepareDescribeBrokerReplicaExclusionsResponse(Map<Integer, String> exclusionReasons) {
        DescribeBrokerReplicaExclusionsResponseData data = new DescribeBrokerReplicaExclusionsResponseData();
        data.setErrorCode(Errors.NONE.code());
        DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponseCollection exclusions = new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponseCollection();
        for (Map.Entry<Integer, String> entry : exclusionReasons.entrySet()) {
            exclusions.add((ImplicitLinkedHashCollection.Element)new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(entry.getKey().intValue()).setReason(entry.getValue()));
        }
        data.setExcludedBrokers(exclusions);
        return new DescribeBrokerReplicaExclusionsResponse(data);
    }

    private static RemoveBrokersResponse prepareRemoveBrokersResponse(Integer brokerId, Errors error) {
        RemoveBrokersResponseData data = new RemoveBrokersResponseData();
        data.setBrokersToRemove(Collections.singletonList(new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(brokerId.intValue()))).setErrorCode(error.code());
        return new RemoveBrokersResponse(data);
    }

    private static RemoveBrokersResponse prepareRemoveBrokersResponse(Integer brokerId, Errors error, String errorMessage) {
        RemoveBrokersResponseData data = new RemoveBrokersResponseData();
        data.setBrokersToRemove(Collections.singletonList(new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(brokerId.intValue()))).setErrorCode(error.code()).setErrorMessage(errorMessage);
        return new RemoveBrokersResponse(data);
    }

    private static RemoveBrokersResponse prepareRemoveBrokersResponse(List<Integer> brokerIds, Errors error) {
        RemoveBrokersResponseData data = new RemoveBrokersResponseData();
        ArrayList brokersToRemoveResponse = new ArrayList();
        brokerIds.forEach(brokerId -> {
            RemoveBrokersResponseData.RemoveBrokerResponse response = new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(brokerId.intValue());
            brokersToRemoveResponse.add(response);
        });
        data.setBrokersToRemove(brokersToRemoveResponse).setErrorCode(error.code());
        return new RemoveBrokersResponse(data);
    }

    private static DescribeBrokerRemovalsResponse prepareDescribeBrokerRemovalsResponse(Map<Integer, Errors> brokerRemovals) {
        return KafkaAdminClientTest.prepareDescribeBrokerRemovalsResponse(Errors.NONE, brokerRemovals);
    }

    private static DescribeBrokerRemovalsResponse prepareDescribeBrokerRemovalsResponse(Errors topLevelError, Map<Integer, Errors> brokerRemovals) {
        String brokerShutdownStatusValue = "COMPLETE";
        String partitionReassignmentStatusValue = "IN_PROGRESS";
        DescribeBrokerRemovalsResponseData data = new DescribeBrokerRemovalsResponseData().setRemovedBrokers(brokerRemovals.entrySet().stream().map(entry -> new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setBrokerId(((Integer)entry.getKey()).intValue()).setRemovalErrorCode(((Errors)entry.getValue()).code()).setGeneralOperationStatus(BalancerOperationStatus.IN_PROGRESS.toString()).setShutdownScheduled(true).setBrokerShutdownStatus(brokerShutdownStatusValue).setShutdownStatus(BrokerShutdownStatus.COMPLETED.toString()).setPartitionReassignmentsStatus(partitionReassignmentStatusValue).setReassignmentsStatus(PartitionReassignmentsStatus.IN_PROGRESS.toString()).setBrokerReplicaExclusionStatus(BrokerReplicaExclusionStatus.COMPLETED.toString())).collect(Collectors.toList())).setErrorCode(topLevelError.code());
        return new DescribeBrokerRemovalsResponse(data);
    }

    private static DescribeBrokerRemovalsResponse prepareDescribeBrokerRemovalsResponseWithoutExclusionFields(Errors topLevelError, Map<Integer, Errors> brokerRemovals) {
        String brokerShutdownStatusValue = "COMPLETE";
        String partitionReassignmentStatusValue = "IN_PROGRESS";
        DescribeBrokerRemovalsResponseData data = new DescribeBrokerRemovalsResponseData().setRemovedBrokers(brokerRemovals.entrySet().stream().map(entry -> new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setBrokerId(((Integer)entry.getKey()).intValue()).setRemovalErrorCode(((Errors)entry.getValue()).code()).setGeneralOperationStatus(BalancerOperationStatus.IN_PROGRESS.toString()).setBrokerShutdownStatus(brokerShutdownStatusValue).setShutdownStatus(BrokerShutdownStatus.COMPLETED.toString()).setPartitionReassignmentsStatus(partitionReassignmentStatusValue).setReassignmentsStatus(PartitionReassignmentsStatus.IN_PROGRESS.toString())).collect(Collectors.toList())).setErrorCode(topLevelError.code());
        return new DescribeBrokerRemovalsResponse(data);
    }

    private static DescribeBrokerRemovalsResponse prepareDescribeBrokerRemovalsResponseWithUnrecognizedStatusValues(int brokerId) {
        String unrecognizedStatusValue = "INVALID";
        DescribeBrokerRemovalsResponseData data = new DescribeBrokerRemovalsResponseData().setRemovedBrokers(Collections.singletonList(new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setBrokerId(brokerId).setRemovalErrorCode(Errors.REBALANCE_PLAN_COMPUTATION_FAILED.code()).setGeneralOperationStatus(unrecognizedStatusValue).setBrokerShutdownStatus(unrecognizedStatusValue).setPartitionReassignmentsStatus(unrecognizedStatusValue).setBrokerReplicaExclusionStatus(unrecognizedStatusValue).setReassignmentsStatus(unrecognizedStatusValue).setShutdownStatus(unrecognizedStatusValue))).setErrorCode(Errors.NONE.code());
        return new DescribeBrokerRemovalsResponse(data);
    }

    private static DescribeBrokerAdditionsResponse prepareDescribeBrokerAdditionsResponse(Map<Integer, ApiException> brokerAdditions) {
        return KafkaAdminClientTest.prepareDescribeBrokerAdditionsResponse(Errors.NONE, brokerAdditions);
    }

    private static DescribeBrokerAdditionsResponse prepareDescribeBrokerAdditionsResponse(Errors topLevelError, Map<Integer, ApiException> brokerAdditions) {
        return KafkaAdminClientTest.prepareDescribeBrokerAdditionsResponse(topLevelError.exception(), brokerAdditions);
    }

    private static DescribeBrokerAdditionsResponse prepareDescribeBrokerAdditionsResponse(ApiException topLevelException, Map<Integer, ApiException> brokerAdditions) {
        DescribeBrokerAdditionsResponseData data = new DescribeBrokerAdditionsResponseData().setBrokerAdditions(brokerAdditions.entrySet().stream().map(entry -> new DescribeBrokerAdditionsResponseData.BrokerAdditionsResponse().setBrokerId(((Integer)entry.getKey()).intValue()).setAdditionErrorCode(entry.getValue() == null ? Errors.NONE.code() : Errors.forException((Throwable)((Throwable)entry.getValue())).code()).setAdditionErrorMessage(entry.getValue() == null ? "" : ((ApiException)entry.getValue()).getMessage()).setPartitionReassignmentsStatus(PartitionReassignmentsStatus.COMPLETED.toString()).setGeneralOperationStatus(BalancerOperationStatus.IN_PROGRESS.toString()).setCreateTimeMs(100L).setLastUpdateTimeMs(101L)).collect(Collectors.toList()));
        if (topLevelException != null) {
            data = data.setErrorCode(Errors.forException((Throwable)topLevelException).code()).setErrorMessage(topLevelException.getMessage());
        }
        return new DescribeBrokerAdditionsResponse(data);
    }

    private static DescribeBrokerAdditionsResponse prepareDescribeBrokerAdditionsResponseWithUnrecognizedStatusValues(int brokerId) {
        String unrecognizedStatusValue = "UNRECOGNIZED";
        DescribeBrokerAdditionsResponseData data = new DescribeBrokerAdditionsResponseData().setBrokerAdditions(Collections.singletonList(new DescribeBrokerAdditionsResponseData.BrokerAdditionsResponse().setBrokerId(brokerId).setAdditionErrorCode(Errors.REBALANCE_PLAN_COMPUTATION_FAILED.code()).setGeneralOperationStatus(unrecognizedStatusValue).setPartitionReassignmentsStatus(unrecognizedStatusValue).setCreateTimeMs(100L).setLastUpdateTimeMs(101L))).setErrorCode(Errors.NONE.code());
        return new DescribeBrokerAdditionsResponse(data);
    }

    private static DescribeBalancerStatusResponse prepareDescribeBalancerStatusResponse(ApiException balancerStatus) {
        return KafkaAdminClientTest.prepareDescribeBalancerStatusResponse(Errors.NONE, balancerStatus);
    }

    private static DescribeBalancerStatusResponse prepareDescribeBalancerStatusResponse(Errors topLevelError, ApiException balancerStatus) {
        return KafkaAdminClientTest.prepareDescribeBalancerStatusResponse(topLevelError.exception(), balancerStatus);
    }

    private static DescribeBalancerStatusResponse prepareDescribeBalancerStatusResponse(ApiException topLevelException, ApiException balancerStatus) {
        DescribeBalancerStatusResponseData data = new DescribeBalancerStatusResponseData().setBalancerStatus(new DescribeBalancerStatusResponseData.BalancerStatusResponse().setGeneralBalancerStatus(BalancerStatus.DISABLED.toString()).setBalancerStatusErrorCode(balancerStatus == null ? Errors.NONE.code() : Errors.forException((Throwable)balancerStatus).code()).setBalancerStatusErrorMessage(balancerStatus == null ? "" : balancerStatus.getMessage()));
        if (topLevelException != null) {
            data = data.setErrorCode(Errors.forException((Throwable)topLevelException).code()).setErrorMessage(topLevelException.getMessage());
        }
        return new DescribeBalancerStatusResponse(data);
    }

    private static DescribeBalancerStatusResponse prepareDescribeBalancerStatusResponseWithUnrecognizedStatusResponse() {
        String unrecognizedStatus = "UNRECOGNIZED";
        DescribeBalancerStatusResponseData data = new DescribeBalancerStatusResponseData().setBalancerStatus(new DescribeBalancerStatusResponseData.BalancerStatusResponse().setGeneralBalancerStatus(unrecognizedStatus).setBalancerStatusErrorCode(Errors.NONE.code()).setBalancerStatusErrorMessage("")).setErrorCode(Errors.NONE.code());
        return new DescribeBalancerStatusResponse(data);
    }

    private static TriggerEvenClusterLoadResponse prepareTriggerEvenClusterLoadResponse(Errors evenClusterLoadError) {
        TriggerEvenClusterLoadResponseData data = new TriggerEvenClusterLoadResponseData().setErrorCode(evenClusterLoadError.code()).setErrorMessage(evenClusterLoadError != Errors.NONE ? evenClusterLoadError.exception().getMessage() : "");
        return new TriggerEvenClusterLoadResponse(data);
    }

    private static ComputeEvenClusterLoadPlanResponse prepareComputeEvenClusterLoadPlanResponse(Errors errors) {
        ComputeEvenClusterLoadPlanResponseData data = new ComputeEvenClusterLoadPlanResponseData().setErrorCode(errors.code()).setErrorMessage(errors != Errors.NONE ? errors.exception().getMessage() : "");
        return new ComputeEvenClusterLoadPlanResponse(data);
    }

    private static DescribeEvenClusterLoadStatusResponse prepareDescribeEvenClusterLoadStatusResponse(ApiException evenClusterLoadStatus) {
        return KafkaAdminClientTest.prepareDescribeEvenClusterLoadStatusResponse(Errors.NONE, evenClusterLoadStatus);
    }

    private static DescribeEvenClusterLoadStatusResponse prepareDescribeEvenClusterLoadStatusResponse(Errors topLevelError, ApiException evenClusterLoadStatus) {
        return KafkaAdminClientTest.prepareDescribeEvenClusterLoadStatusResponse(topLevelError.exception(), evenClusterLoadStatus);
    }

    private static DescribeEvenClusterLoadStatusResponse prepareDescribeEvenClusterLoadStatusResponse(ApiException topLevelException, ApiException evenClusterLoadStatus) {
        DescribeEvenClusterLoadStatusResponseData data = new DescribeEvenClusterLoadStatusResponseData().setEvenClusterLoadStatus(new DescribeEvenClusterLoadStatusResponseData.EvenClusterLoadStatusResponse().setHealUnevenLoadTrigger(BalancerSelfHealMode.ANY_UNEVEN_LOAD.name()).setCurrentStatus(EvenClusterLoadStatus.BALANCING.name()).setCurrentStatusLastUpdateTimeMs(120L).setPreviousStatus(EvenClusterLoadStatus.BALANCING_FAILED.name()).setPreviousStatusLastUpdateTimeMs(110L).setEvenClusterLoadErrorCode(evenClusterLoadStatus == null ? Errors.NONE.code() : Errors.forException((Throwable)evenClusterLoadStatus).code()).setEvenClusterLoadErrorMessage(evenClusterLoadStatus == null ? "" : evenClusterLoadStatus.getMessage()));
        if (topLevelException != null) {
            data = data.setErrorCode(Errors.forException((Throwable)topLevelException).code()).setErrorMessage(topLevelException.getMessage());
        }
        return new DescribeEvenClusterLoadStatusResponse(data);
    }

    private static DescribeEvenClusterLoadStatusResponse prepareDescribeEvenClusterLoadStatusResponseWithUnrecognizedStatusValues() {
        String unrecognizedStatus = "UNRECOGNIZED";
        DescribeEvenClusterLoadStatusResponseData data = new DescribeEvenClusterLoadStatusResponseData().setEvenClusterLoadStatus(new DescribeEvenClusterLoadStatusResponseData.EvenClusterLoadStatusResponse().setHealUnevenLoadTrigger(unrecognizedStatus).setCurrentStatus(unrecognizedStatus).setCurrentStatusLastUpdateTimeMs(120L).setPreviousStatus(unrecognizedStatus).setPreviousStatusLastUpdateTimeMs(110L).setEvenClusterLoadErrorCode(Errors.NONE.code()).setEvenClusterLoadErrorMessage("")).setErrorCode(Errors.NONE.code());
        return new DescribeEvenClusterLoadStatusResponse(data);
    }

    private static DescribeEvenClusterLoadStatusResponse prepareDescribeEvenClusterLoadStatusResponseWithNullStatus() {
        DescribeEvenClusterLoadStatusResponseData data = new DescribeEvenClusterLoadStatusResponseData().setEvenClusterLoadStatus(new DescribeEvenClusterLoadStatusResponseData.EvenClusterLoadStatusResponse().setHealUnevenLoadTrigger(BalancerSelfHealMode.EMPTY_BROKER.name()).setCurrentStatus(null).setCurrentStatusLastUpdateTimeMs(0L).setPreviousStatus(null).setPreviousStatusLastUpdateTimeMs(0L).setEvenClusterLoadErrorCode(Errors.NONE.code()).setEvenClusterLoadErrorMessage("")).setErrorCode(Errors.NONE.code());
        return new DescribeEvenClusterLoadStatusResponse(data);
    }

    public static CreateTopicsResponseData.CreatableTopicResult creatableTopicResult(String name, Errors error) {
        return new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(error.code());
    }

    public static DeleteTopicsResponse prepareDeleteTopicsResponse(int throttleTimeMs, DeleteTopicsResponseData.DeletableTopicResult ... topics) {
        DeleteTopicsResponseData data = new DeleteTopicsResponseData().setThrottleTimeMs(throttleTimeMs).setResponses(new DeleteTopicsResponseData.DeletableTopicResultCollection(Arrays.stream(topics).iterator()));
        return new DeleteTopicsResponse(data);
    }

    public static DeleteTopicsResponseData.DeletableTopicResult deletableTopicResult(String topicName, Errors error) {
        return new DeleteTopicsResponseData.DeletableTopicResult().setName(topicName).setErrorCode(error.code());
    }

    public static DeleteTopicsResponseData.DeletableTopicResult deletableTopicResultWithId(Uuid topicId, Errors error) {
        return new DeleteTopicsResponseData.DeletableTopicResult().setTopicId(topicId).setErrorCode(error.code());
    }

    public static CreatePartitionsResponse prepareCreatePartitionsResponse(int throttleTimeMs, CreatePartitionsResponseData.CreatePartitionsTopicResult ... topics) {
        CreatePartitionsResponseData data = new CreatePartitionsResponseData().setThrottleTimeMs(throttleTimeMs).setResults(Arrays.asList(topics));
        return new CreatePartitionsResponse(data);
    }

    public static CreatePartitionsResponseData.CreatePartitionsTopicResult createPartitionsTopicResult(String name, Errors error) {
        return KafkaAdminClientTest.createPartitionsTopicResult(name, error, null);
    }

    public static CreatePartitionsResponseData.CreatePartitionsTopicResult createPartitionsTopicResult(String name, Errors error, String errorMessage) {
        return new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(name).setErrorCode(error.code()).setErrorMessage(errorMessage);
    }

    private static DeleteTopicsResponse prepareDeleteTopicsResponse(String topicName, Errors error) {
        DeleteTopicsResponseData data = new DeleteTopicsResponseData();
        data.responses().add((ImplicitLinkedHashCollection.Element)new DeleteTopicsResponseData.DeletableTopicResult().setName(topicName).setErrorCode(error.code()));
        return new DeleteTopicsResponse(data);
    }

    private static DeleteTopicsResponse prepareDeleteTopicsResponseWithTopicId(Uuid id, Errors error) {
        DeleteTopicsResponseData data = new DeleteTopicsResponseData();
        data.responses().add((ImplicitLinkedHashCollection.Element)new DeleteTopicsResponseData.DeletableTopicResult().setTopicId(id).setErrorCode(error.code()));
        return new DeleteTopicsResponse(data);
    }

    private static FindCoordinatorResponse prepareFindCoordinatorResponse(Errors error, Node node) {
        return KafkaAdminClientTest.prepareFindCoordinatorResponse(error, GROUP_ID, node);
    }

    private static FindCoordinatorResponse prepareFindCoordinatorResponse(Errors error, String key, Node node) {
        return FindCoordinatorResponse.prepareResponse((Errors)error, (String)key, (Node)node);
    }

    private static FindCoordinatorResponse prepareFindCoordinatorResponse(List<FindCoordinatorResponse.CoordinatorData> coordinatorData) {
        return FindCoordinatorResponse.prepareResponse(coordinatorData);
    }

    private static FindCoordinatorResponse prepareOldFindCoordinatorResponse(Errors error, Node node) {
        return FindCoordinatorResponse.prepareOldResponse((Errors)error, (Node)node);
    }

    private static FindCoordinatorResponse prepareBatchedFindCoordinatorResponse(Errors error, Node node, Collection<String> groups) {
        FindCoordinatorResponseData data = new FindCoordinatorResponseData();
        List coordinators = groups.stream().map(group -> new FindCoordinatorResponseData.Coordinator().setErrorCode(error.code()).setErrorMessage(error.message()).setKey(group).setHost(node.host()).setPort(node.port()).setNodeId(node.id())).collect(Collectors.toList());
        data.setCoordinators(coordinators);
        return new FindCoordinatorResponse(data);
    }

    private static FindCoordinatorResponse prepareBatchedMirrorTopicFindCoordinatorResponse(Errors error, Map<String, Node> topicToNode) {
        FindCoordinatorResponseData data = new FindCoordinatorResponseData();
        List coordinators = topicToNode.keySet().stream().map(topic -> new FindCoordinatorResponseData.Coordinator().setErrorCode(error.code()).setErrorMessage(error.message()).setKey(topic).setHost(((Node)topicToNode.get(topic)).host()).setPort(((Node)topicToNode.get(topic)).port()).setNodeId(((Node)topicToNode.get(topic)).id())).collect(Collectors.toList());
        data.setCoordinators(coordinators);
        return new FindCoordinatorResponse(data);
    }

    private static MetadataResponse prepareMetadataResponse(Cluster cluster, Errors error) {
        return KafkaAdminClientTest.prepareMetadataResponse(cluster, error, error);
    }

    private static MetadataResponse prepareMetadataResponse(Cluster cluster, Errors topicError, Errors partitionError) {
        ArrayList<MetadataResponseData.MetadataResponseTopic> metadata = new ArrayList<MetadataResponseData.MetadataResponseTopic>();
        for (String topic : cluster.topics()) {
            ArrayList<MetadataResponseData.MetadataResponsePartition> pms = new ArrayList<MetadataResponseData.MetadataResponsePartition>();
            for (PartitionInfo pInfo : cluster.availablePartitionsForTopic(topic)) {
                MetadataResponseData.MetadataResponsePartition pm = new MetadataResponseData.MetadataResponsePartition().setErrorCode(partitionError.code()).setPartitionIndex(pInfo.partition()).setLeaderId(pInfo.leader().id()).setLeaderEpoch(234).setReplicaNodes(Arrays.stream(pInfo.replicas()).map(Node::id).collect(Collectors.toList())).setIsrNodes(Arrays.stream(pInfo.inSyncReplicas()).map(Node::id).collect(Collectors.toList())).setOfflineReplicas(Arrays.stream(pInfo.offlineReplicas()).map(Node::id).collect(Collectors.toList()));
                pms.add(pm);
            }
            MetadataResponseData.MetadataResponseTopic tm = new MetadataResponseData.MetadataResponseTopic().setErrorCode(topicError.code()).setName(topic).setIsInternal(false).setPartitions(pms);
            if (!cluster.topicId(topic).equals((Object)Uuid.ZERO_UUID)) {
                tm.setTopicId(cluster.topicId(topic));
            }
            metadata.add(tm);
        }
        return MetadataResponse.prepareResponse((boolean)true, (int)0, (Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), metadata, (int)Integer.MIN_VALUE);
    }

    private static DescribeGroupsResponseData prepareDescribeGroupsResponseData(String groupId, List<String> groupInstances, List<TopicPartition> topicPartitions) {
        ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
        List describedGroupMembers = groupInstances.stream().map(groupInstance -> DescribeGroupsResponse.groupMember((String)"", (String)groupInstance, (String)"clientId0", (String)"clientHost", (byte[])new byte[memberAssignment.remaining()], null)).collect(Collectors.toList());
        DescribeGroupsResponseData data = new DescribeGroupsResponseData();
        data.groups().add(DescribeGroupsResponse.groupMetadata((String)groupId, (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", describedGroupMembers, Collections.emptySet()));
        return data;
    }

    private static FeatureMetadata defaultFeatureMetadata() {
        return new FeatureMetadata(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)new FinalizedVersionRange(2, 2))}), Optional.of(1L), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)new SupportedVersionRange(1, 5))}));
    }

    private static Features<org.apache.kafka.common.feature.SupportedVersionRange> convertSupportedFeaturesMap(Map<String, SupportedVersionRange> features) {
        HashMap<String, org.apache.kafka.common.feature.SupportedVersionRange> featuresMap = new HashMap<String, org.apache.kafka.common.feature.SupportedVersionRange>();
        for (Map.Entry<String, SupportedVersionRange> entry : features.entrySet()) {
            SupportedVersionRange versionRange = entry.getValue();
            featuresMap.put(entry.getKey(), new org.apache.kafka.common.feature.SupportedVersionRange(versionRange.minVersion(), versionRange.maxVersion()));
        }
        return Features.supportedFeatures(featuresMap);
    }

    private static ApiVersionsResponse prepareApiVersionsResponseForDescribeFeatures(Errors error) {
        if (error == Errors.NONE) {
            return new ApiVersionsResponse.Builder().setApiVersions(ApiVersionsResponse.filterApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER, (boolean)false, (ApiMessageType.ApiVisibility)ApiMessageType.ApiVisibility.DEFAULT, (boolean)false, (boolean)true)).setSupportedFeatures(KafkaAdminClientTest.convertSupportedFeaturesMap(KafkaAdminClientTest.defaultFeatureMetadata().supportedFeatures())).setFinalizedFeatures(Collections.singletonMap("test_feature_1", (short)2)).setFinalizedFeaturesEpoch(((Long)KafkaAdminClientTest.defaultFeatureMetadata().finalizedFeaturesEpoch().get()).longValue()).build();
        }
        return new ApiVersionsResponse(new ApiVersionsResponseData().setThrottleTimeMs(0).setErrorCode(error.code()));
    }

    private static QuorumInfo defaultQuorumInfo(boolean emptyOptionals) {
        return new QuorumInfo(1, 1L, 1L, Collections.singletonList(new QuorumInfo.ReplicaState(1, emptyOptionals ? Uuid.ZERO_UUID : REPLICA_DIRECTORY_ID, 100L, emptyOptionals ? OptionalLong.empty() : OptionalLong.of(1000L), emptyOptionals ? OptionalLong.empty() : OptionalLong.of(1000L))), Collections.singletonList(new QuorumInfo.ReplicaState(1, emptyOptionals ? Uuid.ZERO_UUID : REPLICA_DIRECTORY_ID, 100L, emptyOptionals ? OptionalLong.empty() : OptionalLong.of(1000L), emptyOptionals ? OptionalLong.empty() : OptionalLong.of(1000L))), Collections.singletonMap(1, new QuorumInfo.Node(1, Collections.emptyList())));
    }

    private static DescribeQuorumResponse prepareDescribeQuorumResponse(Errors topLevelError, Errors partitionLevelError, Boolean topicCountError, Boolean topicNameError, Boolean partitionCountError, Boolean partitionIndexError, Boolean emptyOptionals) {
        int i;
        String topicName = topicNameError != false ? "RANDOM" : "__cluster_metadata";
        int partitionIndex = partitionIndexError != false ? 1 : Topic.CLUSTER_METADATA_TOPIC_PARTITION.partition();
        ArrayList<DescribeQuorumResponseData.TopicData> topics = new ArrayList<DescribeQuorumResponseData.TopicData>();
        ArrayList<DescribeQuorumResponseData.PartitionData> partitions = new ArrayList<DescribeQuorumResponseData.PartitionData>();
        for (i = 0; i < (partitionCountError != false ? 2 : 1); ++i) {
            DescribeQuorumResponseData.ReplicaState replica = new DescribeQuorumResponseData.ReplicaState().setReplicaId(1).setReplicaDirectoryId(emptyOptionals != false ? Uuid.ZERO_UUID : REPLICA_DIRECTORY_ID).setLogEndOffset(100L);
            replica.setLastFetchTimestamp(emptyOptionals != false ? -1L : 1000L);
            replica.setLastCaughtUpTimestamp(emptyOptionals != false ? -1L : 1000L);
            partitions.add(new DescribeQuorumResponseData.PartitionData().setPartitionIndex(partitionIndex).setLeaderId(1).setLeaderEpoch(1).setHighWatermark(1L).setCurrentVoters(Collections.singletonList(replica)).setObservers(Collections.singletonList(replica)).setErrorCode(partitionLevelError.code()).setErrorMessage(partitionLevelError.message()));
        }
        for (i = 0; i < (topicCountError != false ? 2 : 1); ++i) {
            topics.add(new DescribeQuorumResponseData.TopicData().setTopicName(topicName).setPartitions(partitions));
        }
        return new DescribeQuorumResponse(new DescribeQuorumResponseData().setTopics(topics).setErrorCode(topLevelError.code()).setErrorMessage(topLevelError.message()).setNodes(new DescribeQuorumResponseData.NodeCollection(Collections.singleton(new DescribeQuorumResponseData.Node().setNodeId(1)).iterator())));
    }

    @Test
    public void testTimeoutWithoutMetadata() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, KafkaAdminClientTest.mockBootstrapCluster(), KafkaAdminClientTest.newStrMap("request.timeout.ms", "10"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(1000))).all();
            TestUtils.assertFutureThrows(TimeoutException.class, future);
        }
    }

    @Test
    public void testConnectionFailureOnMetadataUpdate() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockBootstrapCluster();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, cluster);){
            Cluster discoveredCluster = KafkaAdminClientTest.mockCluster(3, 0);
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, null, true);
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, (AbstractResponse)RequestTestUtils.metadataResponse(discoveredCluster.nodes(), discoveredCluster.clusterResource().clusterId(), 1, Collections.emptyList()));
            env.kafkaClient().prepareResponse(body -> body instanceof CreateTopicsRequest, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testUnreachableBootstrapServer() throws Exception {
        this.verifyUnreachableBootstrapServer(MetadataRecoveryStrategy.REBOOTSTRAP);
    }

    @Test
    public void testUnreachableBootstrapServerNoRebootstrap() throws Exception {
        this.verifyUnreachableBootstrapServer(MetadataRecoveryStrategy.NONE);
    }

    private void verifyUnreachableBootstrapServer(MetadataRecoveryStrategy metadataRecoveryStrategy) throws Exception {
        Cluster cluster = Cluster.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 8121)));
        Map<Node, Long> unreachableNodes = Collections.singletonMap((Node)cluster.nodes().get(0), 200L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, cluster, AdminClientUnitTestEnv.clientConfigs("metadata.recovery.strategy", metadataRecoveryStrategy.name), unreachableNodes);){
            Cluster discoveredCluster = KafkaAdminClientTest.mockCluster(3, 0);
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(body -> body instanceof MetadataRequest, (AbstractResponse)RequestTestUtils.metadataResponse(discoveredCluster.nodes(), discoveredCluster.clusterResource().clusterId(), 1, Collections.emptyList()));
            if (metadataRecoveryStrategy == MetadataRecoveryStrategy.REBOOTSTRAP) {
                env.kafkaClient().prepareResponse(body -> body instanceof MetadataRequest, (AbstractResponse)RequestTestUtils.metadataResponse(discoveredCluster.nodes(), discoveredCluster.clusterResource().clusterId(), 1, Collections.emptyList()));
            }
            env.kafkaClient().prepareResponse(body -> body instanceof CreateTopicsRequest, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testPropagatedMetadataFetchException() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("bootstrap.servers", "localhost:8121", "request.timeout.ms", "10"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().createPendingAuthenticationError(env.cluster().nodeById(0), TimeUnit.DAYS.toMillis(1L));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(1000))).all();
            TestUtils.assertFutureThrows(SaslAuthenticationException.class, future);
        }
    }

    @Test
    public void testCreateTopics() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("myTopic"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testCreateTopicsPartialResponse() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("myTopic", "myTopic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            CreateTopicsResult topicsResult = env.adminClient().createTopics(Arrays.asList(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2))), new NewTopic("myTopic2", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000)));
            ((KafkaFuture)topicsResult.values().get("myTopic")).get();
            TestUtils.assertFutureThrows(ApiException.class, (Future)topicsResult.values().get("myTopic2"));
        }
    }

    @Test
    public void testCreateTopicsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return body instanceof CreateTopicsRequest;
            }, null, true);
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return body instanceof CreateTopicsRequest;
            }, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting CreateTopics first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry CreateTopics call");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"CreateTopics retry did not await expected backoff");
        }
    }

    @Test
    public void testCreateTopicsHandleNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 1, Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE), env.cluster().nodeById(1));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testAlterBrokerReplicaExclusionHandlesNotControllerException() throws Exception {
        HashMap<Integer, ExclusionOp> operations = new HashMap<Integer, ExclusionOp>();
        operations.put(1, new ExclusionOp(ExclusionOp.OpType.SET, "Cluster maintenance"));
        operations.put(2, new ExclusionOp(ExclusionOp.OpType.DELETE, "Cluster maintenance"));
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareAlterBrokerReplicaExclusionsResponse(Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)1, Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareAlterBrokerReplicaExclusionsResponse(Collections.emptyMap(), Collections.emptyMap()), env.cluster().nodeById(1));
            KafkaFuture future = env.adminClient().alterBrokerReplicaExclusions(operations, (AlterBrokerReplicaExclusionsOptions)new AlterBrokerReplicaExclusionsOptions().timeoutMs(Integer.valueOf(10000))).result();
            future.get();
        }
    }

    @Test
    public void testAlterBrokerReplicaExclusionHandlesClusterAuthorizationException() throws Exception {
        HashMap<Integer, ExclusionOp> operations = new HashMap<Integer, ExclusionOp>();
        operations.put(1, new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"));
        operations.put(2, new ExclusionOp(ExclusionOp.OpType.DELETE, "maintenance"));
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom(request -> request instanceof AlterBrokerReplicaExclusionsRequest, (AbstractResponse)KafkaAdminClientTest.prepareAlterBrokerReplicaExclusionsResponse(Errors.CLUSTER_AUTHORIZATION_FAILED), env.cluster().nodeById(0));
            KafkaFuture future = env.adminClient().alterBrokerReplicaExclusions(operations, (AlterBrokerReplicaExclusionsOptions)new AlterBrokerReplicaExclusionsOptions().timeoutMs(Integer.valueOf(10000))).result();
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, future);
        }
    }

    @Test
    public void testAlterBrokerReplicaExclusionHandlesTimeoutException() throws Exception {
        HashMap<Integer, ExclusionOp> operations = new HashMap<Integer, ExclusionOp>();
        operations.put(1, new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"));
        operations.put(2, new ExclusionOp(ExclusionOp.OpType.DELETE, "maintenance"));
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime(1500L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, cluster);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom(request -> request instanceof AlterBrokerReplicaExclusionsRequest, (AbstractResponse)KafkaAdminClientTest.prepareAlterBrokerReplicaExclusionsResponse(Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, (AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)0, Collections.emptyList()));
            KafkaFuture future = env.adminClient().alterBrokerReplicaExclusions(operations, (AlterBrokerReplicaExclusionsOptions)new AlterBrokerReplicaExclusionsOptions().timeoutMs(Integer.valueOf(10000))).result();
            TestUtils.assertFutureThrows(TimeoutException.class, future);
        }
    }

    @Test
    public void testAlterBrokerReplicaExclusionHandlesInvalidReasons() throws Exception {
        HashMap<Integer, ExclusionOp> operations = new HashMap<Integer, ExclusionOp>();
        String invalidReason1 = ".";
        String invalidReason2 = "?exclusion?";
        operations.put(1, new ExclusionOp(ExclusionOp.OpType.SET, invalidReason1));
        operations.put(2, new ExclusionOp(ExclusionOp.OpType.DELETE, invalidReason2));
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime(1500L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, cluster);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            KafkaFuture future = env.adminClient().alterBrokerReplicaExclusions(operations, (AlterBrokerReplicaExclusionsOptions)new AlterBrokerReplicaExclusionsOptions().timeoutMs(Integer.valueOf(10000))).result();
            TestUtils.assertFutureThrows(InvalidBrokerReplicaExclusionException.class, future);
        }
    }

    @Test
    public void testAlterBrokerReplicaExclusionThrowsUnrepresentableBrokerIdException() throws Exception {
        HashMap<Integer, ExclusionOp> operations = new HashMap<Integer, ExclusionOp>();
        int unrepresentableBrokerId = -1;
        operations.put(unrepresentableBrokerId, new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"));
        operations.put(2, new ExclusionOp(ExclusionOp.OpType.DELETE, "maintenance"));
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime(1500L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, cluster);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            KafkaFuture future = env.adminClient().alterBrokerReplicaExclusions(operations, (AlterBrokerReplicaExclusionsOptions)new AlterBrokerReplicaExclusionsOptions().timeoutMs(Integer.valueOf(10000))).result();
            UnrepresentableBrokerIdException exception = TestUtils.assertFutureThrows(UnrepresentableBrokerIdException.class, future);
            Assertions.assertEquals((int)unrepresentableBrokerId, (int)exception.brokerId());
        }
    }

    @Test
    public void testAlterBrokerReplicaExclusionExclusionLevelException() throws Exception {
        HashMap<Integer, ExclusionOp> operations = new HashMap<Integer, ExclusionOp>();
        operations.put(1, new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"));
        operations.put(2, new ExclusionOp(ExclusionOp.OpType.DELETE, "maintenance"));
        HashMap<Integer, ApiException> exceptions = new HashMap<Integer, ApiException>();
        String expectedErrMsg = "invalid!";
        InvalidBrokerReplicaExclusionException invalidException = new InvalidBrokerReplicaExclusionException(expectedErrMsg);
        exceptions.put(2, (ApiException)invalidException);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareAlterBrokerReplicaExclusionsResponse(exceptions, operations), env.cluster().nodeById(0));
            KafkaFuture future = env.adminClient().alterBrokerReplicaExclusions(operations).result();
            AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)future.get();
            Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected exclusion to not be applied if there was an exception with any one of them");
            Assertions.assertEquals((int)2, (int)result.exclusionResultByBroker().size());
            ExclusionOpResult broker1Result = (ExclusionOpResult)result.exclusionResultByBroker().get(1);
            Assertions.assertEquals((Object)"maintenance", (Object)broker1Result.reason());
            Assertions.assertEquals((Object)ExclusionOp.OpType.SET, (Object)broker1Result.opType());
            Assertions.assertFalse((boolean)broker1Result.errorOpt().isPresent(), (String)"expected the first exclusion to not have an error");
            ExclusionOpResult broker2Result = (ExclusionOpResult)result.exclusionResultByBroker().get(2);
            Assertions.assertEquals((Object)"maintenance", (Object)broker2Result.reason());
            Assertions.assertEquals((Object)ExclusionOp.OpType.DELETE, (Object)broker2Result.opType());
            Assertions.assertTrue((boolean)broker2Result.errorOpt().isPresent(), (String)"expected the second exclusion to have an error");
            ExclusionOperationError error = (ExclusionOperationError)broker2Result.errorOpt().get();
            Assertions.assertEquals((Object)expectedErrMsg, (Object)error.errorMessage());
            Assertions.assertEquals((short)Errors.INVALID_REPLICA_EXCLUSION.code(), (short)error.errorCode());
            Assertions.assertEquals(invalidException.getClass(), error.exception().getClass());
        }
    }

    @Test
    public void testAlterBrokerReplicaExclusionSuccess() throws Exception {
        HashMap<Integer, ExclusionOp> operations = new HashMap<Integer, ExclusionOp>();
        operations.put(1, new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"));
        operations.put(2, new ExclusionOp(ExclusionOp.OpType.DELETE, "maintenance"));
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareAlterBrokerReplicaExclusionsResponse(Collections.emptyMap(), operations), env.cluster().nodeById(0));
            KafkaFuture future = env.adminClient().alterBrokerReplicaExclusions(operations).result();
            AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)future.get();
            Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Expected exclusion to be applied");
            Assertions.assertEquals((int)2, (int)result.exclusionResultByBroker().size());
            ExclusionOpResult broker1Result = (ExclusionOpResult)result.exclusionResultByBroker().get(1);
            Assertions.assertEquals((Object)"maintenance", (Object)broker1Result.reason());
            Assertions.assertEquals((Object)ExclusionOp.OpType.SET, (Object)broker1Result.opType());
            Assertions.assertFalse((boolean)broker1Result.errorOpt().isPresent(), (String)"expected the first exclusion to not have an error");
            ExclusionOpResult broker2Result = (ExclusionOpResult)result.exclusionResultByBroker().get(2);
            Assertions.assertEquals((Object)"maintenance", (Object)broker2Result.reason());
            Assertions.assertEquals((Object)ExclusionOp.OpType.DELETE, (Object)broker2Result.opType());
            Assertions.assertFalse((boolean)broker2Result.errorOpt().isPresent(), (String)"expected the second exclusion to not have an error");
        }
    }

    @Test
    public void testDescribeBrokerReplicaExclusionHandlesNotControllerException() throws Exception {
        HashMap<Integer, String> mockedExclusions = new HashMap<Integer, String>();
        mockedExclusions.put(1, "maintenance");
        mockedExclusions.put(2, "maintenance");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerReplicaExclusionsResponse(Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)0, Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerReplicaExclusionsResponse(mockedExclusions), env.cluster().nodeById(0));
            KafkaFuture future = env.adminClient().describeBrokerReplicaExclusions().descriptions();
            List exclusions = (List)future.get();
            Assertions.assertEquals((int)2, (int)exclusions.size());
            Assertions.assertEquals(mockedExclusions, exclusions.stream().collect(Collectors.toMap(DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription::brokerId, DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription::reason)));
        }
    }

    @Test
    public void testDescribeBrokerReplicaExclusionHandlesClusterAuthorizationException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerReplicaExclusionsResponse(Errors.CLUSTER_AUTHORIZATION_FAILED), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)0, Collections.emptyList()));
            KafkaFuture future = env.adminClient().describeBrokerReplicaExclusions().descriptions();
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, future);
        }
    }

    @Test
    public void testDescribeBrokerReplicaExclusionHandlesTimeoutException() throws Exception {
        HashMap<Integer, String> mockedExclusions = new HashMap<Integer, String>();
        mockedExclusions.put(1, "maintenance");
        mockedExclusions.put(2, "maintenance");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerReplicaExclusionsResponse(Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)1, Collections.emptyList()));
            KafkaFuture future = env.adminClient().describeBrokerReplicaExclusions((DescribeBrokerReplicaExclusionsOptions)new DescribeBrokerReplicaExclusionsOptions().timeoutMs(Integer.valueOf(10000))).descriptions();
            TestUtils.assertFutureThrows(TimeoutException.class, future);
        }
    }

    @Test
    public void testDescribeBrokerReplicaExclusionSuccess() throws Exception {
        HashMap<Integer, String> mockedExclusions = new HashMap<Integer, String>();
        mockedExclusions.put(1, "maintenance");
        mockedExclusions.put(2, "maintenance");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerReplicaExclusionsResponse(mockedExclusions), env.cluster().nodeById(0));
            KafkaFuture future = env.adminClient().describeBrokerReplicaExclusions().descriptions();
            List exclusions = (List)future.get();
            Assertions.assertEquals((int)2, (int)exclusions.size());
            Assertions.assertEquals(mockedExclusions, exclusions.stream().collect(Collectors.toMap(DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription::brokerId, DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription::reason)));
        }
    }

    @Test
    public void testRemoveBrokersHandlesNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareRemoveBrokersResponse(1, Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)1, Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareRemoveBrokersResponse(1, Errors.NONE), env.cluster().nodeById(1));
            KafkaFuture future = env.adminClient().removeBrokers(Collections.singletonList(1), (RemoveBrokersOptions)new RemoveBrokersOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testRemoveBrokersHandlesClusterAuthorizationException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareRemoveBrokersResponse(1, Errors.CLUSTER_AUTHORIZATION_FAILED));
            RemoveBrokersResult result = env.adminClient().removeBrokers(Collections.singletonList(1), (RemoveBrokersOptions)new RemoveBrokersOptions().timeoutMs(Integer.valueOf(10000)));
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, (Future)result.values().get(1));
        }
    }

    @Test
    public void testRemoveBrokersHandlesInvalidRequestException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareRemoveBrokersResponse(1, Errors.INVALID_REQUEST));
            TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)env.adminClient().removeBrokers(Collections.singletonList(1), (RemoveBrokersOptions)new RemoveBrokersOptions().timeoutMs(Integer.valueOf(10000))).values().get(1));
        }
    }

    @Test
    public void testRemoveBrokersHandlesTimeoutException() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime(1500L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, cluster);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareRemoveBrokersResponse(1, Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)0, Collections.emptyList()));
            RemoveBrokersResult result = env.adminClient().removeBrokers(Collections.singletonList(1), (RemoveBrokersOptions)new RemoveBrokersOptions().timeoutMs(Integer.valueOf(2000)));
            TestUtils.assertFutureThrows(TimeoutException.class, result.all());
        }
    }

    @Test
    public void testRemoveBrokersHandlesBrokerLevelException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            RemoveBrokersResponseData data = new RemoveBrokersResponseData();
            RemoveBrokersResponseData.RemoveBrokerResponse response1 = new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(2).setErrorCode(Errors.BROKER_REMOVAL_IN_PROGRESS.code());
            RemoveBrokersResponseData.RemoveBrokerResponse response2 = new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(5).setErrorCode(Errors.INVALID_REQUEST.code());
            RemoveBrokersResponseData.RemoveBrokerResponse response3 = new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(3).setErrorCode(Errors.BROKER_REMOVED.code());
            data.setBrokersToRemove(Arrays.asList(response1, response2, response3)).setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new RemoveBrokersResponse(data), env.cluster().nodeById(0));
            RemoveBrokersResult result = env.adminClient().removeBrokers(Arrays.asList(2, 3, 5), (RemoveBrokersOptions)new RemoveBrokersOptions().timeoutMs(Integer.valueOf(1000)));
            TestUtils.assertFutureThrows(BrokerRemovalInProgressException.class, (Future)result.values().get(2));
            TestUtils.assertFutureThrows(BrokerRemovedException.class, (Future)result.values().get(3));
            TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)result.values().get(5));
        }
    }

    private MockClient.RequestMatcher expectRemoveBrokersRequest(List<RemoveBrokersRequestData.BrokerId> brokerIds) {
        return body -> {
            if (body instanceof RemoveBrokersRequest) {
                RemoveBrokersRequest request = (RemoveBrokersRequest)body;
                for (RemoveBrokersRequestData.BrokerId brokerId : brokerIds) {
                    if (request.data().brokersToRemove().contains(brokerId)) continue;
                    return false;
                }
                return brokerIds.size() == request.data().brokersToRemove().size() && request.data().shouldShutdown();
            }
            return false;
        };
    }

    @Test
    public void testRemoveBrokersRequest() throws Exception {
        List<Integer> brokersToRemove = Arrays.asList(1, 2, 3);
        List<RemoveBrokersRequestData.BrokerId> brokerIds = brokersToRemove.stream().map(brokerId -> new RemoveBrokersRequestData.BrokerId().setBrokerId(brokerId.intValue())).collect(Collectors.toList());
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectRemoveBrokersRequest(brokerIds), (AbstractResponse)KafkaAdminClientTest.prepareRemoveBrokersResponse(brokersToRemove, Errors.NONE));
            KafkaFuture future = env.adminClient().removeBrokers(brokersToRemove, (RemoveBrokersOptions)new RemoveBrokersOptions().timeoutMs(Integer.valueOf(1000))).all();
            future.get();
        }
    }

    @Test
    public void testDescribeBalancerStatusHandlesNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            int newControllerId = 1;
            MockClient kafkaClient = env.kafkaClient();
            kafkaClient.setNodeApiVersions(NodeApiVersions.create());
            kafkaClient.prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBalancerStatusResponse(Errors.NOT_CONTROLLER, null), env.cluster().nodeById(0));
            kafkaClient.prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)newControllerId, Collections.emptyList()));
            kafkaClient.prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBalancerStatusResponse(null), env.cluster().nodeById(newControllerId));
            KafkaFuture future = env.adminClient().describeBalancerStatus((DescribeBalancerStatusOptions)new DescribeBalancerStatusOptions().timeoutMs(Integer.valueOf(10000))).description();
            future.get();
        }
    }

    @Test
    public void testDescribeBalancerStatusHandlesClusterAuthorizationException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeBalancerStatusResponse(Errors.CLUSTER_AUTHORIZATION_FAILED, null));
            DescribeBalancerStatusResult result = env.adminClient().describeBalancerStatus((DescribeBalancerStatusOptions)new DescribeBalancerStatusOptions().timeoutMs(Integer.valueOf(10000)));
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, result.description());
        }
    }

    @Test
    public void testDescribeBalancerStatusHandlesTimeoutException() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime(1500L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, cluster);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBalancerStatusResponse(Errors.NOT_CONTROLLER, null), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)0, Collections.emptyList()));
            DescribeBalancerStatusResult result = env.adminClient().describeBalancerStatus((DescribeBalancerStatusOptions)new DescribeBalancerStatusOptions().timeoutMs(Integer.valueOf(2000)));
            TestUtils.assertFutureThrows(TimeoutException.class, result.description());
        }
    }

    @Test
    public void testDescribeBalancerStatusNoErrors() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBalancerStatusResponse(Errors.BALANCER_OFFLINE.exception()), env.cluster().nodeById(0));
            BalancerStatusDescription description = (BalancerStatusDescription)env.adminClient().describeBalancerStatus((DescribeBalancerStatusOptions)new DescribeBalancerStatusOptions().timeoutMs(Integer.valueOf(2000))).description().get();
            Assertions.assertEquals((Object)description.balancerStatus(), (Object)BalancerStatus.DISABLED);
            Assertions.assertEquals((short)((BalancerOperationError)description.balancerOperationError().get()).errorCode(), (short)Errors.BALANCER_OFFLINE.code());
            Assertions.assertTrue((boolean)((BalancerOperationError)description.balancerOperationError().get()).errorMessage().contains("Balancer component is disabled"));
            Assertions.assertEquals(((BalancerOperationError)description.balancerOperationError().get()).exception().getClass(), BalancerOfflineException.class);
        }
    }

    @Test
    public void testDescribeBalancerStatusWithUnknownStatusValue() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBalancerStatusResponseWithUnrecognizedStatusResponse(), env.cluster().nodeById(0));
            BalancerStatusDescription description = (BalancerStatusDescription)env.adminClient().describeBalancerStatus((DescribeBalancerStatusOptions)new DescribeBalancerStatusOptions().timeoutMs(Integer.valueOf(2000))).description().get();
            Assertions.assertEquals((Object)BalancerStatus.UNKNOWN, (Object)description.balancerStatus());
            Assertions.assertFalse((boolean)description.balancerOperationError().isPresent());
        }
    }

    @Test
    public void testTriggerEvenClusterLoadHandlesNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            int newControllerId = 1;
            MockClient kafkaClient = env.kafkaClient();
            kafkaClient.setNodeApiVersions(NodeApiVersions.create());
            kafkaClient.prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareTriggerEvenClusterLoadResponse(Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            kafkaClient.prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), newControllerId, Collections.emptyList()));
            kafkaClient.prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareTriggerEvenClusterLoadResponse(Errors.NONE), env.cluster().nodeById(newControllerId));
            KafkaFuture future = env.adminClient().triggerEvenClusterLoad(new ArrayList(), (TriggerEvenClusterLoadOptions)new TriggerEvenClusterLoadOptions().timeoutMs(Integer.valueOf(10000))).result();
            future.get();
        }
    }

    @Test
    public void testTriggerEvenClusterLoadHandlesClusterAuthorizationException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareTriggerEvenClusterLoadResponse(Errors.CLUSTER_AUTHORIZATION_FAILED), env.cluster().nodeById(0));
            TriggerEvenClusterLoadResult result = env.adminClient().triggerEvenClusterLoad(new ArrayList(), (TriggerEvenClusterLoadOptions)new TriggerEvenClusterLoadOptions().timeoutMs(Integer.valueOf(10000)));
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, result.result());
        }
    }

    @Test
    public void testTriggerEvenClusterLoadHandlesTimeoutException() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(2, 0);
        MockTime time = new MockTime(1500L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, cluster);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareTriggerEvenClusterLoadResponse(Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)0, Collections.emptyList()));
            TriggerEvenClusterLoadResult result = env.adminClient().triggerEvenClusterLoad(new ArrayList(), (TriggerEvenClusterLoadOptions)new TriggerEvenClusterLoadOptions().timeoutMs(Integer.valueOf(2000)));
            TestUtils.assertFutureThrows(TimeoutException.class, result.result());
        }
    }

    @Test
    public void testTriggerEvenClusterLoadWithError() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareTriggerEvenClusterLoadResponse(Errors.BALANCER_LOAD_ERROR), env.cluster().nodeById(0));
            TriggerEvenClusterLoadResult result = env.adminClient().triggerEvenClusterLoad(new ArrayList(), (TriggerEvenClusterLoadOptions)new TriggerEvenClusterLoadOptions().timeoutMs(Integer.valueOf(2000)));
            TestUtils.assertFutureThrows(BalancerLoadError.class, result.result());
        }
    }

    @Test
    public void testTriggerEvenClusterLoadSuccess() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareTriggerEvenClusterLoadResponse(Errors.NONE), env.cluster().nodeById(0));
            env.adminClient().triggerEvenClusterLoad(new ArrayList(), (TriggerEvenClusterLoadOptions)new TriggerEvenClusterLoadOptions().timeoutMs(Integer.valueOf(2000))).result().get();
        }
    }

    @Test
    public void testComputeEvenClusterLoadPlanHandlesNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            int newControllerId = 1;
            MockClient kafkaClient = env.kafkaClient();
            kafkaClient.setNodeApiVersions(NodeApiVersions.create());
            kafkaClient.prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareComputeEvenClusterLoadPlanResponse(Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            kafkaClient.prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), newControllerId, Collections.emptyList()));
            kafkaClient.prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareComputeEvenClusterLoadPlanResponse(Errors.NONE), env.cluster().nodeById(newControllerId));
            KafkaFuture future = env.adminClient().computeEvenClusterLoadPlan(new ArrayList(), (ComputeEvenClusterLoadPlanOptions)new ComputeEvenClusterLoadPlanOptions().timeoutMs(Integer.valueOf(10000))).result();
            future.get();
        }
    }

    @Test
    public void testComputeEvenClusterLoadPlanHandlesClusterAuthorizationException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareComputeEvenClusterLoadPlanResponse(Errors.CLUSTER_AUTHORIZATION_FAILED), env.cluster().nodeById(0));
            ComputeEvenClusterLoadPlanResult result = env.adminClient().computeEvenClusterLoadPlan(new ArrayList(), (ComputeEvenClusterLoadPlanOptions)new ComputeEvenClusterLoadPlanOptions().timeoutMs(Integer.valueOf(10000)));
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, result.result());
        }
    }

    @Test
    public void testComputeEvenClusterLoadPlanHandlesTimeoutException() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(2, 0);
        MockTime time = new MockTime(1500L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, cluster);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareComputeEvenClusterLoadPlanResponse(Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)0, Collections.emptyList()));
            ComputeEvenClusterLoadPlanResult result = env.adminClient().computeEvenClusterLoadPlan(new ArrayList(), (ComputeEvenClusterLoadPlanOptions)new ComputeEvenClusterLoadPlanOptions().timeoutMs(Integer.valueOf(2000)));
            TestUtils.assertFutureThrows(TimeoutException.class, result.result());
        }
    }

    @Test
    public void testComputeEvenClusterLoadPlanWithError() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareComputeEvenClusterLoadPlanResponse(Errors.BALANCER_LOAD_ERROR), env.cluster().nodeById(0));
            ComputeEvenClusterLoadPlanResult result = env.adminClient().computeEvenClusterLoadPlan(new ArrayList(), (ComputeEvenClusterLoadPlanOptions)new ComputeEvenClusterLoadPlanOptions().timeoutMs(Integer.valueOf(2000)));
            TestUtils.assertFutureThrows(BalancerLoadError.class, result.result());
        }
    }

    @Test
    public void testComputeEvenClusterLoadPlanSuccess() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareComputeEvenClusterLoadPlanResponse(Errors.NONE), env.cluster().nodeById(0));
            env.adminClient().computeEvenClusterLoadPlan(new ArrayList(), (ComputeEvenClusterLoadPlanOptions)new ComputeEvenClusterLoadPlanOptions().timeoutMs(Integer.valueOf(2000))).result().get();
        }
    }

    @Test
    public void testDescribeEvenClusterLoadStatusHandlesNotControllerException() throws Exception {
        EvenClusterLoadStatusDescription result;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            int newControllerId = 1;
            MockClient kafkaClient = env.kafkaClient();
            kafkaClient.setNodeApiVersions(NodeApiVersions.create());
            kafkaClient.prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeEvenClusterLoadStatusResponse(Errors.NOT_CONTROLLER, null), env.cluster().nodeById(0));
            kafkaClient.prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)newControllerId, Collections.emptyList()));
            kafkaClient.prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeEvenClusterLoadStatusResponse(null), env.cluster().nodeById(newControllerId));
            KafkaFuture future = env.adminClient().describeEvenClusterLoadStatus((DescribeEvenClusterLoadStatusOptions)new DescribeEvenClusterLoadStatusOptions().timeoutMs(Integer.valueOf(10000))).description();
            result = (EvenClusterLoadStatusDescription)future.get();
        }
        Assertions.assertEquals((Object)EvenClusterLoadStatus.BALANCING, (Object)result.currentEvenClusterLoadStatus());
        Assertions.assertEquals((long)120L, (long)result.currentStatusLastUpdatetimeMs());
        Assertions.assertEquals((Object)EvenClusterLoadStatus.BALANCING_FAILED, (Object)result.previousEvenClusterLoadStatus());
        Assertions.assertEquals((long)110L, (long)result.previousStatusLastUpdatetimeMs());
        Assertions.assertFalse((boolean)result.evenClusterLoadError().isPresent());
    }

    @Test
    public void testDescribeEvenClusterLoadStatusHandlesClusterAuthorizationException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeEvenClusterLoadStatusResponse(Errors.CLUSTER_AUTHORIZATION_FAILED, null));
            DescribeEvenClusterLoadStatusResult result = env.adminClient().describeEvenClusterLoadStatus((DescribeEvenClusterLoadStatusOptions)new DescribeEvenClusterLoadStatusOptions().timeoutMs(Integer.valueOf(10000)));
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, result.description());
        }
    }

    @Test
    public void testDescribeEvenClusterLoadStatusHandlesTimeoutException() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime(1500L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, cluster);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeEvenClusterLoadStatusResponse(Errors.NOT_CONTROLLER, null), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)0, Collections.emptyList()));
            DescribeEvenClusterLoadStatusResult result = env.adminClient().describeEvenClusterLoadStatus((DescribeEvenClusterLoadStatusOptions)new DescribeEvenClusterLoadStatusOptions().timeoutMs(Integer.valueOf(2000)));
            TestUtils.assertFutureThrows(TimeoutException.class, result.description());
        }
    }

    @Test
    public void testDescribeEvenClusterLoadStatusNoErrors() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeEvenClusterLoadStatusResponse(Errors.INSUFFICIENT_REBALANCE_PLAN_METRICS.exception()), env.cluster().nodeById(0));
            EvenClusterLoadStatusDescription description = (EvenClusterLoadStatusDescription)env.adminClient().describeEvenClusterLoadStatus((DescribeEvenClusterLoadStatusOptions)new DescribeEvenClusterLoadStatusOptions().timeoutMs(Integer.valueOf(2000))).description().get();
            Assertions.assertEquals((Object)BalancerSelfHealMode.ANY_UNEVEN_LOAD, (Object)description.healUnevenLoadTrigger());
            Assertions.assertEquals((Object)EvenClusterLoadStatus.BALANCING, (Object)description.currentEvenClusterLoadStatus());
            Assertions.assertEquals((long)120L, (long)description.currentStatusLastUpdatetimeMs());
            Assertions.assertEquals((Object)EvenClusterLoadStatus.BALANCING_FAILED, (Object)description.previousEvenClusterLoadStatus());
            Assertions.assertEquals((long)110L, (long)description.previousStatusLastUpdatetimeMs());
            Assertions.assertTrue((boolean)((BalancerOperationError)description.evenClusterLoadError().get()).errorMessage().contains("Confluent Balancer is working on metrics collection"));
            Assertions.assertEquals(InsufficientRebalancePlanMetricsException.class, ((BalancerOperationError)description.evenClusterLoadError().get()).exception().getClass());
        }
    }

    @Test
    public void testDescribeEvenClusterLoadStatusWithUnknownStatusValues() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeEvenClusterLoadStatusResponseWithUnrecognizedStatusValues(), env.cluster().nodeById(0));
            EvenClusterLoadStatusDescription description = (EvenClusterLoadStatusDescription)env.adminClient().describeEvenClusterLoadStatus((DescribeEvenClusterLoadStatusOptions)new DescribeEvenClusterLoadStatusOptions().timeoutMs(Integer.valueOf(2000))).description().get();
            Assertions.assertEquals((Object)BalancerSelfHealMode.UNKNOWN, (Object)description.healUnevenLoadTrigger());
            Assertions.assertEquals((Object)EvenClusterLoadStatus.UNKNOWN, (Object)description.currentEvenClusterLoadStatus());
            Assertions.assertEquals((long)120L, (long)description.currentStatusLastUpdatetimeMs());
            Assertions.assertEquals((Object)EvenClusterLoadStatus.UNKNOWN, (Object)description.previousEvenClusterLoadStatus());
            Assertions.assertEquals((long)110L, (long)description.previousStatusLastUpdatetimeMs());
            Assertions.assertFalse((boolean)description.evenClusterLoadError().isPresent());
        }
    }

    @Test
    public void testDescribeEvenClusterLoadStatusWithNullStatusValues() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeEvenClusterLoadStatusResponseWithNullStatus(), env.cluster().nodeById(0));
            EvenClusterLoadStatusDescription description = (EvenClusterLoadStatusDescription)env.adminClient().describeEvenClusterLoadStatus((DescribeEvenClusterLoadStatusOptions)new DescribeEvenClusterLoadStatusOptions().timeoutMs(Integer.valueOf(2000))).description().get();
            Assertions.assertEquals((Object)BalancerSelfHealMode.EMPTY_BROKER, (Object)description.healUnevenLoadTrigger());
            Assertions.assertNull((Object)description.currentEvenClusterLoadStatus());
            Assertions.assertEquals((long)0L, (long)description.currentStatusLastUpdatetimeMs());
            Assertions.assertNull((Object)description.previousEvenClusterLoadStatus());
            Assertions.assertEquals((long)0L, (long)description.previousStatusLastUpdatetimeMs());
            Assertions.assertFalse((boolean)description.evenClusterLoadError().isPresent());
        }
    }

    @Test
    public void testCreateTopicsRetryThrottlingExceptionWhenEnabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.creatableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(0, KafkaAdminClientTest.creatableTopicResult("topic2", Errors.NONE)));
            CreateTopicsResult result = env.adminClient().createTopics(Arrays.asList(new NewTopic("topic1", 1, 1), new NewTopic("topic2", 1, 1), new NewTopic("topic3", 1, 1)), new CreateTopicsOptions().retryOnQuotaViolation(true));
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic2")).get());
            TestUtils.assertFutureThrows(TopicExistsException.class, (Future)result.values().get("topic3"));
        }
    }

    @Test
    public void testRemoveBrokerWithValidBrokerIds() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            RemoveBrokersResponseData data = new RemoveBrokersResponseData();
            RemoveBrokersResponseData.RemoveBrokerResponse response0 = new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(0).setErrorCode(Errors.NONE.code());
            RemoveBrokersResponseData.RemoveBrokerResponse response1 = new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(1).setErrorCode(Errors.NONE.code());
            RemoveBrokersResponseData.RemoveBrokerResponse response2 = new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(2).setErrorCode(Errors.NONE.code());
            data.setBrokersToRemove(Arrays.asList(response0, response1, response2)).setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new RemoveBrokersResponse(data), env.cluster().nodeById(0));
            KafkaFuture future = env.adminClient().removeBrokers(Arrays.asList(0, 1, 2), (RemoveBrokersOptions)new RemoveBrokersOptions().timeoutMs(Integer.valueOf(1000))).all();
            Assertions.assertEquals((int)3, (int)((List)future.get()).size());
        }
    }

    @Test
    public void testRemoveBrokersHandlesInvalidBrokerIds() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            RemoveBrokersResult result = env.adminClient().removeBrokers(Arrays.asList(-2, 1, 1, null), (RemoveBrokersOptions)new RemoveBrokersOptions().timeoutMs(Integer.valueOf(1000)));
            Map values = result.values();
            KafkaFuture negativeBrokerIdResult = (KafkaFuture)values.get(-2);
            KafkaFuture duplicateBrokerIdResult = (KafkaFuture)values.get(1);
            String errorMessage = "The given broker id '%s' is %s and cannot be represented in a request";
            TestUtils.assertFutureThrowsException((ApiException)new InvalidBrokerRemovalException(String.format(errorMessage, "-2", "invalid")), negativeBrokerIdResult);
            TestUtils.assertFutureThrowsException((ApiException)new InvalidBrokerRemovalException(String.format(errorMessage, "1", "duplicate")), duplicateBrokerIdResult);
            Assertions.assertEquals((int)2, (int)result.values().size());
        }
    }

    @Test
    public void testRemoveBrokerHandlesPartitionUnavailability() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareRemoveBrokersResponse(1, Errors.INVALID_BROKER_REMOVAL, "Can't remove broker 1 as this will result in partitions becoming unavailable: PartitionInfo data"), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)0, Collections.emptyList()));
            RemoveBrokersResult result = env.adminClient().removeBrokers(Collections.singletonList(1), (RemoveBrokersOptions)new RemoveBrokersOptions().timeoutMs(Integer.valueOf(2000)));
            Map values = result.values();
            KafkaFuture failedBrokerRemovalResult = (KafkaFuture)values.get(1);
            TestUtils.assertFutureThrowsException((ApiException)new InvalidBrokerRemovalException("Can't remove broker 1 as this will result in partitions becoming unavailable: PartitionInfo data"), failedBrokerRemovalResult);
        }
    }

    @Test
    public void testDescribeBrokerRemovalsHandlesNotControllerException() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            int newControllerId = 1;
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerRemovalsResponse(Errors.NOT_CONTROLLER, Collections.emptyMap()), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)newControllerId, Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerRemovalsResponse(Collections.emptyMap()), env.cluster().nodeById(newControllerId));
            Map descriptions = (Map)env.adminClient().describeBrokerRemovals().descriptions().get();
            Assertions.assertEquals((int)0, (int)descriptions.size());
        }
    }

    @Test
    public void testDescribeBrokerRemovalsHandlesTopLevelException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerRemovalsResponse(Errors.CLUSTER_AUTHORIZATION_FAILED, Collections.emptyMap()), env.cluster().nodeById(0));
            DescribeBrokerRemovalsResult result = env.adminClient().describeBrokerRemovals();
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, result.descriptions());
        }
    }

    @Test
    public void testDescribeBrokerRemovalsHandlesTimeoutException() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime(1500L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, cluster);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerRemovalsResponse(Errors.NOT_CONTROLLER, Collections.emptyMap()), env.cluster().nodeById(0));
            DescribeBrokerRemovalsResult result = env.adminClient().describeBrokerRemovals();
            TestUtils.assertFutureThrows(TimeoutException.class, result.descriptions());
        }
    }

    @Test
    public void testDescribeBrokerRemovalsHandlesBrokerLevelRemovalExceptions() throws Exception {
        HashMap<Integer, Errors> removalDescriptions = new HashMap<Integer, Errors>();
        removalDescriptions.put(0, Errors.NONE);
        removalDescriptions.put(1, Errors.REBALANCE_PLAN_COMPUTATION_FAILED);
        removalDescriptions.put(2, Errors.REBALANCE_PLAN_COMPUTATION_FAILED);
        removalDescriptions.put(3, Errors.UNKNOWN_SERVER_ERROR);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerRemovalsResponse(removalDescriptions), env.cluster().nodeById(0));
            DescribeBrokerRemovalsResult result = env.adminClient().describeBrokerRemovals();
            Map descriptions = (Map)result.descriptions().get();
            Assertions.assertEquals((int)4, (int)descriptions.size());
            BrokerRemovalDescription broker0Removal = (BrokerRemovalDescription)descriptions.get(0);
            Assertions.assertEquals((Integer)0, (Integer)broker0Removal.brokerId());
            Assertions.assertEquals((Object)BalancerOperationStatus.IN_PROGRESS, (Object)((BrokerRemovalDescription)descriptions.get(0)).generalOperationStatus());
            Assertions.assertTrue((boolean)((BrokerRemovalDescription)descriptions.get(1)).removalError().isPresent(), (String)"Removal error should be populated when not NONE");
            Assertions.assertTrue((boolean)((BrokerRemovalDescription)descriptions.get(2)).removalError().isPresent(), (String)"Removal error should be populated when not NONE");
            Assertions.assertTrue((boolean)((BrokerRemovalDescription)descriptions.get(3)).removalError().isPresent(), (String)"Removal error should be populated when not NONE");
            Assertions.assertEquals(((BrokerRemovalError)((BrokerRemovalDescription)descriptions.get(1)).removalError().get()).exception().getClass(), RebalancePlanComputationException.class);
            Assertions.assertEquals(((BrokerRemovalError)((BrokerRemovalDescription)descriptions.get(2)).removalError().get()).exception().getClass(), RebalancePlanComputationException.class);
            Assertions.assertEquals(((BrokerRemovalError)((BrokerRemovalDescription)descriptions.get(3)).removalError().get()).exception().getClass(), UnknownServerException.class);
        }
    }

    @Test
    public void testDescribeBrokerRemovalsHandlesRequestsWithoutExclusionRelatedFields() throws Exception {
        HashMap<Integer, Errors> removalDescriptions = new HashMap<Integer, Errors>();
        removalDescriptions.put(0, Errors.NONE);
        removalDescriptions.put(1, Errors.REBALANCE_PLAN_COMPUTATION_FAILED);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerRemovalsResponseWithoutExclusionFields(Errors.NONE, removalDescriptions), env.cluster().nodeById(0));
            DescribeBrokerRemovalsResult result = env.adminClient().describeBrokerRemovals();
            Map descriptions = (Map)result.descriptions().get();
            Assertions.assertEquals((int)2, (int)descriptions.size());
            BrokerRemovalDescription broker0Removal = (BrokerRemovalDescription)descriptions.get(0);
            BrokerRemovalDescription broker1Removal = (BrokerRemovalDescription)descriptions.get(1);
            Assertions.assertEquals((Integer)0, (Integer)broker0Removal.brokerId());
            Assertions.assertEquals((Object)BalancerOperationStatus.IN_PROGRESS, (Object)broker0Removal.generalOperationStatus());
            Assertions.assertTrue((boolean)broker0Removal.isShutdownScheduled(), (String)"Expected shutdown scheduled to default to true when not set");
            Assertions.assertEquals((Object)BrokerReplicaExclusionStatus.UNKNOWN, (Object)broker0Removal.brokerReplicaExclusionStatus());
            Assertions.assertTrue((boolean)broker1Removal.removalError().isPresent(), (String)"Removal error should be populated when not NONE");
            Assertions.assertEquals(((BrokerRemovalError)broker1Removal.removalError().get()).exception().getClass(), RebalancePlanComputationException.class);
            Assertions.assertTrue((boolean)broker1Removal.isShutdownScheduled(), (String)"Expected shutdown scheduled to default to true when not set");
            Assertions.assertEquals((Object)BrokerReplicaExclusionStatus.UNKNOWN, (Object)broker1Removal.brokerReplicaExclusionStatus());
        }
    }

    @Test
    public void testDescribeBrokerRemovalsHandlesRequestsWithUnknownStatusFields() throws Exception {
        int brokerId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerRemovalsResponseWithUnrecognizedStatusValues(brokerId), env.cluster().nodeById(0));
            DescribeBrokerRemovalsResult result = env.adminClient().describeBrokerRemovals();
            Map descriptions = (Map)result.descriptions().get();
            Assertions.assertEquals((int)1, (int)descriptions.size());
            BrokerRemovalDescription brokerRemoval = (BrokerRemovalDescription)descriptions.get(brokerId);
            Assertions.assertEquals((int)brokerId, (Integer)brokerRemoval.brokerId());
            Assertions.assertEquals((Object)BalancerOperationStatus.UNKNOWN, (Object)brokerRemoval.generalOperationStatus());
            Assertions.assertTrue((boolean)brokerRemoval.isShutdownScheduled(), (String)"Expected shutdown scheduled to default to true when not set");
            Assertions.assertEquals((Object)BrokerReplicaExclusionStatus.UNKNOWN, (Object)brokerRemoval.brokerReplicaExclusionStatus());
            Assertions.assertEquals((Object)PartitionReassignmentsStatus.UNKNOWN, (Object)brokerRemoval.reassignmentsStatus());
            Assertions.assertEquals((Object)BrokerShutdownStatus.UNKNOWN, (Object)brokerRemoval.shutdownStatus());
            Assertions.assertTrue((boolean)brokerRemoval.removalError().isPresent(), (String)"Removal error should be populated when not NONE");
            Assertions.assertEquals(((BrokerRemovalError)brokerRemoval.removalError().get()).exception().getClass(), RebalancePlanComputationException.class);
        }
    }

    @Test
    public void testCreateTopicsRetryThrottlingExceptionWhenEnabledUntilRequestTimeOut() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "default.api.timeout.ms", String.valueOf(defaultApiTimeout));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.creatableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            CreateTopicsResult result = env.adminClient().createTopics(Arrays.asList(new NewTopic("topic1", 1, 1), new NewTopic("topic2", 1, 1), new NewTopic("topic3", 1, 1)), new CreateTopicsOptions().retryOnQuotaViolation(true));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting CreateTopics requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting next CreateTopics request");
            time.sleep(defaultApiTimeout + 1L);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows(ThrottlingQuotaExceededException.class, (Future)result.values().get("topic2"));
            Assertions.assertEquals((int)0, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows(TopicExistsException.class, (Future)result.values().get("topic3"));
        }
    }

    @Test
    public void testDescribeLogDirsWithVolumeBytes() throws ExecutionException, InterruptedException {
        Set<Integer> brokers = Collections.singleton(0);
        String logDir = "/var/data/kafka";
        TopicPartition tp = new TopicPartition("topic", 12);
        long partitionSize = 1234567890L;
        long offsetLag = 24L;
        long totalBytes = 123L;
        long usableBytes = 456L;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeLogDirsResponse(Errors.NONE, logDir, tp, partitionSize, offsetLag, totalBytes, usableBytes), env.cluster().nodeById(0));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(brokers);
            Map descriptions = result.descriptions();
            Assertions.assertEquals(brokers, descriptions.keySet());
            Assertions.assertNotNull(descriptions.get(0));
            KafkaAdminClientTest.assertDescriptionContains((Map)((KafkaFuture)descriptions.get(0)).get(), logDir, tp, partitionSize, offsetLag, OptionalLong.of(totalBytes), OptionalLong.of(usableBytes));
            Map allDescriptions = (Map)result.allDescriptions().get();
            Assertions.assertEquals(brokers, allDescriptions.keySet());
            KafkaAdminClientTest.assertDescriptionContains((Map)allDescriptions.get(0), logDir, tp, partitionSize, offsetLag, OptionalLong.of(totalBytes), OptionalLong.of(usableBytes));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareEmptyDescribeLogDirsResponse(Optional.empty()), env.cluster().nodeById(0));
            DescribeLogDirsResult errorResult = env.adminClient().describeLogDirs(brokers);
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> errorResult.allDescriptions().get());
            Assertions.assertTrue((boolean)(exception.getCause() instanceof ClusterAuthorizationException));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareEmptyDescribeLogDirsResponse(Optional.of(Errors.UNKNOWN_SERVER_ERROR)), env.cluster().nodeById(0));
            DescribeLogDirsResult errorResult2 = env.adminClient().describeLogDirs(brokers);
            exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> errorResult2.allDescriptions().get());
            Assertions.assertTrue((boolean)(exception.getCause() instanceof UnknownServerException));
        }
    }

    private static DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir, TopicPartition tp, long partitionSize, long offsetLag, long totalBytes, long usableBytes) {
        return KafkaAdminClientTest.prepareDescribeLogDirsResponse(error, logDir, KafkaAdminClientTest.prepareDescribeLogDirsTopics(partitionSize, offsetLag, tp.topic(), tp.partition(), false), totalBytes, usableBytes);
    }

    private static List<DescribeLogDirsResponseData.DescribeLogDirsTopic> prepareDescribeLogDirsTopics(long partitionSize, long offsetLag, String topic, int partition, boolean isFuture) {
        return Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsTopic().setName(topic).setPartitions(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsPartition().setPartitionIndex(partition).setPartitionSize(partitionSize).setIsFutureKey(isFuture).setOffsetLag(offsetLag))));
    }

    private static DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir, List<DescribeLogDirsResponseData.DescribeLogDirsTopic> topics, long totalBytes, long usableBytes) {
        return new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(error.code()).setLogDir(logDir).setTopics(topics).setTotalBytes(totalBytes).setUsableBytes(usableBytes))));
    }

    private static DescribeLogDirsResponse prepareEmptyDescribeLogDirsResponse(Optional<Errors> error) {
        DescribeLogDirsResponseData data = new DescribeLogDirsResponseData();
        if (error.isPresent()) {
            data.setErrorCode(error.get().code());
        }
        return new DescribeLogDirsResponse(data);
    }

    private static DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir, TopicPartition tp, long partitionSize, long offsetLag) {
        return KafkaAdminClientTest.prepareDescribeLogDirsResponse(error, logDir, KafkaAdminClientTest.prepareDescribeLogDirsTopics(partitionSize, offsetLag, tp.topic(), tp.partition(), false));
    }

    private static DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir, List<DescribeLogDirsResponseData.DescribeLogDirsTopic> topics) {
        return new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(error.code()).setLogDir(logDir).setTopics(topics))));
    }

    private static void assertDescriptionContains(Map<String, LogDirDescription> descriptionsMap, String logDir, TopicPartition tp, long partitionSize, long offsetLag) {
        KafkaAdminClientTest.assertDescriptionContains(descriptionsMap, logDir, tp, partitionSize, offsetLag, OptionalLong.empty(), OptionalLong.empty());
    }

    private static void assertDescriptionContains(Map<String, LogDirDescription> descriptionsMap, String logDir, TopicPartition tp, long partitionSize, long offsetLag, OptionalLong totalBytes, OptionalLong usableBytes) {
        Assertions.assertNotNull(descriptionsMap);
        Assertions.assertEquals(Collections.singleton(logDir), descriptionsMap.keySet());
        Assertions.assertNull((Object)descriptionsMap.get(logDir).error());
        Map descriptionsReplicaInfos = descriptionsMap.get(logDir).replicaInfos();
        Assertions.assertEquals(Collections.singleton(tp), descriptionsReplicaInfos.keySet());
        Assertions.assertEquals((long)partitionSize, (long)((ReplicaInfo)descriptionsReplicaInfos.get(tp)).size());
        Assertions.assertEquals((long)offsetLag, (long)((ReplicaInfo)descriptionsReplicaInfos.get(tp)).offsetLag());
        Assertions.assertFalse((boolean)((ReplicaInfo)descriptionsReplicaInfos.get(tp)).isFuture());
        Assertions.assertEquals((Object)totalBytes, (Object)descriptionsMap.get(logDir).totalBytes());
        Assertions.assertEquals((Object)usableBytes, (Object)descriptionsMap.get(logDir).usableBytes());
    }

    @Test
    public void testDescribeBrokerRemovalsPopulatesRightBrokerRemovalLevelExceptions() throws ExecutionException, InterruptedException {
        DescribeBrokerRemovalsResponseData data = new DescribeBrokerRemovalsResponseData().setRemovedBrokers(Arrays.asList(new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setBrokerId(0).setRemovalErrorCode(Errors.REBALANCE_PLAN_COMPUTATION_FAILED.code()).setRemovalErrorMessage("plan failed!").setGeneralOperationStatus(BalancerOperationStatus.FAILED.toString()).setShutdownStatus(BrokerShutdownStatus.COMPLETED.toString()).setReassignmentsStatus(PartitionReassignmentsStatus.IN_PROGRESS.toString()).setBrokerReplicaExclusionStatus(BrokerReplicaExclusionStatus.COMPLETED.toString()).setShutdownScheduled(true), new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setBrokerId(1).setRemovalErrorCode(Errors.NONE.code()).setRemovalErrorMessage("").setCreateTimeMs(100L).setLastUpdateTimeMs(115L).setGeneralOperationStatus(BalancerOperationStatus.SUCCESS.toString()).setShutdownStatus(BrokerShutdownStatus.COMPLETED.toString()).setReassignmentsStatus(PartitionReassignmentsStatus.COMPLETED.toString()).setBrokerReplicaExclusionStatus(BrokerReplicaExclusionStatus.COMPLETED.toString()).setShutdownScheduled(false))).setErrorCode(Errors.NONE.code());
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeBrokerRemovalsResponse(data), env.cluster().nodeById(0));
            DescribeBrokerRemovalsResult result = env.adminClient().describeBrokerRemovals();
            Map descriptions = (Map)result.descriptions().get();
            Assertions.assertEquals((int)2, (int)descriptions.size());
            Optional broker0RemovalOpt = (Optional)result.description(0).get();
            Assertions.assertTrue((boolean)broker0RemovalOpt.isPresent(), (String)"Expected broker 0 to be present in the results");
            BrokerRemovalDescription broker0Removal = (BrokerRemovalDescription)broker0RemovalOpt.get();
            Assertions.assertEquals((Integer)0, (Integer)broker0Removal.brokerId());
            Assertions.assertEquals((Object)BalancerOperationStatus.FAILED, (Object)broker0Removal.generalOperationStatus());
            Assertions.assertEquals((Object)BrokerShutdownStatus.COMPLETED, (Object)broker0Removal.shutdownStatus());
            Assertions.assertEquals((Object)PartitionReassignmentsStatus.IN_PROGRESS, (Object)broker0Removal.reassignmentsStatus());
            Assertions.assertEquals((Object)BrokerReplicaExclusionStatus.COMPLETED, (Object)broker0Removal.brokerReplicaExclusionStatus());
            Assertions.assertTrue((boolean)broker0Removal.isShutdownScheduled());
            Assertions.assertTrue((boolean)broker0Removal.removalError().isPresent(), (String)"Removal error should be populated when not NONE");
            Assertions.assertEquals((short)Errors.REBALANCE_PLAN_COMPUTATION_FAILED.code(), (short)((BrokerRemovalError)broker0Removal.removalError().get()).errorCode());
            Assertions.assertEquals(RebalancePlanComputationException.class, ((BrokerRemovalError)broker0Removal.removalError().get()).exception().getClass());
            Assertions.assertEquals((Object)"plan failed!", (Object)((BrokerRemovalError)broker0Removal.removalError().get()).errorMessage());
            Optional broker1RemovalOpt = (Optional)result.description(1).get();
            Assertions.assertTrue((boolean)broker1RemovalOpt.isPresent(), (String)"Expected broker 1 to be present in the results");
            BrokerRemovalDescription broker1Removal = (BrokerRemovalDescription)broker1RemovalOpt.get();
            Assertions.assertEquals((long)115L, (long)broker1Removal.lastUpdateTimeMs());
            Assertions.assertEquals((long)100L, (long)broker1Removal.createTimeMs());
            Assertions.assertEquals((Object)BalancerOperationStatus.SUCCESS, (Object)broker1Removal.generalOperationStatus());
            Assertions.assertEquals((Object)BrokerShutdownStatus.COMPLETED, (Object)broker1Removal.shutdownStatus());
            Assertions.assertEquals((Object)PartitionReassignmentsStatus.COMPLETED, (Object)broker1Removal.reassignmentsStatus());
            Assertions.assertEquals((Object)BrokerReplicaExclusionStatus.COMPLETED, (Object)broker1Removal.brokerReplicaExclusionStatus());
            Assertions.assertFalse((boolean)broker1Removal.isShutdownScheduled());
            Assertions.assertFalse((boolean)broker1Removal.removalError().isPresent(), (String)"Removal error should not be populated when it is NONE");
            Assertions.assertEquals((long)115L, (long)broker1Removal.lastUpdateTimeMs());
            Assertions.assertEquals((long)100L, (long)broker1Removal.createTimeMs());
            Optional broker2RemovalOpt = (Optional)result.description(2).get();
            Assertions.assertFalse((boolean)broker2RemovalOpt.isPresent(), (String)"Expected broker 2 to not be present in the results");
        }
    }

    @Test
    public void testDescribeTopicWithObserver() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv("confluent.admin.client.describe.topic.partitions.enabled", "false");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            List<Integer> observers = Arrays.asList(4, 5, 6);
            MetadataResponseData.MetadataResponsePartition responsePartitionWithObserver = new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(0).setReplicaNodes(Arrays.asList(1, 2, 3, 4, 5, 6)).setIsrNodes(Arrays.asList(1, 2, 3)).setLeaderEpoch(2).setLeaderId(1).setObservers(observers);
            String topicName = "topic-0";
            MetadataResponseData.MetadataResponseTopic responseTopicWithObserver = new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topicName).setIsInternal(false).setPartitions(Collections.singletonList(responsePartitionWithObserver));
            MetadataResponseData.MetadataResponseTopicCollection responseTopicCollectionWithObserver = new MetadataResponseData.MetadataResponseTopicCollection(Collections.singletonList(responseTopicWithObserver).iterator());
            MetadataResponseData metadataResponseDataWithObservers = new MetadataResponseData().setTopics(responseTopicCollectionWithObserver);
            env.kafkaClient().prepareResponse((AbstractResponse)new MetadataResponse(metadataResponseDataWithObservers, ApiKeys.METADATA.latestVersion()));
            DescribeTopicsResult responseResult = env.adminClient().describeTopics(Collections.singletonList(topicName));
            TopicDescription topicDescription = (TopicDescription)((Map)responseResult.allTopicNames().get()).get(topicName);
            TopicPartitionInfo partitionInfo = (TopicPartitionInfo)topicDescription.partitions().get(0);
            List actualObservers = partitionInfo.observers().stream().map(Node::id).collect(Collectors.toList());
            Assertions.assertEquals(observers, actualObservers);
        }
    }

    @Test
    public void testMetadataRetries() throws Exception {
        String topic = "topic";
        Cluster bootstrapCluster = Cluster.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 9999)));
        Cluster initializedCluster = KafkaAdminClientTest.mockCluster(3, 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, bootstrapCluster, KafkaAdminClientTest.newStrMap("bootstrap.servers", "localhost:9999", "default.api.timeout.ms", "10000000", "retries", "0", "confluent.admin.client.describe.topic.partitions.enabled", "false"));){
            env.kafkaClient().prepareResponse(null, true);
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(initializedCluster.nodes(), initializedCluster.clusterResource().clusterId(), initializedCluster.controller().id(), Collections.emptyList()));
            Node leader = (Node)initializedCluster.nodes().get(0);
            MetadataResponse.PartitionMetadata partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, new TopicPartition(topic, 0), Optional.of(leader.id()), Optional.of(10), Collections.singletonList(leader.id()), Collections.singletonList(leader.id()), Collections.singletonList(leader.id()));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(initializedCluster.nodes(), initializedCluster.clusterResource().clusterId(), 1, Collections.singletonList(new MetadataResponse.TopicMetadata(Errors.NONE, topic, Uuid.ZERO_UUID, false, Collections.singletonList(partitionMetadata), Integer.MIN_VALUE, TopicType.STANDARD))));
            DescribeTopicsResult result = env.adminClient().describeTopics(Collections.singleton(topic));
            Map topicDescriptions = (Map)result.allTopicNames().get();
            Assertions.assertEquals((Object)leader, (Object)((TopicPartitionInfo)((TopicDescription)topicDescriptions.get(topic)).partitions().get(0)).leader());
            Assertions.assertNull((Object)((TopicDescription)topicDescriptions.get(topic)).authorizedOperations());
        }
    }

    @Test
    public void testDescribeTopicWithObserverWithDescribeTopicPartitionsApi() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            List<Integer> observers = Arrays.asList(4, 5, 6);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Integer.MIN_VALUE, false));
            DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition responsePartitionWithObserver = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(0).setReplicaNodes(Arrays.asList(1, 2, 3, 4, 5, 6)).setIsrNodes(Arrays.asList(1, 2, 3)).setLastKnownElr(Collections.emptyList()).setEligibleLeaderReplicas(Collections.emptyList()).setLeaderEpoch(2).setLeaderId(1).setObservers(observers);
            String topicName = "topic-0";
            DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic responseTopicWithObserver = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(Errors.NONE.code()).setName(topicName).setIsInternal(false).setPartitions(Collections.singletonList(responsePartitionWithObserver));
            DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopicCollection responseTopicCollectionWithObserver = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopicCollection(Collections.singletonList(responseTopicWithObserver).iterator());
            DescribeTopicPartitionsResponseData metadataResponseDataWithObservers = new DescribeTopicPartitionsResponseData().setTopics(responseTopicCollectionWithObserver);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeTopicPartitionsResponse(metadataResponseDataWithObservers));
            DescribeTopicsResult responseResult = env.adminClient().describeTopics(Collections.singletonList(topicName));
            TopicDescription topicDescription = (TopicDescription)((Map)responseResult.allTopicNames().get()).get(topicName);
            TopicPartitionInfo partitionInfo = (TopicPartitionInfo)topicDescription.partitions().get(0);
            List actualObservers = partitionInfo.observers().stream().map(Node::id).collect(Collectors.toList());
            Assertions.assertEquals(observers, actualObservers);
        }
    }

    @Test
    public void testDescribeBrokerAdditionsHandlesNotController() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            int newControllerId = 1;
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerAdditionsResponse(Errors.NOT_CONTROLLER, Collections.emptyMap()), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)newControllerId, Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerAdditionsResponse(Collections.emptyMap()), env.cluster().nodeById(newControllerId));
            Map descriptions = (Map)env.adminClient().describeBrokerAdditions().descriptions().get();
            Assertions.assertEquals((int)0, (int)descriptions.size());
        }
    }

    @Test
    public void testDescribeBrokerAdditionsHandlesTopLevelError() {
        String errMsg = "off";
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerAdditionsResponse((ApiException)new BalancerOfflineException(errMsg), Collections.emptyMap()), env.cluster().nodeById(0));
            DescribeBrokerAdditionsResult result = env.adminClient().describeBrokerAdditions();
            TestUtils.assertFutureThrowsException((ApiException)new BalancerOfflineException(errMsg), result.descriptions());
        }
    }

    @Test
    public void testDescribeBrokerAdditionsHandlesBrokerLevelErrors() throws Exception {
        String overriddenMsg = "overridden by broker removal";
        String failedMsg = "overridden by broker removal";
        String planFailedMsg = "plan computation blew up";
        HashMap<Integer, ApiException> additionsDescriptions = new HashMap<Integer, ApiException>();
        additionsDescriptions.put(0, Errors.NONE.exception());
        additionsDescriptions.put(1, Errors.BALANCER_OPERATION_OVERRIDDEN.exception(overriddenMsg));
        additionsDescriptions.put(2, Errors.BALANCER_OPERATION_FAILED.exception(failedMsg));
        additionsDescriptions.put(3, Errors.REBALANCE_PLAN_COMPUTATION_FAILED.exception(planFailedMsg));
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerAdditionsResponse(additionsDescriptions), env.cluster().nodeById(0));
            DescribeBrokerAdditionsResult result = env.adminClient().describeBrokerAdditions();
            Map descriptions = (Map)result.descriptions().get();
            Assertions.assertEquals((int)4, (int)descriptions.size());
            BrokerAdditionDescription broker0Addition = (BrokerAdditionDescription)descriptions.get(0);
            Assertions.assertEquals((int)0, (int)broker0Addition.brokerId());
            Assertions.assertEquals((Object)BalancerOperationStatus.IN_PROGRESS, (Object)((BrokerAdditionDescription)descriptions.get(1)).generalOperationStatus());
            Assertions.assertEquals((Object)PartitionReassignmentsStatus.COMPLETED, (Object)((BrokerAdditionDescription)descriptions.get(1)).partitionReassignmentsStatus());
            Assertions.assertTrue((boolean)((BrokerAdditionDescription)descriptions.get(1)).additionError().isPresent(), (String)"Additions error should be populated when not NONE");
            Assertions.assertTrue((boolean)((BrokerAdditionDescription)descriptions.get(2)).additionError().isPresent(), (String)"Additions error should be populated when not NONE");
            Assertions.assertTrue((boolean)((BrokerAdditionDescription)descriptions.get(3)).additionError().isPresent(), (String)"Additions error should be populated when not NONE");
            Assertions.assertEquals(((BalancerOperationError)((BrokerAdditionDescription)descriptions.get(1)).additionError().get()).exception().getClass(), BalancerOperationOverriddenException.class);
            Assertions.assertEquals((Object)((BalancerOperationError)((BrokerAdditionDescription)descriptions.get(1)).additionError().get()).exception().getMessage(), (Object)overriddenMsg);
            Assertions.assertEquals(((BalancerOperationError)((BrokerAdditionDescription)descriptions.get(2)).additionError().get()).exception().getClass(), BalancerOperationFailedException.class);
            Assertions.assertEquals((Object)((BalancerOperationError)((BrokerAdditionDescription)((Optional)result.description(2).get()).get()).additionError().get()).exception().getMessage(), (Object)failedMsg);
            Assertions.assertEquals(((BalancerOperationError)((BrokerAdditionDescription)((Optional)result.description(3).get()).get()).additionError().get()).exception().getClass(), RebalancePlanComputationException.class);
            Assertions.assertEquals((Object)((BalancerOperationError)((BrokerAdditionDescription)((Optional)result.description(3).get()).get()).additionError().get()).exception().getMessage(), (Object)planFailedMsg);
            Assertions.assertFalse((boolean)((Optional)result.description(4).get()).isPresent(), (String)"Expected no description for broker 4 to be present");
        }
    }

    @Test
    public void testDescribeBrokerAdditionsHandlesTimeoutException() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime(1500L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, cluster);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerAdditionsResponse(Errors.NOT_CONTROLLER, Collections.emptyMap()), env.cluster().nodeById(0));
            DescribeBrokerAdditionsResult result = env.adminClient().describeBrokerAdditions();
            TestUtils.assertFutureThrows(TimeoutException.class, result.descriptions());
        }
    }

    @Test
    public void testDescribeBrokerAdditionsHandlesUnrecognizedStatusValues() throws Exception {
        int brokerid = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeBrokerAdditionsResponseWithUnrecognizedStatusValues(brokerid), env.cluster().nodeById(0));
            DescribeBrokerAdditionsResult result = env.adminClient().describeBrokerAdditions();
            Map descriptions = (Map)result.descriptions().get();
            Assertions.assertEquals((int)1, (int)descriptions.size());
            BrokerAdditionDescription brokerAddition = (BrokerAdditionDescription)descriptions.get(1);
            Assertions.assertEquals((Object)BalancerOperationStatus.UNKNOWN, (Object)brokerAddition.generalOperationStatus());
            Assertions.assertEquals((Object)PartitionReassignmentsStatus.UNKNOWN, (Object)brokerAddition.partitionReassignmentsStatus());
            Assertions.assertTrue((boolean)brokerAddition.additionError().isPresent(), (String)"Addition error should be populated when not NONE");
            Assertions.assertEquals(((BalancerOperationError)brokerAddition.additionError().get()).exception().getClass(), RebalancePlanComputationException.class);
        }
    }

    @Test
    public void testCreateTopicsDontRetryThrottlingExceptionWhenDisabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.creatableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            CreateTopicsResult result = env.adminClient().createTopics(Arrays.asList(new NewTopic("topic1", 1, 1), new NewTopic("topic2", 1, 1), new NewTopic("topic3", 1, 1)), new CreateTopicsOptions().retryOnQuotaViolation(false));
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows(ThrottlingQuotaExceededException.class, (Future)result.values().get("topic2"));
            Assertions.assertEquals((int)1000, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows(TopicExistsException.class, (Future)result.values().get("topic3"));
        }
    }

    private MockClient.RequestMatcher expectCreateTopicsRequestWithTopics(String ... topics) {
        return body -> {
            if (body instanceof CreateTopicsRequest) {
                CreateTopicsRequest request = (CreateTopicsRequest)body;
                for (String topic : topics) {
                    if (request.data().topics().find(topic) != null) continue;
                    return false;
                }
                return topics.length == request.data().topics().size();
            }
            return false;
        };
    }

    @Test
    public void testDeleteTopics() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("myTopic"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().deleteTopics(Collections.singletonList("myTopic"), new DeleteTopicsOptions()).all();
            Assertions.assertNull((Object)future.get());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("myTopic"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse("myTopic", Errors.TOPIC_DELETION_DISABLED));
            future = env.adminClient().deleteTopics(Collections.singletonList("myTopic"), new DeleteTopicsOptions()).all();
            TestUtils.assertFutureThrows(TopicDeletionDisabledException.class, future);
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("myTopic"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse("myTopic", Errors.UNKNOWN_TOPIC_OR_PARTITION));
            future = env.adminClient().deleteTopics(Collections.singletonList("myTopic"), new DeleteTopicsOptions()).all();
            TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, future);
            Uuid topicId = Uuid.randomUuid();
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponseWithTopicId(topicId, Errors.NONE));
            future = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Collections.singletonList(topicId)), new DeleteTopicsOptions()).all();
            Assertions.assertNull((Object)future.get());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponseWithTopicId(topicId, Errors.TOPIC_DELETION_DISABLED));
            future = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Collections.singletonList(topicId)), new DeleteTopicsOptions()).all();
            TestUtils.assertFutureThrows(TopicDeletionDisabledException.class, future);
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponseWithTopicId(topicId, Errors.UNKNOWN_TOPIC_ID));
            future = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Collections.singletonList(topicId)), new DeleteTopicsOptions()).all();
            TestUtils.assertFutureThrows(UnknownTopicIdException.class, future);
        }
    }

    @Test
    public void testDeleteTopicsPartialResponse() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("myTopic", "myOtherTopic"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("myTopic", Errors.NONE)));
            DeleteTopicsResult result = env.adminClient().deleteTopics(Arrays.asList("myTopic", "myOtherTopic"), new DeleteTopicsOptions());
            ((KafkaFuture)result.topicNameValues().get("myTopic")).get();
            TestUtils.assertFutureThrows(ApiException.class, (Future)result.topicNameValues().get("myOtherTopic"));
            Uuid topicId1 = Uuid.randomUuid();
            Uuid topicId2 = Uuid.randomUuid();
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId1, topicId2), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResultWithId(topicId1, Errors.NONE)));
            DeleteTopicsResult resultIds = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Arrays.asList(topicId1, topicId2)), new DeleteTopicsOptions());
            ((KafkaFuture)resultIds.topicIdValues().get(topicId1)).get();
            TestUtils.assertFutureThrows(ApiException.class, (Future)resultIds.topicIdValues().get(topicId2));
        }
    }

    @Test
    public void testDeleteTopicsRetryThrottlingExceptionWhenEnabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(0, KafkaAdminClientTest.deletableTopicResult("topic2", Errors.NONE)));
            DeleteTopicsResult result = env.adminClient().deleteTopics(Arrays.asList("topic1", "topic2", "topic3"), new DeleteTopicsOptions().retryOnQuotaViolation(true));
            Assertions.assertNull((Object)((KafkaFuture)result.topicNameValues().get("topic1")).get());
            Assertions.assertNull((Object)((KafkaFuture)result.topicNameValues().get("topic2")).get());
            TestUtils.assertFutureThrows(TopicExistsException.class, (Future)result.topicNameValues().get("topic3"));
            Uuid topicId1 = Uuid.randomUuid();
            Uuid topicId2 = Uuid.randomUuid();
            Uuid topicId3 = Uuid.randomUuid();
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId1, topicId2, topicId3), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResultWithId(topicId1, Errors.NONE), KafkaAdminClientTest.deletableTopicResultWithId(topicId2, Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResultWithId(topicId3, Errors.UNKNOWN_TOPIC_ID)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId2), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResultWithId(topicId2, Errors.THROTTLING_QUOTA_EXCEEDED)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId2), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(0, KafkaAdminClientTest.deletableTopicResultWithId(topicId2, Errors.NONE)));
            DeleteTopicsResult resultIds = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Arrays.asList(topicId1, topicId2, topicId3)), new DeleteTopicsOptions().retryOnQuotaViolation(true));
            Assertions.assertNull((Object)((KafkaFuture)resultIds.topicIdValues().get(topicId1)).get());
            Assertions.assertNull((Object)((KafkaFuture)resultIds.topicIdValues().get(topicId2)).get());
            TestUtils.assertFutureThrows(UnknownTopicIdException.class, (Future)resultIds.topicIdValues().get(topicId3));
        }
    }

    @Test
    public void testDeleteTopicsRetryThrottlingExceptionWhenEnabledUntilRequestTimeOut() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "default.api.timeout.ms", String.valueOf(defaultApiTimeout));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            DeleteTopicsResult result = env.adminClient().deleteTopics(Arrays.asList("topic1", "topic2", "topic3"), new DeleteTopicsOptions().retryOnQuotaViolation(true));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting DeleteTopics requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting next DeleteTopics request");
            time.sleep(defaultApiTimeout + 1L);
            Assertions.assertNull((Object)((KafkaFuture)result.topicNameValues().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows(ThrottlingQuotaExceededException.class, (Future)result.topicNameValues().get("topic2"));
            Assertions.assertEquals((int)0, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows(TopicExistsException.class, (Future)result.topicNameValues().get("topic3"));
            Uuid topicId1 = Uuid.randomUuid();
            Uuid topicId2 = Uuid.randomUuid();
            Uuid topicId3 = Uuid.randomUuid();
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId1, topicId2, topicId3), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResultWithId(topicId1, Errors.NONE), KafkaAdminClientTest.deletableTopicResultWithId(topicId2, Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResultWithId(topicId3, Errors.UNKNOWN_TOPIC_ID)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId2), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResultWithId(topicId2, Errors.THROTTLING_QUOTA_EXCEEDED)));
            DeleteTopicsResult resultIds = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Arrays.asList(topicId1, topicId2, topicId3)), new DeleteTopicsOptions().retryOnQuotaViolation(true));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting DeleteTopics requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting next DeleteTopics request");
            time.sleep(defaultApiTimeout + 1L);
            Assertions.assertNull((Object)((KafkaFuture)resultIds.topicIdValues().get(topicId1)).get());
            e = TestUtils.assertFutureThrows(ThrottlingQuotaExceededException.class, (Future)resultIds.topicIdValues().get(topicId2));
            Assertions.assertEquals((int)0, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows(UnknownTopicIdException.class, (Future)resultIds.topicIdValues().get(topicId3));
        }
    }

    @Test
    public void testDeleteTopicsDontRetryThrottlingExceptionWhenDisabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            DeleteTopicsResult result = env.adminClient().deleteTopics(Arrays.asList("topic1", "topic2", "topic3"), new DeleteTopicsOptions().retryOnQuotaViolation(false));
            Assertions.assertNull((Object)((KafkaFuture)result.topicNameValues().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows(ThrottlingQuotaExceededException.class, (Future)result.topicNameValues().get("topic2"));
            Assertions.assertEquals((int)1000, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows(TopicExistsException.class, (Future)result.topicNameValues().get("topic3"));
            Uuid topicId1 = Uuid.randomUuid();
            Uuid topicId2 = Uuid.randomUuid();
            Uuid topicId3 = Uuid.randomUuid();
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId1, topicId2, topicId3), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResultWithId(topicId1, Errors.NONE), KafkaAdminClientTest.deletableTopicResultWithId(topicId2, Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResultWithId(topicId3, Errors.UNKNOWN_TOPIC_ID)));
            DeleteTopicsResult resultIds = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Arrays.asList(topicId1, topicId2, topicId3)), new DeleteTopicsOptions().retryOnQuotaViolation(false));
            Assertions.assertNull((Object)((KafkaFuture)resultIds.topicIdValues().get(topicId1)).get());
            e = TestUtils.assertFutureThrows(ThrottlingQuotaExceededException.class, (Future)resultIds.topicIdValues().get(topicId2));
            Assertions.assertEquals((int)1000, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows(UnknownTopicIdException.class, (Future)resultIds.topicIdValues().get(topicId3));
        }
    }

    private MockClient.RequestMatcher expectDeleteTopicsRequestWithTopics(String ... topics) {
        return body -> {
            if (body instanceof DeleteTopicsRequest) {
                DeleteTopicsRequest request = (DeleteTopicsRequest)body;
                return request.topicNames().equals(Arrays.asList(topics));
            }
            return false;
        };
    }

    private MockClient.RequestMatcher expectDeleteTopicsRequestWithTopicIds(Uuid ... topicIds) {
        return body -> {
            if (body instanceof DeleteTopicsRequest) {
                DeleteTopicsRequest request = (DeleteTopicsRequest)body;
                return request.topicIds().equals(Arrays.asList(topicIds));
            }
            return false;
        };
    }

    @Test
    public void testInvalidTopicNames() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            List<String> sillyTopicNames = Arrays.asList("", null);
            Map deleteFutures = env.adminClient().deleteTopics(sillyTopicNames).topicNameValues();
            for (String string : sillyTopicNames) {
                TestUtils.assertFutureThrows(InvalidTopicException.class, (Future)deleteFutures.get(string));
            }
            Assertions.assertEquals((int)0, (int)env.kafkaClient().inFlightRequestCount());
            Map describeFutures = env.adminClient().describeTopics(sillyTopicNames).topicNameValues();
            for (String string : sillyTopicNames) {
                TestUtils.assertFutureThrows(InvalidTopicException.class, (Future)describeFutures.get(string));
            }
            Assertions.assertEquals((int)0, (int)env.kafkaClient().inFlightRequestCount());
            ArrayList<NewTopic> arrayList = new ArrayList<NewTopic>();
            for (String sillyTopicName : sillyTopicNames) {
                arrayList.add(new NewTopic(sillyTopicName, 1, 1));
            }
            Map map = env.adminClient().createTopics(arrayList).values();
            for (String sillyTopicName : sillyTopicNames) {
                TestUtils.assertFutureThrows(InvalidTopicException.class, (Future)map.get(sillyTopicName));
            }
            Assertions.assertEquals((int)0, (int)env.kafkaClient().inFlightRequestCount());
        }
    }

    @Test
    public void testDescribeTopicsWithDescribeTopicPartitionsApiBasic() throws ExecutionException, InterruptedException {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String topicName0 = "test-0";
            String topicName1 = "test-1";
            HashMap<String, Uuid> topics = new HashMap<String, Uuid>();
            topics.put(topicName0, Uuid.randomUuid());
            topics.put(topicName1, Uuid.randomUuid());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Integer.MIN_VALUE, false));
            DescribeTopicPartitionsResponseData dataFirstPart = new DescribeTopicPartitionsResponseData();
            this.addPartitionToDescribeTopicPartitionsResponse(dataFirstPart, topicName0, (Uuid)topics.get(topicName0), Collections.singletonList(0));
            dataFirstPart.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName0).setPartitionIndex(1));
            env.kafkaClient().prepareResponse(body -> {
                DescribeTopicPartitionsRequestData request = (DescribeTopicPartitionsRequestData)body.data();
                if (request.topics().size() != 2) {
                    return false;
                }
                if (!((DescribeTopicPartitionsRequestData.TopicRequest)request.topics().get(0)).name().equals(topicName0)) {
                    return false;
                }
                if (!((DescribeTopicPartitionsRequestData.TopicRequest)request.topics().get(1)).name().equals(topicName1)) {
                    return false;
                }
                return request.cursor() == null;
            }, (AbstractResponse)new DescribeTopicPartitionsResponse(dataFirstPart));
            DescribeTopicPartitionsResponseData dataSecondPart = new DescribeTopicPartitionsResponseData();
            this.addPartitionToDescribeTopicPartitionsResponse(dataSecondPart, topicName0, (Uuid)topics.get(topicName0), Collections.singletonList(1));
            this.addPartitionToDescribeTopicPartitionsResponse(dataSecondPart, topicName1, (Uuid)topics.get(topicName1), Collections.singletonList(0));
            env.kafkaClient().prepareResponse(body -> {
                DescribeTopicPartitionsRequestData request = (DescribeTopicPartitionsRequestData)body.data();
                if (request.topics().size() != 2) {
                    return false;
                }
                if (!((DescribeTopicPartitionsRequestData.TopicRequest)request.topics().get(0)).name().equals(topicName0)) {
                    return false;
                }
                if (!((DescribeTopicPartitionsRequestData.TopicRequest)request.topics().get(1)).name().equals(topicName1)) {
                    return false;
                }
                DescribeTopicPartitionsRequestData.Cursor cursor = request.cursor();
                return cursor != null && cursor.topicName() == topicName0 && cursor.partitionIndex() == 1;
            }, (AbstractResponse)new DescribeTopicPartitionsResponse(dataSecondPart));
            DescribeTopicsResult result = env.adminClient().describeTopics(Arrays.asList(topicName0, topicName1), new DescribeTopicsOptions());
            Map topicDescriptions = (Map)result.allTopicNames().get();
            Assertions.assertEquals((int)2, (int)topicDescriptions.size());
            TopicDescription topicDescription = (TopicDescription)topicDescriptions.get(topicName0);
            Assertions.assertEquals((int)2, (int)topicDescription.partitions().size());
            Assertions.assertEquals((int)0, (int)((TopicPartitionInfo)topicDescription.partitions().get(0)).partition());
            Assertions.assertEquals((int)1, (int)((TopicPartitionInfo)topicDescription.partitions().get(1)).partition());
            topicDescription = (TopicDescription)topicDescriptions.get(topicName1);
            Assertions.assertEquals((int)1, (int)topicDescription.partitions().size());
            Assertions.assertNull((Object)topicDescription.authorizedOperations());
        }
    }

    @Test
    public void testDescribeTopicPartitionsApiWithAuthorizedOps() throws ExecutionException, InterruptedException {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String topicName0 = "test-0";
            Uuid topicId = Uuid.randomUuid();
            int authorisedOperations = Utils.to32BitField(Set.of(Byte.valueOf(AclOperation.DESCRIBE.code()), Byte.valueOf(AclOperation.ALTER.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, authorisedOperations, false));
            DescribeTopicPartitionsResponseData responseData = new DescribeTopicPartitionsResponseData();
            responseData.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode((short)0).setTopicId(topicId).setName(topicName0).setIsInternal(false).setTopicAuthorizedOperations(authorisedOperations));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeTopicPartitionsResponse(responseData));
            DescribeTopicsResult result = env.adminClient().describeTopics(Collections.singletonList(topicName0), new DescribeTopicsOptions().includeAuthorizedOperations(true));
            Map topicDescriptions = (Map)result.allTopicNames().get();
            TopicDescription topicDescription = (TopicDescription)topicDescriptions.get(topicName0);
            Assertions.assertEquals(new HashSet<AclOperation>(Arrays.asList(AclOperation.DESCRIBE, AclOperation.ALTER)), (Object)topicDescription.authorizedOperations());
        }
    }

    @Test
    public void testDescribeTopicPartitionsApiWithoutAuthorizedOps() throws ExecutionException, InterruptedException {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String topicName0 = "test-0";
            Uuid topicId = Uuid.randomUuid();
            int authorisedOperations = Utils.to32BitField(Set.of(Byte.valueOf(AclOperation.DESCRIBE.code()), Byte.valueOf(AclOperation.ALTER.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, authorisedOperations, false));
            DescribeTopicPartitionsResponseData responseData = new DescribeTopicPartitionsResponseData();
            responseData.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode((short)0).setTopicId(topicId).setName(topicName0).setIsInternal(false).setTopicAuthorizedOperations(authorisedOperations));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeTopicPartitionsResponse(responseData));
            DescribeTopicsResult result = env.adminClient().describeTopics(Collections.singletonList(topicName0), new DescribeTopicsOptions().includeAuthorizedOperations(false));
            Map topicDescriptions = (Map)result.allTopicNames().get();
            TopicDescription topicDescription = (TopicDescription)topicDescriptions.get(topicName0);
            Assertions.assertNull((Object)topicDescription.authorizedOperations());
        }
    }

    @Test
    public void testDescribeTopicsWithDescribeTopicPartitionsApiEdgeCase() throws ExecutionException, InterruptedException {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String topicName0 = "test-0";
            String topicName1 = "test-1";
            String topicName2 = "test-2";
            HashMap<String, Uuid> topics = new HashMap<String, Uuid>();
            topics.put(topicName0, Uuid.randomUuid());
            topics.put(topicName1, Uuid.randomUuid());
            topics.put(topicName2, Uuid.randomUuid());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Integer.MIN_VALUE, false));
            DescribeTopicPartitionsResponseData dataFirstPart = new DescribeTopicPartitionsResponseData();
            this.addPartitionToDescribeTopicPartitionsResponse(dataFirstPart, topicName0, (Uuid)topics.get(topicName0), Collections.singletonList(0));
            this.addPartitionToDescribeTopicPartitionsResponse(dataFirstPart, topicName1, (Uuid)topics.get(topicName1), Collections.singletonList(0));
            dataFirstPart.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName1).setPartitionIndex(1));
            env.kafkaClient().prepareResponse(body -> {
                DescribeTopicPartitionsRequestData request = (DescribeTopicPartitionsRequestData)body.data();
                if (request.topics().size() != 3) {
                    return false;
                }
                if (!((DescribeTopicPartitionsRequestData.TopicRequest)request.topics().get(0)).name().equals(topicName0)) {
                    return false;
                }
                if (!((DescribeTopicPartitionsRequestData.TopicRequest)request.topics().get(1)).name().equals(topicName1)) {
                    return false;
                }
                if (!((DescribeTopicPartitionsRequestData.TopicRequest)request.topics().get(2)).name().equals(topicName2)) {
                    return false;
                }
                return request.cursor() == null;
            }, (AbstractResponse)new DescribeTopicPartitionsResponse(dataFirstPart));
            DescribeTopicPartitionsResponseData dataSecondPart = new DescribeTopicPartitionsResponseData();
            this.addPartitionToDescribeTopicPartitionsResponse(dataSecondPart, topicName1, (Uuid)topics.get(topicName1), Collections.singletonList(1));
            this.addPartitionToDescribeTopicPartitionsResponse(dataSecondPart, topicName2, (Uuid)topics.get(topicName2), Collections.singletonList(0));
            dataSecondPart.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName2).setPartitionIndex(1));
            env.kafkaClient().prepareResponse(body -> {
                DescribeTopicPartitionsRequestData request = (DescribeTopicPartitionsRequestData)body.data();
                if (request.topics().size() != 2) {
                    return false;
                }
                if (!((DescribeTopicPartitionsRequestData.TopicRequest)request.topics().get(0)).name().equals(topicName1)) {
                    return false;
                }
                if (!((DescribeTopicPartitionsRequestData.TopicRequest)request.topics().get(1)).name().equals(topicName2)) {
                    return false;
                }
                DescribeTopicPartitionsRequestData.Cursor cursor = request.cursor();
                return cursor != null && cursor.topicName().equals(topicName1) && cursor.partitionIndex() == 1;
            }, (AbstractResponse)new DescribeTopicPartitionsResponse(dataSecondPart));
            DescribeTopicPartitionsResponseData dataThirdPart = new DescribeTopicPartitionsResponseData();
            this.addPartitionToDescribeTopicPartitionsResponse(dataThirdPart, topicName2, (Uuid)topics.get(topicName2), Collections.singletonList(1));
            env.kafkaClient().prepareResponse(body -> {
                DescribeTopicPartitionsRequestData request = (DescribeTopicPartitionsRequestData)body.data();
                if (request.topics().size() != 1) {
                    return false;
                }
                if (!((DescribeTopicPartitionsRequestData.TopicRequest)request.topics().get(0)).name().equals(topicName2)) {
                    return false;
                }
                DescribeTopicPartitionsRequestData.Cursor cursor = request.cursor();
                return cursor != null && cursor.topicName().equals(topicName2) && cursor.partitionIndex() == 1;
            }, (AbstractResponse)new DescribeTopicPartitionsResponse(dataThirdPart));
            DescribeTopicsResult result = env.adminClient().describeTopics(Arrays.asList(topicName1, topicName0, topicName2), new DescribeTopicsOptions());
            Map topicDescriptions = (Map)result.allTopicNames().get();
            Assertions.assertEquals((int)3, (int)topicDescriptions.size());
            TopicDescription topicDescription = (TopicDescription)topicDescriptions.get(topicName0);
            Assertions.assertEquals((int)1, (int)topicDescription.partitions().size());
            Assertions.assertEquals((int)0, (int)((TopicPartitionInfo)topicDescription.partitions().get(0)).partition());
            topicDescription = (TopicDescription)topicDescriptions.get(topicName1);
            Assertions.assertEquals((int)2, (int)topicDescription.partitions().size());
            topicDescription = (TopicDescription)topicDescriptions.get(topicName2);
            Assertions.assertEquals((int)2, (int)topicDescription.partitions().size());
            Assertions.assertNull((Object)topicDescription.authorizedOperations());
        }
    }

    private void addPartitionToDescribeTopicPartitionsResponse(DescribeTopicPartitionsResponseData data, String topicName, Uuid topicId, List<Integer> partitions) {
        ArrayList addingPartitions = new ArrayList();
        partitions.forEach(partition -> addingPartitions.add(new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setIsrNodes(Collections.singletonList(0)).setErrorCode((short)0).setLeaderEpoch(0).setLeaderId(0).setEligibleLeaderReplicas(Collections.singletonList(1)).setLastKnownElr(Collections.singletonList(2)).setPartitionIndex(partition.intValue()).setReplicaNodes(Arrays.asList(0, 1, 2))));
        data.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode((short)0).setTopicId(topicId).setName(topicName).setIsInternal(false).setPartitions(addingPartitions));
    }

    @Test
    public void testDescribeTopicsWithDescribeTopicPartitionsApiErrorHandling() throws InterruptedException {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String topicName0 = "test-0";
            String topicName1 = "test-1";
            HashMap<String, Uuid> topics = new HashMap<String, Uuid>();
            topics.put(topicName0, Uuid.randomUuid());
            topics.put(topicName1, Uuid.randomUuid());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Integer.MIN_VALUE, false));
            DescribeTopicPartitionsResponseData dataFirstPart = new DescribeTopicPartitionsResponseData();
            dataFirstPart.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode((short)0).setTopicId((Uuid)topics.get(topicName0)).setName(topicName0).setIsInternal(false).setPartitions(Collections.singletonList(new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setIsrNodes(Collections.singletonList(0)).setErrorCode((short)0).setLeaderEpoch(0).setLeaderId(0).setEligibleLeaderReplicas(Collections.singletonList(1)).setLastKnownElr(Collections.singletonList(2)).setPartitionIndex(0).setReplicaNodes(Arrays.asList(0, 1, 2)))));
            dataFirstPart.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode((short)29).setTopicId(Uuid.ZERO_UUID).setName(topicName1).setIsInternal(false));
            env.kafkaClient().prepareResponse(body -> {
                DescribeTopicPartitionsRequestData request = (DescribeTopicPartitionsRequestData)body.data();
                if (request.topics().size() != 2) {
                    return false;
                }
                if (!((DescribeTopicPartitionsRequestData.TopicRequest)request.topics().get(0)).name().equals(topicName0)) {
                    return false;
                }
                if (!((DescribeTopicPartitionsRequestData.TopicRequest)request.topics().get(1)).name().equals(topicName1)) {
                    return false;
                }
                return request.cursor() == null;
            }, (AbstractResponse)new DescribeTopicPartitionsResponse(dataFirstPart));
            DescribeTopicsResult result = env.adminClient().describeTopics(Arrays.asList(topicName1, topicName0), new DescribeTopicsOptions());
            TestUtils.assertFutureThrows(TopicAuthorizationException.class, result.allTopicNames());
        }
    }

    @Test
    public void testAdminClientApisAuthenticationFailure() {
        Cluster cluster = KafkaAdminClientTest.mockBootstrapCluster();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, cluster, KafkaAdminClientTest.newStrMap("request.timeout.ms", "1000", "metadata.recovery.strategy", "none"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().createPendingAuthenticationError((Node)cluster.nodes().get(0), TimeUnit.DAYS.toMillis(1L));
            this.callAdminClientApisAndExpectAnAuthenticationError(env);
            this.callClientQuotasApisAndExpectAnAuthenticationError(env);
        }
    }

    private void callAdminClientApisAndExpectAnAuthenticationError(AdminClientUnitTestEnv env) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all().get());
        Assertions.assertInstanceOf(AuthenticationException.class, (Object)e.getCause(), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
        HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
        counts.put("my_topic", NewPartitions.increaseTo((int)3));
        counts.put("other_topic", NewPartitions.increaseTo((int)3, Arrays.asList(Collections.singletonList(2), Collections.singletonList(3))));
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> env.adminClient().createPartitions(counts).all().get());
        Assertions.assertInstanceOf(AuthenticationException.class, (Object)e.getCause(), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> env.adminClient().createAcls(Arrays.asList(ACL1, ACL2)).all().get());
        Assertions.assertInstanceOf(AuthenticationException.class, (Object)e.getCause(), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> env.adminClient().describeAcls(FILTER1).values().get());
        Assertions.assertInstanceOf(AuthenticationException.class, (Object)e.getCause(), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2)).all().get());
        Assertions.assertInstanceOf(AuthenticationException.class, (Object)e.getCause(), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> env.adminClient().describeConfigs(Collections.singleton(new ConfigResource(ConfigResource.Type.BROKER, "0"))).all().get());
        Assertions.assertInstanceOf(AuthenticationException.class, (Object)e.getCause(), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
    }

    private void callClientQuotasApisAndExpectAnAuthenticationError(AdminClientUnitTestEnv env) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> env.adminClient().describeClientQuotas(ClientQuotaFilter.all()).entities().get());
        Assertions.assertInstanceOf(AuthenticationException.class, (Object)e.getCause(), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
        ClientQuotaEntity entity = new ClientQuotaEntity(Collections.singletonMap("user", "user"));
        ClientQuotaAlteration alteration = new ClientQuotaAlteration(entity, Collections.singletonList(new ClientQuotaAlteration.Op("consumer_byte_rate", Double.valueOf(1000.0))));
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> env.adminClient().alterClientQuotas(Collections.singletonList(alteration)).all().get());
        Assertions.assertInstanceOf(AuthenticationException.class, (Object)e.getCause(), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
    }

    @Test
    public void testDescribeAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(new DescribeAclsResponseData().setResources(DescribeAclsResponse.aclsResources(Arrays.asList(ACL1, ACL2))), ApiKeys.DESCRIBE_ACLS.latestVersion()));
            KafkaAdminClientTest.assertCollectionIs((Collection)env.adminClient().describeAcls(FILTER1).values().get(), ACL1, ACL2);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(new DescribeAclsResponseData(), ApiKeys.DESCRIBE_ACLS.latestVersion()));
            Assertions.assertTrue((boolean)((Collection)env.adminClient().describeAcls(FILTER2).values().get()).isEmpty());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(new DescribeAclsResponseData().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("Security is disabled"), ApiKeys.DESCRIBE_ACLS.latestVersion()));
            TestUtils.assertFutureThrows(SecurityDisabledException.class, env.adminClient().describeAcls(FILTER2).values());
            TestUtils.assertFutureThrows(InvalidRequestException.class, env.adminClient().describeAcls(UNKNOWN_FILTER).values());
        }
    }

    @Test
    public void testCreateAclsToController() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv("bootstrap.controllers", "dummy");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(new CreateAclsResponseData().setResults(Arrays.asList(new CreateAclsResponseData.AclCreationResult().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage("not controller")))));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Integer.MIN_VALUE, true));
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(new CreateAclsResponseData().setResults(Arrays.asList(new CreateAclsResponseData.AclCreationResult()))));
            CreateAclsResult results = env.adminClient().createAcls(Arrays.asList(ACL1));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1);
            for (KafkaFuture future : results.values().values()) {
                future.get();
            }
            results.all().get();
        }
    }

    @Test
    public void testDeleteAclsToController() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv("bootstrap.controllers", "dummy");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage("not controller"))), ApiKeys.DELETE_ACLS.latestVersion()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Integer.MIN_VALUE, true));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Collections.singletonList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE))))), ApiKeys.DELETE_ACLS.latestVersion()));
            DeleteAclsResult results = env.adminClient().deleteAcls(Arrays.asList(FILTER1));
            Collection deleted = (Collection)results.all().get();
            KafkaAdminClientTest.assertCollectionIs(deleted, ACL1);
        }
    }

    @Test
    public void testCreateAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(new CreateAclsResponseData().setResults(Arrays.asList(new CreateAclsResponseData.AclCreationResult(), new CreateAclsResponseData.AclCreationResult()))));
            CreateAclsResult results = env.adminClient().createAcls(Arrays.asList(ACL1, ACL2));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1, ACL2);
            for (KafkaFuture future : results.values().values()) {
                future.get();
            }
            results.all().get();
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(new CreateAclsResponseData().setResults(Arrays.asList(new CreateAclsResponseData.AclCreationResult().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("Security is disabled"), new CreateAclsResponseData.AclCreationResult()))));
            results = env.adminClient().createAcls(Arrays.asList(ACL1, ACL2));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1, ACL2);
            TestUtils.assertFutureThrows(SecurityDisabledException.class, (Future)results.values().get(ACL1));
            ((KafkaFuture)results.values().get(ACL2)).get();
            TestUtils.assertFutureThrows(SecurityDisabledException.class, results.all());
        }
    }

    @Test
    public void testDeleteAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE), DeleteAclsResponse.matchingAcl((AclBinding)ACL2, (ApiError)ApiError.NONE))), new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("No security"))), ApiKeys.DELETE_ACLS.latestVersion()));
            DeleteAclsResult results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Map filterResults = results.values();
            DeleteAclsResult.FilterResults filter1Results = (DeleteAclsResult.FilterResults)((KafkaFuture)filterResults.get(FILTER1)).get();
            Assertions.assertNull((Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(0)).exception());
            Assertions.assertEquals((Object)ACL1, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(0)).binding());
            Assertions.assertNull((Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(1)).exception());
            Assertions.assertEquals((Object)ACL2, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(1)).binding());
            TestUtils.assertFutureThrows(SecurityDisabledException.class, (Future)filterResults.get(FILTER2));
            TestUtils.assertFutureThrows(SecurityDisabledException.class, results.all());
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE), new DeleteAclsResponseData.DeleteAclsMatchingAcl().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("No security").setPermissionType(AclPermissionType.ALLOW.code()).setOperation(AclOperation.ALTER.code()).setResourceType(ResourceType.CLUSTER.code()).setPatternType(FILTER2.patternFilter().patternType().code()))), new DeleteAclsResponseData.DeleteAclsFilterResult())), ApiKeys.DELETE_ACLS.latestVersion()));
            results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Assertions.assertTrue((boolean)((DeleteAclsResult.FilterResults)((KafkaFuture)results.values().get(FILTER2)).get()).values().isEmpty());
            TestUtils.assertFutureThrows(SecurityDisabledException.class, results.all());
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Collections.singletonList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE))), new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Collections.singletonList(DeleteAclsResponse.matchingAcl((AclBinding)ACL2, (ApiError)ApiError.NONE))))), ApiKeys.DELETE_ACLS.latestVersion()));
            results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Collection deleted = (Collection)results.all().get();
            KafkaAdminClientTest.assertCollectionIs(deleted, ACL1, ACL2);
        }
    }

    @Test
    public void testElectLeaders() throws Exception {
        TopicPartition topic1 = new TopicPartition("topic", 0);
        TopicPartition topic2 = new TopicPartition("topic", 2);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            for (ElectionType electionType : ElectionType.values()) {
                env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
                ApiError value = ApiError.fromThrowable((Throwable)new ClusterAuthorizationException(null));
                ArrayList<ElectLeadersResponseData.ReplicaElectionResult> electionResults = new ArrayList<ElectLeadersResponseData.ReplicaElectionResult>();
                ElectLeadersResponseData.ReplicaElectionResult electionResult = new ElectLeadersResponseData.ReplicaElectionResult();
                electionResult.setTopic(topic1.topic());
                ElectLeadersResponseData.PartitionResult partition1Result = new ElectLeadersResponseData.PartitionResult();
                partition1Result.setPartitionId(topic1.partition());
                partition1Result.setErrorCode(value.error().code());
                partition1Result.setErrorMessage(value.message());
                electionResult.partitionResult().add(partition1Result);
                ElectLeadersResponseData.PartitionResult partition2Result = new ElectLeadersResponseData.PartitionResult();
                partition2Result.setPartitionId(topic2.partition());
                partition2Result.setErrorCode(value.error().code());
                partition2Result.setErrorMessage(value.message());
                electionResult.partitionResult().add(partition2Result);
                electionResults.add(electionResult);
                env.kafkaClient().prepareResponse((AbstractResponse)new ElectLeadersResponse(0, Errors.NONE.code(), electionResults, ApiKeys.ELECT_LEADERS.latestVersion()));
                ElectLeadersResult results = env.adminClient().electLeaders(electionType, new HashSet<TopicPartition>(Arrays.asList(topic1, topic2)));
                Assertions.assertEquals(ClusterAuthorizationException.class, ((Throwable)((Optional)((Map)results.partitions().get()).get(topic2)).get()).getClass());
                partition1Result.setErrorCode(ApiError.NONE.error().code());
                partition1Result.setErrorMessage(ApiError.NONE.message());
                partition2Result.setErrorCode(ApiError.NONE.error().code());
                partition2Result.setErrorMessage(ApiError.NONE.message());
                env.kafkaClient().prepareResponse((AbstractResponse)new ElectLeadersResponse(0, Errors.NONE.code(), electionResults, ApiKeys.ELECT_LEADERS.latestVersion()));
                results = env.adminClient().electLeaders(electionType, new HashSet<TopicPartition>(Arrays.asList(topic1, topic2)));
                Assertions.assertFalse((boolean)((Optional)((Map)results.partitions().get()).get(topic1)).isPresent());
                Assertions.assertFalse((boolean)((Optional)((Map)results.partitions().get()).get(topic2)).isPresent());
                results = env.adminClient().electLeaders(electionType, new HashSet<TopicPartition>(Arrays.asList(topic1, topic2)), (ElectLeadersOptions)new ElectLeadersOptions().timeoutMs(Integer.valueOf(100)));
                TestUtils.assertFutureThrows(TimeoutException.class, results.partitions());
            }
        }
    }

    @Test
    public void testDescribeBrokerConfigs() throws Exception {
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        ConfigResource broker1Resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Collections.singletonList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(broker0Resource.name()).setResourceType(broker0Resource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Collections.singletonList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(broker1Resource.name()).setResourceType(broker1Resource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))), env.cluster().nodeById(1));
            Map result = env.adminClient().describeConfigs(Arrays.asList(broker0Resource, broker1Resource)).values();
            Assertions.assertEquals(new HashSet<ConfigResource>(Arrays.asList(broker0Resource, broker1Resource)), result.keySet());
            ((KafkaFuture)result.get(broker0Resource)).get();
            ((KafkaFuture)result.get(broker1Resource)).get();
        }
    }

    @Test
    public void testDescribeBrokerAndLogConfigs() throws Exception {
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        ConfigResource brokerLoggerResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "0");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(brokerResource.name()).setResourceType(brokerResource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList()), new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(brokerLoggerResource.name()).setResourceType(brokerLoggerResource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))), env.cluster().nodeById(0));
            Map result = env.adminClient().describeConfigs(Arrays.asList(brokerResource, brokerLoggerResource)).values();
            Assertions.assertEquals(new HashSet<ConfigResource>(Arrays.asList(brokerResource, brokerLoggerResource)), result.keySet());
            ((KafkaFuture)result.get(brokerResource)).get();
            ((KafkaFuture)result.get(brokerLoggerResource)).get();
        }
    }

    @Test
    public void testDescribeConfigsPartialResponse() {
        ConfigResource topic = new ConfigResource(ConfigResource.Type.TOPIC, "topic");
        ConfigResource topic2 = new ConfigResource(ConfigResource.Type.TOPIC, "topic2");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Collections.singletonList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(topic.name()).setResourceType(topic.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))));
            Map result = env.adminClient().describeConfigs(Arrays.asList(topic, topic2)).values();
            Assertions.assertEquals(new HashSet<ConfigResource>(Arrays.asList(topic, topic2)), result.keySet());
            result.get(topic);
            TestUtils.assertFutureThrows(ApiException.class, (Future)result.get(topic2));
        }
    }

    @Test
    public void testDescribeConfigsUnrequested() throws Exception {
        ConfigResource topic = new ConfigResource(ConfigResource.Type.TOPIC, "topic");
        ConfigResource unrequested = new ConfigResource(ConfigResource.Type.TOPIC, "unrequested");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(topic.name()).setResourceType(topic.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList()), new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(unrequested.name()).setResourceType(unrequested.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))));
            Map result = env.adminClient().describeConfigs(Collections.singletonList(topic)).values();
            Assertions.assertEquals(new HashSet<ConfigResource>(Collections.singletonList(topic)), result.keySet());
            Assertions.assertNotNull((Object)((KafkaFuture)result.get(topic)).get());
            Assertions.assertNull(result.get(unrequested));
        }
    }

    @Test
    public void testDescribeClientMetricsConfigs() throws Exception {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "sub1");
        ConfigResource resource1 = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "sub2");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(resource.name()).setResourceType(resource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList()), new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(resource1.name()).setResourceType(resource1.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))));
            Map result = env.adminClient().describeConfigs(Arrays.asList(resource, resource1)).values();
            Assertions.assertEquals(new HashSet<ConfigResource>(Arrays.asList(resource, resource1)), result.keySet());
            Assertions.assertNotNull((Object)((KafkaFuture)result.get(resource)).get());
            Assertions.assertNotNull((Object)((KafkaFuture)result.get(resource1)).get());
        }
    }

    @Test
    public void testDescribeConsumerGroupConfigs() throws Exception {
        ConfigResource resource1 = new ConfigResource(ConfigResource.Type.GROUP, "group1");
        ConfigResource resource2 = new ConfigResource(ConfigResource.Type.GROUP, "group2");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(resource1.name()).setResourceType(resource1.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList()), new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(resource2.name()).setResourceType(resource2.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))));
            Map result = env.adminClient().describeConfigs(Arrays.asList(resource1, resource2)).values();
            Assertions.assertEquals(new HashSet<ConfigResource>(Arrays.asList(resource1, resource2)), result.keySet());
            Assertions.assertNotNull((Object)((KafkaFuture)result.get(resource1)).get());
            Assertions.assertNotNull((Object)((KafkaFuture)result.get(resource2)).get());
        }
    }

    @Test
    public void testDescribeLogDirs() throws ExecutionException, InterruptedException {
        Set<Integer> brokers = Collections.singleton(0);
        String logDir = "/var/data/kafka";
        TopicPartition tp = new TopicPartition("topic", 12);
        long partitionSize = 1234567890L;
        long offsetLag = 24L;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeLogDirsResponse(Errors.NONE, logDir, tp, partitionSize, offsetLag), env.cluster().nodeById(0));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(brokers);
            Map descriptions = result.descriptions();
            Assertions.assertEquals(brokers, descriptions.keySet());
            Assertions.assertNotNull(descriptions.get(0));
            KafkaAdminClientTest.assertDescriptionContains((Map)((KafkaFuture)descriptions.get(0)).get(), logDir, tp, partitionSize, offsetLag);
            Map allDescriptions = (Map)result.allDescriptions().get();
            Assertions.assertEquals(brokers, allDescriptions.keySet());
            KafkaAdminClientTest.assertDescriptionContains((Map)allDescriptions.get(0), logDir, tp, partitionSize, offsetLag);
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareEmptyDescribeLogDirsResponse(Optional.empty()), env.cluster().nodeById(0));
            DescribeLogDirsResult errorResult = env.adminClient().describeLogDirs(brokers);
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> errorResult.allDescriptions().get());
            Assertions.assertInstanceOf(ClusterAuthorizationException.class, (Object)exception.getCause());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareEmptyDescribeLogDirsResponse(Optional.of(Errors.UNKNOWN_SERVER_ERROR)), env.cluster().nodeById(0));
            DescribeLogDirsResult errorResult2 = env.adminClient().describeLogDirs(brokers);
            exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> errorResult2.allDescriptions().get());
            Assertions.assertInstanceOf(UnknownServerException.class, (Object)exception.getCause());
        }
    }

    @Test
    public void testDescribeLogDirsOfflineDir() throws ExecutionException, InterruptedException {
        Set<Integer> brokers = Collections.singleton(0);
        String logDir = "/var/data/kafka";
        Errors error = Errors.KAFKA_STORAGE_ERROR;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeLogDirsResponse(error, logDir, Collections.emptyList()), env.cluster().nodeById(0));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(brokers);
            Map descriptions = result.descriptions();
            Assertions.assertEquals(brokers, descriptions.keySet());
            Assertions.assertNotNull(descriptions.get(0));
            Map descriptionsMap = (Map)((KafkaFuture)descriptions.get(0)).get();
            Assertions.assertEquals(Collections.singleton(logDir), descriptionsMap.keySet());
            Assertions.assertEquals(error.exception().getClass(), ((LogDirDescription)descriptionsMap.get(logDir)).error().getClass());
            Assertions.assertEquals(Collections.emptySet(), ((LogDirDescription)descriptionsMap.get(logDir)).replicaInfos().keySet());
            Map allDescriptions = (Map)result.allDescriptions().get();
            Assertions.assertEquals(brokers, allDescriptions.keySet());
            Map allMap = (Map)allDescriptions.get(0);
            Assertions.assertNotNull((Object)allMap);
            Assertions.assertEquals(Collections.singleton(logDir), allMap.keySet());
            Assertions.assertEquals(error.exception().getClass(), ((LogDirDescription)allMap.get(logDir)).error().getClass());
            Assertions.assertEquals(Collections.emptySet(), ((LogDirDescription)allMap.get(logDir)).replicaInfos().keySet());
        }
    }

    @Test
    public void testDescribeReplicaLogDirs() throws ExecutionException, InterruptedException {
        TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 12, 1);
        TopicPartitionReplica tpr2 = new TopicPartitionReplica("topic", 12, 2);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String broker1log0 = "/var/data/kafka0";
            String broker1log1 = "/var/data/kafka1";
            String broker2log0 = "/var/data/kafka2";
            int broker1Log0OffsetLag = 24;
            int broker1Log0PartitionSize = 987654321;
            int broker1Log1PartitionSize = 123456789;
            int broker1Log1OffsetLag = 4321;
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Arrays.asList(KafkaAdminClientTest.prepareDescribeLogDirsResult(tpr1, broker1log0, broker1Log0PartitionSize, broker1Log0OffsetLag, false), KafkaAdminClientTest.prepareDescribeLogDirsResult(tpr1, broker1log1, broker1Log1PartitionSize, broker1Log1OffsetLag, true)))), env.cluster().nodeById(tpr1.brokerId()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)this.prepareDescribeLogDirsResponse(Errors.KAFKA_STORAGE_ERROR, broker2log0), env.cluster().nodeById(tpr2.brokerId()));
            DescribeReplicaLogDirsResult result = env.adminClient().describeReplicaLogDirs(Arrays.asList(tpr1, tpr2));
            Map values = result.values();
            Assertions.assertEquals(Set.of(tpr1, tpr2), values.keySet());
            Assertions.assertNotNull(values.get(tpr1));
            Assertions.assertEquals((Object)broker1log0, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getCurrentReplicaLogDir());
            Assertions.assertEquals((long)broker1Log0OffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getCurrentReplicaOffsetLag());
            Assertions.assertEquals((Object)broker1log1, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getFutureReplicaLogDir());
            Assertions.assertEquals((long)broker1Log1OffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getFutureReplicaOffsetLag());
            Assertions.assertNotNull(values.get(tpr2));
            Assertions.assertNull((Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getCurrentReplicaLogDir());
            Assertions.assertEquals((long)-1L, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getCurrentReplicaOffsetLag());
            Assertions.assertNull((Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getFutureReplicaLogDir());
            Assertions.assertEquals((long)-1L, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getFutureReplicaOffsetLag());
        }
    }

    private static DescribeLogDirsResponseData.DescribeLogDirsResult prepareDescribeLogDirsResult(TopicPartitionReplica tpr, String logDir, int partitionSize, int offsetLag, boolean isFuture) {
        return new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(Errors.NONE.code()).setLogDir(logDir).setTopics(KafkaAdminClientTest.prepareDescribeLogDirsTopics(partitionSize, offsetLag, tpr.topic(), tpr.partition(), isFuture));
    }

    @Test
    public void testDescribeReplicaLogDirsUnexpected() throws ExecutionException, InterruptedException {
        TopicPartitionReplica expected = new TopicPartitionReplica("topic", 12, 1);
        TopicPartitionReplica unexpected = new TopicPartitionReplica("topic", 12, 2);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String broker1log0 = "/var/data/kafka0";
            String broker1log1 = "/var/data/kafka1";
            int broker1Log0PartitionSize = 987654321;
            int broker1Log0OffsetLag = 24;
            int broker1Log1PartitionSize = 123456789;
            int broker1Log1OffsetLag = 4321;
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Arrays.asList(KafkaAdminClientTest.prepareDescribeLogDirsResult(expected, broker1log0, broker1Log0PartitionSize, broker1Log0OffsetLag, false), KafkaAdminClientTest.prepareDescribeLogDirsResult(unexpected, broker1log1, broker1Log1PartitionSize, broker1Log1OffsetLag, true)))), env.cluster().nodeById(expected.brokerId()));
            DescribeReplicaLogDirsResult result = env.adminClient().describeReplicaLogDirs(Collections.singletonList(expected));
            Map values = result.values();
            Assertions.assertEquals(Set.of(expected), values.keySet());
            Assertions.assertNotNull(values.get(expected));
            Assertions.assertEquals((Object)broker1log0, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(expected)).get()).getCurrentReplicaLogDir());
            Assertions.assertEquals((long)broker1Log0OffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(expected)).get()).getCurrentReplicaOffsetLag());
            Assertions.assertEquals((Object)broker1log1, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(expected)).get()).getFutureReplicaLogDir());
            Assertions.assertEquals((long)broker1Log1OffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(expected)).get()).getFutureReplicaOffsetLag());
        }
    }

    @Test
    public void testCreatePartitions() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("my_topic", "other_topic"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("my_topic", Errors.NONE), KafkaAdminClientTest.createPartitionsTopicResult("other_topic", Errors.INVALID_TOPIC_EXCEPTION, "some detailed reason")));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("my_topic", NewPartitions.increaseTo((int)3));
            counts.put("other_topic", NewPartitions.increaseTo((int)3, Arrays.asList(Collections.singletonList(2), Collections.singletonList(3))));
            CreatePartitionsResult results = env.adminClient().createPartitions(counts);
            Map values = results.values();
            KafkaFuture myTopicResult = (KafkaFuture)values.get("my_topic");
            myTopicResult.get();
            KafkaFuture otherTopicResult = (KafkaFuture)values.get("other_topic");
            Assertions.assertEquals((Object)"some detailed reason", (Object)((InvalidTopicException)Assertions.assertInstanceOf(InvalidTopicException.class, (Object)((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)otherTopicResult).get())).getCause())).getMessage());
        }
    }

    @Test
    public void testCreatePartitionsRetryThrottlingExceptionWhenEnabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.createPartitionsTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(0, KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.NONE)));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("topic1", NewPartitions.increaseTo((int)1));
            counts.put("topic2", NewPartitions.increaseTo((int)2));
            counts.put("topic3", NewPartitions.increaseTo((int)3));
            CreatePartitionsResult result = env.adminClient().createPartitions(counts, new CreatePartitionsOptions().retryOnQuotaViolation(true));
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic2")).get());
            TestUtils.assertFutureThrows(TopicExistsException.class, (Future)result.values().get("topic3"));
        }
    }

    @Test
    public void testCreatePartitionsRetryThrottlingExceptionWhenEnabledUntilRequestTimeOut() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "default.api.timeout.ms", String.valueOf(defaultApiTimeout));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.createPartitionsTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("topic1", NewPartitions.increaseTo((int)1));
            counts.put("topic2", NewPartitions.increaseTo((int)2));
            counts.put("topic3", NewPartitions.increaseTo((int)3));
            CreatePartitionsResult result = env.adminClient().createPartitions(counts, new CreatePartitionsOptions().retryOnQuotaViolation(true));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting CreatePartitions requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting next CreatePartitions request");
            time.sleep(defaultApiTimeout + 1L);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows(ThrottlingQuotaExceededException.class, (Future)result.values().get("topic2"));
            Assertions.assertEquals((int)0, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows(TopicExistsException.class, (Future)result.values().get("topic3"));
        }
    }

    @Test
    public void testCreatePartitionsDontRetryThrottlingExceptionWhenDisabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.createPartitionsTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("topic1", NewPartitions.increaseTo((int)1));
            counts.put("topic2", NewPartitions.increaseTo((int)2));
            counts.put("topic3", NewPartitions.increaseTo((int)3));
            CreatePartitionsResult result = env.adminClient().createPartitions(counts, new CreatePartitionsOptions().retryOnQuotaViolation(false));
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows(ThrottlingQuotaExceededException.class, (Future)result.values().get("topic2"));
            Assertions.assertEquals((int)1000, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows(TopicExistsException.class, (Future)result.values().get("topic3"));
        }
    }

    private MockClient.RequestMatcher expectCreatePartitionsRequestWithTopics(String ... topics) {
        return body -> {
            if (body instanceof CreatePartitionsRequest) {
                CreatePartitionsRequest request = (CreatePartitionsRequest)body;
                for (String topic : topics) {
                    if (request.data().topics().find(topic) != null) continue;
                    return false;
                }
                return topics.length == request.data().topics().size();
            }
            return false;
        };
    }

    @Test
    public void testDeleteRecordsTopicAuthorizationError() {
        String topic = "foo";
        TopicPartition partition = new TopicPartition(topic, 0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            ArrayList<MetadataResponse.TopicMetadata> topics = new ArrayList<MetadataResponse.TopicMetadata>();
            topics.add(new MetadataResponse.TopicMetadata(Errors.TOPIC_AUTHORIZATION_FAILED, topic, false, Collections.emptyList()));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), topics));
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(partition, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            TestUtils.assertFutureThrows(TopicAuthorizationException.class, (Future)results.lowWatermarks().get(partition));
        }
    }

    @Test
    public void testDeleteRecordsMultipleSends() throws Exception {
        String topic = "foo";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0));){
            List nodes = env.cluster().nodes();
            ArrayList<MetadataResponse.PartitionMetadata> partitionMetadata = new ArrayList<MetadataResponse.PartitionMetadata>();
            partitionMetadata.add(new MetadataResponse.PartitionMetadata(Errors.NONE, tp0, Optional.of(((Node)nodes.get(0)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            partitionMetadata.add(new MetadataResponse.PartitionMetadata(Errors.NONE, tp1, Optional.of(((Node)nodes.get(1)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(1)).id()), Collections.singletonList(((Node)nodes.get(1)).id()), Collections.emptyList()));
            ArrayList<MetadataResponse.TopicMetadata> topicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
            topicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, topic, false, partitionMetadata));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), topicMetadata));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DeleteRecordsResponse(new DeleteRecordsResponseData().setTopics(new DeleteRecordsResponseData.DeleteRecordsTopicResultCollection(Collections.singletonList(new DeleteRecordsResponseData.DeleteRecordsTopicResult().setName(tp0.topic()).setPartitions(new DeleteRecordsResponseData.DeleteRecordsPartitionResultCollection(Collections.singletonList(new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(tp0.partition()).setErrorCode(Errors.NONE.code()).setLowWatermark(3L)).iterator()))).iterator()))), (Node)nodes.get(0));
            env.kafkaClient().disconnect(((Node)nodes.get(1)).idString());
            env.kafkaClient().createPendingAuthenticationError((Node)nodes.get(1), 100L);
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(tp0, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(tp1, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            Assertions.assertEquals((long)3L, (long)((DeletedRecords)((KafkaFuture)results.lowWatermarks().get(tp0)).get()).lowWatermark());
            TestUtils.assertFutureThrows(SaslAuthenticationException.class, (Future)results.lowWatermarks().get(tp1));
        }
    }

    @Test
    public void testListConsumerGroupOffsetsOptionsWithBatchedApi() throws Exception {
        this.verifyListConsumerGroupOffsetsOptions();
    }

    private void verifyListConsumerGroupOffsetsOptions() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            List<TopicPartition> partitions = Collections.singletonList(new TopicPartition("A", 0));
            ListConsumerGroupOffsetsOptions options = (ListConsumerGroupOffsetsOptions)new ListConsumerGroupOffsetsOptions().requireStable(true).timeoutMs(Integer.valueOf(300));
            ListConsumerGroupOffsetsSpec groupSpec = new ListConsumerGroupOffsetsSpec().topicPartitions(partitions);
            env.adminClient().listConsumerGroupOffsets(Collections.singletonMap(GROUP_ID, groupSpec), options);
            MockClient mockClient = env.kafkaClient();
            this.waitForRequest(mockClient, ApiKeys.OFFSET_FETCH);
            ClientRequest clientRequest = mockClient.requests().peek();
            Assertions.assertNotNull((Object)clientRequest);
            Assertions.assertEquals((int)300, (int)clientRequest.requestTimeoutMs());
            OffsetFetchRequestData data = ((OffsetFetchRequest)((OffsetFetchRequest.Builder)clientRequest.requestBuilder()).build()).data();
            Assertions.assertTrue((boolean)data.requireStable());
            Assertions.assertEquals(Collections.singletonList(GROUP_ID), data.groups().stream().map(OffsetFetchRequestData.OffsetFetchRequestGroup::groupId).collect(Collectors.toList()));
            Assertions.assertEquals(Collections.singletonList("A"), ((OffsetFetchRequestData.OffsetFetchRequestGroup)data.groups().get(0)).topics().stream().map(OffsetFetchRequestData.OffsetFetchRequestTopics::name).collect(Collectors.toList()));
            Assertions.assertEquals(Collections.singletonList(0), (Object)((OffsetFetchRequestData.OffsetFetchRequestTopics)((OffsetFetchRequestData.OffsetFetchRequestGroup)data.groups().get(0)).topics().get(0)).partitionIndexes());
        }
    }

    @Test
    public void testDeleteRecords() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        nodes.put(0, new Node(0, "localhost", 8121));
        ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>();
        partitionInfos.add(new PartitionInfo("my_topic", 0, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 1, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 2, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 3, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), partitionInfos, Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
        TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
        TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
        TopicPartition myTopicPartition3 = new TopicPartition("my_topic", 3);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.LEADER_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.UNKNOWN_TOPIC_OR_PARTITION));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            DeleteRecordsResponseData m = new DeleteRecordsResponseData();
            m.topics().add((ImplicitLinkedHashCollection.Element)new DeleteRecordsResponseData.DeleteRecordsTopicResult().setName(myTopicPartition0.topic()).setPartitions(new DeleteRecordsResponseData.DeleteRecordsPartitionResultCollection(Arrays.asList(new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(myTopicPartition0.partition()).setLowWatermark(3L).setErrorCode(Errors.NONE.code()), new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(myTopicPartition1.partition()).setLowWatermark(-1L).setErrorCode(Errors.OFFSET_OUT_OF_RANGE.code()), new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(myTopicPartition2.partition()).setLowWatermark(-1L).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code())).iterator())));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteRecordsResponse(m));
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(myTopicPartition0, RecordsToDelete.beforeOffset((long)3L));
            recordsToDelete.put(myTopicPartition1, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition2, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition3, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            Map values = results.lowWatermarks();
            KafkaFuture myTopicPartition0Result = (KafkaFuture)values.get(myTopicPartition0);
            long myTopicPartition0lowWatermark = ((DeletedRecords)myTopicPartition0Result.get()).lowWatermark();
            Assertions.assertEquals((long)3L, (long)myTopicPartition0lowWatermark);
            KafkaFuture myTopicPartition1Result = (KafkaFuture)values.get(myTopicPartition1);
            Assertions.assertInstanceOf(OffsetOutOfRangeException.class, (Object)((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)myTopicPartition1Result).get())).getCause());
            KafkaFuture myTopicPartition2Result = (KafkaFuture)values.get(myTopicPartition2);
            Assertions.assertInstanceOf(TopicAuthorizationException.class, (Object)((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)myTopicPartition2Result).get())).getCause());
            KafkaFuture myTopicPartition3Result = (KafkaFuture)values.get(myTopicPartition3);
            Assertions.assertInstanceOf(ApiException.class, (Object)((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)myTopicPartition3Result).get())).getCause());
        }
    }

    @Test
    public void testDescribeTopicsByIds() throws ExecutionException, InterruptedException {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            Uuid topicId = Uuid.randomUuid();
            String topicName = "test-topic";
            Node leader = (Node)env.cluster().nodes().get(0);
            MetadataResponse.PartitionMetadata partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, new TopicPartition(topicName, 0), Optional.of(leader.id()), Optional.of(10), Collections.singletonList(leader.id()), Collections.singletonList(leader.id()), Collections.singletonList(leader.id()));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), Collections.singletonList(new MetadataResponse.TopicMetadata(Errors.NONE, topicName, topicId, false, Collections.singletonList(partitionMetadata), Integer.MIN_VALUE, TopicType.STANDARD))));
            TopicCollection.TopicIdCollection topicIds = TopicCollection.ofTopicIds(Collections.singletonList(topicId));
            DescribeTopicsResult describeTopicsresult = env.adminClient().describeTopics((TopicCollection)topicIds);
            Map allTopicIds = (Map)describeTopicsresult.allTopicIds().get();
            Assertions.assertEquals((Object)topicName, (Object)((TopicDescription)allTopicIds.get(topicId)).name());
            Uuid nonExistID = Uuid.randomUuid();
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), Collections.emptyList()));
            DescribeTopicsResult result1 = env.adminClient().describeTopics((TopicCollection)TopicCollection.ofTopicIds(Collections.singletonList(nonExistID)));
            TestUtils.assertFutureThrows(UnknownTopicIdException.class, result1.allTopicIds());
            Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> result1.allTopicIds().get(), (String)"describe with non-exist topic ID should throw exception");
            Assertions.assertEquals((Object)String.format("org.apache.kafka.common.errors.UnknownTopicIdException: TopicId %s not found.", nonExistID), (Object)e.getMessage());
            DescribeTopicsResult result2 = env.adminClient().describeTopics((TopicCollection)TopicCollection.ofTopicIds(Collections.singletonList(Uuid.ZERO_UUID)));
            TestUtils.assertFutureThrows(InvalidTopicException.class, result2.allTopicIds());
            e = (Exception)Assertions.assertThrows(Exception.class, () -> result2.allTopicIds().get(), (String)"describe with non-exist topic ID should throw exception");
            Assertions.assertEquals((Object)"The given topic id 'AAAAAAAAAAAAAAAAAAAAAA' cannot be represented in a request.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testDescribeVirtualTopicById() throws ExecutionException, InterruptedException {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            Uuid topicId = Uuid.randomUuid();
            String topicName = "test-topic";
            Node leader = (Node)env.cluster().nodes().get(0);
            MetadataResponse.PartitionMetadata partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, new TopicPartition(topicName, 0), Optional.of(leader.id()), Optional.of(-1), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), Collections.singletonList(new MetadataResponse.TopicMetadata(Errors.NONE, topicName, topicId, false, Collections.singletonList(partitionMetadata), Integer.MIN_VALUE, TopicType.VIRTUAL))));
            TopicCollection.TopicIdCollection topicIds = TopicCollection.ofTopicIds(Collections.singletonList(topicId));
            DescribeTopicsResult describeTopicsresult = env.adminClient().describeTopics((TopicCollection)topicIds);
            Map allTopicIds = (Map)describeTopicsresult.allTopicIds().get();
            Assertions.assertEquals((Object)topicName, (Object)((TopicDescription)allTopicIds.get(topicId)).name());
            Assertions.assertEquals((Object)TopicType.VIRTUAL, (Object)((TopicDescription)allTopicIds.get(topicId)).topicType());
        }
    }

    @Test
    public void testDescribeCluster() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Integer.MIN_VALUE, false));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 3, 1 << AclOperation.DESCRIBE.code() | 1 << AclOperation.ALTER.code(), false));
            DescribeClusterResult result = env.adminClient().describeCluster();
            Assertions.assertEquals((Object)env.cluster().clusterResource().clusterId(), (Object)result.clusterId().get());
            Assertions.assertEquals(new HashSet(env.cluster().nodes()), new HashSet((Collection)result.nodes().get()));
            Assertions.assertEquals((int)2, (int)((Node)result.controller().get()).id());
            Assertions.assertNull((Object)result.authorizedOperations().get());
            DescribeClusterResult result2 = env.adminClient().describeCluster();
            Assertions.assertEquals((Object)env.cluster().clusterResource().clusterId(), (Object)result2.clusterId().get());
            Assertions.assertEquals(new HashSet(env.cluster().nodes()), new HashSet((Collection)result2.nodes().get()));
            Assertions.assertEquals((int)3, (int)((Node)result2.controller().get()).id());
            Assertions.assertEquals(new HashSet<AclOperation>(Arrays.asList(AclOperation.DESCRIBE, AclOperation.ALTER)), (Object)result2.authorizedOperations().get());
        }
    }

    @Test
    public void testDescribeClusterHandleError() {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String errorMessage = "my error";
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterResponse(new DescribeClusterResponseData().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage(errorMessage)));
            DescribeClusterResult result = env.adminClient().describeCluster();
            TestUtils.assertFutureThrows(InvalidRequestException.class, result.clusterId(), errorMessage);
            TestUtils.assertFutureThrows(InvalidRequestException.class, result.controller(), errorMessage);
            TestUtils.assertFutureThrows(InvalidRequestException.class, result.nodes(), errorMessage);
            TestUtils.assertFutureThrows(InvalidRequestException.class, result.authorizedOperations(), errorMessage);
        }
    }

    private static DescribeClusterResponse prepareDescribeClusterResponse(int throttleTimeMs, Collection<Node> brokers, String clusterId, int controllerId, int clusterAuthorizedOperations, boolean sentToController) {
        DescribeClusterResponseData data = new DescribeClusterResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(throttleTimeMs).setControllerId(controllerId).setClusterId(clusterId).setClusterAuthorizedOperations(clusterAuthorizedOperations);
        if (sentToController) {
            data.setEndpointType(EndpointType.CONTROLLER.id());
        }
        brokers.forEach(broker -> data.brokers().add((ImplicitLinkedHashCollection.Element)new DescribeClusterResponseData.DescribeClusterBroker().setHost(broker.host()).setPort(broker.port()).setBrokerId(broker.id()).setRack(broker.rack())));
        return new DescribeClusterResponse(data);
    }

    @Test
    public void testDescribeClusterFailBack() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof DescribeClusterRequest);
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Collections.emptyList(), Integer.MIN_VALUE, ApiKeys.METADATA.latestVersion()));
            DescribeClusterResult result = env.adminClient().describeCluster();
            Assertions.assertEquals((Object)env.cluster().clusterResource().clusterId(), (Object)result.clusterId().get());
            Assertions.assertEquals(new HashSet(env.cluster().nodes()), new HashSet((Collection)result.nodes().get()));
            Assertions.assertEquals((int)2, (int)((Node)result.controller().get()).id());
            Assertions.assertNull((Object)result.authorizedOperations().get());
        }
    }

    @Test
    public void testListGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(Collections.emptyList(), env.cluster().clusterResource().clusterId(), -1, Collections.emptyList()));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupType(GroupType.CONSUMER.toString()).setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-1").setProtocolType("connector").setGroupType(GroupType.CLASSIC.toString()).setGroupState("Stable")))), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setProtocolType("anyproto").setGroupType(GroupType.CLASSIC.toString()).setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-2").setProtocolType("connector").setGroupType(GroupType.CLASSIC.toString()).setGroupState("Stable")))), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-3").setProtocolType("share").setGroupType(GroupType.SHARE.toString()).setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-3").setProtocolType("connector").setGroupType(GroupType.CLASSIC.toString()).setGroupState("Stable")))), env.cluster().nodeById(2));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(3));
            ListGroupsResult result = env.adminClient().listGroups();
            TestUtils.assertFutureThrows(UnknownServerException.class, result.all());
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)6, (int)listings.size());
            HashSet<String> groupIds = new HashSet<String>();
            for (GroupListing listing : listings) {
                groupIds.add(listing.groupId());
            }
            Assertions.assertEquals(Set.of("group-1", "group-connect-1", "group-2", "group-connect-2", "group-3", "group-connect-3"), groupIds);
            Assertions.assertEquals((int)1, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListGroupsMetadataFailure() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(Collections.emptyList(), env.cluster().clusterResource().clusterId(), -1, Collections.emptyList()));
            ListGroupsResult result = env.adminClient().listGroups();
            TestUtils.assertFutureThrows(KafkaException.class, result.all());
        }
    }

    @Test
    public void testListGroupsEmptyProtocol() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupType(GroupType.CONSUMER.toString()).setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setGroupType(GroupType.CLASSIC.toString()).setGroupState("Empty")))), env.cluster().nodeById(0));
            ListGroupsOptions options = new ListGroupsOptions();
            ListGroupsResult result = env.adminClient().listGroups(options);
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)2, (int)listings.size());
            ArrayList<GroupListing> expected = new ArrayList<GroupListing>();
            expected.add(new GroupListing("group-2", Optional.of(GroupType.CLASSIC), "", Optional.of(GroupState.EMPTY)));
            expected.add(new GroupListing("group-1", Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE)));
            Assertions.assertEquals(expected, (Object)listings);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListGroupsEmptyGroupType() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("any")))), env.cluster().nodeById(0));
            ListGroupsOptions options = new ListGroupsOptions();
            ListGroupsResult result = env.adminClient().listGroups(options);
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)1, (int)listings.size());
            ArrayList<GroupListing> expected = new ArrayList<GroupListing>();
            expected.add(new GroupListing("group-1", Optional.empty(), "any", Optional.empty()));
            Assertions.assertEquals(expected, (Object)listings);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListGroupsWithProtocolTypes() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom(this.expectListGroupsRequestWithFilters(Set.of(), Set.of()), (AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable").setGroupType(GroupType.CONSUMER.toString()), new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setGroupState("Empty").setGroupType(GroupType.CONSUMER.toString())))), env.cluster().nodeById(0));
            ListGroupsOptions options = new ListGroupsOptions().withProtocolTypes(Set.of(""));
            ListGroupsResult result = env.adminClient().listGroups(options);
            Collection listing = (Collection)result.valid().get();
            Assertions.assertEquals((int)1, (int)listing.size());
            ArrayList<GroupListing> expected = new ArrayList<GroupListing>();
            expected.add(new GroupListing("group-2", Optional.of(GroupType.CONSUMER), "", Optional.of(GroupState.EMPTY)));
            Assertions.assertEquals(expected, (Object)listing);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListGroupsWithTypes() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom(this.expectListGroupsRequestWithFilters(Collections.emptySet(), Collections.singleton(GroupType.CONSUMER.toString())), (AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable").setGroupType(GroupType.CONSUMER.toString()), new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setGroupState("Empty").setGroupType(GroupType.CONSUMER.toString())))), env.cluster().nodeById(0));
            ListGroupsOptions options = new ListGroupsOptions().withTypes(Collections.singleton(GroupType.CONSUMER));
            ListGroupsResult result = env.adminClient().listGroups(options);
            Collection listing = (Collection)result.valid().get();
            Assertions.assertEquals((int)2, (int)listing.size());
            ArrayList<GroupListing> expected = new ArrayList<GroupListing>();
            expected.add(new GroupListing("group-2", Optional.of(GroupType.CONSUMER), "", Optional.of(GroupState.EMPTY)));
            expected.add(new GroupListing("group-1", Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE)));
            Assertions.assertEquals(expected, (Object)listing);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListGroupsWithTypesOlderBrokerVersion() throws Exception {
        ApiVersionsResponseData.ApiVersion listGroupV4 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.LIST_GROUPS.id).setMinVersion((short)0).setMaxVersion((short)4);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(List.of(listGroupV4)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ListGroupsRequest && !((ListGroupsRequest)request).data().typesFilter().isEmpty());
            ListGroupsOptions options = new ListGroupsOptions().withTypes(Set.of(GroupType.SHARE));
            ListGroupsResult result = env.adminClient().listGroups(options);
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.all());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom(this.expectListGroupsRequestWithFilters(Set.of(), Set.of()), (AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState(GroupState.STABLE.toString())))), env.cluster().nodeById(0));
            options = new ListGroupsOptions().withTypes(Set.of(GroupType.CLASSIC));
            result = env.adminClient().listGroups(options);
            Collection listing = (Collection)result.all().get();
            Assertions.assertEquals((int)1, (int)listing.size());
            List<GroupListing> expected = List.of(new GroupListing("group-1", Optional.empty(), "consumer", Optional.of(GroupState.STABLE)));
            Assertions.assertEquals(expected, (Object)listing);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ListGroupsRequest && !((ListGroupsRequest)request).data().typesFilter().isEmpty());
            options = new ListGroupsOptions().withTypes(Set.of(GroupType.CONSUMER));
            result = env.adminClient().listGroups(options);
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.all());
        }
    }

    @Test
    public void testDescribeClusterHandleUnsupportedVersionForIncludingFencedBrokers() {
        ApiVersionsResponseData.ApiVersion describeClusterV1 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.DESCRIBE_CLUSTER.id).setMinVersion((short)0).setMaxVersion((short)1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Collections.singletonList(describeClusterV1)));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof DescribeClusterRequest);
            DescribeClusterResult result = env.adminClient().describeCluster(new DescribeClusterOptions().includeFencedBrokers(true));
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.nodes());
        }
    }

    @Test
    public void testListConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(List.of(), env.cluster().clusterResource().clusterId(), -1, List.of()));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), List.of()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-1").setProtocolType("connector").setGroupState("Stable")))), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-2").setProtocolType("connector").setGroupState("Stable")))), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-3").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-3").setProtocolType("connector").setGroupState("Stable")))), env.cluster().nodeById(2));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(3));
            ListGroupsResult result = env.adminClient().listGroups(ListGroupsOptions.forConsumerGroups());
            TestUtils.assertFutureThrows(UnknownServerException.class, result.all());
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)3, (int)listings.size());
            HashSet<String> groupIds = new HashSet<String>();
            for (GroupListing listing : listings) {
                groupIds.add(listing.groupId());
                Assertions.assertTrue((boolean)listing.groupState().isPresent());
            }
            Assertions.assertEquals(Set.of("group-1", "group-2", "group-3"), groupIds);
            Assertions.assertEquals((int)1, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListConsumerGroupsMetadataFailure() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(List.of(), env.cluster().clusterResource().clusterId(), -1, List.of()));
            ListGroupsResult result = env.adminClient().listGroups(ListGroupsOptions.forConsumerGroups());
            TestUtils.assertFutureThrows(KafkaException.class, result.all());
        }
    }

    @Test
    public void testListConsumerGroupsWithStates() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setGroupState("Empty")))), env.cluster().nodeById(0));
            ListGroupsOptions options = ListGroupsOptions.forConsumerGroups();
            ListGroupsResult result = env.adminClient().listGroups(options);
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)2, (int)listings.size());
            ArrayList<GroupListing> expected = new ArrayList<GroupListing>();
            expected.add(new GroupListing("group-2", Optional.empty(), "", Optional.of(GroupState.EMPTY)));
            expected.add(new GroupListing("group-1", Optional.empty(), "consumer", Optional.of(GroupState.STABLE)));
            Assertions.assertEquals(expected, (Object)listings);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListConsumerGroupsWithProtocolTypes() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom(this.expectListGroupsRequestWithFilters(Set.of(), Set.of(GroupType.CONSUMER.toString(), GroupType.CLASSIC.toString())), (AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable").setGroupType(GroupType.CONSUMER.toString()), new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setGroupState("Empty").setGroupType(GroupType.CONSUMER.toString())))), env.cluster().nodeById(0));
            ListGroupsOptions options = ListGroupsOptions.forConsumerGroups().withProtocolTypes(Set.of("consumer"));
            ListGroupsResult result = env.adminClient().listGroups(options);
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)1, (int)listings.size());
            ArrayList<GroupListing> expected = new ArrayList<GroupListing>();
            expected.add(new GroupListing("group-1", Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE)));
            Assertions.assertEquals(expected, (Object)listings);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListConsumerGroupsWithTypes() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom(this.expectListGroupsRequestWithFilters(Set.of(GroupState.STABLE.toString()), Set.of(GroupType.CONSUMER.toString(), GroupType.CLASSIC.toString())), (AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable").setGroupType(GroupType.CLASSIC.toString())))), env.cluster().nodeById(0));
            ListGroupsOptions options = ListGroupsOptions.forConsumerGroups().inGroupStates(Set.of(GroupState.STABLE));
            ListGroupsResult result = env.adminClient().listGroups(options);
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)1, (int)listings.size());
            ArrayList<GroupListing> expected = new ArrayList<GroupListing>();
            expected.add(new GroupListing("group-1", Optional.of(GroupType.CLASSIC), "consumer", Optional.of(GroupState.STABLE)));
            Assertions.assertEquals(expected, (Object)listings);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom(this.expectListGroupsRequestWithFilters(Set.of(), Set.of(GroupType.CONSUMER.toString())), (AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable").setGroupType(GroupType.CONSUMER.toString()), new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setGroupState("Empty").setGroupType(GroupType.CONSUMER.toString())))), env.cluster().nodeById(0));
            ListGroupsOptions options2 = ListGroupsOptions.forConsumerGroups().withTypes(Set.of(GroupType.CONSUMER));
            ListGroupsResult result2 = env.adminClient().listGroups(options2);
            Collection listings2 = (Collection)result2.valid().get();
            Assertions.assertEquals((int)2, (int)listings2.size());
            ArrayList<GroupListing> expected2 = new ArrayList<GroupListing>();
            expected2.add(new GroupListing("group-2", Optional.of(GroupType.CONSUMER), "", Optional.of(GroupState.EMPTY)));
            expected2.add(new GroupListing("group-1", Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE)));
            Assertions.assertEquals(expected2, (Object)listings2);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListConsumerGroupsWithStatesOlderBrokerVersion() throws Exception {
        ApiVersionsResponseData.ApiVersion listGroupV3 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.LIST_GROUPS.id).setMinVersion((short)0).setMaxVersion((short)3);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(List.of(listGroupV3)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer")))), env.cluster().nodeById(0));
            ListGroupsOptions options = ListGroupsOptions.forConsumerGroups();
            ListGroupsResult result = env.adminClient().listGroups(options);
            Collection listing = (Collection)result.all().get();
            Assertions.assertEquals((int)1, (int)listing.size());
            List<GroupListing> expected = List.of(new GroupListing("group-1", Optional.empty(), "consumer", Optional.empty()));
            Assertions.assertEquals(expected, (Object)listing);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ListGroupsRequest && !((ListGroupsRequest)request).data().statesFilter().isEmpty());
            options = ListGroupsOptions.forConsumerGroups().inGroupStates(Set.of(GroupState.STABLE));
            result = env.adminClient().listGroups(options);
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.all());
        }
    }

    @Test
    public void testListConsumerGroupsWithTypesOlderBrokerVersion() throws Exception {
        ApiVersionsResponseData.ApiVersion listGroupV4 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.LIST_GROUPS.id).setMinVersion((short)0).setMaxVersion((short)4);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(List.of(listGroupV4)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom(this.expectListGroupsRequestWithFilters(Set.of(GroupState.STABLE.toString()), Set.of()), (AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState(GroupState.STABLE.toString())))), env.cluster().nodeById(0));
            ListGroupsOptions options = ListGroupsOptions.forConsumerGroups().inGroupStates(Set.of(GroupState.STABLE));
            ListGroupsResult result = env.adminClient().listGroups(options);
            Collection listing = (Collection)result.all().get();
            Assertions.assertEquals((int)1, (int)listing.size());
            List<GroupListing> expected = List.of(new GroupListing("group-1", Optional.empty(), "consumer", Optional.of(GroupState.STABLE)));
            Assertions.assertEquals(expected, (Object)listing);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ListGroupsRequest && !((ListGroupsRequest)request).data().typesFilter().isEmpty());
            options = ListGroupsOptions.forConsumerGroups().withTypes(Set.of(GroupType.SHARE));
            result = env.adminClient().listGroups(options);
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.all());
        }
    }

    @Test
    public void testListConsumerGroupsDeprecated() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(List.of(), env.cluster().clusterResource().clusterId(), -1, List.of()));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), List.of()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-1").setProtocolType("connector").setGroupState("Stable")))), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()).setGroups(List.of())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()).setGroups(List.of())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-2").setProtocolType("connector").setGroupState("Stable")))), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-3").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-3").setProtocolType("connector").setGroupState("Stable")))), env.cluster().nodeById(2));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setGroups(List.of())), env.cluster().nodeById(3));
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups();
            TestUtils.assertFutureThrows(UnknownServerException.class, result.all());
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)3, (int)listings.size());
            HashSet<String> groupIds = new HashSet<String>();
            for (ConsumerGroupListing listing : listings) {
                groupIds.add(listing.groupId());
                Assertions.assertTrue((boolean)listing.state().isPresent());
            }
            Assertions.assertEquals(Set.of("group-1", "group-2", "group-3"), groupIds);
            Assertions.assertEquals((int)1, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListConsumerGroupsDeprecatedMetadataFailure() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(List.of(), env.cluster().clusterResource().clusterId(), -1, List.of()));
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups();
            TestUtils.assertFutureThrows(KafkaException.class, result.all());
        }
    }

    @Test
    public void testListConsumerGroupsDeprecatedWithStates() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setGroupState("Empty")))), env.cluster().nodeById(0));
            ListConsumerGroupsOptions options = new ListConsumerGroupsOptions();
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups(options);
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)2, (int)listings.size());
            ArrayList<ConsumerGroupListing> expected = new ArrayList<ConsumerGroupListing>();
            expected.add(new ConsumerGroupListing("group-2", Optional.of(GroupState.EMPTY), true));
            expected.add(new ConsumerGroupListing("group-1", Optional.of(GroupState.STABLE), false));
            Assertions.assertEquals(expected, (Object)listings);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListConsumerGroupsDeprecatedWithTypes() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom(this.expectListGroupsRequestWithFilters(Set.of(GroupState.STABLE.toString()), Set.of()), (AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable").setGroupType(GroupType.CLASSIC.toString())))), env.cluster().nodeById(0));
            ListConsumerGroupsOptions options = new ListConsumerGroupsOptions().inGroupStates(Set.of(GroupState.STABLE));
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups(options);
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)1, (int)listings.size());
            ArrayList<ConsumerGroupListing> expected = new ArrayList<ConsumerGroupListing>();
            expected.add(new ConsumerGroupListing("group-1", Optional.of(GroupState.STABLE), Optional.of(GroupType.CLASSIC), false));
            Assertions.assertEquals(expected, (Object)listings);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom(this.expectListGroupsRequestWithFilters(Set.of(), Set.of(GroupType.CONSUMER.toString())), (AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable").setGroupType(GroupType.CONSUMER.toString()), new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setGroupState("Empty").setGroupType(GroupType.CONSUMER.toString())))), env.cluster().nodeById(0));
            ListConsumerGroupsOptions options2 = new ListConsumerGroupsOptions().withTypes(Collections.singleton(GroupType.CONSUMER));
            ListConsumerGroupsResult result2 = env.adminClient().listConsumerGroups(options2);
            Collection listings2 = (Collection)result2.valid().get();
            Assertions.assertEquals((int)2, (int)listings2.size());
            ArrayList<ConsumerGroupListing> expected2 = new ArrayList<ConsumerGroupListing>();
            expected2.add(new ConsumerGroupListing("group-2", Optional.of(GroupState.EMPTY), Optional.of(GroupType.CONSUMER), true));
            expected2.add(new ConsumerGroupListing("group-1", Optional.of(GroupState.STABLE), Optional.of(GroupType.CONSUMER), false));
            Assertions.assertEquals(expected2, (Object)listings2);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListConsumerGroupsDeprecatedWithStatesOlderBrokerVersion() throws Exception {
        ApiVersionsResponseData.ApiVersion listGroupV3 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.LIST_GROUPS.id).setMinVersion((short)0).setMaxVersion((short)3);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(List.of(listGroupV3)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer")))), env.cluster().nodeById(0));
            ListConsumerGroupsOptions options = new ListConsumerGroupsOptions();
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups(options);
            Collection listing = (Collection)result.all().get();
            Assertions.assertEquals((int)1, (int)listing.size());
            List<ConsumerGroupListing> expected = List.of(new ConsumerGroupListing("group-1", false));
            Assertions.assertEquals(expected, (Object)listing);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(body -> body instanceof ListGroupsRequest);
            options = new ListConsumerGroupsOptions().inGroupStates(Set.of(GroupState.STABLE));
            result = env.adminClient().listConsumerGroups(options);
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.all());
        }
    }

    @Test
    public void testListConsumerGroupsDeprecatedWithTypesOlderBrokerVersion() throws Exception {
        ApiVersionsResponseData.ApiVersion listGroupV4 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.LIST_GROUPS.id).setMinVersion((short)0).setMaxVersion((short)4);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(List.of(listGroupV4)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom(this.expectListGroupsRequestWithFilters(Set.of(GroupState.STABLE.toString()), Set.of()), (AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState(GroupState.STABLE.toString())))), env.cluster().nodeById(0));
            ListConsumerGroupsOptions options = new ListConsumerGroupsOptions().inGroupStates(Set.of(GroupState.STABLE));
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups(options);
            Collection listing = (Collection)result.all().get();
            Assertions.assertEquals((int)1, (int)listing.size());
            List<ConsumerGroupListing> expected = List.of(new ConsumerGroupListing("group-1", Optional.of(GroupState.STABLE), false));
            Assertions.assertEquals(expected, (Object)listing);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ListGroupsRequest && !((ListGroupsRequest)request).data().typesFilter().isEmpty());
            options = new ListConsumerGroupsOptions().withTypes(Set.of(GroupType.SHARE));
            result = env.adminClient().listConsumerGroups(options);
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.all());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom(this.expectListGroupsRequestWithFilters(Set.of(), Set.of()), (AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(List.of(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState(GroupState.STABLE.toString())))), env.cluster().nodeById(0));
            options = new ListConsumerGroupsOptions().withTypes(Set.of(GroupType.CLASSIC));
            result = env.adminClient().listConsumerGroups(options);
            listing = (Collection)result.all().get();
            Assertions.assertEquals((int)1, (int)listing.size());
            Assertions.assertEquals(expected, (Object)listing);
        }
    }

    private MockClient.RequestMatcher expectListGroupsRequestWithFilters(Set<String> expectedStates, Set<String> expectedTypes) {
        return body -> {
            if (body instanceof ListGroupsRequest) {
                ListGroupsRequest request = (ListGroupsRequest)body;
                return Objects.equals(new HashSet(request.data().statesFilter()), expectedStates) && Objects.equals(new HashSet(request.data().typesFilter()), expectedTypes);
            }
            return false;
        };
    }

    @Test
    public void testOffsetCommitNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition tp1 = new TopicPartition("foo", 0);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
            TestUtils.assertFutureThrows(TimeoutException.class, result.all());
        }
    }

    @Test
    public void testStreamsOffsetCommitNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition tp1 = new TopicPartition("foo", 0);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterStreamsGroupOffsetsResult result = env.adminClient().alterStreamsGroupOffsets(GROUP_ID, offsets);
            TestUtils.assertFutureThrows(TimeoutException.class, result.all());
        }
    }

    @Test
    public void testOffsetCommitWithMultipleErrors() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition foo0 = new TopicPartition("foo", 0);
            TopicPartition foo1 = new TopicPartition("foo", 1);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
            responseData.put(foo0, Errors.NONE);
            responseData.put(foo1, Errors.UNKNOWN_TOPIC_OR_PARTITION);
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetCommitResponse(0, responseData));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(foo0, new OffsetAndMetadata(123L));
            offsets.put(foo1, new OffsetAndMetadata(456L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
            Assertions.assertNull((Object)result.partitionResult(foo0).get());
            TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, result.partitionResult(foo1));
            TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, result.all());
        }
    }

    @Test
    public void testStreamsOffsetCommitWithMultipleErrors() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition foo0 = new TopicPartition("foo", 0);
            TopicPartition foo1 = new TopicPartition("foo", 1);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
            responseData.put(foo0, Errors.NONE);
            responseData.put(foo1, Errors.UNKNOWN_TOPIC_OR_PARTITION);
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetCommitResponse(0, responseData));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(foo0, new OffsetAndMetadata(123L));
            offsets.put(foo1, new OffsetAndMetadata(456L));
            AlterStreamsGroupOffsetsResult result = env.adminClient().alterStreamsGroupOffsets(GROUP_ID, offsets);
            Assertions.assertNull((Object)result.partitionResult(foo0).get());
            TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, result.partitionResult(foo1));
            TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, result.all());
        }
    }

    @Test
    public void testOffsetCommitRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            TopicPartition tp1 = new TopicPartition("foo", 0);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            KafkaFuture future = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting CommitOffsets first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry CommitOffsets call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"CommitOffsets retry did not await expected backoff");
        }
    }

    @Test
    public void testStreamsOffsetCommitRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            TopicPartition tp1 = new TopicPartition("foo", 0);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            KafkaFuture future = env.adminClient().alterStreamsGroupOffsets(GROUP_ID, offsets).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting CommitOffsets first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry CommitOffsets call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"CommitOffsets retry did not await expected backoff");
        }
    }

    @Test
    public void testDescribeConsumerGroupNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NOT_COORDINATOR, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList(GROUP_ID));
            TestUtils.assertFutureThrows(TimeoutException.class, result.all());
        }
    }

    @Test
    public void testDescribeConsumerGroupRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NOT_COORDINATOR, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DescribeGroupsResponse(data));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Collections.emptyList(), Collections.emptySet()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DescribeGroupsResponse(data));
            KafkaFuture future = env.adminClient().describeConsumerGroups(Collections.singletonList(GROUP_ID)).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting DescribeConsumerGroup first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry DescribeConsumerGroup call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"DescribeConsumerGroup retry did not await expected backoff!");
        }
    }

    @Test
    public void testDescribeConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ConsumerGroupDescribeRequest);
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.COORDINATOR_LOAD_IN_PROGRESS, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NOT_COORDINATOR, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.COORDINATOR_NOT_AVAILABLE, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new DescribeGroupsResponseData();
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            topicPartitions.add(0, myTopicPartition0);
            topicPartitions.add(1, myTopicPartition1);
            topicPartitions.add(2, myTopicPartition2);
            ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
            byte[] memberAssignmentBytes = new byte[memberAssignment.remaining()];
            memberAssignment.get(memberAssignmentBytes);
            DescribeGroupsResponseData.DescribedGroupMember memberOne = DescribeGroupsResponse.groupMember((String)"0", (String)"instance1", (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null);
            DescribeGroupsResponseData.DescribedGroupMember memberTwo = DescribeGroupsResponse.groupMember((String)"1", (String)"instance2", (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null);
            ArrayList<MemberDescription> expectedMemberDescriptions = new ArrayList<MemberDescription>();
            expectedMemberDescriptions.add(KafkaAdminClientTest.convertToMemberDescriptions(memberOne, new MemberAssignment(new HashSet(topicPartitions))));
            expectedMemberDescriptions.add(KafkaAdminClientTest.convertToMemberDescriptions(memberTwo, new MemberAssignment(new HashSet(topicPartitions))));
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Arrays.asList(memberOne, memberTwo), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList(GROUP_ID));
            ConsumerGroupDescription groupDescription = (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get(GROUP_ID)).get();
            Assertions.assertEquals((int)1, (int)result.describedGroups().size());
            Assertions.assertEquals((Object)GROUP_ID, (Object)groupDescription.groupId());
            Assertions.assertEquals((int)2, (int)groupDescription.members().size());
            Assertions.assertEquals(expectedMemberDescriptions, (Object)groupDescription.members());
        }
    }

    @Test
    public void testDescribeMultipleConsumerGroups() {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new FindCoordinatorResponse(new FindCoordinatorResponseData().setCoordinators(Arrays.asList(FindCoordinatorResponse.prepareCoordinatorResponse((Errors)Errors.NONE, (String)GROUP_ID, (Node)env.cluster().controller()), FindCoordinatorResponse.prepareCoordinatorResponse((Errors)Errors.NONE, (String)"group-connect-0", (Node)env.cluster().controller())))));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ConsumerGroupDescribeRequest);
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            topicPartitions.add(0, myTopicPartition0);
            topicPartitions.add(1, myTopicPartition1);
            topicPartitions.add(2, myTopicPartition2);
            ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
            byte[] memberAssignmentBytes = new byte[memberAssignment.remaining()];
            memberAssignment.get(memberAssignmentBytes);
            DescribeGroupsResponseData groupData = new DescribeGroupsResponseData();
            groupData.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Arrays.asList(DescribeGroupsResponse.groupMember((String)"0", null, (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null), DescribeGroupsResponse.groupMember((String)"1", null, (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null)), Collections.emptySet()));
            groupData.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-connect-0", (Errors)Errors.NONE, (String)"", (String)"connect", (String)"", Arrays.asList(DescribeGroupsResponse.groupMember((String)"0", null, (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null), DescribeGroupsResponse.groupMember((String)"1", null, (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null)), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(groupData));
            HashSet<String> groups = new HashSet<String>();
            groups.add(GROUP_ID);
            groups.add("group-connect-0");
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(groups);
            Assertions.assertEquals((int)2, (int)result.describedGroups().size());
            Assertions.assertEquals(groups, result.describedGroups().keySet());
            KafkaFuture allFuture = result.all();
            Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)allFuture).get());
            Assertions.assertTrue((boolean)allFuture.isCompletedExceptionally());
        }
    }

    @Test
    public void testDescribeConsumerGroupsGroupIdNotFound() {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new FindCoordinatorResponse(new FindCoordinatorResponseData().setCoordinators(Arrays.asList(FindCoordinatorResponse.prepareCoordinatorResponse((Errors)Errors.NONE, (String)GROUP_ID, (Node)env.cluster().controller()), FindCoordinatorResponse.prepareCoordinatorResponse((Errors)Errors.NONE, (String)"group-connect-0", (Node)env.cluster().controller())))));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ConsumerGroupDescribeRequest);
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            topicPartitions.add(0, myTopicPartition0);
            topicPartitions.add(1, myTopicPartition1);
            topicPartitions.add(2, myTopicPartition2);
            ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
            byte[] memberAssignmentBytes = new byte[memberAssignment.remaining()];
            memberAssignment.get(memberAssignmentBytes);
            DescribeGroupsResponseData groupData = new DescribeGroupsResponseData();
            groupData.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Arrays.asList(DescribeGroupsResponse.groupMember((String)"0", null, (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null), DescribeGroupsResponse.groupMember((String)"1", null, (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null)), Collections.emptySet()));
            groupData.groups().add(DescribeGroupsResponse.groupError((String)"group-connect-0", (Errors)Errors.GROUP_ID_NOT_FOUND, (String)"Group group-connect-0 is not a classic group."));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(groupData));
            HashSet<String> groups = new HashSet<String>();
            groups.add(GROUP_ID);
            groups.add("group-connect-0");
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(groups);
            Assertions.assertEquals((int)2, (int)result.describedGroups().size());
            Assertions.assertEquals(groups, result.describedGroups().keySet());
            KafkaFuture allFuture = result.all();
            Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)allFuture).get());
            Assertions.assertTrue((boolean)result.all().isCompletedExceptionally());
        }
    }

    @Test
    public void testDescribeConsumerGroupsWithAuthorizedOperationsOmitted() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ConsumerGroupDescribeRequest);
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Collections.emptyList(), (int)Integer.MIN_VALUE));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList(GROUP_ID));
            ConsumerGroupDescription groupDescription = (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get(GROUP_ID)).get();
            Assertions.assertNull((Object)groupDescription.authorizedOperations());
        }
    }

    @Test
    public void testDescribeNonConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ConsumerGroupDescribeRequest);
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NONE, (String)"", (String)"non-consumer", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList(GROUP_ID));
            TestUtils.assertFutureThrows(IllegalArgumentException.class, (Future)result.describedGroups().get(GROUP_ID));
        }
    }

    @Test
    public void testDescribeGroupsWithBothUnsupportedApis() throws InterruptedException {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ConsumerGroupDescribeRequest);
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof DescribeGroupsRequest);
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList(GROUP_ID));
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, (Future)result.describedGroups().get(GROUP_ID));
        }
    }

    @Test
    public void testDescribeOldAndNewConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new FindCoordinatorResponse(new FindCoordinatorResponseData().setCoordinators(Arrays.asList(FindCoordinatorResponse.prepareCoordinatorResponse((Errors)Errors.NONE, (String)"grp1", (Node)env.cluster().controller()), FindCoordinatorResponse.prepareCoordinatorResponse((Errors)Errors.NONE, (String)"grp2", (Node)env.cluster().controller())))));
            env.kafkaClient().prepareResponse((AbstractResponse)new ConsumerGroupDescribeResponse(new ConsumerGroupDescribeResponseData().setGroups(Arrays.asList(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("grp1").setGroupState("Stable").setGroupEpoch(10).setAssignmentEpoch(10).setAssignorName("range").setAuthorizedOperations(Utils.to32BitField(Collections.emptySet())).setMembers(Collections.singletonList(new ConsumerGroupDescribeResponseData.Member().setMemberId("memberId").setInstanceId("instanceId").setClientHost("host").setClientId("clientId").setMemberEpoch(10).setRackId("rackid").setSubscribedTopicNames(Collections.singletonList("foo")).setSubscribedTopicRegex("regex").setAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(Uuid.randomUuid()).setTopicName("foo").setPartitions(Collections.singletonList(0))))).setTargetAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(Uuid.randomUuid()).setTopicName("foo").setPartitions(Collections.singletonList(1))))).setMemberType((byte)1))), new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("grp2").setErrorCode(Errors.GROUP_ID_NOT_FOUND.code())))));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(new DescribeGroupsResponseData().setGroups(Collections.singletonList(DescribeGroupsResponse.groupMetadata((String)"grp2", (Errors)Errors.NONE, (String)"Stable", (String)"consumer", (String)"range", Collections.singletonList(DescribeGroupsResponse.groupMember((String)"0", null, (String)"clientId0", (String)"clientHost", (byte[])ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(Collections.singletonList(new TopicPartition("bar", 0)))).array(), null)), Collections.emptySet())))));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Arrays.asList("grp1", "grp2"));
            HashMap<String, ConsumerGroupDescription> expectedResult = new HashMap<String, ConsumerGroupDescription>();
            expectedResult.put("grp1", new ConsumerGroupDescription("grp1", false, Collections.singletonList(new MemberDescription("memberId", Optional.of("instanceId"), "clientId", "host", new MemberAssignment(Collections.singleton(new TopicPartition("foo", 0))), Optional.of(new MemberAssignment(Collections.singleton(new TopicPartition("foo", 1)))), Optional.of(10), Optional.of(true))), "range", GroupType.CONSUMER, GroupState.STABLE, env.cluster().controller(), Collections.emptySet(), Optional.of(10), Optional.of(10)));
            expectedResult.put("grp2", new ConsumerGroupDescription("grp2", false, Collections.singletonList(new MemberDescription("0", Optional.empty(), "clientId0", "clientHost", new MemberAssignment(Collections.singleton(new TopicPartition("bar", 0))), Optional.empty(), Optional.empty(), Optional.empty())), "range", GroupType.CLASSIC, GroupState.STABLE, env.cluster().controller(), Collections.emptySet(), Optional.empty(), Optional.empty()));
            Assertions.assertEquals(expectedResult, (Object)result.all().get());
        }
    }

    @Test
    public void testListConsumerGroupOffsetsNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets(GROUP_ID);
            TestUtils.assertFutureThrows(TimeoutException.class, result.partitionsToOffsetAndMetadata());
        }
    }

    @Test
    public void testListConsumerGroupOffsetsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(Errors.NOT_COORDINATOR));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(Errors.NONE));
            KafkaFuture future = env.adminClient().listConsumerGroupOffsets(GROUP_ID).partitionsToOffsetAndMetadata();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting ListConsumerGroupOffsets first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry ListConsumerGroupOffsets call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"ListConsumerGroupOffsets retry did not await expected backoff!");
        }
    }

    @Test
    public void testListConsumerGroupOffsetsRetriableErrorsWithMultipleGroups() throws ExecutionException, InterruptedException {
        String group0 = "groupZero";
        String group1 = "groupOne";
        String group2 = "groupTwo";
        String group3 = "groupThree";
        TopicPartition tp0 = new TopicPartition("my_topic", 0);
        TopicPartition tp1 = new TopicPartition("my_topic", 1);
        TopicPartition tp2 = new TopicPartition("my_topic", 2);
        List<String> groups = List.of(group0, group1, group2, group3);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            Node controller = env.cluster().controller();
            List<FindCoordinatorResponse.CoordinatorData> findCoordinatorResponseList = groups.stream().map(groupId -> new FindCoordinatorResponse.CoordinatorData(Errors.NONE, groupId, controller)).collect(Collectors.toList());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(findCoordinatorResponseList));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(new OffsetFetchResponseData().setGroups(groups.stream().map(g -> new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(g).setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code())).collect(Collectors.toList())), ApiKeys.OFFSET_FETCH.latestVersion()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(new OffsetFetchResponseData().setGroups(groups.stream().map(g -> new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(g).setErrorCode(Errors.NOT_COORDINATOR.code())).collect(Collectors.toList())), ApiKeys.OFFSET_FETCH.latestVersion()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(findCoordinatorResponseList));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(new OffsetFetchResponseData().setGroups(groups.stream().map(g -> new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(g).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code())).collect(Collectors.toList())), ApiKeys.OFFSET_FETCH.latestVersion()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(findCoordinatorResponseList));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(new OffsetFetchResponseData().setGroups(groups.stream().map(g -> new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(g).setErrorCode(Errors.NONE.code())).collect(Collectors.toList())), ApiKeys.OFFSET_FETCH.latestVersion()));
            Map<String, ListConsumerGroupOffsetsSpec> requestData = Map.of(group0, new ListConsumerGroupOffsetsSpec().topicPartitions(Collections.singletonList(tp0)), group1, new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(tp0, tp1)), group2, new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(tp0, tp1, tp2)), group3, new ListConsumerGroupOffsetsSpec());
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets(requestData, new ListConsumerGroupOffsetsOptions());
            for (String g2 : groups) {
                Assertions.assertEquals(Collections.emptyMap(), (Object)result.partitionsToOffsetAndMetadata(g2).get());
            }
        }
    }

    @Test
    public void testListConsumerGroupOffsetsRetriableErrors() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(Errors.COORDINATOR_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(Errors.NONE));
            ListConsumerGroupOffsetsResult errorResult1 = env.adminClient().listConsumerGroupOffsets(GROUP_ID);
            Assertions.assertEquals(Collections.emptyMap(), (Object)errorResult1.partitionsToOffsetAndMetadata().get());
        }
    }

    @Test
    public void testListConsumerGroupOffsetsNonRetriableErrorsWithMultipleGroups() {
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND);
        String group0 = "groupZero";
        String group1 = "groupOne";
        String group2 = "groupTwo";
        String group3 = "groupThree";
        List<String> groups = List.of(group0, group1, group2, group3);
        TopicPartition tp0 = new TopicPartition("my_topic", 0);
        TopicPartition tp1 = new TopicPartition("my_topic", 1);
        TopicPartition tp2 = new TopicPartition("my_topic", 2);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            Node controller = env.cluster().controller();
            List<FindCoordinatorResponse.CoordinatorData> findCoordinatorResponseList = groups.stream().map(groupId -> new FindCoordinatorResponse.CoordinatorData(Errors.NONE, groupId, controller)).collect(Collectors.toList());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(findCoordinatorResponseList));
                env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(new OffsetFetchResponseData().setGroups(groups.stream().map(g -> new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(g).setErrorCode(error.code())).collect(Collectors.toList())), ApiKeys.OFFSET_FETCH.latestVersion()));
                Map<String, ListConsumerGroupOffsetsSpec> requestData = Map.of(group0, new ListConsumerGroupOffsetsSpec().topicPartitions(Collections.singletonList(tp0)), group1, new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(tp0, tp1)), group2, new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(tp0, tp1, tp2)), group3, new ListConsumerGroupOffsetsSpec());
                ListConsumerGroupOffsetsResult errorResult = env.adminClient().listConsumerGroupOffsets(requestData, new ListConsumerGroupOffsetsOptions());
                groups.forEach(g -> TestUtils.assertFutureThrows(error.exception().getClass(), errorResult.partitionsToOffsetAndMetadata(g)));
            }
        }
    }

    @Test
    public void testListConsumerGroupOffsetsNonRetriableErrors() throws Exception {
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND, Errors.UNKNOWN_MEMBER_ID, Errors.STALE_MEMBER_EPOCH);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(error));
                ListConsumerGroupOffsetsResult errorResult = env.adminClient().listConsumerGroupOffsets(GROUP_ID);
                TestUtils.assertFutureThrows(error.exception().getClass(), errorResult.partitionsToOffsetAndMetadata());
            }
        }
    }

    @Test
    public void testListConsumerGroupOffsetsWithMultipleGroups() throws Exception {
        String group0 = "groupZero";
        String group1 = "groupOne";
        String group2 = "groupTwo";
        String group3 = "groupThree";
        TopicPartition tp0 = new TopicPartition("my_topic", 0);
        TopicPartition tp1 = new TopicPartition("my_topic", 1);
        TopicPartition tp2 = new TopicPartition("my_topic", 2);
        TopicPartition tp3 = new TopicPartition("my_topic", 3);
        List<String> groups = List.of(group0, group1, group2, group3);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            Node controller = env.cluster().controller();
            List<FindCoordinatorResponse.CoordinatorData> findCoordinatorResponseList = groups.stream().map(groupId -> new FindCoordinatorResponse.CoordinatorData(Errors.NONE, groupId, controller)).collect(Collectors.toList());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(findCoordinatorResponseList));
            OffsetFetchResponseData response = new OffsetFetchResponseData().setGroups(List.of(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(group0).setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(tp0.topic()).setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp0.partition()).setCommittedOffset(10L))))), new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(group1).setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(tp0.topic()).setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp0.partition()).setCommittedOffset(10L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp1.partition()).setCommittedOffset(0L))))), new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(group2).setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(tp0.topic()).setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp0.partition()).setCommittedOffset(10L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp1.partition()).setCommittedOffset(0L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp2.partition()).setCommittedOffset(20L))))), new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(group3).setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(tp0.topic()).setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp0.partition()).setCommittedOffset(10L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp1.partition()).setCommittedOffset(0L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp2.partition()).setCommittedOffset(20L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp3.partition()).setCommittedOffset(-1L)))))));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(response, ApiKeys.OFFSET_FETCH.latestVersion()));
            Map<String, ListConsumerGroupOffsetsSpec> requestData = Map.of(group0, new ListConsumerGroupOffsetsSpec().topicPartitions(Collections.singletonList(tp0)), group1, new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(tp0, tp1)), group2, new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(tp0, tp1, tp2)), group3, new ListConsumerGroupOffsetsSpec());
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets(requestData, new ListConsumerGroupOffsetsOptions());
            Map groupToPartitionOffsetMetadata = (Map)result.all().get();
            Assertions.assertEquals((int)4, (int)groupToPartitionOffsetMetadata.size());
            for (Map.Entry entry : groupToPartitionOffsetMetadata.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "groupZero": {
                        Map offsetAndMetadataMap0 = (Map)entry.getValue();
                        Assertions.assertEquals((int)1, (int)offsetAndMetadataMap0.size());
                        Assertions.assertEquals((long)10L, (long)((OffsetAndMetadata)offsetAndMetadataMap0.get(tp0)).offset());
                        break;
                    }
                    case "groupOne": {
                        Map offsetAndMetadataMap1 = (Map)entry.getValue();
                        Assertions.assertEquals((int)2, (int)offsetAndMetadataMap1.size());
                        Assertions.assertEquals((long)10L, (long)((OffsetAndMetadata)offsetAndMetadataMap1.get(tp0)).offset());
                        Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)offsetAndMetadataMap1.get(tp1)).offset());
                        break;
                    }
                    case "groupTwo": {
                        Map offsetAndMetadataMap2 = (Map)entry.getValue();
                        Assertions.assertEquals((int)3, (int)offsetAndMetadataMap2.size());
                        Assertions.assertEquals((long)10L, (long)((OffsetAndMetadata)offsetAndMetadataMap2.get(tp0)).offset());
                        Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)offsetAndMetadataMap2.get(tp1)).offset());
                        Assertions.assertEquals((long)20L, (long)((OffsetAndMetadata)offsetAndMetadataMap2.get(tp2)).offset());
                        break;
                    }
                    case "groupThree": {
                        Map offsetAndMetadataMap3 = (Map)entry.getValue();
                        Assertions.assertEquals((int)4, (int)offsetAndMetadataMap3.size());
                        Assertions.assertEquals((long)10L, (long)((OffsetAndMetadata)offsetAndMetadataMap3.get(tp0)).offset());
                        Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)offsetAndMetadataMap3.get(tp1)).offset());
                        Assertions.assertEquals((long)20L, (long)((OffsetAndMetadata)offsetAndMetadataMap3.get(tp2)).offset());
                        Assertions.assertTrue((boolean)offsetAndMetadataMap3.containsKey(tp3));
                        Assertions.assertNull(offsetAndMetadataMap3.get(tp3));
                    }
                }
            }
        }
    }

    @Test
    public void testListConsumerGroupOffsets() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(Errors.COORDINATOR_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            TopicPartition myTopicPartition3 = new TopicPartition("my_topic", 3);
            OffsetFetchResponseData response = new OffsetFetchResponseData().setGroups(List.of(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(GROUP_ID).setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("my_topic").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(myTopicPartition0.partition()).setCommittedOffset(10L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(myTopicPartition1.partition()).setCommittedOffset(0L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(myTopicPartition2.partition()).setCommittedOffset(20L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(myTopicPartition3.partition()).setCommittedOffset(-1L)))))));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(response, ApiKeys.OFFSET_FETCH.latestVersion()));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets(GROUP_ID);
            Map partitionToOffsetAndMetadata = (Map)result.partitionsToOffsetAndMetadata().get();
            Assertions.assertEquals((int)4, (int)partitionToOffsetAndMetadata.size());
            Assertions.assertEquals((long)10L, (long)((OffsetAndMetadata)partitionToOffsetAndMetadata.get(myTopicPartition0)).offset());
            Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)partitionToOffsetAndMetadata.get(myTopicPartition1)).offset());
            Assertions.assertEquals((long)20L, (long)((OffsetAndMetadata)partitionToOffsetAndMetadata.get(myTopicPartition2)).offset());
            Assertions.assertTrue((boolean)partitionToOffsetAndMetadata.containsKey(myTopicPartition3));
            Assertions.assertNull(partitionToOffsetAndMetadata.get(myTopicPartition3));
        }
    }

    @Test
    public void testBatchedListConsumerGroupOffsets() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(1, 0);
        MockTime time = new MockTime();
        Map<String, ListConsumerGroupOffsetsSpec> groupSpecs = this.batchedListConsumerGroupOffsetsSpec();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareBatchedFindCoordinatorResponse(Errors.NONE, env.cluster().controller(), groupSpecs.keySet()));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets(groupSpecs, new ListConsumerGroupOffsetsOptions());
            this.sendOffsetFetchResponse(env.kafkaClient(), groupSpecs, true, Errors.NONE);
            this.verifyListOffsetsForMultipleGroups(groupSpecs, result);
        }
    }

    @Test
    public void testBatchedListStreamsGroupOffsets() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(1, 0);
        MockTime time = new MockTime();
        Map<String, ListStreamsGroupOffsetsSpec> groupSpecs = this.batchedListStreamsGroupOffsetsSpec();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareBatchedFindCoordinatorResponse(Errors.NONE, env.cluster().controller(), groupSpecs.keySet()));
            ListStreamsGroupOffsetsResult result = env.adminClient().listStreamsGroupOffsets(groupSpecs, new ListStreamsGroupOffsetsOptions());
            this.sendStreamsOffsetFetchResponse(env.kafkaClient(), groupSpecs, true, Errors.NONE);
            this.verifyListStreamsOffsetsForMultipleGroups(groupSpecs, result);
        }
    }

    @Test
    public void testBatchedListConsumerGroupOffsetsWithNoFindCoordinatorBatching() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(1, 0);
        MockTime time = new MockTime();
        Map<String, ListConsumerGroupOffsetsSpec> groupSpecs = this.batchedListConsumerGroupOffsetsSpec();
        ApiVersionsResponseData.ApiVersion findCoordinatorV3 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FIND_COORDINATOR.id).setMinVersion((short)0).setMaxVersion((short)3);
        ApiVersionsResponseData.ApiVersion offsetFetchV7 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.OFFSET_FETCH.id).setMinVersion((short)0).setMaxVersion((short)7);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Arrays.asList(findCoordinatorV3, offsetFetchV7)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets(groupSpecs);
            this.sendOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.COORDINATOR_LOAD_IN_PROGRESS);
            this.sendOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.NONE);
            this.sendOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.NONE);
            this.verifyListOffsetsForMultipleGroups(groupSpecs, result);
        }
    }

    @Test
    public void testBatchedListStreamsGroupOffsetsWithNoFindCoordinatorBatching() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(1, 0);
        MockTime time = new MockTime();
        Map<String, ListStreamsGroupOffsetsSpec> groupSpecs = this.batchedListStreamsGroupOffsetsSpec();
        ApiVersionsResponseData.ApiVersion findCoordinatorV3 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FIND_COORDINATOR.id).setMinVersion((short)0).setMaxVersion((short)3);
        ApiVersionsResponseData.ApiVersion offsetFetchV7 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.OFFSET_FETCH.id).setMinVersion((short)0).setMaxVersion((short)7);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Arrays.asList(findCoordinatorV3, offsetFetchV7)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            ListStreamsGroupOffsetsResult result = env.adminClient().listStreamsGroupOffsets(groupSpecs);
            this.sendStreamsOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.COORDINATOR_LOAD_IN_PROGRESS);
            this.sendStreamsOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.NONE);
            this.sendStreamsOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.NONE);
            this.verifyListStreamsOffsetsForMultipleGroups(groupSpecs, result);
        }
    }

    @Test
    public void testBatchedListConsumerGroupOffsetsWithNoOffsetFetchBatching() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(1, 0);
        MockTime time = new MockTime();
        Map<String, ListConsumerGroupOffsetsSpec> groupSpecs = this.batchedListConsumerGroupOffsetsSpec();
        ApiVersionsResponseData.ApiVersion offsetFetchV7 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.OFFSET_FETCH.id).setMinVersion((short)0).setMaxVersion((short)7);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Collections.singleton(offsetFetchV7)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareBatchedFindCoordinatorResponse(Errors.NONE, env.cluster().controller(), groupSpecs.keySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(Errors.COORDINATOR_NOT_AVAILABLE));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets(groupSpecs);
            this.sendFindCoordinatorResponse(env.kafkaClient(), env.cluster().controller());
            this.sendFindCoordinatorResponse(env.kafkaClient(), env.cluster().controller());
            this.sendOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.NONE);
            this.sendOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.NONE);
            this.verifyListOffsetsForMultipleGroups(groupSpecs, result);
        }
    }

    @Test
    public void testBatchedListStreamsGroupOffsetsWithNoOffsetFetchBatching() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(1, 0);
        MockTime time = new MockTime();
        Map<String, ListStreamsGroupOffsetsSpec> groupSpecs = this.batchedListStreamsGroupOffsetsSpec();
        ApiVersionsResponseData.ApiVersion offsetFetchV7 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.OFFSET_FETCH.id).setMinVersion((short)0).setMaxVersion((short)7);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Collections.singleton(offsetFetchV7)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareBatchedFindCoordinatorResponse(Errors.NONE, env.cluster().controller(), groupSpecs.keySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.offsetFetchResponse(Errors.COORDINATOR_NOT_AVAILABLE));
            ListStreamsGroupOffsetsResult result = env.adminClient().listStreamsGroupOffsets(groupSpecs);
            this.sendFindCoordinatorResponse(env.kafkaClient(), env.cluster().controller());
            this.sendFindCoordinatorResponse(env.kafkaClient(), env.cluster().controller());
            this.sendStreamsOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.NONE);
            this.sendStreamsOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.NONE);
            this.verifyListStreamsOffsetsForMultipleGroups(groupSpecs, result);
        }
    }

    private Map<String, ListConsumerGroupOffsetsSpec> batchedListConsumerGroupOffsetsSpec() {
        Set<TopicPartition> groupAPartitions = Collections.singleton(new TopicPartition("A", 1));
        Set<TopicPartition> groupBPartitions = Collections.singleton(new TopicPartition("B", 2));
        ListConsumerGroupOffsetsSpec groupASpec = new ListConsumerGroupOffsetsSpec().topicPartitions(groupAPartitions);
        ListConsumerGroupOffsetsSpec groupBSpec = new ListConsumerGroupOffsetsSpec().topicPartitions(groupBPartitions);
        return Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"groupA", (Object)groupASpec), Utils.mkEntry((Object)"groupB", (Object)groupBSpec)});
    }

    private Map<String, ListStreamsGroupOffsetsSpec> batchedListStreamsGroupOffsetsSpec() {
        Set<TopicPartition> groupAPartitions = Collections.singleton(new TopicPartition("A", 1));
        Set<TopicPartition> groupBPartitions = Collections.singleton(new TopicPartition("B", 2));
        ListStreamsGroupOffsetsSpec groupASpec = new ListStreamsGroupOffsetsSpec().topicPartitions(groupAPartitions);
        ListStreamsGroupOffsetsSpec groupBSpec = new ListStreamsGroupOffsetsSpec().topicPartitions(groupBPartitions);
        return Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"groupA", (Object)groupASpec), Utils.mkEntry((Object)"groupB", (Object)groupBSpec)});
    }

    private void waitForRequest(MockClient mockClient, ApiKeys apiKeys) throws Exception {
        TestUtils.waitForCondition(() -> {
            ClientRequest clientRequest = mockClient.requests().peek();
            return clientRequest != null && clientRequest.apiKey() == apiKeys;
        }, "Failed awaiting " + String.valueOf(apiKeys) + " request");
    }

    private void sendFindCoordinatorResponse(MockClient mockClient, Node coordinator) throws Exception {
        this.waitForRequest(mockClient, ApiKeys.FIND_COORDINATOR);
        ClientRequest clientRequest = mockClient.requests().peek();
        FindCoordinatorRequestData data = ((FindCoordinatorRequest.Builder)clientRequest.requestBuilder()).data();
        mockClient.respond((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, data.key(), coordinator));
    }

    private void sendOffsetFetchResponse(MockClient mockClient, Map<String, ListConsumerGroupOffsetsSpec> groupSpecs, boolean batched, Errors error) throws Exception {
        this.waitForRequest(mockClient, ApiKeys.OFFSET_FETCH);
        ClientRequest clientRequest = mockClient.requests().peek();
        OffsetFetchRequestData data = ((OffsetFetchRequest)((OffsetFetchRequest.Builder)clientRequest.requestBuilder()).build()).data();
        if (!batched) {
            Assertions.assertEquals((int)1, (int)data.groups().size());
        }
        OffsetFetchResponseData response = new OffsetFetchResponseData().setGroups(data.groups().stream().map(group -> new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(group.groupId()).setErrorCode(error.code()).setTopics(((ListConsumerGroupOffsetsSpec)groupSpecs.get(group.groupId())).topicPartitions().stream().collect(Collectors.groupingBy(TopicPartition::topic)).entrySet().stream().map(entry -> new OffsetFetchResponseData.OffsetFetchResponseTopics().setName((String)entry.getKey()).setPartitions(((List)entry.getValue()).stream().map(partition -> new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partition.partition()).setCommittedOffset(10L)).collect(Collectors.toList()))).collect(Collectors.toList()))).collect(Collectors.toList()));
        mockClient.respond((AbstractResponse)new OffsetFetchResponse(response, ApiKeys.OFFSET_FETCH.latestVersion()));
    }

    private void sendStreamsOffsetFetchResponse(MockClient mockClient, Map<String, ListStreamsGroupOffsetsSpec> groupSpecs, boolean batched, Errors error) throws Exception {
        this.waitForRequest(mockClient, ApiKeys.OFFSET_FETCH);
        ClientRequest clientRequest = mockClient.requests().peek();
        OffsetFetchRequestData data = ((OffsetFetchRequest)((OffsetFetchRequest.Builder)clientRequest.requestBuilder()).build()).data();
        if (!batched) {
            Assertions.assertEquals((int)1, (int)data.groups().size());
        }
        OffsetFetchResponseData response = new OffsetFetchResponseData().setGroups(data.groups().stream().map(group -> new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(group.groupId()).setErrorCode(error.code()).setTopics(((ListStreamsGroupOffsetsSpec)groupSpecs.get(group.groupId())).topicPartitions().stream().collect(Collectors.groupingBy(TopicPartition::topic)).entrySet().stream().map(entry -> new OffsetFetchResponseData.OffsetFetchResponseTopics().setName((String)entry.getKey()).setPartitions(((List)entry.getValue()).stream().map(partition -> new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partition.partition()).setCommittedOffset(10L)).collect(Collectors.toList()))).collect(Collectors.toList()))).collect(Collectors.toList()));
        mockClient.respond((AbstractResponse)new OffsetFetchResponse(response, ApiKeys.OFFSET_FETCH.latestVersion()));
    }

    private void verifyListOffsetsForMultipleGroups(Map<String, ListConsumerGroupOffsetsSpec> groupSpecs, ListConsumerGroupOffsetsResult result) throws Exception {
        Assertions.assertEquals((int)groupSpecs.size(), (int)((Map)result.all().get(10L, TimeUnit.SECONDS)).size());
        for (Map.Entry<String, ListConsumerGroupOffsetsSpec> entry : groupSpecs.entrySet()) {
            Assertions.assertEquals((Object)entry.getValue().topicPartitions(), ((Map)result.partitionsToOffsetAndMetadata(entry.getKey()).get()).keySet());
        }
    }

    private void verifyListStreamsOffsetsForMultipleGroups(Map<String, ListStreamsGroupOffsetsSpec> groupSpecs, ListStreamsGroupOffsetsResult result) throws Exception {
        Assertions.assertEquals((int)groupSpecs.size(), (int)((Map)result.all().get(10L, TimeUnit.SECONDS)).size());
        for (Map.Entry<String, ListStreamsGroupOffsetsSpec> entry : groupSpecs.entrySet()) {
            Assertions.assertEquals((Object)entry.getValue().topicPartitions(), ((Map)result.partitionsToOffsetAndMetadata(entry.getKey()).get()).keySet());
        }
    }

    @Test
    public void testDeleteConsumerGroupsNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        List<String> groupIds = Collections.singletonList("groupId");
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.NOT_COORDINATOR.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteConsumerGroupsResult result = env.adminClient().deleteConsumerGroups(groupIds);
            TestUtils.assertFutureThrows(TimeoutException.class, result.all());
        }
    }

    @Test
    public void testDeleteStreamsGroupsNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        List<String> groupIds = Collections.singletonList("groupId");
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.NOT_COORDINATOR.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteStreamsGroupsResult result = env.adminClient().deleteStreamsGroups(groupIds);
            TestUtils.assertFutureThrows(TimeoutException.class, result.all());
        }
    }

    @Test
    public void testDeleteConsumerGroupsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        List<String> groupIds = Collections.singletonList(GROUP_ID);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(GROUP_ID).setErrorCode(Errors.NOT_COORDINATOR.code()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(GROUP_ID).setErrorCode(Errors.NONE.code()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            KafkaFuture future = env.adminClient().deleteConsumerGroups(groupIds).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting DeleteConsumerGroups first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry DeleteConsumerGroups call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"DeleteConsumerGroups retry did not await expected backoff!");
        }
    }

    @Test
    public void testDeleteStreamsGroupsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        List<String> groupIds = Collections.singletonList(GROUP_ID);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(GROUP_ID).setErrorCode(Errors.NOT_COORDINATOR.code()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(GROUP_ID).setErrorCode(Errors.NONE.code()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            KafkaFuture future = env.adminClient().deleteStreamsGroups(groupIds).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting DeleteStreamsGroups first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry DeleteStreamsGroups call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"DeleteConsumerGroups retry did not await expected backoff!");
        }
    }

    @Test
    public void testDeleteConsumerGroupsWithOlderBroker() throws Exception {
        List<String> groupIds = Collections.singletonList("groupId");
        ApiVersionsResponseData.ApiVersion findCoordinatorV3 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FIND_COORDINATOR.id).setMinVersion((short)0).setMaxVersion((short)3);
        ApiVersionsResponseData.ApiVersion describeGroups = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.DESCRIBE_GROUPS.id).setMinVersion((short)0).setMaxVersion(ApiKeys.DELETE_GROUPS.latestVersion());
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Arrays.asList(findCoordinatorV3, describeGroups)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.NONE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            DeleteConsumerGroupsResult result = env.adminClient().deleteConsumerGroups(groupIds);
            KafkaFuture results = (KafkaFuture)result.deletedGroups().get("groupId");
            Assertions.assertNull((Object)results.get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            DeleteConsumerGroupsResult errorResult = env.adminClient().deleteConsumerGroups(groupIds);
            TestUtils.assertFutureThrows(GroupAuthorizationException.class, (Future)errorResult.deletedGroups().get("groupId"));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection errorResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            errorResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(errorResponse)));
            DeleteGroupsResponseData.DeletableGroupResultCollection coordinatorMoved = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            coordinatorMoved.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.NOT_COORDINATOR.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(coordinatorMoved)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            coordinatorMoved = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            coordinatorMoved.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(coordinatorMoved)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            errorResult = env.adminClient().deleteConsumerGroups(groupIds);
            KafkaFuture errorResults = (KafkaFuture)errorResult.deletedGroups().get("groupId");
            Assertions.assertNull((Object)errorResults.get());
        }
    }

    @Test
    public void testDeleteStreamsGroupsWithOlderBroker() throws Exception {
        List<String> groupIds = Collections.singletonList("groupId");
        ApiVersionsResponseData.ApiVersion findCoordinatorV3 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FIND_COORDINATOR.id).setMinVersion((short)0).setMaxVersion((short)3);
        ApiVersionsResponseData.ApiVersion describeGroups = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.DESCRIBE_GROUPS.id).setMinVersion((short)0).setMaxVersion(ApiKeys.DELETE_GROUPS.latestVersion());
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Arrays.asList(findCoordinatorV3, describeGroups)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.NONE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            DeleteStreamsGroupsResult result = env.adminClient().deleteStreamsGroups(groupIds);
            KafkaFuture results = (KafkaFuture)result.deletedGroups().get("groupId");
            Assertions.assertNull((Object)results.get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            DeleteStreamsGroupsResult errorResult = env.adminClient().deleteStreamsGroups(groupIds);
            TestUtils.assertFutureThrows(GroupAuthorizationException.class, (Future)errorResult.deletedGroups().get("groupId"));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection errorResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            errorResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(errorResponse)));
            DeleteGroupsResponseData.DeletableGroupResultCollection coordinatorMoved = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            coordinatorMoved.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.NOT_COORDINATOR.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(coordinatorMoved)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            coordinatorMoved = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            coordinatorMoved.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(coordinatorMoved)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            errorResult = env.adminClient().deleteStreamsGroups(groupIds);
            KafkaFuture errorResults = (KafkaFuture)errorResult.deletedGroups().get("groupId");
            Assertions.assertNull((Object)errorResults.get());
        }
    }

    @Test
    public void testDeleteMultipleConsumerGroupsWithOlderBroker() throws Exception {
        List<String> groupIds = Arrays.asList("group1", "group2");
        ApiVersionsResponseData.ApiVersion findCoordinatorV3 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FIND_COORDINATOR.id).setMinVersion((short)0).setMaxVersion((short)3);
        ApiVersionsResponseData.ApiVersion describeGroups = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.DESCRIBE_GROUPS.id).setMinVersion((short)0).setMaxVersion(ApiKeys.DELETE_GROUPS.latestVersion());
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            int i;
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Arrays.asList(findCoordinatorV3, describeGroups)));
            env.kafkaClient().prepareResponse(null);
            for (i = 0; i < groupIds.size(); ++i) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            }
            for (i = 0; i < groupIds.size(); ++i) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            }
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group1").setErrorCode(Errors.NONE.code()));
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group2").setErrorCode(Errors.NONE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            DeleteConsumerGroupsResult result = env.adminClient().deleteConsumerGroups(groupIds);
            KafkaFuture results = (KafkaFuture)result.deletedGroups().get("group1");
            Assertions.assertNull((Object)results.get(5L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testDeleteMultipleStreamsGroupsWithOlderBroker() throws Exception {
        List<String> groupIds = Arrays.asList("group1", "group2");
        ApiVersionsResponseData.ApiVersion findCoordinatorV3 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FIND_COORDINATOR.id).setMinVersion((short)0).setMaxVersion((short)3);
        ApiVersionsResponseData.ApiVersion describeGroups = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.DESCRIBE_GROUPS.id).setMinVersion((short)0).setMaxVersion(ApiKeys.DELETE_GROUPS.latestVersion());
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            int i;
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Arrays.asList(findCoordinatorV3, describeGroups)));
            env.kafkaClient().prepareResponse(null);
            for (i = 0; i < groupIds.size(); ++i) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            }
            for (i = 0; i < groupIds.size(); ++i) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            }
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group1").setErrorCode(Errors.NONE.code()));
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group2").setErrorCode(Errors.NONE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            DeleteStreamsGroupsResult result = env.adminClient().deleteStreamsGroups(groupIds);
            KafkaFuture results = (KafkaFuture)result.deletedGroups().get("group1");
            Assertions.assertNull((Object)results.get(5L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            TopicPartition tp1 = new TopicPartition("foo", 0);
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteConsumerGroupOffsetsResult result = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
            TestUtils.assertFutureThrows(TimeoutException.class, result.all());
        }
    }

    @Test
    public void testDeleteStreamsGroupOffsetsNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            TopicPartition tp1 = new TopicPartition("foo", 0);
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteStreamsGroupOffsetsResult result = env.adminClient().deleteStreamsGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
            TestUtils.assertFutureThrows(TimeoutException.class, result.all());
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            TopicPartition tp1 = new TopicPartition("foo", 0);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.NOT_COORDINATOR));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            KafkaFuture future = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet())).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting DeleteConsumerGroupOffsets first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry DeleteConsumerGroupOffsets call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"DeleteConsumerGroupOffsets retry did not await expected backoff!");
        }
    }

    @Test
    public void testDeleteStreamsGroupOffsetsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            TopicPartition tp1 = new TopicPartition("foo", 0);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.NOT_COORDINATOR));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            KafkaFuture future = env.adminClient().deleteStreamsGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet())).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting DeleteStreamsGroupOffsets first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry DeleteStreamsGroupOffsets call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"DeleteStreamsGroupOffsets retry did not await expected backoff!");
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsets() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("foobar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetDeleteResponse(new OffsetDeleteResponseData().setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(Stream.of(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("foo").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code())).iterator())), new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("bar").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code())).iterator()))).collect(Collectors.toList()).iterator()))));
            DeleteConsumerGroupOffsetsResult errorResult = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1, tp2).collect(Collectors.toSet()));
            Assertions.assertNull((Object)errorResult.partitionResult(tp1).get());
            TestUtils.assertFutureThrows(GroupSubscribedToTopicException.class, errorResult.all());
            TestUtils.assertFutureThrows(GroupSubscribedToTopicException.class, errorResult.partitionResult(tp2));
            Assertions.assertThrows(IllegalArgumentException.class, () -> errorResult.partitionResult(tp3));
        }
    }

    @Test
    public void testDeleteStreamsGroupOffsets() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("foobar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetDeleteResponse(new OffsetDeleteResponseData().setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(Stream.of(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("foo").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code())).iterator())), new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("bar").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code())).iterator()))).collect(Collectors.toList()).iterator()))));
            DeleteStreamsGroupOffsetsResult errorResult = env.adminClient().deleteStreamsGroupOffsets(GROUP_ID, Stream.of(tp1, tp2).collect(Collectors.toSet()));
            Assertions.assertNull((Object)errorResult.partitionResult(tp1).get());
            TestUtils.assertFutureThrows(GroupSubscribedToTopicException.class, errorResult.all());
            TestUtils.assertFutureThrows(GroupSubscribedToTopicException.class, errorResult.partitionResult(tp2));
            Assertions.assertThrows(IllegalArgumentException.class, () -> errorResult.partitionResult(tp3));
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.COORDINATOR_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            DeleteConsumerGroupOffsetsResult errorResult1 = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
            Assertions.assertNull((Object)errorResult1.all().get());
            Assertions.assertNull((Object)errorResult1.partitionResult(tp1).get());
        }
    }

    @Test
    public void testDeleteStreamsGroupOffsetsRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.COORDINATOR_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            DeleteStreamsGroupOffsetsResult errorResult1 = env.adminClient().deleteStreamsGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
            Assertions.assertNull((Object)errorResult1.all().get());
            Assertions.assertNull((Object)errorResult1.partitionResult(tp1).get());
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsNonRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(error));
                DeleteConsumerGroupOffsetsResult errorResult = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
                TestUtils.assertFutureThrows(error.exception().getClass(), errorResult.all());
                TestUtils.assertFutureThrows(error.exception().getClass(), errorResult.partitionResult(tp1));
            }
        }
    }

    @Test
    public void testDeleteStreamsGroupOffsetsNonRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(error));
                DeleteStreamsGroupOffsetsResult errorResult = env.adminClient().deleteStreamsGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
                TestUtils.assertFutureThrows(error.exception().getClass(), errorResult.all());
                TestUtils.assertFutureThrows(error.exception().getClass(), errorResult.partitionResult(tp1));
            }
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsFindCoordinatorRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            DeleteConsumerGroupOffsetsResult result = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.partitionResult(tp1).get());
        }
    }

    @Test
    public void testDeleteStreamsGroupOffsetsFindCoordinatorRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            DeleteStreamsGroupOffsetsResult result = env.adminClient().deleteStreamsGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.partitionResult(tp1).get());
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsFindCoordinatorNonRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            DeleteConsumerGroupOffsetsResult errorResult = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
            TestUtils.assertFutureThrows(GroupAuthorizationException.class, errorResult.all());
            TestUtils.assertFutureThrows(GroupAuthorizationException.class, errorResult.partitionResult(tp1));
        }
    }

    @Test
    public void testDescribeStreamsGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            StreamsGroupDescribeResponseData data = new StreamsGroupDescribeResponseData();
            data.groups().add(new StreamsGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new StreamsGroupDescribeResponse(data));
            data = new StreamsGroupDescribeResponseData();
            data.groups().add(new StreamsGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setErrorCode(Errors.NOT_COORDINATOR.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new StreamsGroupDescribeResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new StreamsGroupDescribeResponseData();
            data.groups().add(new StreamsGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new StreamsGroupDescribeResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = KafkaAdminClientTest.makeFullStreamsGroupDescribeResponse();
            env.kafkaClient().prepareResponse((AbstractResponse)new StreamsGroupDescribeResponse(data));
            DescribeStreamsGroupsResult result = env.adminClient().describeStreamsGroups(Collections.singletonList(GROUP_ID));
            StreamsGroupDescription groupDescription = (StreamsGroupDescription)((KafkaFuture)result.describedGroups().get(GROUP_ID)).get();
            String subtopologyId = "my_subtopology";
            StreamsGroupMemberAssignment.TaskIds expectedActiveTasks1 = new StreamsGroupMemberAssignment.TaskIds("my_subtopology", Arrays.asList(0, 1, 2));
            StreamsGroupMemberAssignment.TaskIds expectedStandbyTasks1 = new StreamsGroupMemberAssignment.TaskIds("my_subtopology", Arrays.asList(3, 4, 5));
            StreamsGroupMemberAssignment.TaskIds expectedWarmupTasks1 = new StreamsGroupMemberAssignment.TaskIds("my_subtopology", Arrays.asList(6, 7, 8));
            StreamsGroupMemberAssignment.TaskIds expectedActiveTasks2 = new StreamsGroupMemberAssignment.TaskIds("my_subtopology", Arrays.asList(3, 4, 5));
            StreamsGroupMemberAssignment.TaskIds expectedStandbyTasks2 = new StreamsGroupMemberAssignment.TaskIds("my_subtopology", Arrays.asList(6, 7, 8));
            StreamsGroupMemberAssignment.TaskIds expectedWarmupTasks2 = new StreamsGroupMemberAssignment.TaskIds("my_subtopology", Arrays.asList(0, 1, 2));
            StreamsGroupMemberAssignment expectedMemberAssignment = new StreamsGroupMemberAssignment(Collections.singletonList(expectedActiveTasks1), Collections.singletonList(expectedStandbyTasks1), Collections.singletonList(expectedWarmupTasks1));
            StreamsGroupMemberAssignment expectedTargetAssignment = new StreamsGroupMemberAssignment(Collections.singletonList(expectedActiveTasks2), Collections.singletonList(expectedStandbyTasks2), Collections.singletonList(expectedWarmupTasks2));
            String instanceId = "instance-id";
            String rackId = "rack-id";
            StreamsGroupMemberDescription expectedMemberOne = new StreamsGroupMemberDescription("0", 1, Optional.of("instance-id"), Optional.of("rack-id"), "clientId0", "clientHost", 0, "processId", Optional.of(new StreamsGroupMemberDescription.Endpoint("localhost", 8080)), Collections.singletonMap("key", "value"), Collections.singletonList(new StreamsGroupMemberDescription.TaskOffset("my_subtopology", 0, 0L)), Collections.singletonList(new StreamsGroupMemberDescription.TaskOffset("my_subtopology", 0, 1L)), expectedMemberAssignment, expectedTargetAssignment, true);
            StreamsGroupMemberDescription expectedMemberTwo = new StreamsGroupMemberDescription("1", 2, Optional.empty(), Optional.empty(), "clientId1", "clientHost", 1, "processId2", Optional.empty(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), new StreamsGroupMemberAssignment(Collections.emptyList(), Collections.emptyList(), Collections.emptyList()), new StreamsGroupMemberAssignment(Collections.emptyList(), Collections.emptyList(), Collections.emptyList()), false);
            StreamsGroupSubtopologyDescription expectedSubtopologyDescription = new StreamsGroupSubtopologyDescription("my_subtopology", Collections.singletonList("my_source_topic"), Collections.singletonList("my_repartition_sink_topic"), Collections.singletonMap("my_changelog_topic", new StreamsGroupSubtopologyDescription.TopicInfo(0, 3, Collections.singletonMap("key1", "value1"))), Collections.singletonMap("my_repartition_topic", new StreamsGroupSubtopologyDescription.TopicInfo(99, 0, Collections.emptyMap())));
            Assertions.assertEquals((int)1, (int)result.describedGroups().size());
            Assertions.assertEquals((Object)GROUP_ID, (Object)groupDescription.groupId());
            Assertions.assertEquals((int)2, (int)groupDescription.members().size());
            Iterator members = groupDescription.members().iterator();
            Assertions.assertEquals((Object)expectedMemberOne, members.next());
            Assertions.assertEquals((Object)expectedMemberTwo, members.next());
            Assertions.assertEquals((int)1, (int)groupDescription.subtopologies().size());
            Assertions.assertEquals((Object)expectedSubtopologyDescription, groupDescription.subtopologies().iterator().next());
            Assertions.assertEquals((int)2, (int)groupDescription.groupEpoch());
            Assertions.assertEquals((int)1, (int)groupDescription.targetAssignmentEpoch());
        }
    }

    @Test
    public void testDescribeStreamsGroupsWithAuthorizedOperationsOmitted() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            StreamsGroupDescribeResponseData data = KafkaAdminClientTest.makeFullStreamsGroupDescribeResponse();
            ((StreamsGroupDescribeResponseData.DescribedGroup)data.groups().iterator().next()).setAuthorizedOperations(Integer.MIN_VALUE);
            env.kafkaClient().prepareResponse((AbstractResponse)new StreamsGroupDescribeResponse(data));
            DescribeStreamsGroupsResult result = env.adminClient().describeStreamsGroups(Collections.singletonList(GROUP_ID));
            StreamsGroupDescription groupDescription = (StreamsGroupDescription)((KafkaFuture)result.describedGroups().get(GROUP_ID)).get();
            Assertions.assertNull((Object)groupDescription.authorizedOperations());
        }
    }

    @Test
    public void testDescribeMultipleStreamsGroups() {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            StreamsGroupDescribeResponseData.TaskIds activeTasks = new StreamsGroupDescribeResponseData.TaskIds().setSubtopologyId("my_subtopology").setPartitions(Arrays.asList(0, 1, 2));
            StreamsGroupDescribeResponseData.TaskIds standbyTasks = new StreamsGroupDescribeResponseData.TaskIds().setSubtopologyId("my_subtopology").setPartitions(Arrays.asList(3, 4, 5));
            StreamsGroupDescribeResponseData.TaskIds warmupTasks = new StreamsGroupDescribeResponseData.TaskIds().setSubtopologyId("my_subtopology").setPartitions(Arrays.asList(6, 7, 8));
            StreamsGroupDescribeResponseData.Assignment memberAssignment = new StreamsGroupDescribeResponseData.Assignment().setActiveTasks(Collections.singletonList(activeTasks)).setStandbyTasks(Collections.singletonList(standbyTasks)).setWarmupTasks(Collections.singletonList(warmupTasks));
            StreamsGroupDescribeResponseData group0Data = new StreamsGroupDescribeResponseData();
            group0Data.groups().add(new StreamsGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setGroupState(GroupState.STABLE.toString()).setMembers(Arrays.asList(new StreamsGroupDescribeResponseData.Member().setMemberId("0").setClientId("clientId0").setClientHost("clientHost").setAssignment(memberAssignment), new StreamsGroupDescribeResponseData.Member().setMemberId("1").setClientId("clientId1").setClientHost("clientHost").setAssignment(memberAssignment))));
            StreamsGroupDescribeResponseData group1Data = new StreamsGroupDescribeResponseData();
            group1Data.groups().add(new StreamsGroupDescribeResponseData.DescribedGroup().setGroupId("group-1").setGroupState(GroupState.STABLE.toString()).setMembers(Arrays.asList(new StreamsGroupDescribeResponseData.Member().setMemberId("0").setClientId("clientId0").setClientHost("clientHost").setAssignment(memberAssignment), new StreamsGroupDescribeResponseData.Member().setMemberId("1").setClientId("clientId1").setClientHost("clientHost").setAssignment(memberAssignment))));
            env.kafkaClient().prepareResponse((AbstractResponse)new StreamsGroupDescribeResponse(group0Data));
            env.kafkaClient().prepareResponse((AbstractResponse)new StreamsGroupDescribeResponse(group1Data));
            HashSet<String> groups = new HashSet<String>();
            groups.add(GROUP_ID);
            groups.add("group-1");
            DescribeStreamsGroupsResult result = env.adminClient().describeStreamsGroups(groups);
            Assertions.assertEquals((int)2, (int)result.describedGroups().size());
            Assertions.assertEquals(groups, result.describedGroups().keySet());
        }
    }

    @Test
    public void testDeleteStreamsGroupOffsetsFindCoordinatorNonRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            DeleteStreamsGroupOffsetsResult errorResult = env.adminClient().deleteStreamsGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
            TestUtils.assertFutureThrows(GroupAuthorizationException.class, errorResult.all());
            TestUtils.assertFutureThrows(GroupAuthorizationException.class, errorResult.partitionResult(tp1));
        }
    }

    @Test
    public void testListStreamsGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(Collections.emptyList(), env.cluster().clusterResource().clusterId(), -1, Collections.emptyList()));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Collections.singletonList(new ListGroupsResponseData.ListedGroup().setGroupId("streams-group-1").setGroupType(GroupType.STREAMS.toString()).setGroupState("Stable")))), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("streams-group-2").setGroupType(GroupType.STREAMS.toString()).setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("streams-group-3").setGroupType(GroupType.STREAMS.toString()).setGroupState("Stable")))), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Collections.singletonList(new ListGroupsResponseData.ListedGroup().setGroupId("streams-group-4").setGroupType(GroupType.STREAMS.toString()).setGroupState("Stable")))), env.cluster().nodeById(2));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(3));
            ListGroupsResult result = env.adminClient().listGroups(ListGroupsOptions.forStreamsGroups());
            TestUtils.assertFutureThrows(UnknownServerException.class, result.all());
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)4, (int)listings.size());
            HashSet<String> groupIds = new HashSet<String>();
            for (GroupListing listing : listings) {
                groupIds.add(listing.groupId());
                Assertions.assertTrue((boolean)listing.groupState().isPresent());
            }
            Assertions.assertEquals(Set.of("streams-group-1", "streams-group-2", "streams-group-3", "streams-group-4"), groupIds);
            Assertions.assertEquals((int)1, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListStreamsGroupsMetadataFailure() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(Collections.emptyList(), env.cluster().clusterResource().clusterId(), -1, Collections.emptyList()));
            ListGroupsResult result = env.adminClient().listGroups(ListGroupsOptions.forStreamsGroups());
            TestUtils.assertFutureThrows(KafkaException.class, result.all());
        }
    }

    @Test
    public void testListStreamsGroupsWithStates() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("streams-group-1").setGroupType(GroupType.STREAMS.toString()).setProtocolType("streams").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("streams-group-2").setGroupType(GroupType.STREAMS.toString()).setProtocolType("streams").setGroupState("NotReady")))), env.cluster().nodeById(0));
            ListGroupsResult result = env.adminClient().listGroups(ListGroupsOptions.forStreamsGroups());
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)2, (int)listings.size());
            ArrayList<GroupListing> expected = new ArrayList<GroupListing>();
            expected.add(new GroupListing("streams-group-1", Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE)));
            expected.add(new GroupListing("streams-group-2", Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.NOT_READY)));
            Assertions.assertEquals(expected, (Object)listings);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListStreamsGroupsWithStatesOlderBrokerVersion() {
        ApiVersionsResponseData.ApiVersion listGroupV4 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.LIST_GROUPS.id).setMinVersion((short)0).setMaxVersion((short)4);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Collections.singletonList(listGroupV4)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Collections.singletonList(new ListGroupsResponseData.ListedGroup().setGroupId("streams-group-1")))), env.cluster().nodeById(0));
            ListGroupsResult result = env.adminClient().listGroups(ListGroupsOptions.forStreamsGroups());
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.all());
        }
    }

    @Test
    public void testDescribeShareGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            ShareGroupDescribeResponseData data = new ShareGroupDescribeResponseData();
            data.groups().add(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new ShareGroupDescribeResponse(data));
            data = new ShareGroupDescribeResponseData();
            data.groups().add(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setErrorCode(Errors.NOT_COORDINATOR.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new ShareGroupDescribeResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new ShareGroupDescribeResponseData();
            data.groups().add(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new ShareGroupDescribeResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new ShareGroupDescribeResponseData();
            ShareGroupDescribeResponseData.TopicPartitions topicPartitions = new ShareGroupDescribeResponseData.TopicPartitions().setTopicName("my_topic").setPartitions(Arrays.asList(0, 1, 2));
            ShareGroupDescribeResponseData.Assignment memberAssignment = new ShareGroupDescribeResponseData.Assignment().setTopicPartitions(Arrays.asList(topicPartitions));
            ShareGroupDescribeResponseData.Member memberOne = new ShareGroupDescribeResponseData.Member().setMemberId("0").setClientId("clientId0").setClientHost("clientHost").setAssignment(memberAssignment);
            ShareGroupDescribeResponseData.Member memberTwo = new ShareGroupDescribeResponseData.Member().setMemberId("1").setClientId("clientId1").setClientHost("clientHost").setAssignment(memberAssignment);
            ShareGroupDescribeResponseData group0Data = new ShareGroupDescribeResponseData();
            group0Data.groups().add(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setGroupState(GroupState.STABLE.toString()).setMembers(Arrays.asList(memberOne, memberTwo)));
            ArrayList<TopicPartition> expectedTopicPartitions = new ArrayList<TopicPartition>();
            expectedTopicPartitions.add(0, new TopicPartition("my_topic", 0));
            expectedTopicPartitions.add(1, new TopicPartition("my_topic", 1));
            expectedTopicPartitions.add(2, new TopicPartition("my_topic", 2));
            ArrayList<ShareMemberDescription> expectedMemberDescriptions = new ArrayList<ShareMemberDescription>();
            expectedMemberDescriptions.add(KafkaAdminClientTest.convertToShareMemberDescriptions(memberOne, new ShareMemberAssignment(new HashSet(expectedTopicPartitions))));
            expectedMemberDescriptions.add(KafkaAdminClientTest.convertToShareMemberDescriptions(memberTwo, new ShareMemberAssignment(new HashSet(expectedTopicPartitions))));
            data.groups().add(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setGroupState(GroupState.STABLE.toString()).setMembers(Arrays.asList(memberOne, memberTwo)));
            env.kafkaClient().prepareResponse((AbstractResponse)new ShareGroupDescribeResponse(data));
            DescribeShareGroupsResult result = env.adminClient().describeShareGroups(Collections.singletonList(GROUP_ID));
            ShareGroupDescription groupDescription = (ShareGroupDescription)((KafkaFuture)result.describedGroups().get(GROUP_ID)).get();
            Assertions.assertEquals((int)1, (int)result.describedGroups().size());
            Assertions.assertEquals((Object)GROUP_ID, (Object)groupDescription.groupId());
            Assertions.assertEquals((int)2, (int)groupDescription.members().size());
            Assertions.assertEquals(expectedMemberDescriptions, (Object)groupDescription.members());
        }
    }

    @Test
    public void testDescribeShareGroupsGroupIdNotFound() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new FindCoordinatorResponse(new FindCoordinatorResponseData().setCoordinators(Arrays.asList(FindCoordinatorResponse.prepareCoordinatorResponse((Errors)Errors.NONE, (String)GROUP_ID, (Node)env.cluster().controller()), FindCoordinatorResponse.prepareCoordinatorResponse((Errors)Errors.NONE, (String)"group-1", (Node)env.cluster().controller())))));
            ShareGroupDescribeResponseData.TopicPartitions topicPartitions = new ShareGroupDescribeResponseData.TopicPartitions().setTopicName("my_topic").setPartitions(Arrays.asList(0, 1, 2));
            ShareGroupDescribeResponseData.Assignment memberAssignment = new ShareGroupDescribeResponseData.Assignment().setTopicPartitions(Arrays.asList(topicPartitions));
            ShareGroupDescribeResponseData groupData = new ShareGroupDescribeResponseData();
            groupData.groups().add(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setGroupState(GroupState.STABLE.toString()).setMembers(Arrays.asList(new ShareGroupDescribeResponseData.Member().setMemberId("0").setClientId("clientId0").setClientHost("clientHost").setAssignment(memberAssignment), new ShareGroupDescribeResponseData.Member().setMemberId("1").setClientId("clientId1").setClientHost("clientHost").setAssignment(memberAssignment))));
            groupData.groups().add(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId("group-1").setGroupState(GroupState.DEAD.toString()).setErrorCode(Errors.GROUP_ID_NOT_FOUND.code()).setErrorMessage("Group group-1 not found."));
            env.kafkaClient().prepareResponse((AbstractResponse)new ShareGroupDescribeResponse(groupData));
            HashSet<String> groups = new HashSet<String>();
            groups.add(GROUP_ID);
            groups.add("group-1");
            DescribeShareGroupsResult result = env.adminClient().describeShareGroups(groups);
            Assertions.assertEquals((int)2, (int)result.describedGroups().size());
            Assertions.assertEquals(groups, result.describedGroups().keySet());
            KafkaFuture allFuture = result.all();
            Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)allFuture).get());
            Assertions.assertTrue((boolean)result.all().isCompletedExceptionally());
        }
    }

    @Test
    public void testDescribeShareGroupsWithAuthorizedOperationsOmitted() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            ShareGroupDescribeResponseData data = new ShareGroupDescribeResponseData();
            data.groups().add(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setAuthorizedOperations(Integer.MIN_VALUE));
            env.kafkaClient().prepareResponse((AbstractResponse)new ShareGroupDescribeResponse(data));
            DescribeShareGroupsResult result = env.adminClient().describeShareGroups(Collections.singletonList(GROUP_ID));
            ShareGroupDescription groupDescription = (ShareGroupDescription)((KafkaFuture)result.describedGroups().get(GROUP_ID)).get();
            Assertions.assertNull((Object)groupDescription.authorizedOperations());
        }
    }

    @Test
    public void testDescribeMultipleShareGroups() {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new FindCoordinatorResponse(new FindCoordinatorResponseData().setCoordinators(Arrays.asList(FindCoordinatorResponse.prepareCoordinatorResponse((Errors)Errors.NONE, (String)GROUP_ID, (Node)env.cluster().controller()), FindCoordinatorResponse.prepareCoordinatorResponse((Errors)Errors.NONE, (String)"group-1", (Node)env.cluster().controller())))));
            ShareGroupDescribeResponseData.TopicPartitions topicPartitions = new ShareGroupDescribeResponseData.TopicPartitions().setTopicName("my_topic").setPartitions(Arrays.asList(0, 1, 2));
            ShareGroupDescribeResponseData.Assignment memberAssignment = new ShareGroupDescribeResponseData.Assignment().setTopicPartitions(Arrays.asList(topicPartitions));
            ShareGroupDescribeResponseData groupData = new ShareGroupDescribeResponseData();
            groupData.groups().add(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setGroupState(GroupState.STABLE.toString()).setMembers(Arrays.asList(new ShareGroupDescribeResponseData.Member().setMemberId("0").setClientId("clientId0").setClientHost("clientHost").setAssignment(memberAssignment), new ShareGroupDescribeResponseData.Member().setMemberId("1").setClientId("clientId1").setClientHost("clientHost").setAssignment(memberAssignment))));
            groupData.groups().add(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId("group-1").setGroupState(GroupState.STABLE.toString()).setMembers(Arrays.asList(new ShareGroupDescribeResponseData.Member().setMemberId("0").setClientId("clientId0").setClientHost("clientHost").setAssignment(memberAssignment), new ShareGroupDescribeResponseData.Member().setMemberId("1").setClientId("clientId1").setClientHost("clientHost").setAssignment(memberAssignment))));
            env.kafkaClient().prepareResponse((AbstractResponse)new ShareGroupDescribeResponse(groupData));
            HashSet<String> groups = new HashSet<String>();
            groups.add(GROUP_ID);
            groups.add("group-1");
            DescribeShareGroupsResult result = env.adminClient().describeShareGroups(groups);
            Assertions.assertEquals((int)2, (int)result.describedGroups().size());
            Assertions.assertEquals(groups, result.describedGroups().keySet());
            KafkaFuture allFuture = result.all();
            Assertions.assertDoesNotThrow(() -> (Map)allFuture.get());
            Assertions.assertFalse((boolean)allFuture.isCompletedExceptionally());
        }
    }

    @Test
    public void testListShareGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(Collections.emptyList(), env.cluster().clusterResource().clusterId(), -1, Collections.emptyList()));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("share-group-1").setGroupType(GroupType.SHARE.toString()).setGroupState("Stable")))), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("share-group-2").setGroupType(GroupType.SHARE.toString()).setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("share-group-3").setGroupType(GroupType.SHARE.toString()).setGroupState("Stable")))), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("share-group-4").setGroupType(GroupType.SHARE.toString()).setGroupState("Stable")))), env.cluster().nodeById(2));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(3));
            ListGroupsResult result = env.adminClient().listGroups(ListGroupsOptions.forShareGroups());
            TestUtils.assertFutureThrows(UnknownServerException.class, result.all());
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)4, (int)listings.size());
            HashSet<String> groupIds = new HashSet<String>();
            for (GroupListing listing : listings) {
                groupIds.add(listing.groupId());
                Assertions.assertTrue((boolean)listing.groupState().isPresent());
            }
            Assertions.assertEquals(Set.of("share-group-1", "share-group-2", "share-group-3", "share-group-4"), groupIds);
            Assertions.assertEquals((int)1, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListShareGroupsMetadataFailure() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(Collections.emptyList(), env.cluster().clusterResource().clusterId(), -1, Collections.emptyList()));
            ListGroupsResult result = env.adminClient().listGroups(ListGroupsOptions.forShareGroups());
            TestUtils.assertFutureThrows(KafkaException.class, result.all());
        }
    }

    @Test
    public void testListShareGroupsWithStates() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("share-group-1").setGroupType(GroupType.SHARE.toString()).setProtocolType("share").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("share-group-2").setGroupType(GroupType.SHARE.toString()).setProtocolType("share").setGroupState("Empty")))), env.cluster().nodeById(0));
            ListGroupsResult result = env.adminClient().listGroups(ListGroupsOptions.forShareGroups());
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)2, (int)listings.size());
            ArrayList<GroupListing> expected = new ArrayList<GroupListing>();
            expected.add(new GroupListing("share-group-1", Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)));
            expected.add(new GroupListing("share-group-2", Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.EMPTY)));
            Assertions.assertEquals(expected, (Object)listings);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListShareGroupsWithStatesOlderBrokerVersion() {
        ApiVersionsResponseData.ApiVersion listGroupV4 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.LIST_GROUPS.id).setMinVersion((short)0).setMaxVersion((short)4);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Collections.singletonList(listGroupV4)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Collections.singletonList(new ListGroupsResponseData.ListedGroup().setGroupId("share-group-1")))), env.cluster().nodeById(0));
            ListGroupsResult result = env.adminClient().listGroups(ListGroupsOptions.forShareGroups());
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.all());
        }
    }

    @Test
    public void testDescribeClassicGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(GROUP_ID).setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            data = new DescribeGroupsResponseData();
            data.groups().add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(GROUP_ID).setErrorCode(Errors.NOT_COORDINATOR.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new DescribeGroupsResponseData();
            data.groups().add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(GROUP_ID).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            List<TopicPartition> topicPartitions = List.of(new TopicPartition("my_topic", 0), new TopicPartition("my_topic", 1), new TopicPartition("my_topic", 2));
            ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
            byte[] memberAssignmentBytes = new byte[memberAssignment.remaining()];
            memberAssignment.get(memberAssignmentBytes);
            data = new DescribeGroupsResponseData();
            DescribeGroupsResponseData.DescribedGroupMember memberOne = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("0").setClientId("clientId0").setClientHost("clientHost").setMemberAssignment(memberAssignmentBytes);
            DescribeGroupsResponseData.DescribedGroupMember memberTwo = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("1").setClientId("clientId1").setClientHost("clientHost").setGroupInstanceId("static").setMemberAssignment(memberAssignmentBytes);
            ArrayList<TopicPartition> expectedTopicPartitions = new ArrayList<TopicPartition>();
            expectedTopicPartitions.add(0, new TopicPartition("my_topic", 0));
            expectedTopicPartitions.add(1, new TopicPartition("my_topic", 1));
            expectedTopicPartitions.add(2, new TopicPartition("my_topic", 2));
            ArrayList<MemberDescription> expectedMemberDescriptions = new ArrayList<MemberDescription>();
            expectedMemberDescriptions.add(KafkaAdminClientTest.convertToMemberDescriptions(memberOne, new MemberAssignment(new HashSet(expectedTopicPartitions))));
            expectedMemberDescriptions.add(KafkaAdminClientTest.convertToMemberDescriptions(memberTwo, new MemberAssignment(new HashSet(expectedTopicPartitions))));
            data.groups().add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(GROUP_ID).setProtocolType("consumer").setGroupState(ClassicGroupState.STABLE.toString()).setMembers(List.of(memberOne, memberTwo)));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeClassicGroupsResult result = env.adminClient().describeClassicGroups(List.of(GROUP_ID));
            ClassicGroupDescription groupDescription = (ClassicGroupDescription)((KafkaFuture)result.describedGroups().get(GROUP_ID)).get();
            Assertions.assertEquals((int)1, (int)result.describedGroups().size());
            Assertions.assertEquals((Object)GROUP_ID, (Object)groupDescription.groupId());
            Assertions.assertEquals((int)2, (int)groupDescription.members().size());
            Assertions.assertEquals(expectedMemberDescriptions, (Object)groupDescription.members());
        }
    }

    @Test
    public void testDescribeClassicGroupsWithAuthorizedOperationsOmitted() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(GROUP_ID).setProtocolType("").setAuthorizedOperations(Integer.MIN_VALUE));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeClassicGroupsResult result = env.adminClient().describeClassicGroups(List.of(GROUP_ID));
            ClassicGroupDescription groupDescription = (ClassicGroupDescription)((KafkaFuture)result.describedGroups().get(GROUP_ID)).get();
            Assertions.assertNull((Object)groupDescription.authorizedOperations());
        }
    }

    @Test
    public void testDescribeMultipleClassicGroups() {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            List<TopicPartition> topicPartitions = List.of(new TopicPartition("my_topic", 0), new TopicPartition("my_topic", 1), new TopicPartition("my_topic", 2));
            ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
            byte[] memberAssignmentBytes = new byte[memberAssignment.remaining()];
            memberAssignment.get(memberAssignmentBytes);
            DescribeGroupsResponseData group0Data = new DescribeGroupsResponseData();
            group0Data.groups().add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(GROUP_ID).setProtocolType("consumer").setGroupState(ClassicGroupState.STABLE.toString()).setMembers(List.of(new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("0").setClientId("clientId0").setClientHost("clientHost").setMemberAssignment(memberAssignmentBytes), new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("1").setClientId("clientId1").setClientHost("clientHost").setMemberAssignment(memberAssignmentBytes))));
            DescribeGroupsResponseData group1Data = new DescribeGroupsResponseData();
            group1Data.groups().add(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group-1").setProtocolType("other").setGroupState(ClassicGroupState.STABLE.toString()).setMembers(List.of(new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("0").setClientId("clientId0").setClientHost("clientHost"), new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("1").setClientId("clientId1").setClientHost("clientHost"))));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(group0Data));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(group1Data));
            HashSet<String> groups = new HashSet<String>();
            groups.add(GROUP_ID);
            groups.add("group-1");
            DescribeClassicGroupsResult result = env.adminClient().describeClassicGroups(groups);
            Assertions.assertEquals((int)2, (int)result.describedGroups().size());
            Assertions.assertEquals(groups, result.describedGroups().keySet());
        }
    }

    @Test
    public void testIncrementalAlterConfigs() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            IncrementalAlterConfigsResponseData responseData = new IncrementalAlterConfigsResponseData();
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage("authorization error"));
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("metric1").setResourceType(ConfigResource.Type.CLIENT_METRICS.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Subscription is not allowed"));
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("topic1").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Config value append is not allowed for config"));
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("group1").setResourceType(ConfigResource.Type.GROUP.id()).setErrorCode(Errors.INVALID_CONFIG.code()).setErrorMessage("Unknown group config name: group.initial.rebalance.delay.ms"));
            env.kafkaClient().prepareResponse((AbstractResponse)new IncrementalAlterConfigsResponse(responseData));
            ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "");
            ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "topic1");
            ConfigResource metricResource = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "metric1");
            ConfigResource groupResource = new ConfigResource(ConfigResource.Type.GROUP, "group1");
            AlterConfigOp alterConfigOp1 = new AlterConfigOp(new ConfigEntry("log.segment.bytes", "1073741"), AlterConfigOp.OpType.SET);
            AlterConfigOp alterConfigOp2 = new AlterConfigOp(new ConfigEntry("compression.type", "gzip"), AlterConfigOp.OpType.APPEND);
            AlterConfigOp alterConfigOp3 = new AlterConfigOp(new ConfigEntry("interval.ms", "1000"), AlterConfigOp.OpType.APPEND);
            AlterConfigOp alterConfigOp4 = new AlterConfigOp(new ConfigEntry("group.initial.rebalance.delay.ms", "1000"), AlterConfigOp.OpType.SET);
            HashMap<ConfigResource, List<AlterConfigOp>> configs = new HashMap<ConfigResource, List<AlterConfigOp>>();
            configs.put(brokerResource, Collections.singletonList(alterConfigOp1));
            configs.put(topicResource, Collections.singletonList(alterConfigOp2));
            configs.put(metricResource, Collections.singletonList(alterConfigOp3));
            configs.put(groupResource, Collections.singletonList(alterConfigOp4));
            AlterConfigsResult result = env.adminClient().incrementalAlterConfigs(configs);
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, (Future)result.values().get(brokerResource));
            TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)result.values().get(topicResource));
            TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)result.values().get(metricResource));
            TestUtils.assertFutureThrows(InvalidConfigurationException.class, (Future)result.values().get(groupResource));
            responseData = new IncrementalAlterConfigsResponseData();
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(ApiError.NONE.message()));
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("metric1").setResourceType(ConfigResource.Type.CLIENT_METRICS.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(ApiError.NONE.message()));
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("group1").setResourceType(ConfigResource.Type.GROUP.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(ApiError.NONE.message()));
            HashMap<ConfigResource, List<AlterConfigOp>> successConfig = new HashMap<ConfigResource, List<AlterConfigOp>>();
            successConfig.put(brokerResource, Collections.singletonList(alterConfigOp1));
            successConfig.put(metricResource, Collections.singletonList(alterConfigOp3));
            successConfig.put(groupResource, Collections.singletonList(alterConfigOp4));
            env.kafkaClient().prepareResponse((AbstractResponse)new IncrementalAlterConfigsResponse(responseData));
            env.adminClient().incrementalAlterConfigs(successConfig).all().get();
        }
    }

    @Test
    public void testClusterLinkIncrementalAlterConfigs() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            IncrementalAlterConfigsResponseData responseData = new IncrementalAlterConfigsResponseData();
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("link1").setResourceType(ConfigResource.Type.CLUSTER_LINK.id()).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage("authorization error"));
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("link2").setResourceType(ConfigResource.Type.CLUSTER_LINK.id()).setErrorCode(Errors.NONE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new IncrementalAlterConfigsResponse(responseData));
            ConfigResource link1 = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, "link1");
            ConfigResource link2 = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, "link2");
            AlterConfigOp alterConfigOp1 = new AlterConfigOp(new ConfigEntry("ssl.truststore.certificates", TestUtils.randomString(Short.MAX_VALUE)), AlterConfigOp.OpType.SET);
            AlterConfigOp alterConfigOp2 = new AlterConfigOp(new ConfigEntry("bootstrap.servers", "localhost:9092"), AlterConfigOp.OpType.SET);
            AlterConfigOp nullConfigValue = new AlterConfigOp(new ConfigEntry("null.config", null), AlterConfigOp.OpType.SET);
            AlterConfigOp invalidConfigValue = new AlterConfigOp(new ConfigEntry("ssl.truststore.certificates", TestUtils.randomString(32768)), AlterConfigOp.OpType.SET);
            AlterConfigOp invalidConfigName = new AlterConfigOp(new ConfigEntry(TestUtils.randomString(32768), "value"), AlterConfigOp.OpType.SET);
            HashMap<ConfigResource, List<AlterConfigOp>> configs = new HashMap<ConfigResource, List<AlterConfigOp>>();
            configs.put(link1, Arrays.asList(alterConfigOp1, alterConfigOp2));
            configs.put(link2, Arrays.asList(alterConfigOp2, nullConfigValue));
            AlterConfigsResult result = env.adminClient().incrementalAlterConfigs(configs);
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, (Future)result.values().get(link1));
            ((KafkaFuture)result.values().get(link2)).get(15L, TimeUnit.SECONDS);
            configs.put(link2, Arrays.asList(invalidConfigValue, alterConfigOp2));
            InvalidRequestException e = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> env.adminClient().incrementalAlterConfigs(configs));
            Assertions.assertEquals((Object)"Configuration value for 'ssl.truststore.certificates' for cluster link 'link2' is too long, max size is 32767, provided size is 32768.", (Object)e.getMessage());
            configs.put(link2, Arrays.asList(invalidConfigName, alterConfigOp2));
            e = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> env.adminClient().incrementalAlterConfigs(configs));
            Assertions.assertEquals((Object)("Configuration name '" + invalidConfigName.configEntry().name() + "' for cluster link 'link2' is too long, max size is 32767, provided size is 32768."), (Object)e.getMessage());
        }
    }

    @Test
    public void testIncrementalAlterConfigsToController() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv("bootstrap.controllers", "dummy");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            IncrementalAlterConfigsResponseData responseData = new IncrementalAlterConfigsResponseData();
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage("not controller"));
            env.kafkaClient().prepareResponse((AbstractResponse)new IncrementalAlterConfigsResponse(responseData));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Integer.MIN_VALUE, true));
            IncrementalAlterConfigsResponseData responseData2 = new IncrementalAlterConfigsResponseData();
            responseData2.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(ApiError.NONE.message()));
            ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "");
            AlterConfigOp alterConfigOp1 = new AlterConfigOp(new ConfigEntry("log.segment.bytes", "1073741"), AlterConfigOp.OpType.SET);
            HashMap<ConfigResource, List<AlterConfigOp>> configs = new HashMap<ConfigResource, List<AlterConfigOp>>();
            configs.put(brokerResource, Collections.singletonList(alterConfigOp1));
            env.kafkaClient().prepareResponse((AbstractResponse)new IncrementalAlterConfigsResponse(responseData2));
            env.adminClient().incrementalAlterConfigs(configs).all().get();
        }
    }

    @Test
    public void testRemoveMembersFromGroupNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            List<MemberToRemove> membersToRemove = Arrays.asList(new MemberToRemove("instance-1"), new MemberToRemove("instance-2"));
            RemoveMembersFromConsumerGroupResult result = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            TestUtils.assertFutureThrows(TimeoutException.class, result.all());
        }
    }

    @Test
    public void testRemoveMembersFromGroupRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code())));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            LeaveGroupResponseData.MemberResponse responseOne = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(responseOne))));
            List<MemberToRemove> membersToRemove = Collections.singletonList(new MemberToRemove("instance-1"));
            KafkaFuture future = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove)).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting RemoveMembersFromGroup first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry RemoveMembersFromGroup call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"RemoveMembersFromGroup retry did not await expected backoff!");
        }
    }

    @Test
    public void testRemoveMembersFromGroupRetriableErrors() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            LeaveGroupResponseData.MemberResponse memberResponse = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(memberResponse))));
            MemberToRemove memberToRemove = new MemberToRemove("instance-1");
            List<MemberToRemove> membersToRemove = Collections.singletonList(memberToRemove);
            RemoveMembersFromConsumerGroupResult result = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.memberResult(memberToRemove).get());
        }
    }

    @Test
    public void testRemoveMembersFromGroupNonRetriableErrors() throws Exception {
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(error.code())));
                MemberToRemove memberToRemove = new MemberToRemove("instance-1");
                List<MemberToRemove> membersToRemove = Collections.singletonList(memberToRemove);
                RemoveMembersFromConsumerGroupResult result = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
                TestUtils.assertFutureThrows(error.exception().getClass(), result.all());
                TestUtils.assertFutureThrows(error.exception().getClass(), result.memberResult(memberToRemove));
            }
        }
    }

    @Test
    public void testRemoveMembersFromGroup() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            String instanceOne = "instance-1";
            String instanceTwo = "instance-2";
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code())));
            List<MemberToRemove> membersToRemove = Arrays.asList(new MemberToRemove("instance-1"), new MemberToRemove("instance-2"));
            RemoveMembersFromConsumerGroupResult unknownErrorResult = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            MemberToRemove memberOne = new MemberToRemove("instance-1");
            MemberToRemove memberTwo = new MemberToRemove("instance-2");
            TestUtils.assertFutureThrows(UnknownServerException.class, unknownErrorResult.memberResult(memberOne));
            TestUtils.assertFutureThrows(UnknownServerException.class, unknownErrorResult.memberResult(memberTwo));
            LeaveGroupResponseData.MemberResponse responseOne = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code());
            LeaveGroupResponseData.MemberResponse responseTwo = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-2").setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseOne, responseTwo))));
            RemoveMembersFromConsumerGroupResult memberLevelErrorResult = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            TestUtils.assertFutureThrows(UnknownMemberIdException.class, memberLevelErrorResult.all());
            TestUtils.assertFutureThrows(UnknownMemberIdException.class, memberLevelErrorResult.memberResult(memberOne));
            Assertions.assertNull((Object)memberLevelErrorResult.memberResult(memberTwo).get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(responseTwo))));
            RemoveMembersFromConsumerGroupResult missingMemberResult = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            TestUtils.assertFutureThrows(IllegalArgumentException.class, missingMemberResult.all());
            TestUtils.assertFutureThrows(IllegalArgumentException.class, missingMemberResult.memberResult(memberOne));
            Assertions.assertNull((Object)missingMemberResult.memberResult(memberTwo).get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseTwo, new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.NONE.code())))));
            RemoveMembersFromConsumerGroupResult noErrorResult = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            Assertions.assertNull((Object)noErrorResult.all().get());
            Assertions.assertNull((Object)noErrorResult.memberResult(memberOne).get());
            Assertions.assertNull((Object)noErrorResult.memberResult(memberTwo).get());
            List<TopicPartition> topicPartitions = Stream.of(1, 2, 3).map(partition -> new TopicPartition("my_topic", partition.intValue())).collect(Collectors.toList());
            DescribeGroupsResponseData data = KafkaAdminClientTest.prepareDescribeGroupsResponseData(GROUP_ID, Arrays.asList("instance-1", "instance-2"), topicPartitions);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseOne, responseTwo))));
            RemoveMembersFromConsumerGroupResult partialFailureResults = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions());
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> partialFailureResults.all().get());
            Assertions.assertInstanceOf(KafkaException.class, (Object)exception.getCause());
            Assertions.assertInstanceOf(UnknownMemberIdException.class, (Object)exception.getCause().getCause());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseTwo, new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.NONE.code())))));
            RemoveMembersFromConsumerGroupResult successResult = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions());
            Assertions.assertNull((Object)successResult.all().get());
        }
    }

    private void testRemoveMembersFromGroup(String reason, String expectedReason) throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, cluster);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse(body -> {
                if (!(body instanceof LeaveGroupRequest)) {
                    return false;
                }
                LeaveGroupRequestData leaveGroupRequest = ((LeaveGroupRequest)body).data();
                return leaveGroupRequest.members().stream().allMatch(member -> member.reason().equals(expectedReason));
            }, (AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1"), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-2")))));
            MemberToRemove memberToRemove1 = new MemberToRemove("instance-1");
            MemberToRemove memberToRemove2 = new MemberToRemove("instance-2");
            RemoveMembersFromConsumerGroupOptions options = new RemoveMembersFromConsumerGroupOptions(Arrays.asList(memberToRemove1, memberToRemove2));
            options.reason(reason);
            RemoveMembersFromConsumerGroupResult result = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, options);
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.memberResult(memberToRemove1).get());
            Assertions.assertNull((Object)result.memberResult(memberToRemove2).get());
        }
    }

    @Test
    public void testRemoveMembersFromGroupReason() throws Exception {
        this.testRemoveMembersFromGroup("testing remove members reason", "testing remove members reason");
    }

    @Test
    public void testRemoveMembersFromGroupDefaultReason() throws Exception {
        this.testRemoveMembersFromGroup(null, "member was removed by an admin");
        this.testRemoveMembersFromGroup("", "member was removed by an admin");
    }

    @Test
    public void testAlterPartitionReassignments() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition tp1 = new TopicPartition("A", 0);
            TopicPartition tp2 = new TopicPartition("B", 0);
            HashMap reassignments = new HashMap();
            reassignments.put(tp1, Optional.empty());
            reassignments.put(tp2, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            AlterPartitionReassignmentsResponseData responseData1 = new AlterPartitionReassignmentsResponseData();
            AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse normalPartitionResponse = new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(0);
            responseData1.setResponses(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(responseData1));
            AlterPartitionReassignmentsResult result1 = env.adminClient().alterPartitionReassignments(reassignments);
            KafkaFuture future1 = result1.all();
            Future future2 = (Future)result1.values().get(tp1);
            TestUtils.assertFutureThrows(UnknownServerException.class, future1);
            TestUtils.assertFutureThrows(UnknownServerException.class, future2);
            AlterPartitionReassignmentsResponseData controllerErrResponseData = new AlterPartitionReassignmentsResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage(Errors.NOT_CONTROLLER.message()).setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            MetadataResponse controllerNodeResponse = RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 1, Collections.emptyList());
            AlterPartitionReassignmentsResponseData normalResponse = new AlterPartitionReassignmentsResponseData().setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(controllerErrResponseData));
            env.kafkaClient().prepareResponse((AbstractResponse)controllerNodeResponse);
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(normalResponse));
            AlterPartitionReassignmentsResult controllerErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            controllerErrResult.all().get();
            ((KafkaFuture)controllerErrResult.values().get(tp1)).get();
            ((KafkaFuture)controllerErrResult.values().get(tp2)).get();
            AlterPartitionReassignmentsResponseData partitionLevelErrData = new AlterPartitionReassignmentsResponseData().setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(0).setErrorMessage(Errors.INVALID_REPLICA_ASSIGNMENT.message()).setErrorCode(Errors.INVALID_REPLICA_ASSIGNMENT.code()))), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(partitionLevelErrData));
            AlterPartitionReassignmentsResult partitionLevelErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            TestUtils.assertFutureThrows(InvalidReplicaAssignmentException.class, (Future)partitionLevelErrResult.values().get(tp1));
            ((KafkaFuture)partitionLevelErrResult.values().get(tp2)).get();
            String errorMessage = "this is custom error message";
            AlterPartitionReassignmentsResponseData topLevelErrResponseData = new AlterPartitionReassignmentsResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage(errorMessage).setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(topLevelErrResponseData));
            AlterPartitionReassignmentsResult topLevelErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            Assertions.assertEquals((Object)errorMessage, (Object)TestUtils.assertFutureThrows(ClusterAuthorizationException.class, topLevelErrResult.all()).getMessage());
            Assertions.assertEquals((Object)errorMessage, (Object)TestUtils.assertFutureThrows(ClusterAuthorizationException.class, (Future)topLevelErrResult.values().get(tp1)).getMessage());
            Assertions.assertEquals((Object)errorMessage, (Object)TestUtils.assertFutureThrows(ClusterAuthorizationException.class, (Future)topLevelErrResult.values().get(tp2)).getMessage());
            TopicPartition invalidTopicTP = new TopicPartition("", 0);
            TopicPartition invalidPartitionTP = new TopicPartition("ABC", -1);
            HashMap<TopicPartition, Optional<NewPartitionReassignment>> invalidTopicReassignments = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
            invalidTopicReassignments.put(invalidPartitionTP, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            invalidTopicReassignments.put(invalidTopicTP, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            invalidTopicReassignments.put(tp1, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            AlterPartitionReassignmentsResponseData singlePartResponseData = new AlterPartitionReassignmentsResponseData().setResponses(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(singlePartResponseData));
            AlterPartitionReassignmentsResult unrepresentableTopicResult = env.adminClient().alterPartitionReassignments(invalidTopicReassignments);
            TestUtils.assertFutureThrows(InvalidTopicException.class, (Future)unrepresentableTopicResult.values().get(invalidTopicTP));
            TestUtils.assertFutureThrows(InvalidTopicException.class, (Future)unrepresentableTopicResult.values().get(invalidPartitionTP));
            ((KafkaFuture)unrepresentableTopicResult.values().get(tp1)).get();
            AlterPartitionReassignmentsResponseData noErrResponseData = new AlterPartitionReassignmentsResponseData().setErrorCode(Errors.NONE.code()).setErrorMessage(Errors.NONE.message()).setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(noErrResponseData));
            AlterPartitionReassignmentsResult noErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            noErrResult.all().get();
            ((KafkaFuture)noErrResult.values().get(tp1)).get();
            ((KafkaFuture)noErrResult.values().get(tp2)).get();
        }
    }

    @Test
    public void testListPartitionReassignmentsWithObservers() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition tp0 = new TopicPartition("A", 0);
            ListPartitionReassignmentsResponseData.OngoingPartitionReassignment tp1PartitionReassignment = new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6)).setAddingReplicas(Arrays.asList(4, 5, 6)).setObservers(Arrays.asList(2, 4));
            ListPartitionReassignmentsResponseData.OngoingTopicReassignment tp1Reassignment = new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("A").setPartitions(Collections.singletonList(tp1PartitionReassignment));
            TopicPartition tp1 = new TopicPartition("B", 0);
            ListPartitionReassignmentsResponseData.OngoingPartitionReassignment tp2PartitionReassignment = new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6)).setAddingReplicas(Arrays.asList(4, 5, 6));
            ListPartitionReassignmentsResponseData.OngoingTopicReassignment tp2Reassignment = new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("B").setPartitions(Collections.singletonList(tp2PartitionReassignment));
            ListPartitionReassignmentsResponseData responseData = new ListPartitionReassignmentsResponseData().setTopics(Arrays.asList(tp1Reassignment, tp2Reassignment));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(responseData));
            ListPartitionReassignmentsResult responseResult = env.adminClient().listPartitionReassignments();
            Map result = (Map)responseResult.reassignments().get();
            Assertions.assertEquals(Arrays.asList(2, 4), (Object)((PartitionReassignment)result.get(tp0)).observers());
            Assertions.assertEquals(Collections.emptyList(), (Object)((PartitionReassignment)result.get(tp1)).observers());
        }
    }

    @Test
    public void testListPartitionReassignments() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition tp1 = new TopicPartition("A", 0);
            ListPartitionReassignmentsResponseData.OngoingPartitionReassignment tp1PartitionReassignment = new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setRemovingReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Arrays.asList(4, 5, 6)).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6));
            ListPartitionReassignmentsResponseData.OngoingTopicReassignment tp1Reassignment = new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("A").setPartitions(Collections.singletonList(tp1PartitionReassignment));
            TopicPartition tp2 = new TopicPartition("B", 0);
            ListPartitionReassignmentsResponseData.OngoingPartitionReassignment tp2PartitionReassignment = new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setRemovingReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Arrays.asList(4, 5, 6)).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6));
            ListPartitionReassignmentsResponseData.OngoingTopicReassignment tp2Reassignment = new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("B").setPartitions(Collections.singletonList(tp2PartitionReassignment));
            ListPartitionReassignmentsResponseData notControllerData = new ListPartitionReassignmentsResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage(Errors.NOT_CONTROLLER.message());
            MetadataResponse controllerNodeResponse = RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 1, Collections.emptyList());
            ListPartitionReassignmentsResponseData reassignmentsData = new ListPartitionReassignmentsResponseData().setTopics(Arrays.asList(tp1Reassignment, tp2Reassignment));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(notControllerData));
            env.kafkaClient().prepareResponse((AbstractResponse)controllerNodeResponse);
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(reassignmentsData));
            ListPartitionReassignmentsResult noControllerResult = env.adminClient().listPartitionReassignments();
            noControllerResult.reassignments().get();
            ListPartitionReassignmentsResponseData unknownTpData = new ListPartitionReassignmentsResponseData().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_OR_PARTITION.message());
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(unknownTpData));
            ListPartitionReassignmentsResult unknownTpResult = env.adminClient().listPartitionReassignments(new HashSet<TopicPartition>(Arrays.asList(tp1, tp2)));
            TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, unknownTpResult.reassignments());
            ListPartitionReassignmentsResponseData responseData = new ListPartitionReassignmentsResponseData().setTopics(Arrays.asList(tp1Reassignment, tp2Reassignment));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(responseData));
            ListPartitionReassignmentsResult responseResult = env.adminClient().listPartitionReassignments();
            Map reassignments = (Map)responseResult.reassignments().get();
            PartitionReassignment tp1Result = (PartitionReassignment)reassignments.get(tp1);
            Assertions.assertEquals((Object)tp1PartitionReassignment.addingReplicas(), (Object)tp1Result.addingReplicas());
            Assertions.assertEquals((Object)tp1PartitionReassignment.removingReplicas(), (Object)tp1Result.removingReplicas());
            Assertions.assertEquals((Object)tp1PartitionReassignment.replicas(), (Object)tp1Result.replicas());
            Assertions.assertEquals((Object)tp1PartitionReassignment.replicas(), (Object)tp1Result.replicas());
            PartitionReassignment tp2Result = (PartitionReassignment)reassignments.get(tp2);
            Assertions.assertEquals((Object)tp2PartitionReassignment.addingReplicas(), (Object)tp2Result.addingReplicas());
            Assertions.assertEquals((Object)tp2PartitionReassignment.removingReplicas(), (Object)tp2Result.removingReplicas());
            Assertions.assertEquals((Object)tp2PartitionReassignment.replicas(), (Object)tp2Result.replicas());
            Assertions.assertEquals((Object)tp2PartitionReassignment.replicas(), (Object)tp2Result.replicas());
        }
    }

    private ReplicaStatusResponseData.ReplicaStatusReplicaResponse newReplicaStatusReplicaResponse(int brokerId, boolean isLeader, boolean isObserver, boolean isIsrEligible, boolean isInIsr, boolean isCaughtUp, long logStartOffset, long logEndOffset, long lastCaughtUpTimeMs, long lastFetchTimeMs, Optional<String> linkName) {
        return new ReplicaStatusResponseData.ReplicaStatusReplicaResponse().setId(brokerId).setIsLeader(isLeader).setIsObserver(isObserver).setIsIsrEligible(isIsrEligible).setIsInIsr(isInIsr).setIsCaughtUp(isCaughtUp).setLogStartOffset(logStartOffset).setLogEndOffset(logEndOffset).setLastCaughtUpTimeMs(lastCaughtUpTimeMs).setLastFetchTimeMs(lastFetchTimeMs).setLinkName((String)linkName.orElse(null));
    }

    @Test
    public void testReplicaStatus() throws Exception {
        String topic = "replica-status-topic";
        MockTime time = new MockTime();
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        nodes.put(0, new Node(0, "localhost", 8121));
        nodes.put(1, new Node(1, "localhost", 8122));
        TopicPartition tp = new TopicPartition("replica-status-topic", 0);
        Node[] nodesArray = new Node[]{(Node)nodes.get(0), (Node)nodes.get(1)};
        List<Integer> replicas = Arrays.asList(0, 1);
        ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>(1);
        partitionInfos.add(new PartitionInfo("replica-status-topic", 0, (Node)nodes.get(0), nodesArray, nodesArray));
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), partitionInfos, Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<MetadataResponseData.MetadataResponsePartition> partitionMetadata = new ArrayList<MetadataResponseData.MetadataResponsePartition>();
            partitionMetadata.add(new MetadataResponseData.MetadataResponsePartition().setErrorCode(Errors.NONE.code()).setPartitionIndex(tp.partition()).setLeaderId(((Node)nodes.get(0)).id()).setLeaderEpoch(5).setReplicaNodes(replicas).setIsrNodes(replicas).setOfflineReplicas(Collections.emptyList()));
            ArrayList<MetadataResponseData.MetadataResponseTopic> topicMetadata = new ArrayList<MetadataResponseData.MetadataResponseTopic>();
            topicMetadata.add(new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName("replica-status-topic").setIsInternal(false).setPartitions(partitionMetadata));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), topicMetadata));
            long leaderTimeMs = time.milliseconds();
            long followerTimeMs = leaderTimeMs - 10000L;
            long observerTimeMs = leaderTimeMs - 1000L;
            ArrayList<ReplicaStatusResponseData.ReplicaStatusReplicaResponse> replicaResponse = new ArrayList<ReplicaStatusResponseData.ReplicaStatusReplicaResponse>();
            replicaResponse.add(this.newReplicaStatusReplicaResponse(0, true, false, true, true, true, 10L, 100L, leaderTimeMs, leaderTimeMs, Optional.empty()));
            replicaResponse.add(this.newReplicaStatusReplicaResponse(1, false, false, true, false, false, 5L, 50L, followerTimeMs, followerTimeMs, Optional.empty()));
            replicaResponse.add(this.newReplicaStatusReplicaResponse(2, false, true, false, false, true, 10L, 100L, observerTimeMs, observerTimeMs, Optional.of("link-name")));
            ArrayList<ReplicaStatusResponseData.ReplicaStatusPartitionResponse> partitionResponse = new ArrayList<ReplicaStatusResponseData.ReplicaStatusPartitionResponse>();
            partitionResponse.add(new ReplicaStatusResponseData.ReplicaStatusPartitionResponse().setPartitionIndex(0).setLeaderId(0).setLeaderEpoch(2).setReplicas(replicaResponse).setErrorCode(Errors.NONE.code()));
            ArrayList<ReplicaStatusResponseData.ReplicaStatusTopicResponse> topicResponse = new ArrayList<ReplicaStatusResponseData.ReplicaStatusTopicResponse>();
            topicResponse.add(new ReplicaStatusResponseData.ReplicaStatusTopicResponse().setName("replica-status-topic").setPartitions(partitionResponse));
            ReplicaStatusResponseData responseData = new ReplicaStatusResponseData().setTopics(topicResponse);
            env.kafkaClient().prepareResponse((AbstractResponse)new ReplicaStatusResponse(responseData));
            HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>(1);
            topicPartitions.add(tp);
            ReplicaStatusResult adminResult = env.adminClient().replicaStatus(topicPartitions, new ReplicaStatusOptions());
            Assertions.assertEquals((int)adminResult.result().size(), (int)1);
            KafkaFuture result = (KafkaFuture)adminResult.result().get(tp);
            Assertions.assertNotNull((Object)result);
            Assertions.assertEquals((int)3, (int)((List)result.get()).size());
            ReplicaStatus result0 = (ReplicaStatus)((List)result.get()).get(0);
            Assertions.assertEquals((int)0, (int)result0.brokerId());
            Assertions.assertTrue((boolean)result0.isLeader());
            Assertions.assertFalse((boolean)result0.isObserver());
            Assertions.assertTrue((boolean)result0.isIsrEligible());
            Assertions.assertTrue((boolean)result0.isInIsr());
            Assertions.assertTrue((boolean)result0.isCaughtUp());
            Assertions.assertEquals((long)10L, (long)result0.logStartOffset());
            Assertions.assertEquals((long)100L, (long)result0.logEndOffset());
            Assertions.assertEquals((long)leaderTimeMs, (long)result0.lastCaughtUpTimeMs());
            Assertions.assertEquals((long)leaderTimeMs, (long)result0.lastFetchTimeMs());
            Assertions.assertFalse((boolean)result0.linkName().isPresent());
            ReplicaStatus result1 = (ReplicaStatus)((List)result.get()).get(1);
            Assertions.assertEquals((int)1, (int)result1.brokerId());
            Assertions.assertFalse((boolean)result1.isLeader());
            Assertions.assertFalse((boolean)result1.isObserver());
            Assertions.assertTrue((boolean)result1.isIsrEligible());
            Assertions.assertFalse((boolean)result1.isInIsr());
            Assertions.assertFalse((boolean)result1.isCaughtUp());
            Assertions.assertEquals((long)5L, (long)result1.logStartOffset());
            Assertions.assertEquals((long)50L, (long)result1.logEndOffset());
            Assertions.assertEquals((long)followerTimeMs, (long)result1.lastCaughtUpTimeMs());
            Assertions.assertEquals((long)followerTimeMs, (long)result1.lastFetchTimeMs());
            Assertions.assertFalse((boolean)result1.linkName().isPresent());
            ReplicaStatus result2 = (ReplicaStatus)((List)result.get()).get(2);
            Assertions.assertEquals((int)2, (int)result2.brokerId());
            Assertions.assertFalse((boolean)result2.isLeader());
            Assertions.assertTrue((boolean)result2.isObserver());
            Assertions.assertFalse((boolean)result2.isIsrEligible());
            Assertions.assertFalse((boolean)result2.isInIsr());
            Assertions.assertTrue((boolean)result2.isCaughtUp());
            Assertions.assertEquals((long)10L, (long)result2.logStartOffset());
            Assertions.assertEquals((long)100L, (long)result2.logEndOffset());
            Assertions.assertEquals((long)observerTimeMs, (long)result2.lastCaughtUpTimeMs());
            Assertions.assertEquals((long)observerTimeMs, (long)result2.lastFetchTimeMs());
            Assertions.assertEquals((Object)"link-name", result2.linkName().get());
        }
    }

    @Test
    public void testReplicaStatusErrors() throws Exception {
        String topic = "replica-status-topic";
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        nodes.put(0, new Node(0, "localhost", 8121));
        nodes.put(1, new Node(1, "localhost", 8122));
        TopicPartition tp0 = new TopicPartition("replica-status-topic", 0);
        TopicPartition tp1 = new TopicPartition("replica-status-topic", 1);
        Node[] nodesArray = new Node[]{(Node)nodes.get(0), (Node)nodes.get(1)};
        List<Integer> replicas = Arrays.asList(0, 1);
        ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>();
        partitionInfos.add(new PartitionInfo("replica-status-topic", 0, (Node)nodes.get(0), nodesArray, nodesArray));
        partitionInfos.add(new PartitionInfo("replica-status-topic", 1, (Node)nodes.get(1), nodesArray, nodesArray));
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), partitionInfos, Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<MetadataResponseData.MetadataResponsePartition> partitionMetadata = new ArrayList<MetadataResponseData.MetadataResponsePartition>();
            partitionMetadata.add(new MetadataResponseData.MetadataResponsePartition().setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code()).setPartitionIndex(tp0.partition()).setLeaderId(((Node)nodes.get(1)).id()).setLeaderEpoch(5).setReplicaNodes(replicas).setIsrNodes(replicas).setOfflineReplicas(Collections.emptyList()));
            ArrayList<MetadataResponseData.MetadataResponseTopic> topicMetadata = new ArrayList<MetadataResponseData.MetadataResponseTopic>();
            topicMetadata.add(new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName("replica-status-topic").setIsInternal(false).setPartitions(partitionMetadata));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), topicMetadata));
            ArrayList<ReplicaStatusResponseData.ReplicaStatusPartitionResponse> partitionResponse = new ArrayList<ReplicaStatusResponseData.ReplicaStatusPartitionResponse>();
            partitionResponse.add(new ReplicaStatusResponseData.ReplicaStatusPartitionResponse().setPartitionIndex(0).setReplicas(null).setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code()));
            ArrayList<ReplicaStatusResponseData.ReplicaStatusTopicResponse> topicResponse = new ArrayList<ReplicaStatusResponseData.ReplicaStatusTopicResponse>();
            topicResponse.add(new ReplicaStatusResponseData.ReplicaStatusTopicResponse().setName("replica-status-topic").setPartitions(partitionResponse));
            ReplicaStatusResponseData responseData = new ReplicaStatusResponseData().setTopics(topicResponse);
            env.kafkaClient().prepareResponse((AbstractResponse)new ReplicaStatusResponse(responseData));
            HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>();
            topicPartitions.add(tp0);
            topicPartitions.add(tp1);
            ReplicaStatusResult result = env.adminClient().replicaStatus(topicPartitions, new ReplicaStatusOptions());
            Assertions.assertEquals((int)result.result().size(), (int)2);
            KafkaFuture result0 = (KafkaFuture)result.result().get(tp0);
            Assertions.assertNotNull((Object)result0);
            TestUtils.assertFutureThrows(NotLeaderOrFollowerException.class, result0);
            KafkaFuture result1 = (KafkaFuture)result.result().get(tp1);
            Assertions.assertNotNull((Object)result1);
            TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, result1);
            KafkaFuture result2 = (KafkaFuture)result.result().get(new TopicPartition("replica-status-topic", 2));
            Assertions.assertNull((Object)result2);
        }
    }

    @Test
    public void testAlterConsumerGroupOffsets() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("foobar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
            responseData.put(tp1, Errors.NONE);
            responseData.put(tp2, Errors.NONE);
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetCommitResponse(0, responseData));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            offsets.put(tp2, new OffsetAndMetadata(456L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.partitionResult(tp1).get());
            Assertions.assertNull((Object)result.partitionResult(tp2).get());
            TestUtils.assertFutureThrows(IllegalArgumentException.class, result.partitionResult(tp3));
        }
    }

    @Test
    public void testAlterStreamsGroupOffsets() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("foobar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
            responseData.put(tp1, Errors.NONE);
            responseData.put(tp2, Errors.NONE);
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetCommitResponse(0, responseData));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            offsets.put(tp2, new OffsetAndMetadata(456L));
            AlterStreamsGroupOffsetsResult result = env.adminClient().alterStreamsGroupOffsets(GROUP_ID, offsets);
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.partitionResult(tp1).get());
            Assertions.assertNull((Object)result.partitionResult(tp2).get());
            TestUtils.assertFutureThrows(IllegalArgumentException.class, result.partitionResult(tp3));
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.COORDINATOR_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.COORDINATOR_LOAD_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.REBALANCE_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult result1 = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
            Assertions.assertNull((Object)result1.all().get());
            Assertions.assertNull((Object)result1.partitionResult(tp1).get());
        }
    }

    @Test
    public void testAlterStreamsGroupOffsetsRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.COORDINATOR_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.COORDINATOR_LOAD_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.REBALANCE_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterStreamsGroupOffsetsResult result1 = env.adminClient().alterStreamsGroupOffsets(GROUP_ID, offsets);
            Assertions.assertNull((Object)result1.all().get());
            Assertions.assertNull((Object)result1.partitionResult(tp1).get());
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsNonRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND, Errors.STALE_MEMBER_EPOCH);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, error));
                HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
                offsets.put(tp1, new OffsetAndMetadata(123L));
                AlterConsumerGroupOffsetsResult errorResult = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
                TestUtils.assertFutureThrows(error.exception().getClass(), errorResult.all());
                TestUtils.assertFutureThrows(error.exception().getClass(), errorResult.partitionResult(tp1));
            }
        }
    }

    @Test
    public void testAlterStreamsGroupOffsetsNonRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND, Errors.STALE_MEMBER_EPOCH);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, error));
                HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
                offsets.put(tp1, new OffsetAndMetadata(123L));
                AlterStreamsGroupOffsetsResult errorResult = env.adminClient().alterStreamsGroupOffsets(GROUP_ID, offsets);
                TestUtils.assertFutureThrows(error.exception().getClass(), errorResult.all());
                TestUtils.assertFutureThrows(error.exception().getClass(), errorResult.partitionResult(tp1));
            }
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsFindCoordinatorRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.partitionResult(tp1).get());
        }
    }

    @Test
    public void testAlterStreamsGroupOffsetsFindCoordinatorRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterStreamsGroupOffsetsResult result = env.adminClient().alterStreamsGroupOffsets(GROUP_ID, offsets);
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.partitionResult(tp1).get());
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsFindCoordinatorNonRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult errorResult = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
            TestUtils.assertFutureThrows(GroupAuthorizationException.class, errorResult.all());
            TestUtils.assertFutureThrows(GroupAuthorizationException.class, errorResult.partitionResult(tp1));
        }
    }

    @Test
    public void testResolveOffsetRange() throws Exception {
        String topic0 = "foo";
        String topic1 = "bar";
        HashMap<String, Uuid> nameToId = new HashMap<String, Uuid>();
        nameToId.put(topic0, Uuid.randomUuid());
        nameToId.put(topic1, Uuid.randomUuid());
        Uuid id0 = (Uuid)nameToId.get(topic0);
        TopicIdAndPartition tp0 = new TopicIdAndPartition(id0, 0);
        ResolveOffsetRangeSpec spec0 = new ResolveOffsetRangeSpec(100L);
        ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse response0 = new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse().setPartitionIndex(tp0.partition()).setBrokerRange(new ResolveOffsetRangeResponseData.BrokerMetadata().setStartOffset(100L).setEndOffset(200L));
        TopicIdAndPartition tp1 = new TopicIdAndPartition(id0, 2);
        ResolveOffsetRangeSpec spec1 = new ResolveOffsetRangeSpec(2L);
        ResolveOffsetRangeResponseData.SegmentFileMetadata tieredSegmentMetadata1 = new ResolveOffsetRangeResponseData.SegmentFileMetadata().setStartBytePosition(0L).setEndBytePosition(50L).setLocator("tiered-segment-1").setFragmentTypeByte(TieredFragmentType.SEGMENT.getByte());
        ResolveOffsetRangeResponseData.SegmentFileMetadata tieredOffsetIndexMetadata1 = new ResolveOffsetRangeResponseData.SegmentFileMetadata().setStartBytePosition(50L).setEndBytePosition(60L).setLocator("offset-index-1").setFragmentTypeByte(TieredFragmentType.OFFSET_INDEX.getByte());
        List<ResolveOffsetRangeResponseData.TieredSegmentMetadata> tieredSegments1 = Collections.singletonList(new ResolveOffsetRangeResponseData.TieredSegmentMetadata().setStartOffset(0L).setEndOffset(1000L).setSegmentFiles(Arrays.asList(tieredSegmentMetadata1, tieredOffsetIndexMetadata1)));
        ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse response1 = new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse().setPartitionIndex(tp1.partition()).setTieredSegmentRange(tieredSegments1).setBrokerRange(new ResolveOffsetRangeResponseData.BrokerMetadata().setStartOffset(1000L).setEndOffset(1200L));
        ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse topicResponse0 = new ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse().setTopicId(id0).setPartitions(Arrays.asList(response0, response1));
        Uuid id1 = (Uuid)nameToId.get(topic1);
        TopicIdAndPartition tp2 = new TopicIdAndPartition(id1, 5);
        ResolveOffsetRangeSpec spec2 = new ResolveOffsetRangeSpec(15L);
        ResolveOffsetRangeResponseData.SegmentFileMetadata tieredSegmentMetadata2 = new ResolveOffsetRangeResponseData.SegmentFileMetadata().setStartBytePosition(0L).setEndBytePosition(45L).setLocator("tiered-segment-2").setFragmentTypeByte(TieredFragmentType.SEGMENT.getByte());
        ResolveOffsetRangeResponseData.SegmentFileMetadata tieredOffsetIndexMetadata2 = new ResolveOffsetRangeResponseData.SegmentFileMetadata().setStartBytePosition(45L).setEndBytePosition(50L).setLocator("offset-index-2").setFragmentTypeByte(TieredFragmentType.OFFSET_INDEX.getByte());
        ArrayList<ResolveOffsetRangeResponseData.TieredSegmentMetadata> tieredSegments2 = new ArrayList<ResolveOffsetRangeResponseData.TieredSegmentMetadata>();
        tieredSegments2.add(new ResolveOffsetRangeResponseData.TieredSegmentMetadata().setStartOffset(0L).setEndOffset(1000L).setSegmentFiles(Arrays.asList(tieredSegmentMetadata1, tieredOffsetIndexMetadata1)));
        tieredSegments2.add(new ResolveOffsetRangeResponseData.TieredSegmentMetadata().setStartOffset(1000L).setEndOffset(1500L).setSegmentFiles(Arrays.asList(tieredSegmentMetadata2, tieredOffsetIndexMetadata2)));
        ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse response2 = new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse().setPartitionIndex(tp2.partition()).setTieredSegmentRange(tieredSegments2).setBrokerRange(new ResolveOffsetRangeResponseData.BrokerMetadata().setStartOffset(1500L).setEndOffset(1550L));
        ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse topicResponse1 = new ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse().setTopicId(id1).setPartitions(Collections.singletonList(response2));
        ResolveOffsetRangeResponseData responseData = new ResolveOffsetRangeResponseData().setTopics(Arrays.asList(topicResponse0, topicResponse1));
        Node node0 = new Node(0, "localhost", 8120);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo(topic0, tp0.partition(), node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo(topic0, tp1.partition(), node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo(topic1, tp2.partition(), node0, new Node[]{node0}, new Node[]{node0}));
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), pInfos, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), node0, nameToId);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            env.kafkaClient().prepareResponse((AbstractResponse)new ResolveOffsetRangeResponse(responseData));
            HashMap<TopicIdAndPartition, ResolveOffsetRangeSpec> topicPartitionOffsets = new HashMap<TopicIdAndPartition, ResolveOffsetRangeSpec>();
            topicPartitionOffsets.put(tp0, spec0);
            topicPartitionOffsets.put(tp1, spec1);
            topicPartitionOffsets.put(tp2, spec2);
            ResolveOffsetRangeResult result = env.adminClient().resolveOffsetRange(topicPartitionOffsets, new ResolveOffsetRangeOptions(IsolationLevel.READ_UNCOMMITTED, 3));
            ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo info0 = (ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo)result.partitionResult(tp0).get();
            Assertions.assertEquals((long)100L, (Long)((Long)info0.brokerStartOffset().get()));
            Assertions.assertEquals((long)200L, (Long)((Long)info0.brokerEndOffset().get()));
            ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo info1 = (ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo)result.partitionResult(tp1).get();
            List tieredRanges = info1.tieredRanges();
            Assertions.assertEquals((int)1, (int)tieredRanges.size());
            ResolveOffsetRangeResult.TieredRange tieredRange1 = (ResolveOffsetRangeResult.TieredRange)tieredRanges.get(0);
            Assertions.assertEquals((long)0L, (long)tieredRange1.startOffset());
            Assertions.assertEquals((long)1000L, (long)tieredRange1.endOffset());
            Assertions.assertEquals((Object)tieredSegmentMetadata1.locator(), (Object)tieredRange1.segmentFile().objectLocator());
            Assertions.assertEquals((long)tieredSegmentMetadata1.startBytePosition(), (long)tieredRange1.segmentFile().startPosition());
            Assertions.assertEquals((long)tieredSegmentMetadata1.endBytePosition(), (long)tieredRange1.segmentFile().endPosition());
            Assertions.assertEquals((byte)tieredSegmentMetadata1.fragmentTypeByte(), (byte)tieredRange1.segmentFile().fragmentType().getByte());
            Assertions.assertEquals((Object)tieredOffsetIndexMetadata1.locator(), (Object)tieredRange1.offsetIndex().objectLocator());
            Assertions.assertEquals((long)tieredOffsetIndexMetadata1.startBytePosition(), (long)tieredRange1.offsetIndex().startPosition());
            Assertions.assertEquals((long)tieredOffsetIndexMetadata1.endBytePosition(), (long)tieredRange1.offsetIndex().endPosition());
            Assertions.assertEquals((byte)tieredOffsetIndexMetadata1.fragmentTypeByte(), (byte)tieredRange1.offsetIndex().fragmentType().getByte());
            Assertions.assertFalse((boolean)tieredRange1.transactionIndex().isPresent());
            Assertions.assertEquals((long)1000L, (Long)((Long)info1.brokerStartOffset().get()));
            Assertions.assertEquals((long)1200L, (Long)((Long)info1.brokerEndOffset().get()));
            tieredRanges = ((ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo)result.partitionResult(tp2).get()).tieredRanges();
            Assertions.assertEquals((int)2, (int)tieredRanges.size());
            tieredRange1 = tieredRanges.stream().filter(t -> t.startOffset() == 0L).findFirst().get();
            Assertions.assertEquals((long)1000L, (long)tieredRange1.endOffset());
            Assertions.assertEquals((Object)tieredSegmentMetadata1.locator(), (Object)tieredRange1.segmentFile().objectLocator());
            Assertions.assertEquals((long)tieredSegmentMetadata1.startBytePosition(), (long)tieredRange1.segmentFile().startPosition());
            Assertions.assertEquals((long)tieredSegmentMetadata1.endBytePosition(), (long)tieredRange1.segmentFile().endPosition());
            Assertions.assertEquals((byte)tieredSegmentMetadata1.fragmentTypeByte(), (byte)tieredRange1.segmentFile().fragmentType().getByte());
            Assertions.assertEquals((Object)tieredOffsetIndexMetadata1.locator(), (Object)tieredRange1.offsetIndex().objectLocator());
            Assertions.assertEquals((long)tieredOffsetIndexMetadata1.startBytePosition(), (long)tieredRange1.offsetIndex().startPosition());
            Assertions.assertEquals((long)tieredOffsetIndexMetadata1.endBytePosition(), (long)tieredRange1.offsetIndex().endPosition());
            Assertions.assertEquals((byte)tieredOffsetIndexMetadata1.fragmentTypeByte(), (byte)tieredRange1.offsetIndex().fragmentType().getByte());
            ResolveOffsetRangeResult.TieredRange tieredRange2 = tieredRanges.stream().filter(t -> t.startOffset() == 1000L).findFirst().get();
            Assertions.assertEquals((long)1000L, (long)tieredRange2.startOffset());
            Assertions.assertEquals((long)1500L, (long)tieredRange2.endOffset());
            Assertions.assertEquals((Object)tieredSegmentMetadata2.locator(), (Object)tieredRange2.segmentFile().objectLocator());
            Assertions.assertEquals((Object)tieredOffsetIndexMetadata2.locator(), (Object)tieredRange2.offsetIndex().objectLocator());
            Assertions.assertFalse((boolean)tieredRange2.transactionIndex().isPresent());
            Assertions.assertEquals((long)1500L, (Long)((Long)((ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo)result.partitionResult(tp2).get()).brokerStartOffset().get()));
            Assertions.assertEquals((long)1550L, (Long)((Long)((ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo)result.partitionResult(tp2).get()).brokerEndOffset().get()));
        }
    }

    @Test
    public void testResolveOffsetRangeRetriableErrors() throws Exception {
        String topic = "foo";
        Uuid topicId = Uuid.randomUuid();
        HashMap<String, Uuid> nameToId = new HashMap<String, Uuid>();
        nameToId.put(topic, topicId);
        TopicIdAndPartition tp0 = new TopicIdAndPartition(topicId, 0);
        ResolveOffsetRangeSpec spec0 = new ResolveOffsetRangeSpec(10L);
        ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse response0 = new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse().setPartitionIndex(tp0.partition()).setErrorCode(Errors.LEADER_NOT_AVAILABLE.code());
        TopicIdAndPartition tp1 = new TopicIdAndPartition(topicId, 1);
        ResolveOffsetRangeSpec spec1 = new ResolveOffsetRangeSpec(10L);
        ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse response1 = new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse().setPartitionIndex(tp1.partition()).setErrorCode(Errors.REQUEST_TIMED_OUT.code());
        ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse topicResponse = new ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse().setTopicId(topicId).setPartitions(Arrays.asList(response0, response1));
        ResolveOffsetRangeResponseData errorResponse = new ResolveOffsetRangeResponseData().setTopics(Arrays.asList(topicResponse));
        ResolveOffsetRangeResponseData.SegmentFileMetadata tieredSegmentMetadata = new ResolveOffsetRangeResponseData.SegmentFileMetadata().setStartBytePosition(0L).setEndBytePosition(50L).setLocator("tiered-segment").setFragmentTypeByte(TieredFragmentType.SEGMENT.getByte());
        ResolveOffsetRangeResponseData.SegmentFileMetadata tieredOffsetIndexMetadata = new ResolveOffsetRangeResponseData.SegmentFileMetadata().setStartBytePosition(50L).setEndBytePosition(60L).setLocator("offset-index").setFragmentTypeByte(TieredFragmentType.OFFSET_INDEX.getByte());
        List<ResolveOffsetRangeResponseData.TieredSegmentMetadata> tieredSegments = Collections.singletonList(new ResolveOffsetRangeResponseData.TieredSegmentMetadata().setStartOffset(0L).setEndOffset(1000L).setSegmentFiles(Arrays.asList(tieredSegmentMetadata, tieredOffsetIndexMetadata)));
        ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse successResponse0 = new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse().setPartitionIndex(tp0.partition()).setTieredSegmentRange(tieredSegments);
        ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse successResponse1 = new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse().setPartitionIndex(tp1.partition()).setBrokerRange(new ResolveOffsetRangeResponseData.BrokerMetadata().setStartOffset(100L).setEndOffset(200L));
        topicResponse = new ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse().setTopicId(topicId).setPartitions(Arrays.asList(successResponse0, successResponse1));
        ResolveOffsetRangeResponseData retryResponse = new ResolveOffsetRangeResponseData().setTopics(Arrays.asList(topicResponse));
        Node node0 = new Node(0, "localhost", 8120);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo(topic, tp0.partition(), node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo(topic, tp1.partition(), node0, new Node[]{node0}, new Node[]{node0}));
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), pInfos, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), node0, nameToId);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            env.kafkaClient().prepareResponse((AbstractResponse)new ResolveOffsetRangeResponse(errorResponse));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            env.kafkaClient().prepareResponse((AbstractResponse)new ResolveOffsetRangeResponse(retryResponse));
            HashMap<TopicIdAndPartition, ResolveOffsetRangeSpec> topicPartitionOffsets = new HashMap<TopicIdAndPartition, ResolveOffsetRangeSpec>();
            topicPartitionOffsets.put(tp0, spec0);
            topicPartitionOffsets.put(tp1, spec1);
            ResolveOffsetRangeResult result = env.adminClient().resolveOffsetRange(topicPartitionOffsets, new ResolveOffsetRangeOptions(IsolationLevel.READ_UNCOMMITTED, 2));
            List tieredRanges = ((ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo)result.partitionResult(tp0).get()).tieredRanges();
            Assertions.assertEquals((int)1, (int)tieredRanges.size());
            ResolveOffsetRangeResult.TieredRange tieredRange = (ResolveOffsetRangeResult.TieredRange)tieredRanges.get(0);
            Assertions.assertEquals((long)0L, (long)tieredRange.startOffset());
            Assertions.assertEquals((long)1000L, (long)tieredRange.endOffset());
            Assertions.assertEquals((Object)tieredSegmentMetadata.locator(), (Object)tieredRange.segmentFile().objectLocator());
            Assertions.assertEquals((long)tieredSegmentMetadata.startBytePosition(), (long)tieredRange.segmentFile().startPosition());
            Assertions.assertEquals((long)tieredSegmentMetadata.endBytePosition(), (long)tieredRange.segmentFile().endPosition());
            Assertions.assertEquals((byte)tieredSegmentMetadata.fragmentTypeByte(), (byte)tieredRange.segmentFile().fragmentType().getByte());
            Assertions.assertEquals((Object)tieredOffsetIndexMetadata.locator(), (Object)tieredRange.offsetIndex().objectLocator());
            Assertions.assertEquals((long)tieredOffsetIndexMetadata.startBytePosition(), (long)tieredRange.offsetIndex().startPosition());
            Assertions.assertEquals((long)tieredOffsetIndexMetadata.endBytePosition(), (long)tieredRange.offsetIndex().endPosition());
            Assertions.assertEquals((byte)tieredOffsetIndexMetadata.fragmentTypeByte(), (byte)tieredRange.offsetIndex().fragmentType().getByte());
            Assertions.assertFalse((boolean)tieredRange.transactionIndex().isPresent());
            ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo info1 = (ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo)result.partitionResult(tp1).get();
            Assertions.assertEquals((int)0, (int)info1.tieredRanges().size());
            Assertions.assertEquals((long)successResponse1.brokerRange().startOffset(), (Long)((Long)info1.brokerStartOffset().get()));
            Assertions.assertEquals((long)successResponse1.brokerRange().endOffset(), (Long)((Long)info1.brokerEndOffset().get()));
        }
    }

    @Test
    public void testResolveOffsetRangeNonRetriableErrors() throws Exception {
        String topic = "foo";
        Uuid topicId = Uuid.randomUuid();
        HashMap<String, Uuid> nameToId = new HashMap<String, Uuid>();
        nameToId.put(topic, topicId);
        TopicIdAndPartition tp0 = new TopicIdAndPartition(topicId, 0);
        ResolveOffsetRangeSpec spec0 = new ResolveOffsetRangeSpec(10L);
        String errorMsg0 = "tp0-error";
        ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse response0 = new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse().setPartitionIndex(tp0.partition()).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(errorMsg0);
        TopicIdAndPartition tp1 = new TopicIdAndPartition(topicId, 1);
        ResolveOffsetRangeSpec spec1 = new ResolveOffsetRangeSpec(10L);
        String errorMsg1 = "tp1-error";
        ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse response1 = new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse().setPartitionIndex(tp1.partition()).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage(errorMsg1);
        ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse topicResponse = new ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse().setTopicId(topicId).setPartitions(Arrays.asList(response0, response1));
        ResolveOffsetRangeResponseData responseData = new ResolveOffsetRangeResponseData().setTopics(Arrays.asList(topicResponse));
        Node node0 = new Node(0, "localhost", 8120);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo(topic, tp0.partition(), node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo(topic, tp1.partition(), node0, new Node[]{node0}, new Node[]{node0}));
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), pInfos, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), node0, nameToId);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            env.kafkaClient().prepareResponse((AbstractResponse)new ResolveOffsetRangeResponse(responseData));
            HashMap<TopicIdAndPartition, ResolveOffsetRangeSpec> topicPartitionOffsets = new HashMap<TopicIdAndPartition, ResolveOffsetRangeSpec>();
            topicPartitionOffsets.put(tp0, spec0);
            topicPartitionOffsets.put(tp1, spec1);
            ResolveOffsetRangeResult result = env.adminClient().resolveOffsetRange(topicPartitionOffsets, new ResolveOffsetRangeOptions(IsolationLevel.READ_UNCOMMITTED, 2));
            Exception e0 = (Exception)Assertions.assertThrows(TopicAuthorizationException.class, () -> {
                try {
                    result.partitionResult(tp0).get();
                }
                catch (Exception e) {
                    throw e.getCause();
                }
            });
            Assertions.assertEquals((Object)errorMsg0, (Object)e0.getMessage());
            Exception e1 = (Exception)Assertions.assertThrows(ClusterAuthorizationException.class, () -> {
                try {
                    result.partitionResult(tp1).get();
                }
                catch (Exception e) {
                    throw e.getCause();
                }
            });
            Assertions.assertEquals((Object)errorMsg1, (Object)e1.getMessage());
        }
    }

    @Test
    public void testAlterStreamsGroupOffsetsFindCoordinatorNonRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterStreamsGroupOffsetsResult errorResult = env.adminClient().alterStreamsGroupOffsets(GROUP_ID, offsets);
            TestUtils.assertFutureThrows(GroupAuthorizationException.class, errorResult.all());
            TestUtils.assertFutureThrows(GroupAuthorizationException.class, errorResult.partitionResult(tp1));
        }
    }

    @Test
    public void testListOffsets() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("bar", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("baz", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("qux", 0, node0, new Node[]{node0}, new Node[]{node0}));
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("bar", 0);
        TopicPartition tp2 = new TopicPartition("baz", 0);
        TopicPartition tp3 = new TopicPartition("qux", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)123L, (int)321);
            ListOffsetsResponseData.ListOffsetsTopicResponse t1 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)234L, (int)432);
            ListOffsetsResponseData.ListOffsetsTopicResponse t2 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp2, (Errors)Errors.NONE, (long)123456789L, (long)345L, (int)543);
            ListOffsetsResponseData.ListOffsetsTopicResponse t3 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp3, (Errors)Errors.NONE, (long)234567890L, (long)456L, (int)654);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0, t1, t2, t3));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetsResponse(responseData));
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.earliest());
            partitions.put(tp2, OffsetSpec.forTimestamp((long)System.currentTimeMillis()));
            partitions.put(tp3, OffsetSpec.maxTimestamp());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assertions.assertFalse((boolean)offsets.isEmpty());
            Assertions.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assertions.assertEquals((int)321, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assertions.assertEquals((long)234L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assertions.assertEquals((int)432, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
            Assertions.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).offset());
            Assertions.assertEquals((int)543, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).leaderEpoch().get()));
            Assertions.assertEquals((long)123456789L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).timestamp());
            Assertions.assertEquals((long)456L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp3)).offset());
            Assertions.assertEquals((int)654, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp3)).leaderEpoch().get()));
            Assertions.assertEquals((long)234567890L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp3)).timestamp());
            Assertions.assertEquals(offsets.get(tp0), (Object)result.partitionResult(tp0).get());
            Assertions.assertEquals(offsets.get(tp1), (Object)result.partitionResult(tp1).get());
            Assertions.assertEquals(offsets.get(tp2), (Object)result.partitionResult(tp2).get());
            Assertions.assertEquals(offsets.get(tp3), (Object)result.partitionResult(tp3).get());
            Assertions.assertThrows(IllegalArgumentException.class, () -> result.partitionResult(new TopicPartition("unknown", 0)).get());
        }
    }

    @Test
    public void testListOffsetsRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        pInfos.add(new PartitionInfo("foo", 1, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        pInfos.add(new PartitionInfo("bar", 0, node1, new Node[]{node1, node0}, new Node[]{node1, node0}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.LEADER_NOT_AVAILABLE, (long)-1L, (long)123L, (int)321);
            ListOffsetsResponseData.ListOffsetsTopicResponse t1 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)987L, (int)789);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0, t1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node0);
            ListOffsetsResponseData.ListOffsetsTopicResponse t2 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp2, (Errors)Errors.NONE, (long)-1L, (long)456L, (int)654);
            responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(t2));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node1);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node0);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            partitions.put(tp2, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assertions.assertFalse((boolean)offsets.isEmpty());
            Assertions.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assertions.assertEquals((int)543, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assertions.assertEquals((long)987L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assertions.assertEquals((int)789, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
            Assertions.assertEquals((long)456L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).offset());
            Assertions.assertEquals((int)654, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).timestamp());
        }
    }

    @Test
    public void testListOffsetsNonRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.TOPIC_AUTHORIZATION_FAILED, (long)-1L, (long)-1L, (int)-1);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(t0));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetsResponse(responseData));
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            TestUtils.assertFutureThrows(TopicAuthorizationException.class, result.all());
        }
    }

    @Test
    public void testListOffsetsMaxTimestampUnsupportedSingleOffsetSpec() {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        Cluster cluster = new Cluster("mockClusterId", nodes, Collections.singleton(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node})), Collections.emptySet(), Collections.emptySet(), node);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.LIST_OFFSETS.id, (short)0, (short)6));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ListOffsetsRequest);
            ListOffsetsResult result = env.adminClient().listOffsets(Collections.singletonMap(tp0, OffsetSpec.maxTimestamp()));
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.all());
        }
    }

    @Test
    public void testListOffsetsMaxTimestampUnsupportedMultipleOffsetSpec() throws Exception {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node}));
        pInfos.add(new PartitionInfo("foo", 1, node, new Node[]{node}, new Node[]{node}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.LIST_OFFSETS.id, (short)0, (short)6));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ListOffsetsRequest);
            ListOffsetsResponseData.ListOffsetsTopicResponse topicResponse = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(topicResponse));
            env.kafkaClient().prepareResponseFrom(request -> request instanceof ListOffsetsRequest && ((ListOffsetsRequest)request).topics().stream().flatMap(t -> t.partitions().stream()).noneMatch(p -> p.timestamp() == -3L), (AbstractResponse)new ListOffsetsResponse(responseData), node);
            ListOffsetsResult result = env.adminClient().listOffsets(Map.of(tp0, OffsetSpec.maxTimestamp(), tp1, OffsetSpec.latest()));
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.partitionResult(tp0));
            ListOffsetsResult.ListOffsetsResultInfo tp1Offset = (ListOffsetsResult.ListOffsetsResultInfo)result.partitionResult(tp1).get();
            Assertions.assertEquals((long)345L, (long)tp1Offset.offset());
            Assertions.assertEquals((int)543, (int)((Integer)tp1Offset.leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)tp1Offset.timestamp());
        }
    }

    @Test
    public void testListOffsetsHandlesFulfillmentTimeouts() throws Exception {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node}));
        pInfos.add(new PartitionInfo("foo", 1, node, new Node[]{node}, new Node[]{node}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        int numRetries = 2;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, "retries", Integer.toString(numRetries));){
            ListOffsetsResponseData.ListOffsetsTopicResponse tp0ErrorResponse = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.REQUEST_TIMED_OUT, (long)-1L, (long)-1L, (int)-1);
            ListOffsetsResponseData.ListOffsetsTopicResponse tp1Response = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            ListOffsetsResponseData responseDataWithError = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(tp0ErrorResponse, tp1Response));
            ListOffsetsResponseData.ListOffsetsTopicResponse tp0Response = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)789L, (int)987);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(tp0Response, tp1Response));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            for (int i = 0; i < numRetries + 1; ++i) {
                env.kafkaClient().prepareResponseFrom(request -> request instanceof ListOffsetsRequest, (AbstractResponse)new ListOffsetsResponse(responseDataWithError), node);
            }
            ListOffsetsResult result = env.adminClient().listOffsets(Map.of(tp0, OffsetSpec.latest(), tp1, OffsetSpec.latest()));
            TestUtils.assertFutureThrows(TimeoutException.class, result.partitionResult(tp0));
            ListOffsetsResult.ListOffsetsResultInfo tp1Result = (ListOffsetsResult.ListOffsetsResultInfo)result.partitionResult(tp1).get();
            Assertions.assertEquals((long)345L, (long)tp1Result.offset());
            Assertions.assertEquals((int)543, (int)((Integer)tp1Result.leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)tp1Result.timestamp());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            for (int i = 0; i < numRetries; ++i) {
                env.kafkaClient().prepareResponseFrom(request -> request instanceof ListOffsetsRequest, (AbstractResponse)new ListOffsetsResponse(responseDataWithError), node);
            }
            env.kafkaClient().prepareResponseFrom(request -> request instanceof ListOffsetsRequest, (AbstractResponse)new ListOffsetsResponse(responseData), node);
            result = env.adminClient().listOffsets(Map.of(tp0, OffsetSpec.latest(), tp1, OffsetSpec.latest()));
            ListOffsetsResult.ListOffsetsResultInfo tp0Result = (ListOffsetsResult.ListOffsetsResultInfo)result.partitionResult(tp0).get();
            Assertions.assertEquals((long)789L, (long)tp0Result.offset());
            Assertions.assertEquals((int)987, (int)((Integer)tp0Result.leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)tp0Result.timestamp());
            tp1Result = (ListOffsetsResult.ListOffsetsResultInfo)result.partitionResult(tp1).get();
            Assertions.assertEquals((long)345L, (long)tp1Result.offset());
            Assertions.assertEquals((int)543, (int)((Integer)tp1Result.leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)tp1Result.timestamp());
        }
    }

    @Test
    public void testListOffsetsUnsupportedNonMaxTimestamp() {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.LIST_OFFSETS.id, (short)0, (short)0));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ListOffsetsRequest);
            ListOffsetsResult result = env.adminClient().listOffsets(Collections.singletonMap(tp0, OffsetSpec.latest()));
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.partitionResult(tp0));
        }
    }

    @Test
    public void testListOffsetsNonMaxTimestampDowngradedImmediately() throws Exception {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.LIST_OFFSETS.id, (short)0, (short)6));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)123L, (int)321);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(t0));
            env.kafkaClient().prepareResponse(request -> request instanceof ListOffsetsRequest, (AbstractResponse)new ListOffsetsResponse(responseData));
            ListOffsetsResult result = env.adminClient().listOffsets(Collections.singletonMap(tp0, OffsetSpec.latest()));
            ListOffsetsResult.ListOffsetsResultInfo tp0Offset = (ListOffsetsResult.ListOffsetsResultInfo)result.partitionResult(tp0).get();
            Assertions.assertEquals((long)123L, (long)tp0Offset.offset());
            Assertions.assertEquals((int)321, (int)((Integer)tp0Offset.leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)tp0Offset.timestamp());
        }
    }

    @Test
    public void testListOffsetsEarliestLocalSpecMinVersion() throws Exception {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.adminClient().listOffsets(Collections.singletonMap(tp0, OffsetSpec.earliestLocal()));
            TestUtils.waitForCondition(() -> env.kafkaClient().requests().stream().anyMatch(request -> request.requestBuilder().apiKey().messageType == ApiMessageType.LIST_OFFSETS && request.requestBuilder().oldestAllowedVersion() == 8), "no listOffsets request has the expected oldestAllowedVersion");
        }
    }

    @Test
    public void testListOffsetsLatestTierSpecSpecMinVersion() throws Exception {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.adminClient().listOffsets(Collections.singletonMap(tp0, OffsetSpec.latestTiered()));
            TestUtils.waitForCondition(() -> env.kafkaClient().requests().stream().anyMatch(request -> request.requestBuilder().apiKey().messageType == ApiMessageType.LIST_OFFSETS && request.requestBuilder().oldestAllowedVersion() == 9), "no listOffsets request has the expected oldestAllowedVersion");
        }
    }

    private Map<String, FeatureUpdate> makeTestFeatureUpdates() {
        return Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)new FeatureUpdate(2, FeatureUpdate.UpgradeType.UPGRADE)), Utils.mkEntry((Object)"test_feature_2", (Object)new FeatureUpdate(3, FeatureUpdate.UpgradeType.SAFE_DOWNGRADE))});
    }

    private void testUpdateFeatures(Map<String, FeatureUpdate> featureUpdates, ApiError topLevelError, Set<String> updates) throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponse(body -> body instanceof UpdateFeaturesRequest, (AbstractResponse)UpdateFeaturesResponse.createWithErrors((ApiError)topLevelError, updates, (int)0));
            Map futures = env.adminClient().updateFeatures(featureUpdates, (UpdateFeaturesOptions)new UpdateFeaturesOptions().timeoutMs(Integer.valueOf(10000))).values();
            for (Map.Entry entry : futures.entrySet()) {
                KafkaFuture future = (KafkaFuture)entry.getValue();
                if (topLevelError.error() == Errors.NONE) {
                    future.get();
                    continue;
                }
                ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)future).get());
                Assertions.assertEquals(e.getCause().getClass(), topLevelError.exception().getClass());
                Assertions.assertEquals((Object)e.getCause().getMessage(), (Object)topLevelError.exception().getMessage());
            }
        }
    }

    @ParameterizedTest
    @ValueSource(shorts={1, 2})
    public void testUpdateFeaturesDuringSuccess(short version) throws Exception {
        Map<String, FeatureUpdate> updates = this.makeTestFeatureUpdates();
        Set<String> features = version <= 1 ? updates.keySet() : Set.of();
        this.testUpdateFeatures(updates, ApiError.NONE, features);
    }

    @Test
    public void testUpdateFeaturesTopLevelError() throws Exception {
        Map<String, FeatureUpdate> updates = this.makeTestFeatureUpdates();
        this.testUpdateFeatures(updates, new ApiError(Errors.INVALID_REQUEST), Set.of());
    }

    @ParameterizedTest
    @ValueSource(shorts={1, 2})
    public void testUpdateFeaturesHandleNotControllerException(short version) throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponseFrom(request -> request instanceof UpdateFeaturesRequest, (AbstractResponse)UpdateFeaturesResponse.createWithErrors((ApiError)new ApiError(Errors.NOT_CONTROLLER), Set.of(), (int)0), env.cluster().nodeById(0));
            boolean controllerId = true;
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 1, Collections.emptyList()));
            Set features = version <= 1 ? Set.of("test_feature_1", "test_feature_2") : Set.of();
            env.kafkaClient().prepareResponseFrom(request -> request instanceof UpdateFeaturesRequest, (AbstractResponse)UpdateFeaturesResponse.createWithErrors((ApiError)ApiError.NONE, features, (int)0), env.cluster().nodeById(1));
            KafkaFuture future = env.adminClient().updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)new FeatureUpdate(2, FeatureUpdate.UpgradeType.UPGRADE)), Utils.mkEntry((Object)"test_feature_2", (Object)new FeatureUpdate(3, FeatureUpdate.UpgradeType.SAFE_DOWNGRADE))}), (UpdateFeaturesOptions)new UpdateFeaturesOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testUpdateFeaturesShouldFailRequestForEmptyUpdates() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> env.adminClient().updateFeatures(new HashMap(), new UpdateFeaturesOptions()));
        }
    }

    @Test
    public void testUpdateFeaturesShouldFailRequestForInvalidFeatureName() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> env.adminClient().updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature", (Object)new FeatureUpdate(2, FeatureUpdate.UpgradeType.UPGRADE)), Utils.mkEntry((Object)"", (Object)new FeatureUpdate(2, FeatureUpdate.UpgradeType.UPGRADE))}), new UpdateFeaturesOptions()));
        }
    }

    @Test
    public void testUpdateFeaturesShouldFailRequestInClientWhenDowngradeFlagIsNotSetDuringDeletion() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FeatureUpdate(0, FeatureUpdate.UpgradeType.UPGRADE));
    }

    @Test
    public void testDescribeFeaturesSuccess() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponse(body -> body instanceof ApiVersionsRequest, (AbstractResponse)KafkaAdminClientTest.prepareApiVersionsResponseForDescribeFeatures(Errors.NONE));
            KafkaFuture future = env.adminClient().describeFeatures((DescribeFeaturesOptions)new DescribeFeaturesOptions().timeoutMs(Integer.valueOf(10000))).featureMetadata();
            FeatureMetadata metadata = (FeatureMetadata)future.get();
            Assertions.assertEquals((Object)KafkaAdminClientTest.defaultFeatureMetadata(), (Object)metadata);
        }
    }

    @Test
    public void testDescribeFeaturesFailure() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponse(body -> body instanceof ApiVersionsRequest, (AbstractResponse)KafkaAdminClientTest.prepareApiVersionsResponseForDescribeFeatures(Errors.INVALID_REQUEST));
            DescribeFeaturesOptions options = new DescribeFeaturesOptions();
            options.timeoutMs(Integer.valueOf(10000));
            KafkaFuture future = env.adminClient().describeFeatures(options).featureMetadata();
            ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)future).get());
            Assertions.assertEquals(Errors.INVALID_REQUEST.exception().getClass(), e.getCause().getClass());
        }
    }

    @Test
    public void testListOffsetsMetadataRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("foo", 1, node1, new Node[]{node1}, new Node[]{node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.LEADER_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE, Errors.UNKNOWN_TOPIC_OR_PARTITION));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node0);
            ListOffsetsResponseData.ListOffsetsTopicResponse t1 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)789L, (int)987);
            responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(t1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node1);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assertions.assertFalse((boolean)offsets.isEmpty());
            Assertions.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assertions.assertEquals((int)543, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assertions.assertEquals((long)789L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assertions.assertEquals((int)987, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
        }
    }

    @Test
    public void testListOffsetsWithMultiplePartitionsLeaderChange() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        Node node2 = new Node(2, "localhost", 8122);
        List<Node> nodes = Arrays.asList(node0, node1, node2);
        PartitionInfo oldPInfo1 = new PartitionInfo("foo", 0, node0, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
        PartitionInfo oldPnfo2 = new PartitionInfo("foo", 1, node0, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
        List<PartitionInfo> oldPInfos = Arrays.asList(oldPInfo1, oldPnfo2);
        Cluster oldCluster = new Cluster("mockClusterId", nodes, oldPInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(oldCluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(oldCluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NOT_LEADER_OR_FOLLOWER, (long)-1L, (long)345L, (int)543);
            ListOffsetsResponseData.ListOffsetsTopicResponse t1 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.LEADER_NOT_AVAILABLE, (long)-2L, (long)123L, (int)456);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0, t1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node0);
            PartitionInfo newPInfo1 = new PartitionInfo("foo", 0, node1, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
            PartitionInfo newPInfo2 = new PartitionInfo("foo", 1, node2, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
            List<PartitionInfo> newPInfos = Arrays.asList(newPInfo1, newPInfo2);
            Cluster newCluster = new Cluster("mockClusterId", nodes, newPInfos, Collections.emptySet(), Collections.emptySet(), node0);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(newCluster, Errors.NONE));
            t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node1);
            t1 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-2L, (long)123L, (int)456);
            responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(t1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node2);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assertions.assertFalse((boolean)offsets.isEmpty());
            Assertions.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assertions.assertEquals((int)543, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assertions.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assertions.assertEquals((int)456, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()));
            Assertions.assertEquals((long)-2L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
        }
    }

    @Test
    public void testListOffsetsWithLeaderChange() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        Node node2 = new Node(2, "localhost", 8122);
        List<Node> nodes = Arrays.asList(node0, node1, node2);
        PartitionInfo oldPartitionInfo = new PartitionInfo("foo", 0, node0, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
        Cluster oldCluster = new Cluster("mockClusterId", nodes, Collections.singletonList(oldPartitionInfo), Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(oldCluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(oldCluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NOT_LEADER_OR_FOLLOWER, (long)-1L, (long)345L, (int)543);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node0);
            PartitionInfo newPartitionInfo = new PartitionInfo("foo", 0, node1, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
            Cluster newCluster = new Cluster("mockClusterId", nodes, Collections.singletonList(newPartitionInfo), Collections.emptySet(), Collections.emptySet(), node0);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(newCluster, Errors.NONE));
            t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-2L, (long)123L, (int)456);
            responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node1);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assertions.assertFalse((boolean)offsets.isEmpty());
            Assertions.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assertions.assertEquals((int)456, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()));
            Assertions.assertEquals((long)-2L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"listOffsetsMetadataNonRetriableErrors"})
    public void testListOffsetsMetadataNonRetriableErrors(Errors topicMetadataError, Errors partitionMetadataError, Class<? extends Throwable> expectedFailure) throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp1 = new TopicPartition("foo", 0);
        MetadataResponse preparedResponse = KafkaAdminClientTest.prepareMetadataResponse(cluster, topicMetadataError, partitionMetadataError);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)preparedResponse);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            TestUtils.assertFutureThrows(expectedFailure, result.all());
        }
    }

    private static Stream<Arguments> listOffsetsMetadataNonRetriableErrors() {
        return Stream.of(Arguments.of((Object[])new Object[]{Errors.TOPIC_AUTHORIZATION_FAILED, Errors.TOPIC_AUTHORIZATION_FAILED, TopicAuthorizationException.class}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.NONE, UnknownTopicOrPartitionException.class}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.UNKNOWN_TOPIC_OR_PARTITION, UnknownTopicOrPartitionException.class}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.LEADER_NOT_AVAILABLE, UnknownTopicOrPartitionException.class}));
    }

    @Test
    public void testCreateClusterLinks() throws Exception {
        Node node0 = new Node(0, "localhost", 8121);
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), node0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("link.test", "TODO");
            ArrayList<NewClusterLink> newClusterLinks = new ArrayList<NewClusterLink>();
            newClusterLinks.add(new NewClusterLink("cluster-1", "cluster-id-1", Collections.emptyMap()));
            newClusterLinks.add(new NewClusterLink("cluster-2a", "cluster-id-2", Collections.emptyMap()));
            newClusterLinks.add(new NewClusterLink("cluster-2b", "cluster-id-2", configs));
            newClusterLinks.add(new NewClusterLink("cluster-3", null, Collections.emptyMap()));
            newClusterLinks.add(new NewClusterLink("cluster+4", "cluster-id-4", Collections.singletonMap("test", null)));
            HashMap<String, CreateClusterLinksResponse.ApiErrorAndOriginalThrowable> responseData = new HashMap<String, CreateClusterLinksResponse.ApiErrorAndOriginalThrowable>(newClusterLinks.size());
            for (NewClusterLink newClusterLink : newClusterLinks) {
                responseData.put(newClusterLink.linkName(), new CreateClusterLinksResponse.ApiErrorAndOriginalThrowable(ApiError.NONE, null));
            }
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateClusterLinksResponse(responseData, 0));
            CreateClusterLinksResult result = env.adminClient().createClusterLinks(newClusterLinks, new CreateClusterLinksOptions());
            Assertions.assertEquals((int)newClusterLinks.size(), (int)result.result().size());
            for (NewClusterLink newClusterLink : newClusterLinks) {
                KafkaFuture future = (KafkaFuture)result.result().get(newClusterLink.linkName());
                Assertions.assertTrue((future != null ? 1 : 0) != 0);
                future.get();
            }
            String string = TestUtils.randomString(32768);
            newClusterLinks.add(new NewClusterLink("cluster+5", "cluster-id-5", Collections.singletonMap("ssl.truststore.certificates", string)));
            InvalidRequestException e = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> env.adminClient().createClusterLinks((Collection)newClusterLinks, new CreateClusterLinksOptions()));
            Assertions.assertEquals((Object)"Configuration value for 'ssl.truststore.certificates' for cluster link 'cluster+5' is too long, max size is 32767, provided size is 32768.", (Object)e.getMessage());
            newClusterLinks.remove(newClusterLinks.size() - 1);
            newClusterLinks.add(new NewClusterLink("cluster+5", "cluster-id-5", Collections.singletonMap(string, "value")));
            e = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> env.adminClient().createClusterLinks((Collection)newClusterLinks, new CreateClusterLinksOptions()));
            Assertions.assertEquals((Object)("Configuration name '" + string + "' for cluster link 'cluster+5' is too long, max size is 32767, provided size is 32768."), (Object)e.getMessage());
            newClusterLinks.remove(newClusterLinks.size() - 1);
            newClusterLinks.add(new NewClusterLink("cluster+5", "cluster-id-5", Collections.singletonMap("config1", TestUtils.randomString(Short.MAX_VALUE))));
            responseData.put("cluster+5", new CreateClusterLinksResponse.ApiErrorAndOriginalThrowable(ApiError.NONE, null));
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateClusterLinksResponse(responseData, 0));
            result = env.adminClient().createClusterLinks(newClusterLinks, new CreateClusterLinksOptions());
            Assertions.assertEquals((int)newClusterLinks.size(), (int)result.result().size());
            for (NewClusterLink newClusterLink : newClusterLinks) {
                KafkaFuture future = (KafkaFuture)result.result().get(newClusterLink.linkName());
                Assertions.assertTrue((future != null ? 1 : 0) != 0);
                future.get();
            }
        }
    }

    @Test
    public void testCreateClusterLinksRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8121);
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), node0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String linkName = "cluster";
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateClusterLinksResponse(Collections.singletonList(linkName), 0, (Throwable)Errors.NOT_CONTROLLER.exception()));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), Collections.emptyList()));
            ArrayList<NewClusterLink> newClusterLinks = new ArrayList<NewClusterLink>();
            newClusterLinks.add(new NewClusterLink(linkName, "cluster-id", Collections.emptyMap()));
            HashMap<String, CreateClusterLinksResponse.ApiErrorAndOriginalThrowable> responseData = new HashMap<String, CreateClusterLinksResponse.ApiErrorAndOriginalThrowable>(1);
            responseData.put(linkName, new CreateClusterLinksResponse.ApiErrorAndOriginalThrowable(ApiError.NONE, null));
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateClusterLinksResponse(responseData, 0));
            CreateClusterLinksResult result = env.adminClient().createClusterLinks(newClusterLinks, new CreateClusterLinksOptions());
            Assertions.assertEquals((int)1, (int)result.result().size());
            KafkaFuture future = (KafkaFuture)result.result().get(linkName);
            Assertions.assertTrue((future != null ? 1 : 0) != 0);
            future.get();
        }
    }

    @Test
    public void testCreateClusterLinksNonRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8121);
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), node0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String linkNameExists = "cluster-exists";
            String linkNameAuthorizationFailed = "cluster-authorization-failed";
            ArrayList<NewClusterLink> newClusterLinks = new ArrayList<NewClusterLink>(2);
            newClusterLinks.add(new NewClusterLink(linkNameExists, null, Collections.emptyMap()));
            newClusterLinks.add(new NewClusterLink(linkNameAuthorizationFailed, null, Collections.emptyMap()));
            HashMap<String, CreateClusterLinksResponse.ApiErrorAndOriginalThrowable> responseData = new HashMap<String, CreateClusterLinksResponse.ApiErrorAndOriginalThrowable>(2);
            responseData.put(linkNameExists, new CreateClusterLinksResponse.ApiErrorAndOriginalThrowable(new ApiError(Errors.CLUSTER_LINK_EXISTS, ""), (Throwable)new ClusterLinkExistsException("Cluster link exists.")));
            responseData.put(linkNameAuthorizationFailed, new CreateClusterLinksResponse.ApiErrorAndOriginalThrowable(new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED, ""), (Throwable)new AuthorizationException("Not authorized.")));
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateClusterLinksResponse(responseData, 0));
            CreateClusterLinksResult result = env.adminClient().createClusterLinks(newClusterLinks, new CreateClusterLinksOptions());
            Assertions.assertEquals((int)newClusterLinks.size(), (int)result.result().size());
            TestUtils.assertFutureThrows(ClusterLinkExistsException.class, (Future)result.result().get(linkNameExists));
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, (Future)result.result().get(linkNameAuthorizationFailed));
        }
    }

    @Test
    public void testListClusterLinks() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<ListClusterLinksResponseData.EntryData> entryData = new ArrayList<ListClusterLinksResponseData.EntryData>();
            entryData.add(new ListClusterLinksResponseData.EntryData().setLinkName("cluster-1").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1").setTopics(Collections.emptyList()));
            entryData.add(new ListClusterLinksResponseData.EntryData().setLinkName("cluster-2a").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-2").setTopics(Collections.emptyList()));
            entryData.add(new ListClusterLinksResponseData.EntryData().setLinkName("cluster-2b").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-2").setTopics(Collections.emptyList()));
            entryData.add(new ListClusterLinksResponseData.EntryData().setLinkName("cluster-3").setLinkId(Uuid.randomUuid()).setRemoteClusterId(null).setTopics(Collections.emptyList()));
            entryData.add(new ListClusterLinksResponseData.EntryData().setLinkName("cluster-4").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-4").setTopics(Collections.emptyList()));
            entryData.add(new ListClusterLinksResponseData.EntryData().setLinkName("cluster-5").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-5").setTopics(Arrays.asList("topic-1", "topic-2")));
            ListClusterLinksResponseData responseData = new ListClusterLinksResponseData().setEntries(entryData).setThrottleTimeMs(0);
            env.kafkaClient().prepareResponse((AbstractResponse)new ListClusterLinksResponse(responseData));
            ListClusterLinksResult result = env.adminClient().listClusterLinks(new ListClusterLinksOptions());
            Collection resultData = (Collection)result.result().get();
            Assertions.assertEquals(this.convertResponseToListing(responseData), (Object)resultData);
        }
    }

    @Test
    public void testListClusterLinksRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8121);
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), node0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new ListClusterLinksResponse(0, (Throwable)Errors.NOT_CONTROLLER.exception()));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), Collections.emptyList()));
            ListClusterLinksResponseData responseData = new ListClusterLinksResponseData().setEntries(Collections.singletonList(new ListClusterLinksResponseData.EntryData().setLinkName("cluster-1").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1"))).setThrottleTimeMs(0);
            env.kafkaClient().prepareResponse((AbstractResponse)new ListClusterLinksResponse(responseData));
            ListClusterLinksResult result = env.adminClient().listClusterLinks(new ListClusterLinksOptions());
            ArrayList resultData = new ArrayList((Collection)result.result().get());
            Assertions.assertEquals(this.convertResponseToListing(responseData), resultData);
        }
    }

    @Test
    public void testListClusterLinksNonRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8121);
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), node0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new ListClusterLinksResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception()));
            ListClusterLinksResult result = env.adminClient().listClusterLinks(new ListClusterLinksOptions());
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, result.result());
        }
    }

    @Test
    public void testDescribeClusterLinksToAllBrokersHappyPath() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeClusterLinksResponseData.EntryData> entryData = new ArrayList<DescribeClusterLinksResponseData.EntryData>();
            entryData.add(new DescribeClusterLinksResponseData.EntryData().setLinkName("cluster-1").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1").setTopics(Collections.emptyList()));
            entryData.add(new DescribeClusterLinksResponseData.EntryData().setLinkName("cluster-2a").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-2").setTopics(Collections.emptyList()));
            entryData.add(new DescribeClusterLinksResponseData.EntryData().setLinkName("cluster-2b").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-2").setTopics(Collections.emptyList()));
            entryData.add(new DescribeClusterLinksResponseData.EntryData().setLinkName("cluster-3").setLinkId(Uuid.randomUuid()).setRemoteClusterId(null).setTopics(Collections.emptyList()));
            entryData.add(new DescribeClusterLinksResponseData.EntryData().setLinkName("cluster-4").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-4").setTopics(Collections.emptyList()));
            entryData.add(new DescribeClusterLinksResponseData.EntryData().setLinkName("cluster-5").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-5").setTopics(Arrays.asList("topic-1", "topic-2")));
            DescribeClusterLinksResponseData responseData = new DescribeClusterLinksResponseData().setEntries(entryData).setThrottleTimeMs(0);
            MetadataResponseData.MetadataResponseBrokerCollection brokers = new MetadataResponseData.MetadataResponseBrokerCollection();
            env.cluster().nodes().forEach(node -> brokers.add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseBroker().setHost(node.host()).setNodeId(node.id()).setPort(node.port()).setRack(node.rack())));
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, (AbstractResponse)new MetadataResponse(new MetadataResponseData().setBrokers(brokers), 13));
            env.cluster().nodes().forEach(node -> env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(responseData)));
            DescribeClusterLinksResult result = env.adminClient().describeClusterLinks(new DescribeClusterLinksOptions().includeTasks(true));
            Collection resultData = (Collection)result.result().get();
            Collection<ClusterLinkDescription> expected = this.convertResponseToDescription(responseData);
            Assertions.assertEquals(new HashSet<ClusterLinkDescription>(expected), new HashSet(resultData));
        }
    }

    @Test
    public void testDescribeClusterLinksUsingFindCoordinatorHappyPath() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeClusterLinksResponseData.EntryData> entryData = new ArrayList<DescribeClusterLinksResponseData.EntryData>();
            String linkName = "cluster-1";
            entryData.add(new DescribeClusterLinksResponseData.EntryData().setLinkName(linkName).setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1").setTopics(Collections.emptyList()));
            DescribeClusterLinksResponseData responseData = new DescribeClusterLinksResponseData().setEntries(entryData).setThrottleTimeMs(0);
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, linkName, coordinator));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(responseData));
            DescribeClusterLinksResult result = env.adminClient().describeClusterLinks(new DescribeClusterLinksOptions().linkNames(Collections.singletonList(linkName)).includeTasks(true));
            Collection resultData = (Collection)result.result().get();
            Collection<ClusterLinkDescription> expected = this.convertResponseToDescription(responseData);
            Assertions.assertEquals(new HashSet<ClusterLinkDescription>(expected), new HashSet(resultData));
        }
    }

    @Test
    public void testDescribeMirrorsUsingController() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeMirrorsResponseData.TopicData> topicData = new ArrayList<DescribeMirrorsResponseData.TopicData>();
            String topic = "topic";
            topicData.add(new DescribeMirrorsResponseData.TopicData().setTopic(topic).setLinkName("link-1").setLinkId(UUID.randomUUID().toString()));
            DescribeMirrorsResponseData responseData = new DescribeMirrorsResponseData().setTopics(topicData);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeMirrorsResponse(responseData));
            DescribeMirrorsResult result = env.adminClient().describeMirrors(Collections.singleton(topic), new DescribeMirrorsOptions());
            MirrorTopicDescription actual = (MirrorTopicDescription)((KafkaFuture)result.result().get(topic)).get();
            List<MirrorTopicDescription> expected = this.convertResponseToMirrorTopicDescription(responseData);
            Assertions.assertEquals((Object)expected.get(0), (Object)actual);
        }
    }

    @Test
    public void testDescribeSwitchoverStatusHappyPath() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeSwitchoverStatusResponseData.TopicData> topicData = new ArrayList<DescribeSwitchoverStatusResponseData.TopicData>();
            topicData.add(new DescribeSwitchoverStatusResponseData.TopicData().setTopic("topic1").setErrorCode((short)0).setErrorMessage("").setState(MirrorTopicDescription.State.PENDING_MIRROR.toString()).setSwitchoverMessagesTruncated(0L));
            ArrayList<DescribeSwitchoverStatusResponseData.TaskData> taskData = new ArrayList<DescribeSwitchoverStatusResponseData.TaskData>();
            taskData.add(new DescribeSwitchoverStatusResponseData.TaskData().setName("ConsumerOffsetSync").setState((short)1));
            String linkName = "link1";
            DescribeSwitchoverStatusResponseData responseData = new DescribeSwitchoverStatusResponseData();
            responseData.setThrottleTimeMs(0).setErrorCode((short)0).setErrorMessage("").setLinkName(linkName).setLinkId(Uuid.randomUuid()).setRemoteClusterId("remote").setLocalClusterId("local").setSwitchoverState((byte)1).setSwitchoverType((byte)1).setLinkErrorCode((short)0).setLinkErrorMessage("").setRemoteLinkErrorCode((short)0).setRemoteLinkErrorMessage("").setTopics(topicData).setTasks(taskData);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeSwitchoverStatusResponse(responseData));
            DescribeSwitchoverStatusResult result = env.adminClient().describeSwitchoverStatus(linkName);
            ClusterLinkSwitchoverStatusDescription resultData = (ClusterLinkSwitchoverStatusDescription)result.result().get();
            Assertions.assertEquals((Object)DescribeSwitchoverStatusResponse.responseDataToSwitchoverStatusDescription((DescribeSwitchoverStatusResponseData)responseData), (Object)resultData);
        }
    }

    @Test
    public void testDescribeSwitchoverStatusFailsOnClusterAuthorization() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String linkName = "link1";
            Errors error = Errors.CLUSTER_AUTHORIZATION_FAILED;
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeSwitchoverStatusResponse(0, (Throwable)error.exception()));
            DescribeSwitchoverStatusResult result = env.adminClient().describeSwitchoverStatus(linkName);
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, result.result());
        }
    }

    @Test
    public void testDescribeSwitchoverStatusFailsOnUnsupportedVersion() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String linkName = "link1";
            Errors error = Errors.UNSUPPORTED_VERSION;
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeSwitchoverStatusResponse(0, (Throwable)error.exception()));
            DescribeSwitchoverStatusResult result = env.adminClient().describeSwitchoverStatus(linkName);
            TestUtils.assertFutureThrows(Errors.UNSUPPORTED_VERSION.exception().getClass(), result.result());
        }
    }

    @Test
    public void testDescribeMirrorsUsingFindCoordinatorHappyPath() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeMirrorsResponseData.TopicData> topicData = new ArrayList<DescribeMirrorsResponseData.TopicData>();
            String topic = "topic";
            topicData.add(new DescribeMirrorsResponseData.TopicData().setTopic(topic).setLinkName("link-1").setLinkId(UUID.randomUUID().toString()));
            DescribeMirrorsResponseData responseData = new DescribeMirrorsResponseData().setTopics(topicData);
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, topic, coordinator));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeMirrorsResponse(responseData));
            DescribeMirrorsResult result = env.adminClient().describeMirrors(Collections.singleton(topic), new DescribeMirrorsOptions().includeStateTransitionErrors(true));
            MirrorTopicDescription actual = (MirrorTopicDescription)((KafkaFuture)result.result().get(topic)).get();
            List<MirrorTopicDescription> expected = this.convertResponseToMirrorTopicDescription(responseData);
            Assertions.assertEquals((Object)expected.get(0), (Object)actual);
        }
    }

    @Test
    public void testDescribeMirrorsUsesControllerAfterUnsupportedVersionException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeMirrorsResponseData.TopicData> topicData = new ArrayList<DescribeMirrorsResponseData.TopicData>();
            String topic = "topic";
            topicData.add(new DescribeMirrorsResponseData.TopicData().setTopic(topic).setLinkName("link-1").setLinkId(UUID.randomUUID().toString()));
            DescribeMirrorsResponseData responseData = new DescribeMirrorsResponseData().setTopics(topicData);
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, topic, coordinator));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeMirrorsResponse(Collections.emptyList(), 0, (Throwable)Errors.UNSUPPORTED_VERSION.exception()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeMirrorsResponse(responseData));
            DescribeMirrorsResult result = env.adminClient().describeMirrors(Collections.singleton(topic), new DescribeMirrorsOptions().includeStateTransitionErrors(true));
            MirrorTopicDescription actual = (MirrorTopicDescription)((KafkaFuture)result.result().get(topic)).get();
            List<MirrorTopicDescription> expected = this.convertResponseToMirrorTopicDescription(responseData);
            Assertions.assertEquals((Object)expected.get(0), (Object)actual);
        }
    }

    @Test
    public void testDescribeMirrorsUsesControllerForSubsetOfTopicsAfterUnsupportedVersionException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            Node coordinatorTwo;
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            Iterator iterator = env.cluster().nodes().iterator();
            Node controller = env.cluster().controller();
            Node coordinatorOne = (Node)iterator.next();
            if (coordinatorOne.equals((Object)controller)) {
                coordinatorOne = (Node)iterator.next();
            }
            if ((coordinatorTwo = (Node)iterator.next()).equals((Object)controller)) {
                coordinatorTwo = (Node)iterator.next();
            }
            HashSet<String> topics = new HashSet<String>();
            String topicOne = "topic-1";
            topics.add(topicOne);
            String topicTwo = "topic-2";
            topics.add(topicTwo);
            HashMap<String, Node> topicToCoordinator = new HashMap<String, Node>();
            topicToCoordinator.put(topicOne, coordinatorOne);
            topicToCoordinator.put(topicTwo, coordinatorTwo);
            Assertions.assertNotEquals((Object)coordinatorOne, (Object)coordinatorTwo);
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareBatchedMirrorTopicFindCoordinatorResponse(Errors.NONE, topicToCoordinator));
            ArrayList<DescribeMirrorsResponseData.TopicData> linkCoordinatorTopicData = new ArrayList<DescribeMirrorsResponseData.TopicData>();
            linkCoordinatorTopicData.add(new DescribeMirrorsResponseData.TopicData().setTopic(topicOne).setLinkName("link-1").setLinkId(UUID.randomUUID().toString()));
            DescribeMirrorsResponseData linkCoordinatorResponseData = new DescribeMirrorsResponseData().setTopics(linkCoordinatorTopicData);
            ArrayList<DescribeMirrorsResponseData.TopicData> controllerTopicData = new ArrayList<DescribeMirrorsResponseData.TopicData>();
            controllerTopicData.add(new DescribeMirrorsResponseData.TopicData().setTopic(topicTwo).setLinkName("link-1").setLinkId(UUID.randomUUID().toString()));
            DescribeMirrorsResponseData controllerResponseData = new DescribeMirrorsResponseData().setTopics(controllerTopicData);
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeMirrorsResponse(linkCoordinatorResponseData), coordinatorOne);
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeMirrorsResponse(Collections.emptyList(), 0, (Throwable)Errors.UNSUPPORTED_VERSION.exception()), coordinatorTwo);
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeMirrorsResponse(controllerResponseData), controller);
            DescribeMirrorsResult result = env.adminClient().describeMirrors(topics, new DescribeMirrorsOptions().includeStateTransitionErrors(true));
            Collection actual = ((Map)result.all().get()).values();
            List<MirrorTopicDescription> expected = this.convertResponseToMirrorTopicDescription(linkCoordinatorResponseData);
            expected.addAll(this.convertResponseToMirrorTopicDescription(controllerResponseData));
            Assertions.assertEquals(new HashSet<MirrorTopicDescription>(expected), new HashSet(actual));
        }
    }

    @Test
    public void testDescribeMirrorsUsesControllerAfterInvalidRequestFromFindCoordinators() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeMirrorsResponseData.TopicData> topicData = new ArrayList<DescribeMirrorsResponseData.TopicData>();
            String topic = "topic";
            topicData.add(new DescribeMirrorsResponseData.TopicData().setTopic(topic).setLinkName("link-1").setLinkId(UUID.randomUUID().toString()));
            DescribeMirrorsResponseData responseData = new DescribeMirrorsResponseData().setTopics(topicData);
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.INVALID_REQUEST, topic, coordinator));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeMirrorsResponse(responseData));
            DescribeMirrorsResult result = env.adminClient().describeMirrors(Collections.singleton(topic), new DescribeMirrorsOptions().includeStateTransitionErrors(true));
            MirrorTopicDescription actual = (MirrorTopicDescription)((KafkaFuture)result.result().get(topic)).get();
            List<MirrorTopicDescription> expected = this.convertResponseToMirrorTopicDescription(responseData);
            Assertions.assertEquals((Object)expected.get(0), (Object)actual);
        }
    }

    @Test
    public void testDescribeMirrorsUsingFindCoordinatorRetriesWhenCoordinatorLoading() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeMirrorsResponseData.TopicData> topicData = new ArrayList<DescribeMirrorsResponseData.TopicData>();
            String topic = "topic";
            topicData.add(new DescribeMirrorsResponseData.TopicData().setTopic(topic).setLinkName("link-1").setLinkId(UUID.randomUUID().toString()));
            DescribeMirrorsResponseData responseData = new DescribeMirrorsResponseData().setTopics(topicData);
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, topic, coordinator));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeMirrorsResponse(Collections.emptyList(), 0, (Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeMirrorsResponse(responseData));
            DescribeMirrorsResult result = env.adminClient().describeMirrors(Collections.singleton(topic), new DescribeMirrorsOptions().includeStateTransitionErrors(true));
            MirrorTopicDescription actual = (MirrorTopicDescription)((KafkaFuture)result.result().get(topic)).get();
            List<MirrorTopicDescription> expected = this.convertResponseToMirrorTopicDescription(responseData);
            Assertions.assertEquals((Object)expected.get(0), (Object)actual);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"COORDINATOR_NOT_AVAILABLE", "NOT_COORDINATOR", "NOT_CONTROLLER"})
    public void testDescribeMirrorsUsingFindCoordinatorRetriesWhenCoordinatorChanges(String errStr) throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeMirrorsResponseData.TopicData> topicData = new ArrayList<DescribeMirrorsResponseData.TopicData>();
            String topic = "topic";
            topicData.add(new DescribeMirrorsResponseData.TopicData().setTopic(topic).setLinkName("link-1").setLinkId(UUID.randomUUID().toString()));
            DescribeMirrorsResponseData responseData = new DescribeMirrorsResponseData().setTopics(topicData);
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, topic, coordinator));
            Errors error = Errors.valueOf((String)errStr);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeMirrorsResponse(Collections.emptyList(), 0, (Throwable)error.exception()));
            coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, topic, coordinator));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeMirrorsResponse(responseData));
            DescribeMirrorsResult result = env.adminClient().describeMirrors(Collections.singleton(topic), new DescribeMirrorsOptions().includeStateTransitionErrors(true));
            MirrorTopicDescription actual = (MirrorTopicDescription)((KafkaFuture)result.result().get(topic)).get();
            List<MirrorTopicDescription> expected = this.convertResponseToMirrorTopicDescription(responseData);
            Assertions.assertEquals((Object)expected.get(0), (Object)actual);
        }
    }

    @Test
    public void testDescribeMirrorsUsingFindCoordinatorFailsOnClusterAuthorization() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeMirrorsResponseData.TopicData> topicData = new ArrayList<DescribeMirrorsResponseData.TopicData>();
            String topic = "topic";
            topicData.add(new DescribeMirrorsResponseData.TopicData().setTopic(topic).setLinkName("link-1").setLinkId(UUID.randomUUID().toString()));
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, topic, coordinator));
            Errors error = Errors.CLUSTER_AUTHORIZATION_FAILED;
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeMirrorsResponse(Collections.emptyList(), 0, (Throwable)error.exception()));
            DescribeMirrorsResult result = env.adminClient().describeMirrors(Collections.singleton(topic), new DescribeMirrorsOptions().includeStateTransitionErrors(true));
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, (Future)result.result().get(topic));
        }
    }

    @Test
    public void testDescribeClusterLinksUsingFindCoordinatorRetriesWhenCoordinatorIsLoading() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeClusterLinksResponseData.EntryData> entryData = new ArrayList<DescribeClusterLinksResponseData.EntryData>();
            String linkName = "cluster-1";
            entryData.add(new DescribeClusterLinksResponseData.EntryData().setLinkName(linkName).setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1").setTopics(Collections.emptyList()));
            DescribeClusterLinksResponseData responseData = new DescribeClusterLinksResponseData().setEntries(entryData).setThrottleTimeMs(0);
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, linkName, coordinator));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(0, (Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(responseData));
            DescribeClusterLinksResult result = env.adminClient().describeClusterLinks(new DescribeClusterLinksOptions().linkNames(Collections.singletonList(linkName)).includeTasks(true));
            Collection resultData = (Collection)result.result().get();
            Collection<ClusterLinkDescription> expected = this.convertResponseToDescription(responseData);
            Assertions.assertEquals(new HashSet<ClusterLinkDescription>(expected), new HashSet(resultData));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"COORDINATOR_NOT_AVAILABLE", "NOT_COORDINATOR", "NOT_CONTROLLER"})
    public void testDescribeClusterLinksUsingFindCoordinatorRelookUp(String errorStr) throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeClusterLinksResponseData.EntryData> entryData = new ArrayList<DescribeClusterLinksResponseData.EntryData>();
            String linkName = "cluster-1";
            entryData.add(new DescribeClusterLinksResponseData.EntryData().setLinkName(linkName).setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1").setTopics(Collections.emptyList()));
            DescribeClusterLinksResponseData responseData = new DescribeClusterLinksResponseData().setEntries(entryData).setThrottleTimeMs(0);
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, linkName, coordinator));
            Errors error = Errors.valueOf((String)errorStr);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(0, (Throwable)error.exception()));
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, linkName, coordinator));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(responseData));
            DescribeClusterLinksResult result = env.adminClient().describeClusterLinks(new DescribeClusterLinksOptions().linkNames(Collections.singletonList(linkName)).includeTasks(true));
            Collection resultData = (Collection)result.result().get();
            Collection<ClusterLinkDescription> expected = this.convertResponseToDescription(responseData);
            Assertions.assertEquals(new HashSet<ClusterLinkDescription>(expected), new HashSet(resultData));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"COORDINATOR_LOAD_IN_PROGRESS", "REQUEST_TIMED_OUT"})
    public void testDescribeClusterLinksToAllBrokersRetries(String errorStr) throws Exception {
        Node node0 = new Node(0, "localhost", 8121);
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), node0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            MetadataResponseData.MetadataResponseBrokerCollection brokers = new MetadataResponseData.MetadataResponseBrokerCollection();
            env.cluster().nodes().forEach(node -> brokers.add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseBroker().setHost(node.host()).setNodeId(node.id()).setPort(node.port()).setRack(node.rack())));
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, (AbstractResponse)new MetadataResponse(new MetadataResponseData().setBrokers(brokers), 13));
            Errors error = Errors.valueOf((String)errorStr);
            env.cluster().nodes().forEach(node -> env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(0, (Throwable)error.exception())));
            DescribeClusterLinksResponseData responseData = new DescribeClusterLinksResponseData().setEntries(Collections.singletonList(new DescribeClusterLinksResponseData.EntryData().setLinkName("cluster-1").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1"))).setThrottleTimeMs(0);
            env.cluster().nodes().forEach(node -> env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(responseData)));
            DescribeClusterLinksResult result = env.adminClient().describeClusterLinks(new DescribeClusterLinksOptions().includeTasks(true));
            ArrayList resultData = new ArrayList((Collection)result.result().get());
            Collection<ClusterLinkDescription> expected = this.convertResponseToDescription(responseData);
            Assertions.assertEquals(new HashSet<ClusterLinkDescription>(expected), new HashSet(resultData));
        }
    }

    @Test
    public void testDescribeMetadataQuorumSuccess() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.DESCRIBE_QUORUM.id, (short)ApiKeys.DESCRIBE_QUORUM.oldestVersion(), (short)ApiKeys.DESCRIBE_QUORUM.latestVersion()));
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, false, false, false, false, false));
            KafkaFuture future = env.adminClient().describeMetadataQuorum().quorumInfo();
            QuorumInfo quorumInfo = (QuorumInfo)future.get();
            Assertions.assertEquals((Object)KafkaAdminClientTest.defaultQuorumInfo(false), (Object)quorumInfo);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, false, false, false, false, true));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            quorumInfo = (QuorumInfo)future.get();
            Assertions.assertEquals((Object)KafkaAdminClientTest.defaultQuorumInfo(true), (Object)quorumInfo);
        }
    }

    @Test
    public void testDescribeMetadataQuorumRetriableError() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.DESCRIBE_QUORUM.id, (short)ApiKeys.DESCRIBE_QUORUM.oldestVersion(), (short)ApiKeys.DESCRIBE_QUORUM.latestVersion()));
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NOT_LEADER_OR_FOLLOWER, false, false, false, false, false));
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, false, false, false, false, false));
            KafkaFuture future = env.adminClient().describeMetadataQuorum().quorumInfo();
            QuorumInfo quorumInfo = (QuorumInfo)future.get();
            Assertions.assertEquals((Object)KafkaAdminClientTest.defaultQuorumInfo(false), (Object)quorumInfo);
        }
    }

    @Test
    public void testDescribeMetadataQuorumFailure() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.DESCRIBE_QUORUM.id, (short)ApiKeys.DESCRIBE_QUORUM.oldestVersion(), (short)ApiKeys.DESCRIBE_QUORUM.latestVersion()));
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.INVALID_REQUEST, Errors.NONE, false, false, false, false, false));
            KafkaFuture future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(InvalidRequestException.class, future);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, true, false, false, false, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(UnknownServerException.class, future);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, false, true, false, false, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(UnknownServerException.class, future);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, false, false, true, false, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(UnknownServerException.class, future);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, false, false, false, true, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(UnknownServerException.class, future);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.INVALID_REQUEST, false, false, false, false, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(InvalidRequestException.class, future);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, true, true, true, true, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(UnknownServerException.class, future);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.INVALID_REQUEST, Errors.INVALID_REQUEST, true, true, true, true, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(Errors.INVALID_REQUEST.exception().getClass(), future);
        }
    }

    @Test
    public void testDescribeClusterLinksToAllBrokersNonRetriableErrors() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            MetadataResponseData.MetadataResponseBrokerCollection brokers = new MetadataResponseData.MetadataResponseBrokerCollection();
            env.cluster().nodes().forEach(node -> brokers.add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseBroker().setHost(node.host()).setNodeId(node.id()).setPort(node.port()).setRack(node.rack())));
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, (AbstractResponse)new MetadataResponse(new MetadataResponseData().setBrokers(brokers), 13));
            env.cluster().nodes().forEach(node -> env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception())));
            DescribeClusterLinksResult result = env.adminClient().describeClusterLinks(new DescribeClusterLinksOptions().includeTasks(true));
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, result.result());
        }
    }

    @Test
    public void testDescribeClusterLinksTriesUsingCoordinatorsThenUsesController() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            MetadataResponseData.MetadataResponseBrokerCollection brokers = new MetadataResponseData.MetadataResponseBrokerCollection();
            env.cluster().nodes().forEach(node -> brokers.add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseBroker().setHost(node.host()).setNodeId(node.id()).setPort(node.port()).setRack(node.rack())));
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, (AbstractResponse)new MetadataResponse(new MetadataResponseData().setBrokers(brokers), 13));
            env.cluster().nodes().forEach(node -> env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(0, (Throwable)Errors.UNSUPPORTED_VERSION.exception())));
            DescribeClusterLinksResponseData responseData = new DescribeClusterLinksResponseData().setEntries(Collections.singletonList(new DescribeClusterLinksResponseData.EntryData().setLinkName("cluster-1").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1"))).setThrottleTimeMs(0);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(responseData));
            DescribeClusterLinksResult result = env.adminClient().describeClusterLinks(new DescribeClusterLinksOptions());
            ArrayList resultData = new ArrayList((Collection)result.result().get());
            Collection<ClusterLinkDescription> expected = this.convertResponseToDescription(responseData);
            Assertions.assertEquals(new HashSet<ClusterLinkDescription>(expected), new HashSet(resultData));
        }
    }

    @Test
    public void testDescribeClusterLinksUsesFindCoordinatorThenUsesController() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeClusterLinksResponseData.EntryData> entryData = new ArrayList<DescribeClusterLinksResponseData.EntryData>();
            String linkName = "cluster-1";
            entryData.add(new DescribeClusterLinksResponseData.EntryData().setLinkName(linkName).setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1").setTopics(Collections.emptyList()));
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, linkName, coordinator));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(0, (Throwable)Errors.UNSUPPORTED_VERSION.exception()));
            DescribeClusterLinksResponseData responseData = new DescribeClusterLinksResponseData().setEntries(Collections.singletonList(new DescribeClusterLinksResponseData.EntryData().setLinkName("cluster-1").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1"))).setThrottleTimeMs(0);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(responseData));
            DescribeClusterLinksResult result = env.adminClient().describeClusterLinks(new DescribeClusterLinksOptions().linkNames(Collections.singletonList(linkName)));
            ArrayList resultData = new ArrayList((Collection)result.result().get());
            Collection<ClusterLinkDescription> expected = this.convertResponseToDescription(responseData);
            Assertions.assertEquals(new HashSet<ClusterLinkDescription>(expected), new HashSet(resultData));
        }
    }

    @Test
    public void testDescribeClusterLinksFailsOnFindCoordinatorThenUsesController() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeClusterLinksResponseData.EntryData> entryData = new ArrayList<DescribeClusterLinksResponseData.EntryData>();
            String linkName = "cluster-1";
            entryData.add(new DescribeClusterLinksResponseData.EntryData().setLinkName(linkName).setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1").setTopics(Collections.emptyList()));
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.INVALID_REQUEST, linkName, coordinator));
            DescribeClusterLinksResponseData responseData = new DescribeClusterLinksResponseData().setEntries(Collections.singletonList(new DescribeClusterLinksResponseData.EntryData().setLinkName("cluster-1").setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1"))).setThrottleTimeMs(0);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(responseData));
            DescribeClusterLinksResult result = env.adminClient().describeClusterLinks(new DescribeClusterLinksOptions().linkNames(Collections.singletonList(linkName)));
            ArrayList resultData = new ArrayList((Collection)result.result().get());
            Collection<ClusterLinkDescription> expected = this.convertResponseToDescription(responseData);
            Assertions.assertEquals(new HashSet<ClusterLinkDescription>(expected), new HashSet(resultData));
        }
    }

    @Test
    public void testDescribeClusterLinksUsingFindCoordinatorFailsOnNonRetriableError() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ArrayList<DescribeClusterLinksResponseData.EntryData> entryData = new ArrayList<DescribeClusterLinksResponseData.EntryData>();
            String linkName = "cluster-1";
            entryData.add(new DescribeClusterLinksResponseData.EntryData().setLinkName(linkName).setLinkId(Uuid.randomUuid()).setRemoteClusterId("cluster-id-1").setTopics(Collections.emptyList()));
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, linkName, coordinator));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterLinksResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception()));
            DescribeClusterLinksResult result = env.adminClient().describeClusterLinks(new DescribeClusterLinksOptions().linkNames(Collections.singletonList(linkName)).includeTasks(true));
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, result.result());
        }
    }

    private Collection<ClusterLinkDescription> convertResponseToDescription(DescribeClusterLinksResponseData responseData) {
        ArrayList<ClusterLinkDescription> linkDescriptions = new ArrayList<ClusterLinkDescription>();
        List entries = responseData.entries();
        for (DescribeClusterLinksResponseData.EntryData e : entries) {
            linkDescriptions.add(new ClusterLinkDescription.Builder().setLinkName(e.linkName()).setLinkId(e.linkId()).setRemoteClusterId(e.remoteClusterId()).setLocalClusterId(e.localClusterId()).setTopics((Collection)e.topics()).setLinkState(ClusterLinkDescription.LinkState.fromShort((short)e.linkState())).setLinkMode(ClusterLinkDescription.LinkMode.fromShort((short)e.linkMode())).setConnectionMode(ClusterLinkDescription.ConnectionMode.fromShort((short)e.connectionMode())).setClusterLinkError(ClusterLinkError.fromShort((short)e.linkErrorCode())).setLinkErrorMessage(e.linkErrorMessage()).setLinkCoordinator(new Node(e.linkCoordinatorId(), e.linkCoordinatorHost(), e.linkCoordinatorPort())).setTaskDescriptions(DescribeClusterLinksResponse.toAdminClientLinkTaskDescriptions((List)e.tasks())).build());
        }
        return linkDescriptions;
    }

    private List<MirrorTopicDescription> convertResponseToMirrorTopicDescription(DescribeMirrorsResponseData responseData) {
        ArrayList<MirrorTopicDescription> descriptions = new ArrayList<MirrorTopicDescription>();
        List entries = responseData.topics();
        for (DescribeMirrorsResponseData.TopicData e : entries) {
            MirrorTopicDescription.State state = this.toState(e.state());
            MirrorTopicError failureReason = MirrorTopicError.forCode((short)e.mirrorTopicError(), (state == MirrorTopicDescription.State.FAILED ? 1 : 0) != 0);
            descriptions.add(new MirrorTopicDescription(e.linkName(), Utils.toKafkaUuid((UUID)UUID.fromString(e.linkId())), e.mirrorTopic(), e.numPartitions(), state, e.stateTimeMs(), e.stoppedLogEndOffsets(), e.sourceTopicId(), failureReason, e.mirrorStateTransitionErrors().stream().map(err -> new ClusterLinkTaskError(ClusterLinkTaskError.ClusterLinkTaskErrorCode.fromShort((short)err.mirrorStateTransitionErrorCode()), err.mirrorStateTransitionErrorMessage())).collect(Collectors.toList())));
        }
        return descriptions;
    }

    private MirrorTopicDescription.State toState(String state) {
        try {
            return MirrorTopicDescription.State.valueOf((String)state);
        }
        catch (IllegalArgumentException e) {
            return MirrorTopicDescription.State.UNKNOWN;
        }
    }

    @Test
    public void testDeleteClusterLinks() throws Exception {
        Node node0 = new Node(0, "localhost", 8121);
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), node0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            List<String> linkNames = Arrays.asList("cluster-1", "cluster+2");
            HashMap<String, ApiError> responseData = new HashMap<String, ApiError>(linkNames.size());
            for (String linkName : linkNames) {
                responseData.put(linkName, ApiError.NONE);
            }
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteClusterLinksResponse(responseData, 0));
            DeleteClusterLinksResult result = env.adminClient().deleteClusterLinks(linkNames, new DeleteClusterLinksOptions());
            Assertions.assertEquals((int)linkNames.size(), (int)result.result().size());
            for (String linkName : linkNames) {
                KafkaFuture future = (KafkaFuture)result.result().get(linkName);
                Assertions.assertTrue((future != null ? 1 : 0) != 0);
                future.get();
            }
        }
    }

    @Test
    public void testDeleteClusterLinksRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8121);
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), node0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String linkName = "cluster";
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteClusterLinksResponse(Collections.singletonList(linkName), 0, (Throwable)Errors.NOT_CONTROLLER.exception()));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), Collections.emptyList()));
            HashMap<String, ApiError> responseData = new HashMap<String, ApiError>(1);
            responseData.put(linkName, ApiError.NONE);
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteClusterLinksResponse(responseData, 0));
            DeleteClusterLinksResult result = env.adminClient().deleteClusterLinks(Collections.singletonList(linkName), new DeleteClusterLinksOptions());
            Assertions.assertEquals((int)1, (int)result.result().size());
            KafkaFuture future = (KafkaFuture)result.result().get(linkName);
            Assertions.assertTrue((future != null ? 1 : 0) != 0);
            future.get();
        }
    }

    @Test
    public void testDeleteClusterLinksNonRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8121);
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), node0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String linkNameNotFound = "cluster-not-found";
            String linkNameAuthorizationFailed = "cluster-authorization-failed";
            List<String> linkNames = Arrays.asList(linkNameNotFound, linkNameAuthorizationFailed);
            HashMap<String, ApiError> responseData = new HashMap<String, ApiError>(2);
            responseData.put(linkNameNotFound, new ApiError(Errors.CLUSTER_LINK_NOT_FOUND, ""));
            responseData.put(linkNameAuthorizationFailed, new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED, ""));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteClusterLinksResponse(responseData, 0));
            DeleteClusterLinksResult result = env.adminClient().deleteClusterLinks(linkNames, new DeleteClusterLinksOptions());
            Assertions.assertEquals((int)linkNames.size(), (int)result.result().size());
            TestUtils.assertFutureThrows(ClusterLinkNotFoundException.class, (Future)result.result().get(linkNameNotFound));
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, (Future)result.result().get(linkNameAuthorizationFailed));
        }
    }

    @Test
    public void testAlterMirrors() throws Exception {
        this.verifyAlterMirrors(ApiKeys.ALTER_MIRRORS.latestVersion());
    }

    @Test
    public void testAlterMirrorsVersion1() throws Exception {
        this.verifyAlterMirrors((short)1);
    }

    private void verifyAlterMirrors(short version) throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            List<String> topics = Arrays.asList("mirror-1", "mirror-2");
            HashMap<String, AlterMirrorOp> ops = new HashMap<String, AlterMirrorOp>(topics.size());
            ArrayList<AlterMirrorsResponseData.AlterMirrorResult> responseData = new ArrayList<AlterMirrorsResponseData.AlterMirrorResult>(topics.size());
            for (String topic : topics) {
                ops.put(topic, AlterMirrorOp.FAILOVER);
                responseData.add(new AlterMirrorsResponseData.AlterMirrorResult().setTopic(topic).setErrorCode(Errors.NONE.code()));
            }
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterMirrorsResponse(responseData, 0));
            AlterMirrorsResult result = env.adminClient().alterMirrors(ops, new AlterMirrorsOptions());
            Assertions.assertEquals((int)topics.size(), (int)result.values().size());
            for (String topic : topics) {
                Assertions.assertNull((Object)((KafkaFuture)result.values().get(topic)).get());
            }
            Assertions.assertNull((Object)result.all().get());
        }
    }

    @Test
    public void testAlterMirrorsRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8121);
        Cluster cluster = new Cluster("mockClusterId", Collections.singletonList(node0), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), node0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String topic = "mirror";
            Map<String, AlterMirrorOp> ops = Collections.singletonMap(topic, AlterMirrorOp.FAILOVER);
            List<AlterMirrorsResponseData.AlterMirrorResult> results = Collections.singletonList(new AlterMirrorsResponseData.AlterMirrorResult().setTopic(topic).setErrorCode(Errors.NOT_CONTROLLER.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterMirrorsResponse(results, 0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), Collections.emptyList()));
            results = Collections.singletonList(new AlterMirrorsResponseData.AlterMirrorResult().setTopic(topic).setErrorCode(Errors.NONE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterMirrorsResponse(results, 0));
            AlterMirrorsResult result = env.adminClient().alterMirrors(ops, new AlterMirrorsOptions());
            Assertions.assertEquals((int)1, (int)result.values().size());
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(topic)).get(10L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testAlterMirrorsNonRetriableErrors() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String unknownTopic = "unknown-topic";
            String topicAuthorizationFailed = "topic-authorization-failed";
            List<AlterMirrorsResponseData.AlterMirrorResult> results = Arrays.asList(new AlterMirrorsResponseData.AlterMirrorResult().setTopic(unknownTopic).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()), new AlterMirrorsResponseData.AlterMirrorResult().setTopic(topicAuthorizationFailed).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterMirrorsResponse(results, 0));
            Map ops = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)unknownTopic, (Object)AlterMirrorOp.FAILOVER), Utils.mkEntry((Object)topicAuthorizationFailed, (Object)AlterMirrorOp.PROMOTE)});
            AlterMirrorsResult result = env.adminClient().alterMirrors(ops, new AlterMirrorsOptions());
            Assertions.assertEquals((int)2, (int)result.values().size());
            TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, (Future)result.values().get(unknownTopic));
            TestUtils.assertFutureThrows(TopicAuthorizationException.class, (Future)result.values().get(topicAuthorizationFailed));
        }
    }

    @Test
    public void testListOffsetsPartialResponse() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        pInfos.add(new PartitionInfo("foo", 1, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-2L, (long)123L, (int)456);
            ListOffsetsResponseData data = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(data), node0);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Assertions.assertNotNull((Object)result.partitionResult(tp0).get());
            TestUtils.assertFutureThrows(ApiException.class, result.partitionResult(tp1));
            TestUtils.assertFutureThrows(ApiException.class, result.all());
        }
    }

    @Test
    public void testGetSubLevelError() {
        List<LeaveGroupRequestData.MemberIdentity> memberIdentities = Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("instance-0"), new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("instance-1"));
        HashMap<LeaveGroupRequestData.MemberIdentity, Errors> errorsMap = new HashMap<LeaveGroupRequestData.MemberIdentity, Errors>();
        errorsMap.put(memberIdentities.get(0), Errors.NONE);
        errorsMap.put(memberIdentities.get(1), Errors.FENCED_INSTANCE_ID);
        Assertions.assertEquals(IllegalArgumentException.class, KafkaAdminClient.getSubLevelError(errorsMap, (Object)new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("non-exist-id"), (String)"For unit test").getClass());
        Assertions.assertNull((Object)KafkaAdminClient.getSubLevelError(errorsMap, (Object)memberIdentities.get(0), (String)"For unit test"));
        Assertions.assertEquals(FencedInstanceIdException.class, KafkaAdminClient.getSubLevelError(errorsMap, (Object)memberIdentities.get(1), (String)"For unit test").getClass());
    }

    @Test
    public void testSuccessfulRetryAfterRequestTimeout() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        Node node0 = new Node(0, "localhost", 8121);
        nodes.put(0, node0);
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Collections.singletonList(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0})), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        int requestTimeoutMs = 1000;
        int retryBackoffMs = 100;
        int apiTimeoutMs = 3000;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", String.valueOf(100), "retry.backoff.max.ms", String.valueOf(100), "request.timeout.ms", String.valueOf(1000));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ListTopicsResult result = env.adminClient().listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(3000)));
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Timed out waiting for Metadata request to be sent");
            time.sleep(1001L);
            TestUtils.waitForCondition(() -> !env.kafkaClient().hasInFlightRequests(), "Timed out waiting for inFlightRequests to be timed out");
            time.sleep(101L);
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Failed to retry Metadata request");
            env.kafkaClient().respond((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            Assertions.assertEquals((int)1, (int)((Collection)result.listings().get()).size());
            Assertions.assertEquals((Object)"foo", (Object)((TopicListing)((Collection)result.listings().get()).iterator().next()).name());
        }
    }

    @Test
    public void testDefaultApiTimeout() throws Exception {
        this.testApiTimeout(1500, 3000, OptionalInt.empty());
    }

    @Test
    public void testDefaultApiTimeoutOverride() throws Exception {
        this.testApiTimeout(1500, 10000, OptionalInt.of(3000));
    }

    private void testApiTimeout(int requestTimeoutMs, int defaultApiTimeoutMs, OptionalInt overrideApiTimeoutMs) throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        Node node0 = new Node(0, "localhost", 8121);
        nodes.put(0, node0);
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Collections.singletonList(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0})), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        int retryBackoffMs = 100;
        int effectiveTimeoutMs = overrideApiTimeoutMs.orElse(defaultApiTimeoutMs);
        Assertions.assertEquals((int)(2 * requestTimeoutMs), (int)effectiveTimeoutMs, (String)"This test expects the effective timeout to be twice the request timeout");
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", String.valueOf(100), "request.timeout.ms", String.valueOf(requestTimeoutMs), "default.api.timeout.ms", String.valueOf(defaultApiTimeoutMs));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ListTopicsOptions options = new ListTopicsOptions();
            overrideApiTimeoutMs.ifPresent(arg_0 -> ((ListTopicsOptions)options).timeoutMs(arg_0));
            ListTopicsResult result = env.adminClient().listTopics(options);
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Timed out waiting for Metadata request to be sent");
            time.sleep(requestTimeoutMs + 1);
            TestUtils.waitForCondition(() -> !env.kafkaClient().hasInFlightRequests(), "Timed out waiting for inFlightRequests to be timed out");
            TestUtils.waitForCondition(() -> {
                boolean hasInflightRequests = env.kafkaClient().hasInFlightRequests();
                if (!hasInflightRequests) {
                    time.sleep(100L);
                }
                return hasInflightRequests;
            }, "Timed out waiting for Metadata request to be sent");
            time.sleep(requestTimeoutMs + 1);
            TestUtils.assertFutureThrows(TimeoutException.class, result.future);
        }
    }

    @Test
    public void testRequestTimeoutExceedingDefaultApiTimeout() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        Node node0 = new Node(0, "localhost", 8121);
        nodes.put(0, node0);
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Collections.singletonList(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0})), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        int retryBackoffMs = 100;
        int requestTimeoutMs = 120000;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", String.valueOf(100), "request.timeout.ms", String.valueOf(120000));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ListTopicsOptions options = new ListTopicsOptions();
            ListTopicsResult result = env.adminClient().listTopics(options);
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Timed out waiting for Metadata request to be sent");
            time.sleep(60001L);
            Assertions.assertTrue((boolean)env.kafkaClient().hasInFlightRequests());
            time.sleep(60000L);
            TestUtils.assertFutureThrows(TimeoutException.class, result.future);
        }
    }

    private ClientQuotaEntity newClientQuotaEntity(String ... args) {
        Assertions.assertEquals((int)0, (int)(args.length % 2));
        HashMap<String, String> entityMap = new HashMap<String, String>(args.length / 2);
        for (int index = 0; index < args.length; index += 2) {
            entityMap.put(args[index], args[index + 1]);
        }
        return new ClientQuotaEntity(entityMap);
    }

    @Test
    public void testDescribeClientQuotas() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String value = "value";
            HashMap<ClientQuotaEntity, Map<String, Double>> responseData = new HashMap<ClientQuotaEntity, Map<String, Double>>();
            ClientQuotaEntity entity1 = this.newClientQuotaEntity("user", "user-1", "client-id", "value");
            ClientQuotaEntity entity2 = this.newClientQuotaEntity("user", "user-2", "client-id", "value");
            responseData.put(entity1, Collections.singletonMap("consumer_byte_rate", 10000.0));
            responseData.put(entity2, Collections.singletonMap("producer_byte_rate", 20000.0));
            env.kafkaClient().prepareResponse((AbstractResponse)DescribeClientQuotasResponse.fromQuotaEntities(responseData, (int)0));
            ClientQuotaFilter filter = ClientQuotaFilter.contains(Collections.singletonList(ClientQuotaFilterComponent.ofEntity((String)"user", (String)"value")));
            DescribeClientQuotasResult result = env.adminClient().describeClientQuotas(filter);
            Map resultData = (Map)result.entities().get();
            Assertions.assertEquals((int)2, (int)resultData.size());
            Assertions.assertTrue((boolean)resultData.containsKey(entity1));
            Map config1 = (Map)resultData.get(entity1);
            Assertions.assertEquals((int)1, (int)config1.size());
            Assertions.assertEquals((double)10000.0, (double)((Double)config1.get("consumer_byte_rate")), (double)1.0E-6);
            Assertions.assertTrue((boolean)resultData.containsKey(entity2));
            Map config2 = (Map)resultData.get(entity2);
            Assertions.assertEquals((int)1, (int)config2.size());
            Assertions.assertEquals((double)20000.0, (double)((Double)config2.get("producer_byte_rate")), (double)1.0E-6);
        }
    }

    @Test
    public void testEqualsOfClientQuotaFilterComponent() {
        Assertions.assertEquals((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"), (Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"));
        Assertions.assertEquals((Object)ClientQuotaFilterComponent.ofEntityType((String)"user"), (Object)ClientQuotaFilterComponent.ofEntityType((String)"user"));
        Assertions.assertNotEquals((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"), (Object)ClientQuotaFilterComponent.ofEntityType((String)"user"));
        Assertions.assertEquals((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user"), (Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user"));
        Assertions.assertNotEquals((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user"), (Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"));
        Assertions.assertNotEquals((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user"), (Object)ClientQuotaFilterComponent.ofEntityType((String)"user"));
    }

    @Test
    public void testAlterClientQuotas() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ClientQuotaEntity goodEntity = this.newClientQuotaEntity("user", "user-1");
            ClientQuotaEntity unauthorizedEntity = this.newClientQuotaEntity("user", "user-0");
            ClientQuotaEntity invalidEntity = this.newClientQuotaEntity("", "user-0");
            HashMap<ClientQuotaEntity, ApiError> responseData = new HashMap<ClientQuotaEntity, ApiError>(2);
            responseData.put(goodEntity, new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED, "Authorization failed"));
            responseData.put(unauthorizedEntity, new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED, "Authorization failed"));
            responseData.put(invalidEntity, new ApiError(Errors.INVALID_REQUEST, "Invalid quota entity"));
            env.kafkaClient().prepareResponse((AbstractResponse)AlterClientQuotasResponse.fromQuotaEntities(responseData, (int)0));
            ArrayList<ClientQuotaAlteration> entries = new ArrayList<ClientQuotaAlteration>(3);
            entries.add(new ClientQuotaAlteration(goodEntity, Collections.singleton(new ClientQuotaAlteration.Op("consumer_byte_rate", Double.valueOf(10000.0)))));
            entries.add(new ClientQuotaAlteration(unauthorizedEntity, Collections.singleton(new ClientQuotaAlteration.Op("producer_byte_rate", Double.valueOf(10000.0)))));
            entries.add(new ClientQuotaAlteration(invalidEntity, Collections.singleton(new ClientQuotaAlteration.Op("producer_byte_rate", Double.valueOf(100.0)))));
            AlterClientQuotasResult result = env.adminClient().alterClientQuotas(entries);
            result.values().get(goodEntity);
            TestUtils.assertFutureThrows(ClusterAuthorizationException.class, (Future)result.values().get(unauthorizedEntity));
            TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)result.values().get(invalidEntity));
            Assertions.assertThrows(UnsupportedOperationException.class, () -> result.values().put(this.newClientQuotaEntity("user", "user-3"), null));
        }
    }

    @Test
    public void testAlterReplicaLogDirsSuccess() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(0), Errors.NONE, 0);
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(1), Errors.NONE, 0);
            TopicPartitionReplica tpr0 = new TopicPartitionReplica("topic", 0, 0);
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 0, 1);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr0, "/data0");
            logDirs.put(tpr1, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(tpr0)).get());
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(tpr1)).get());
        }
    }

    @Test
    public void testAlterReplicaLogDirsLogDirNotFound() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(0), Errors.NONE, 0);
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(1), Errors.LOG_DIR_NOT_FOUND, 0);
            TopicPartitionReplica tpr0 = new TopicPartitionReplica("topic", 0, 0);
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 0, 1);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr0, "/data0");
            logDirs.put(tpr1, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(tpr0)).get());
            TestUtils.assertFutureThrows(LogDirNotFoundException.class, (Future)result.values().get(tpr1));
        }
    }

    @Test
    public void testAlterReplicaLogDirsUnrequested() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(0), Errors.NONE, 1, 2);
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 1, 0);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr1, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(tpr1)).get());
        }
    }

    @Test
    public void testAlterReplicaLogDirsPartialResponse() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(0), Errors.NONE, 1);
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 1, 0);
            TopicPartitionReplica tpr2 = new TopicPartitionReplica("topic", 2, 0);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr1, "/data1");
            logDirs.put(tpr2, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(tpr1)).get());
            TestUtils.assertFutureThrows(ApiException.class, (Future)result.values().get(tpr2));
        }
    }

    @Test
    public void testAlterReplicaLogDirsPartialFailure() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "retries", "0");){
            env.kafkaClient().prepareResponseFrom((AbstractResponse)this.prepareAlterLogDirsResponse(Errors.NONE, "topic", 2), env.cluster().nodeById(1));
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 1, 0);
            TopicPartitionReplica tpr2 = new TopicPartitionReplica("topic", 2, 1);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr1, "/data1");
            logDirs.put(tpr2, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting request");
            time.sleep(defaultApiTimeout + 1L);
            TestUtils.assertFutureThrows(TimeoutException.class, (Future)result.values().get(tpr1));
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(tpr2)).get());
        }
    }

    @Test
    public void testDescribeUserScramCredentials() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String user0Name = "user0";
            ScramMechanism user0ScramMechanism0 = ScramMechanism.SCRAM_SHA_256;
            int user0Iterations0 = 4096;
            ScramMechanism user0ScramMechanism1 = ScramMechanism.SCRAM_SHA_512;
            int user0Iterations1 = 8192;
            DescribeUserScramCredentialsResponseData.CredentialInfo user0CredentialInfo0 = new DescribeUserScramCredentialsResponseData.CredentialInfo();
            user0CredentialInfo0.setMechanism(user0ScramMechanism0.type());
            user0CredentialInfo0.setIterations(4096);
            DescribeUserScramCredentialsResponseData.CredentialInfo user0CredentialInfo1 = new DescribeUserScramCredentialsResponseData.CredentialInfo();
            user0CredentialInfo1.setMechanism(user0ScramMechanism1.type());
            user0CredentialInfo1.setIterations(8192);
            String user1Name = "user1";
            ScramMechanism user1ScramMechanism = ScramMechanism.SCRAM_SHA_256;
            int user1Iterations = 4096;
            DescribeUserScramCredentialsResponseData.CredentialInfo user1CredentialInfo = new DescribeUserScramCredentialsResponseData.CredentialInfo();
            user1CredentialInfo.setMechanism(user1ScramMechanism.type());
            user1CredentialInfo.setIterations(4096);
            DescribeUserScramCredentialsResponseData responseData = new DescribeUserScramCredentialsResponseData();
            responseData.setResults(Arrays.asList(new DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult().setUser("user0").setCredentialInfos(Arrays.asList(user0CredentialInfo0, user0CredentialInfo1)), new DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult().setUser("user1").setCredentialInfos(Collections.singletonList(user1CredentialInfo))));
            DescribeUserScramCredentialsResponse response = new DescribeUserScramCredentialsResponse(responseData);
            HashSet<String> usersRequestedSet = new HashSet<String>();
            usersRequestedSet.add("user0");
            usersRequestedSet.add("user1");
            for (List users : Arrays.asList(null, new ArrayList(), Arrays.asList("user0", null, "user1"))) {
                env.kafkaClient().prepareResponse((AbstractResponse)response);
                DescribeUserScramCredentialsResult result = env.adminClient().describeUserScramCredentials(users);
                Map descriptionResults = (Map)result.all().get();
                KafkaFuture user0DescriptionFuture = result.description("user0");
                KafkaFuture user1DescriptionFuture = result.description("user1");
                HashSet usersDescribedFromUsersSet = new HashSet((Collection)result.users().get());
                Assertions.assertEquals(usersRequestedSet, usersDescribedFromUsersSet);
                Set usersDescribedFromMapKeySet = descriptionResults.keySet();
                Assertions.assertEquals(usersRequestedSet, usersDescribedFromMapKeySet);
                UserScramCredentialsDescription userScramCredentialsDescription0 = (UserScramCredentialsDescription)descriptionResults.get("user0");
                Assertions.assertEquals((Object)"user0", (Object)userScramCredentialsDescription0.name());
                Assertions.assertEquals((int)2, (int)userScramCredentialsDescription0.credentialInfos().size());
                Assertions.assertEquals((Object)user0ScramMechanism0, (Object)((ScramCredentialInfo)userScramCredentialsDescription0.credentialInfos().get(0)).mechanism());
                Assertions.assertEquals((int)4096, (int)((ScramCredentialInfo)userScramCredentialsDescription0.credentialInfos().get(0)).iterations());
                Assertions.assertEquals((Object)user0ScramMechanism1, (Object)((ScramCredentialInfo)userScramCredentialsDescription0.credentialInfos().get(1)).mechanism());
                Assertions.assertEquals((int)8192, (int)((ScramCredentialInfo)userScramCredentialsDescription0.credentialInfos().get(1)).iterations());
                Assertions.assertEquals((Object)userScramCredentialsDescription0, (Object)user0DescriptionFuture.get());
                UserScramCredentialsDescription userScramCredentialsDescription1 = (UserScramCredentialsDescription)descriptionResults.get("user1");
                Assertions.assertEquals((Object)"user1", (Object)userScramCredentialsDescription1.name());
                Assertions.assertEquals((int)1, (int)userScramCredentialsDescription1.credentialInfos().size());
                Assertions.assertEquals((Object)user1ScramMechanism, (Object)((ScramCredentialInfo)userScramCredentialsDescription1.credentialInfos().get(0)).mechanism());
                Assertions.assertEquals((int)4096, (int)((ScramCredentialInfo)userScramCredentialsDescription1.credentialInfos().get(0)).iterations());
                Assertions.assertEquals((Object)userScramCredentialsDescription1, (Object)user1DescriptionFuture.get());
            }
        }
    }

    @Test
    public void testAlterUserScramCredentialsUnknownMechanism() throws ExecutionException, InterruptedException {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String user0Name = "user0";
            ScramMechanism user0ScramMechanism0 = ScramMechanism.UNKNOWN;
            String user1Name = "user1";
            ScramMechanism user1ScramMechanism0 = ScramMechanism.UNKNOWN;
            String user2Name = "user2";
            ScramMechanism user2ScramMechanism0 = ScramMechanism.SCRAM_SHA_256;
            AlterUserScramCredentialsResponseData responseData = new AlterUserScramCredentialsResponseData();
            responseData.setResults(Collections.singletonList(new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser("user2")));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterUserScramCredentialsResponse(responseData));
            AlterUserScramCredentialsResult result = env.adminClient().alterUserScramCredentials(Arrays.asList(new UserScramCredentialDeletion("user0", user0ScramMechanism0), new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(user1ScramMechanism0, 8192), "password"), new UserScramCredentialUpsertion("user2", new ScramCredentialInfo(user2ScramMechanism0, 4096), "password")));
            Map resultData = result.values();
            Assertions.assertEquals((int)3, (int)resultData.size());
            Stream.of("user0", "user1").forEach(u -> {
                Assertions.assertTrue((boolean)resultData.containsKey(u));
                Assertions.assertThrows(Exception.class, () -> ((KafkaFuture)resultData.get(u)).get(), (String)("Expected request for user " + u + " to complete exceptionally, but it did not"));
            });
            Assertions.assertTrue((boolean)resultData.containsKey("user2"));
            ((KafkaFuture)resultData.get("user2")).get();
            Assertions.assertThrows(Exception.class, () -> result.all().get(), (String)"Expected 'result.all().get()' to throw an exception since at least one user failed, but it did not");
        }
    }

    @Test
    public void testAlterUserScramCredentials() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String user0Name = "user0";
            ScramMechanism user0ScramMechanism0 = ScramMechanism.SCRAM_SHA_256;
            ScramMechanism user0ScramMechanism1 = ScramMechanism.SCRAM_SHA_512;
            String user1Name = "user1";
            ScramMechanism user1ScramMechanism0 = ScramMechanism.SCRAM_SHA_256;
            String user2Name = "user2";
            ScramMechanism user2ScramMechanism0 = ScramMechanism.SCRAM_SHA_512;
            AlterUserScramCredentialsResponseData responseData = new AlterUserScramCredentialsResponseData();
            responseData.setResults(Stream.of("user0", "user1", "user2").map(u -> new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser(u).setErrorCode(Errors.NONE.code())).collect(Collectors.toList()));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterUserScramCredentialsResponse(responseData));
            AlterUserScramCredentialsResult result = env.adminClient().alterUserScramCredentials(Arrays.asList(new UserScramCredentialDeletion("user0", user0ScramMechanism0), new UserScramCredentialUpsertion("user0", new ScramCredentialInfo(user0ScramMechanism1, 8192), "password"), new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(user1ScramMechanism0, 8192), "password"), new UserScramCredentialDeletion("user2", user2ScramMechanism0)));
            Map resultData = result.values();
            Assertions.assertEquals((int)3, (int)resultData.size());
            Stream.of("user0", "user1", "user2").forEach(u -> {
                Assertions.assertTrue((boolean)resultData.containsKey(u));
                Assertions.assertFalse((boolean)((KafkaFuture)resultData.get(u)).isCompletedExceptionally());
            });
        }
    }

    private void createAlterLogDirsResponse(AdminClientUnitTestEnv env, Node node, Errors error, int ... partitions) {
        env.kafkaClient().prepareResponseFrom((AbstractResponse)this.prepareAlterLogDirsResponse(error, "topic", partitions), node);
    }

    private AlterReplicaLogDirsResponse prepareAlterLogDirsResponse(Errors error, String topic, int ... partitions) {
        return new AlterReplicaLogDirsResponse(new AlterReplicaLogDirsResponseData().setResults(Collections.singletonList(new AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult().setTopicName(topic).setPartitions(Arrays.stream(partitions).boxed().map(partitionId -> new AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult().setPartitionIndex(partitionId.intValue()).setErrorCode(error.code())).collect(Collectors.toList())))));
    }

    @Test
    public void testDescribeLogDirsPartialFailure() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "retries", "0");){
            env.kafkaClient().prepareResponseFrom((AbstractResponse)this.prepareDescribeLogDirsResponse(Errors.NONE, "/data"), env.cluster().nodeById(1));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(Arrays.asList(0, 1));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting request");
            time.sleep(defaultApiTimeout + 1L);
            TestUtils.assertFutureThrows(TimeoutException.class, (Future)result.descriptions().get(0));
            Assertions.assertNotNull((Object)((KafkaFuture)result.descriptions().get(1)).get());
        }
    }

    @Test
    public void testDescribeReplicaLogDirsWithNonExistReplica() throws Exception {
        int brokerId = 0;
        TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic1", 12, brokerId);
        TopicPartitionReplica tpr2 = new TopicPartitionReplica("topic2", 12, brokerId);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String logDir = "/var/data/kafka0";
            int offsetLag = 1;
            int defaultOffsetLag = -1;
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Collections.singletonList(KafkaAdminClientTest.prepareDescribeLogDirsResult(tpr1, logDir, 123456, offsetLag, false)))), env.cluster().nodeById(brokerId));
            DescribeReplicaLogDirsResult result = env.adminClient().describeReplicaLogDirs(Arrays.asList(tpr1, tpr2));
            Map values = result.values();
            Assertions.assertEquals((Object)logDir, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getCurrentReplicaLogDir());
            Assertions.assertNull((Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getFutureReplicaLogDir());
            Assertions.assertEquals((long)offsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getCurrentReplicaOffsetLag());
            Assertions.assertEquals((long)defaultOffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getFutureReplicaOffsetLag());
            Assertions.assertNull((Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getCurrentReplicaLogDir());
            Assertions.assertNull((Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getFutureReplicaLogDir());
            Assertions.assertEquals((long)defaultOffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getCurrentReplicaOffsetLag());
            Assertions.assertEquals((long)defaultOffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getFutureReplicaOffsetLag());
        }
    }

    private Collection<ClusterLinkListing> convertResponseToListing(ListClusterLinksResponseData responseData) {
        ArrayList<ClusterLinkListing> linkListings = new ArrayList<ClusterLinkListing>();
        List entries = responseData.entries();
        for (ListClusterLinksResponseData.EntryData e : entries) {
            linkListings.add(new ClusterLinkListing(e.linkName(), e.linkId(), e.remoteClusterId(), e.localClusterId(), Optional.ofNullable(e.topics()), ClusterLinkError.fromShort((short)e.linkErrorCode()), e.linkErrorMessage(), ClusterLinkDescription.LinkState.fromShort((short)e.linkState())));
        }
        return linkListings;
    }

    @Test
    public void testUnregisterBrokerSuccess() throws InterruptedException, ExecutionException {
        int nodeId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.UNREGISTER_BROKER.id, (short)0, (short)0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.NONE, 0));
            UnregisterBrokerResult result = env.adminClient().unregisterBroker(nodeId);
            Assertions.assertNotNull((Object)result.all());
            result.all().get();
        }
    }

    @Test
    public void testUnregisterBrokerFailure() {
        int nodeId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.UNREGISTER_BROKER.id, (short)0, (short)0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.UNKNOWN_SERVER_ERROR, 0));
            UnregisterBrokerResult result = env.adminClient().unregisterBroker(nodeId);
            Assertions.assertNotNull((Object)result.all());
            TestUtils.assertFutureThrows(UnknownServerException.class, result.all());
        }
    }

    @Test
    public void testUnregisterBrokerTimeoutAndSuccessRetry() throws ExecutionException, InterruptedException {
        int nodeId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.UNREGISTER_BROKER.id, (short)0, (short)0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.REQUEST_TIMED_OUT, 0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.NONE, 0));
            UnregisterBrokerResult result = env.adminClient().unregisterBroker(nodeId);
            Assertions.assertNotNull((Object)result.all());
            result.all().get();
        }
    }

    @Test
    public void testUnregisterBrokerTimeoutAndFailureRetry() {
        int nodeId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.UNREGISTER_BROKER.id, (short)0, (short)0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.REQUEST_TIMED_OUT, 0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.UNKNOWN_SERVER_ERROR, 0));
            UnregisterBrokerResult result = env.adminClient().unregisterBroker(nodeId);
            Assertions.assertNotNull((Object)result.all());
            TestUtils.assertFutureThrows(UnknownServerException.class, result.all());
        }
    }

    @Test
    public void testUnregisterBrokerTimeoutMaxRetry() {
        int nodeId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(Time.SYSTEM, "retries", "1");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.UNREGISTER_BROKER.id, (short)0, (short)0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.REQUEST_TIMED_OUT, 0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.REQUEST_TIMED_OUT, 0));
            UnregisterBrokerResult result = env.adminClient().unregisterBroker(nodeId);
            Assertions.assertNotNull((Object)result.all());
            TestUtils.assertFutureThrows(TimeoutException.class, result.all());
        }
    }

    @Test
    public void testUnregisterBrokerTimeoutMaxWait() {
        int nodeId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.UNREGISTER_BROKER.id, (short)0, (short)0));
            UnregisterBrokerOptions options = new UnregisterBrokerOptions();
            options.timeoutMs = 10;
            UnregisterBrokerResult result = env.adminClient().unregisterBroker(nodeId, options);
            Assertions.assertNotNull((Object)result.all());
            TestUtils.assertFutureThrows(TimeoutException.class, result.all());
        }
    }

    @Test
    public void testDescribeProducers() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            TopicPartition topicPartition = new TopicPartition("foo", 0);
            Node leader = (Node)env.cluster().nodes().iterator().next();
            this.expectMetadataRequest(env, topicPartition, leader);
            List<ProducerState> expected = Arrays.asList(new ProducerState(12345L, 15, 30, env.time().milliseconds(), OptionalInt.of(99), OptionalLong.empty()), new ProducerState(12345L, 15, 30, env.time().milliseconds(), OptionalInt.empty(), OptionalLong.of(23423L)));
            DescribeProducersResponse response = this.buildDescribeProducersResponse(topicPartition, expected);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof DescribeProducersRequest, (AbstractResponse)response, leader);
            DescribeProducersResult result = env.adminClient().describeProducers(Collections.singleton(topicPartition));
            KafkaFuture partitionFuture = result.partitionResult(topicPartition);
            Assertions.assertEquals(new HashSet<ProducerState>(expected), new HashSet(((DescribeProducersResult.PartitionProducerState)partitionFuture.get()).activeProducers()));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDescribeProducersTimeout(boolean timeoutInMetadataLookup) throws Exception {
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, new String[0]);){
            TopicPartition topicPartition = new TopicPartition("foo", 0);
            int requestTimeoutMs = 15000;
            if (!timeoutInMetadataLookup) {
                Node leader = (Node)env.cluster().nodes().iterator().next();
                this.expectMetadataRequest(env, topicPartition, leader);
            }
            DescribeProducersOptions options = (DescribeProducersOptions)new DescribeProducersOptions().timeoutMs(Integer.valueOf(requestTimeoutMs));
            DescribeProducersResult result = env.adminClient().describeProducers(Collections.singleton(topicPartition), options);
            Assertions.assertFalse((boolean)result.all().isDone());
            time.sleep(requestTimeoutMs);
            TestUtils.waitForCondition(() -> result.all().isDone(), "Future failed to timeout after expiration of timeout");
            Assertions.assertTrue((boolean)result.all().isCompletedExceptionally());
            TestUtils.assertFutureThrows(TimeoutException.class, result.all());
            Assertions.assertFalse((boolean)env.kafkaClient().hasInFlightRequests());
        }
    }

    @Test
    public void testDescribeProducersRetryAfterDisconnect() throws Exception {
        MockTime time = new MockTime();
        int retryBackoffMs = 100;
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        Map<String, Object> configOverride = KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoffMs);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, configOverride);){
            TopicPartition topicPartition = new TopicPartition("foo", 0);
            Iterator nodeIterator = env.cluster().nodes().iterator();
            Node initialLeader = (Node)nodeIterator.next();
            this.expectMetadataRequest(env, topicPartition, initialLeader);
            List<ProducerState> expected = Arrays.asList(new ProducerState(12345L, 15, 30, env.time().milliseconds(), OptionalInt.of(99), OptionalLong.empty()), new ProducerState(12345L, 15, 30, env.time().milliseconds(), OptionalInt.empty(), OptionalLong.of(23423L)));
            DescribeProducersResponse response = this.buildDescribeProducersResponse(topicPartition, expected);
            env.kafkaClient().prepareResponseFrom(request -> {
                env.time().sleep((long)retryBackoffMs);
                return request instanceof DescribeProducersRequest;
            }, (AbstractResponse)response, initialLeader, true);
            Node retryLeader = (Node)nodeIterator.next();
            this.expectMetadataRequest(env, topicPartition, retryLeader);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof DescribeProducersRequest, (AbstractResponse)response, retryLeader);
            DescribeProducersResult result = env.adminClient().describeProducers(Collections.singleton(topicPartition));
            KafkaFuture partitionFuture = result.partitionResult(topicPartition);
            Assertions.assertEquals(new HashSet<ProducerState>(expected), new HashSet(((DescribeProducersResult.PartitionProducerState)partitionFuture.get()).activeProducers()));
        }
    }

    @Test
    public void testDescribeTransactions() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            String transactionalId = "foo";
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            TransactionDescription expected = new TransactionDescription(coordinator.id(), TransactionState.COMPLETE_COMMIT, 12345L, 15, 10000L, OptionalLong.empty(), Collections.emptySet());
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, transactionalId, coordinator));
            env.kafkaClient().prepareResponseFrom(request -> request instanceof DescribeTransactionsRequest, (AbstractResponse)new DescribeTransactionsResponse(new DescribeTransactionsResponseData().setTransactionStates(Collections.singletonList(new DescribeTransactionsResponseData.TransactionState().setErrorCode(Errors.NONE.code()).setProducerEpoch((short)expected.producerEpoch()).setProducerId(expected.producerId()).setTransactionalId(transactionalId).setTransactionTimeoutMs(10000).setTransactionStartTimeMs(-1L).setTransactionState(expected.state().toString())))), coordinator);
            DescribeTransactionsResult result = env.adminClient().describeTransactions(Collections.singleton(transactionalId));
            KafkaFuture future = result.description(transactionalId);
            Assertions.assertEquals((Object)expected, (Object)future.get());
        }
    }

    @Test
    public void testRetryDescribeTransactionsAfterNotCoordinatorError() throws Exception {
        MockTime time = new MockTime();
        int retryBackoffMs = 100;
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        Map<String, Object> configOverride = KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoffMs);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, configOverride);){
            String transactionalId = "foo";
            Iterator nodeIterator = env.cluster().nodes().iterator();
            Node coordinator1 = (Node)nodeIterator.next();
            Node coordinator2 = (Node)nodeIterator.next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)new FindCoordinatorResponse(new FindCoordinatorResponseData().setCoordinators(Collections.singletonList(new FindCoordinatorResponseData.Coordinator().setKey(transactionalId).setErrorCode(Errors.NONE.code()).setNodeId(coordinator1.id()).setHost(coordinator1.host()).setPort(coordinator1.port())))));
            env.kafkaClient().prepareResponseFrom(request -> {
                if (!(request instanceof DescribeTransactionsRequest)) {
                    return false;
                }
                time.sleep(retryBackoffMs);
                return true;
            }, (AbstractResponse)new DescribeTransactionsResponse(new DescribeTransactionsResponseData().setTransactionStates(Collections.singletonList(new DescribeTransactionsResponseData.TransactionState().setErrorCode(Errors.NOT_COORDINATOR.code()).setTransactionalId(transactionalId)))), coordinator1);
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)new FindCoordinatorResponse(new FindCoordinatorResponseData().setCoordinators(Collections.singletonList(new FindCoordinatorResponseData.Coordinator().setKey(transactionalId).setErrorCode(Errors.NONE.code()).setNodeId(coordinator2.id()).setHost(coordinator2.host()).setPort(coordinator2.port())))));
            TransactionDescription expected = new TransactionDescription(coordinator2.id(), TransactionState.COMPLETE_COMMIT, 12345L, 15, 10000L, OptionalLong.empty(), Collections.emptySet());
            env.kafkaClient().prepareResponseFrom(request -> request instanceof DescribeTransactionsRequest, (AbstractResponse)new DescribeTransactionsResponse(new DescribeTransactionsResponseData().setTransactionStates(Collections.singletonList(new DescribeTransactionsResponseData.TransactionState().setErrorCode(Errors.NONE.code()).setProducerEpoch((short)expected.producerEpoch()).setProducerId(expected.producerId()).setTransactionalId(transactionalId).setTransactionTimeoutMs(10000).setTransactionStartTimeMs(-1L).setTransactionState(expected.state().toString())))), coordinator2);
            DescribeTransactionsResult result = env.adminClient().describeTransactions(Collections.singleton(transactionalId));
            KafkaFuture future = result.description(transactionalId);
            Assertions.assertEquals((Object)expected, (Object)future.get());
        }
    }

    @Test
    public void testAbortTransaction() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            TopicPartition topicPartition = new TopicPartition("foo", 13);
            AbortTransactionSpec abortSpec = new AbortTransactionSpec(topicPartition, 12345L, 15, 200);
            Node leader = (Node)env.cluster().nodes().iterator().next();
            this.expectMetadataRequest(env, topicPartition, leader);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof WriteTxnMarkersRequest, (AbstractResponse)this.writeTxnMarkersResponse(abortSpec, Errors.NONE), leader);
            AbortTransactionResult result = env.adminClient().abortTransaction(abortSpec);
            Assertions.assertNull((Object)result.all().get());
        }
    }

    @Test
    public void testAbortTransactionFindLeaderAfterDisconnect() throws Exception {
        MockTime time = new MockTime();
        int retryBackoffMs = 100;
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        Map<String, Object> configOverride = KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoffMs);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, configOverride);){
            TopicPartition topicPartition = new TopicPartition("foo", 13);
            AbortTransactionSpec abortSpec = new AbortTransactionSpec(topicPartition, 12345L, 15, 200);
            Iterator nodeIterator = env.cluster().nodes().iterator();
            Node firstLeader = (Node)nodeIterator.next();
            this.expectMetadataRequest(env, topicPartition, firstLeader);
            WriteTxnMarkersResponse response = this.writeTxnMarkersResponse(abortSpec, Errors.NONE);
            env.kafkaClient().prepareResponseFrom(request -> {
                time.sleep(retryBackoffMs);
                return request instanceof WriteTxnMarkersRequest;
            }, (AbstractResponse)response, firstLeader, true);
            Node retryLeader = (Node)nodeIterator.next();
            this.expectMetadataRequest(env, topicPartition, retryLeader);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof WriteTxnMarkersRequest, (AbstractResponse)response, retryLeader);
            AbortTransactionResult result = env.adminClient().abortTransaction(abortSpec);
            Assertions.assertNull((Object)result.all().get());
        }
    }

    @Test
    public void testForceTerminateTransaction() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            String transactionalId = "testForceTerminate";
            Node transactionCoordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, transactionalId, transactionCoordinator));
            InitProducerIdResponseData initProducerIdResponseData = new InitProducerIdResponseData().setProducerId(5678L).setProducerEpoch((short)123);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof InitProducerIdRequest, (AbstractResponse)new InitProducerIdResponse(initProducerIdResponseData), transactionCoordinator);
            TerminateTransactionResult result = env.adminClient().forceTerminateTransaction(transactionalId);
            Assertions.assertNull((Object)result.result().get());
        }
    }

    @Test
    public void testForceTerminateTransactionWithError() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            String transactionalId = "testForceTerminateError";
            Node transactionCoordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, transactionalId, transactionCoordinator));
            env.kafkaClient().prepareResponseFrom(request -> request instanceof InitProducerIdRequest, (AbstractResponse)new InitProducerIdResponse(new InitProducerIdResponseData().setErrorCode(Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED.code())), transactionCoordinator);
            TerminateTransactionResult result = env.adminClient().forceTerminateTransaction(transactionalId);
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> result.result().get());
            Assertions.assertTrue((boolean)(exception.getCause() instanceof TransactionalIdAuthorizationException));
        }
    }

    @Test
    public void testForceTerminateTransactionWithCustomTimeout() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            String transactionalId = "testForceTerminateTimeout";
            Node transactionCoordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, transactionalId, transactionCoordinator));
            InitProducerIdResponseData initProducerIdResponseData = new InitProducerIdResponseData().setProducerId(9012L).setProducerEpoch((short)456);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof InitProducerIdRequest, (AbstractResponse)new InitProducerIdResponse(initProducerIdResponseData), transactionCoordinator);
            TerminateTransactionOptions options = (TerminateTransactionOptions)new TerminateTransactionOptions().timeoutMs(Integer.valueOf(10000));
            TerminateTransactionResult result = env.adminClient().forceTerminateTransaction(transactionalId, options);
            Assertions.assertNull((Object)result.result().get());
        }
    }

    @Test
    public void testListTransactions() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            MetadataResponseData.MetadataResponseBrokerCollection brokers = new MetadataResponseData.MetadataResponseBrokerCollection();
            env.cluster().nodes().forEach(node -> brokers.add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseBroker().setHost(node.host()).setNodeId(node.id()).setPort(node.port()).setRack(node.rack())));
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, (AbstractResponse)new MetadataResponse(new MetadataResponseData().setBrokers(brokers), 13));
            List<TransactionListing> expected = Arrays.asList(new TransactionListing("foo", 12345L, TransactionState.ONGOING), new TransactionListing("bar", 98765L, TransactionState.PREPARE_ABORT), new TransactionListing("baz", 13579L, TransactionState.COMPLETE_COMMIT));
            Assertions.assertEquals(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)), env.cluster().nodes().stream().map(Node::id).collect(Collectors.toSet()));
            env.cluster().nodes().forEach(node -> {
                ListTransactionsResponseData response = new ListTransactionsResponseData().setErrorCode(Errors.NONE.code());
                TransactionListing listing = (TransactionListing)expected.get(node.id());
                response.transactionStates().add(new ListTransactionsResponseData.TransactionState().setTransactionalId(listing.transactionalId()).setProducerId(listing.producerId()).setTransactionState(listing.state().toString()));
                env.kafkaClient().prepareResponseFrom(request -> request instanceof ListTransactionsRequest, (AbstractResponse)new ListTransactionsResponse(response), (Node)node);
            });
            ListTransactionsResult result = env.adminClient().listTransactions();
            Assertions.assertEquals(new HashSet<TransactionListing>(expected), new HashSet((Collection)result.all().get()));
        }
    }

    private WriteTxnMarkersResponse writeTxnMarkersResponse(AbortTransactionSpec abortSpec, Errors error) {
        WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult partitionResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult().setPartitionIndex(abortSpec.topicPartition().partition()).setErrorCode(error.code());
        WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult topicResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult().setName(abortSpec.topicPartition().topic());
        topicResponse.partitions().add(partitionResponse);
        WriteTxnMarkersResponseData.WritableTxnMarkerResult markerResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerResult().setProducerId(abortSpec.producerId());
        markerResponse.topics().add(topicResponse);
        WriteTxnMarkersResponseData response = new WriteTxnMarkersResponseData();
        response.markers().add(markerResponse);
        return new WriteTxnMarkersResponse(response);
    }

    private DescribeProducersResponse buildDescribeProducersResponse(TopicPartition topicPartition, List<ProducerState> producerStates) {
        DescribeProducersResponseData response = new DescribeProducersResponseData();
        DescribeProducersResponseData.TopicResponse topicResponse = new DescribeProducersResponseData.TopicResponse().setName(topicPartition.topic());
        response.topics().add(topicResponse);
        DescribeProducersResponseData.PartitionResponse partitionResponse = new DescribeProducersResponseData.PartitionResponse().setPartitionIndex(topicPartition.partition()).setErrorCode(Errors.NONE.code());
        topicResponse.partitions().add(partitionResponse);
        partitionResponse.setActiveProducers(producerStates.stream().map(producerState -> new DescribeProducersResponseData.ProducerState().setProducerId(producerState.producerId()).setProducerEpoch(producerState.producerEpoch()).setCoordinatorEpoch(producerState.coordinatorEpoch().orElse(-1)).setLastSequence(producerState.lastSequence()).setLastTimestamp(producerState.lastTimestamp()).setCurrentTxnStartOffset(producerState.currentTransactionStartOffset().orElse(-1L))).collect(Collectors.toList()));
        return new DescribeProducersResponse(response);
    }

    private void expectMetadataRequest(AdminClientUnitTestEnv env, TopicPartition topicPartition, Node leader) {
        MetadataResponseData.MetadataResponseTopicCollection responseTopics = new MetadataResponseData.MetadataResponseTopicCollection();
        MetadataResponseData.MetadataResponseTopic responseTopic = new MetadataResponseData.MetadataResponseTopic().setName(topicPartition.topic()).setErrorCode(Errors.NONE.code());
        responseTopics.add((ImplicitLinkedHashCollection.Element)responseTopic);
        MetadataResponseData.MetadataResponsePartition responsePartition = new MetadataResponseData.MetadataResponsePartition().setErrorCode(Errors.NONE.code()).setPartitionIndex(topicPartition.partition()).setLeaderId(leader.id()).setReplicaNodes(Collections.singletonList(leader.id())).setIsrNodes(Collections.singletonList(leader.id()));
        responseTopic.partitions().add(responsePartition);
        env.kafkaClient().prepareResponse(request -> {
            if (!(request instanceof MetadataRequest)) {
                return false;
            }
            MetadataRequest metadataRequest = (MetadataRequest)request;
            return metadataRequest.topics().equals(Collections.singletonList(topicPartition.topic()));
        }, (AbstractResponse)new MetadataResponse(new MetadataResponseData().setTopics(responseTopics), 13));
    }

    @Test
    public void testClientSideTimeoutAfterFailureToSend() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        CompletableFuture<String> disconnectFuture = new CompletableFuture<String>();
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, KafkaAdminClientTest.newStrMap("request.timeout.ms", "1", "default.api.timeout.ms", "100000", "retry.backoff.ms", "1"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Node node2 : cluster.nodes()) {
                env.kafkaClient().delayReady(node2, 100L);
            }
            CountDownLatch readyLatch = new CountDownLatch(2);
            env.kafkaClient().setDisconnectFuture(disconnectFuture);
            env.kafkaClient().setReadyCallback(node -> readyLatch.countDown());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListTopicsResult result = env.adminClient().listTopics();
            readyLatch.await(15000L, TimeUnit.MILLISECONDS);
            log.debug("Advancing clock by 25 ms to trigger client-side disconnect.");
            time.sleep(25L);
            disconnectFuture.get();
            log.debug("Enabling nodes to send requests again.");
            for (Node node3 : cluster.nodes()) {
                env.kafkaClient().delayReady(node3, 0L);
            }
            time.sleep(5L);
            log.info("Waiting for result.");
            Assertions.assertEquals((int)0, (int)((Collection)result.listings().get()).size());
        }
    }

    @Test
    public void testClientSideTimeoutAfterFailureToReceiveResponse() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        CompletableFuture<String> disconnectFuture = new CompletableFuture<String>();
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, KafkaAdminClientTest.newStrMap("request.timeout.ms", "1", "default.api.timeout.ms", "100000", "retry.backoff.ms", "0"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().setDisconnectFuture(disconnectFuture);
            ListTopicsResult result = env.adminClient().listTopics();
            TestUtils.waitForCondition(() -> {
                time.sleep(1L);
                return disconnectFuture.isDone();
            }, 5000L, 1L, () -> "Timed out waiting for expected disconnect");
            Assertions.assertFalse((boolean)disconnectFuture.isCompletedExceptionally());
            Assertions.assertFalse((boolean)result.future.isDone());
            TestUtils.waitForCondition(env.kafkaClient()::hasInFlightRequests, "Timed out waiting for retry");
            env.kafkaClient().respond((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            Assertions.assertEquals((int)0, (int)((Collection)result.listings().get()).size());
        }
    }

    @Test
    public void testFenceProducers() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            String transactionalId = "copyCat";
            Node transactionCoordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, transactionalId, transactionCoordinator));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, transactionalId, transactionCoordinator));
            env.kafkaClient().prepareResponseFrom(request -> request instanceof InitProducerIdRequest, (AbstractResponse)new InitProducerIdResponse(new InitProducerIdResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code())), transactionCoordinator);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof InitProducerIdRequest, (AbstractResponse)new InitProducerIdResponse(new InitProducerIdResponseData().setErrorCode(Errors.NOT_COORDINATOR.code())), transactionCoordinator);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, transactionalId, transactionCoordinator));
            InitProducerIdResponseData initProducerIdResponseData = new InitProducerIdResponseData().setProducerId(4761L).setProducerEpoch((short)489);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof InitProducerIdRequest, (AbstractResponse)new InitProducerIdResponse(initProducerIdResponseData), transactionCoordinator);
            FenceProducersResult result = env.adminClient().fenceProducers(Collections.singleton(transactionalId));
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertEquals((long)4761L, (Long)((Long)result.producerId(transactionalId).get()));
            Assertions.assertEquals((short)489, (Short)((Short)result.epochId(transactionalId).get()));
        }
    }

    @Test
    public void testClientInstanceId() {
        try (MockedStatic mockedCommonClientConfigs = Mockito.mockStatic(CommonClientConfigs.class, (Answer)new CallsRealMethods());){
            ClientTelemetryReporter clientTelemetryReporter = (ClientTelemetryReporter)Mockito.mock(ClientTelemetryReporter.class);
            clientTelemetryReporter.configure((Map)ArgumentMatchers.any());
            mockedCommonClientConfigs.when(() -> CommonClientConfigs.telemetryReporter((String)ArgumentMatchers.anyString(), (AbstractConfig)((AbstractConfig)ArgumentMatchers.any()))).thenReturn(Optional.of(clientTelemetryReporter));
            try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv("enable.metrics.push", "true");){
                ClientTelemetrySender clientTelemetrySender = (ClientTelemetrySender)Mockito.mock(ClientTelemetrySender.class);
                Uuid expectedUuid = Uuid.randomUuid();
                Mockito.when((Object)clientTelemetryReporter.telemetrySender()).thenReturn((Object)clientTelemetrySender);
                Mockito.when((Object)clientTelemetrySender.clientInstanceId((Duration)ArgumentMatchers.any())).thenReturn(Optional.of(expectedUuid));
                Uuid result = env.adminClient().clientInstanceId(Duration.ofSeconds(1L));
                Assertions.assertEquals((Object)expectedUuid, (Object)result);
            }
        }
    }

    @Test
    public void testClientInstanceIdInvalidTimeout() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        KafkaAdminClient admin = (KafkaAdminClient)AdminClient.create((Properties)props);
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> admin.clientInstanceId(Duration.ofMillis(-1L)));
        Assertions.assertEquals((Object)"The timeout cannot be negative.", (Object)exception.getMessage());
        admin.close();
    }

    @Test
    public void testClientInstanceIdNoTelemetryReporterRegistered() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("enable.metrics.push", "false");
        KafkaAdminClient admin = (KafkaAdminClient)AdminClient.create((Properties)props);
        Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> admin.clientInstanceId(Duration.ofMillis(0L)));
        Assertions.assertEquals((Object)"Telemetry is not enabled. Set config `enable.metrics.push` to `true`.", (Object)exception.getMessage());
        admin.close();
    }

    private UnregisterBrokerResponse prepareUnregisterBrokerResponse(Errors error, int throttleTimeMs) {
        return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setErrorCode(error.code()).setErrorMessage(error.message()).setThrottleTimeMs(throttleTimeMs));
    }

    private DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir) {
        return new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(error.code()).setLogDir(logDir))));
    }

    private static OffsetFetchResponse offsetFetchResponse(Errors error) {
        return new OffsetFetchResponse(new OffsetFetchResponseData().setGroups(List.of(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(GROUP_ID).setErrorCode(error.code()))), ApiKeys.OFFSET_FETCH.latestVersion());
    }

    private static MemberDescription convertToMemberDescriptions(DescribeGroupsResponseData.DescribedGroupMember member, MemberAssignment assignment) {
        return new MemberDescription(member.memberId(), Optional.ofNullable(member.groupInstanceId()), member.clientId(), member.clientHost(), assignment, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static ShareMemberDescription convertToShareMemberDescriptions(ShareGroupDescribeResponseData.Member member, ShareMemberAssignment assignment) {
        return new ShareMemberDescription(member.memberId(), member.clientId(), member.clientHost(), assignment, member.memberEpoch());
    }

    @Test
    public void testListClientMetricsResources() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            List<ClientMetricsResourceListing> expected = Arrays.asList(new ClientMetricsResourceListing("one"), new ClientMetricsResourceListing("two"));
            ListConfigResourcesResponseData responseData = new ListConfigResourcesResponseData().setErrorCode(Errors.NONE.code());
            responseData.configResources().add(new ListConfigResourcesResponseData.ConfigResource().setResourceName("one").setResourceType(ConfigResource.Type.CLIENT_METRICS.id()));
            responseData.configResources().add(new ListConfigResourcesResponseData.ConfigResource().setResourceName("two").setResourceType(ConfigResource.Type.CLIENT_METRICS.id()));
            env.kafkaClient().prepareResponse(request -> request instanceof ListConfigResourcesRequest, (AbstractResponse)new ListConfigResourcesResponse(responseData));
            ListClientMetricsResourcesResult result = env.adminClient().listClientMetricsResources();
            Assertions.assertEquals(new HashSet<ClientMetricsResourceListing>(expected), new HashSet((Collection)result.all().get()));
        }
    }

    @Test
    public void testListClientMetricsResourcesEmpty() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            List expected = Collections.emptyList();
            ListConfigResourcesResponseData responseData = new ListConfigResourcesResponseData().setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse(request -> request instanceof ListConfigResourcesRequest, (AbstractResponse)new ListConfigResourcesResponse(responseData));
            ListClientMetricsResourcesResult result = env.adminClient().listClientMetricsResources();
            Assertions.assertEquals(new HashSet(expected), new HashSet((Collection)result.all().get()));
        }
    }

    @Test
    public void testListClientMetricsResourcesNotSupported() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponse(request -> request instanceof ListConfigResourcesRequest, (AbstractResponse)KafkaAdminClientTest.prepareListClientMetricsResourcesResponse(Errors.UNSUPPORTED_VERSION));
            ListClientMetricsResourcesResult result = env.adminClient().listClientMetricsResources();
            Assertions.assertNotNull((Object)result.all());
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.all());
        }
    }

    @Test
    public void testListConfigResources() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            List<ConfigResource> expected = List.of(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "client-metrics"), new ConfigResource(ConfigResource.Type.BROKER, "1"), new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "1"), new ConfigResource(ConfigResource.Type.TOPIC, "topic"), new ConfigResource(ConfigResource.Type.GROUP, "group"));
            ListConfigResourcesResponseData responseData = new ListConfigResourcesResponseData().setErrorCode(Errors.NONE.code());
            expected.forEach(c -> responseData.configResources().add(new ListConfigResourcesResponseData.ConfigResource().setResourceName(c.name()).setResourceType(c.type().id())));
            env.kafkaClient().prepareResponse(request -> request instanceof ListConfigResourcesRequest, (AbstractResponse)new ListConfigResourcesResponse(responseData));
            ListConfigResourcesResult result = env.adminClient().listConfigResources();
            Assertions.assertEquals((int)expected.size(), (int)((Collection)result.all().get()).size());
            Assertions.assertEquals(new HashSet<ConfigResource>(expected), new HashSet((Collection)result.all().get()));
        }
    }

    @Test
    public void testListConfigResourcesEmpty() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            ListConfigResourcesResponseData responseData = new ListConfigResourcesResponseData().setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse(request -> request instanceof ListConfigResourcesRequest, (AbstractResponse)new ListConfigResourcesResponse(responseData));
            ListConfigResourcesResult result = env.adminClient().listConfigResources();
            Assertions.assertTrue((boolean)((Collection)result.all().get()).isEmpty());
        }
    }

    @Test
    public void testListConfigResourcesNotSupported() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponse(request -> request instanceof ListConfigResourcesRequest, (AbstractResponse)new ListConfigResourcesResponse(new ListConfigResourcesResponseData().setErrorCode(Errors.UNSUPPORTED_VERSION.code())));
            ListConfigResourcesResult result = env.adminClient().listConfigResources(Set.of(ConfigResource.Type.UNKNOWN), new ListConfigResourcesOptions());
            Assertions.assertNotNull((Object)result.all());
            TestUtils.assertFutureThrows(UnsupportedVersionException.class, result.all());
        }
    }

    @Test
    public void testCallFailWithUnsupportedVersionExceptionDoesNotHaveConcurrentModificationException() throws InterruptedException {
        final Cluster cluster = KafkaAdminClientTest.mockCluster(1, 0);
        try (MockClient mockClient = new MockClient(Time.SYSTEM, new MockClient.MockMetadataUpdater(){
            final /* synthetic */ KafkaAdminClientTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public List<Node> fetchNodes() {
                return cluster.nodes();
            }

            @Override
            public boolean isUpdateNeeded() {
                return false;
            }

            @Override
            public void update(Time time, MockClient.MetadataUpdate update) {
                throw new UnsupportedOperationException();
            }
        });){
            AdminMetadataManager metadataManager = (AdminMetadataManager)Mockito.mock(AdminMetadataManager.class);
            ((AdminMetadataManager)Mockito.doReturn((Object)false).doReturn((Object)true).when((Object)metadataManager)).isReady();
            ((AdminMetadataManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnsupportedVersionException("Unsupported version")}).doNothing().when((Object)metadataManager)).requestUpdate();
            ((AdminMetadataManager)Mockito.doReturn((Object)false).when((Object)metadataManager)).usingBootstrapControllers();
            ((AdminMetadataManager)Mockito.doReturn((Object)1L).when((Object)metadataManager)).metadataFetchDelayMs(ArgumentMatchers.anyLong());
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            try (KafkaAdminClient admin = KafkaAdminClient.createInternal((AdminClientConfig)new AdminClientConfig(Collections.emptyMap()), (AdminMetadataManager)metadataManager, (KafkaClient)mockClient, (Time)Time.SYSTEM, null);){
                DescribeClusterResult result = admin.describeCluster(new DescribeClusterOptions());
                TestUtils.waitForCondition(() -> mockClient.inFlightRequestCount() != 0, "Timed out waiting for listNodes request");
                ClientRequest request = mockClient.requests().peek();
                Assertions.assertEquals((Object)ApiKeys.METADATA, (Object)request.apiKey());
                mockClient.respondToRequest(request, (AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
                Assertions.assertEquals((Object)cluster.clusterResource().clusterId(), (Object)Assertions.assertDoesNotThrow(() -> (String)result.clusterId().get()));
            }
        }
    }

    private static ListConfigResourcesResponse prepareListClientMetricsResourcesResponse(Errors error) {
        return new ListConfigResourcesResponse(new ListConfigResourcesResponseData().setErrorCode(error.code()));
    }

    @ParameterizedTest
    @EnumSource(value=BrokerComponent.class, names={"UNSPECIFIED", "STORAGE", "NETWORK"})
    public void testAlterBrokerHealth(BrokerComponent component) throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            List<Integer> brokerIds = Arrays.asList(0);
            List<Byte> componentHealthStatuses = Arrays.asList((byte)0);
            List<Errors> brokerErrors = Arrays.asList(Errors.NONE);
            List requestData = brokerIds.stream().map(i -> new AlterBrokerHealthResponseData.BrokerHealthStatusResult().setBrokerId(((Integer)brokerIds.get((int)i)).intValue()).setComponentCode(component.id()).setStatusCode(((Byte)componentHealthStatuses.get((int)i)).byteValue()).setErrorCode(((Errors)brokerErrors.get((int)i)).code()).setErrorMessage(((Errors)brokerErrors.get((int)i)).message())).collect(Collectors.toList());
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterBrokerHealthResponse(new AlterBrokerHealthResponseData().setBrokerHealthStatusResults(requestData)));
            ArrayList futures = new ArrayList(env.adminClient().alterBrokerHealth(new AlterBrokerHealthSpec(new HashSet<Integer>(brokerIds), component, ComponentHealthStatus.DEGRADED, "reason", false), new AlterBrokerHealthOptions()).values().values());
            Assertions.assertEquals((int)brokerIds.size(), (int)futures.size());
            BrokerHealthStatusResult result = (BrokerHealthStatusResult)((KafkaFuture)futures.get(0)).get();
            Assertions.assertEquals((Integer)brokerIds.get(0), (int)result.brokerId());
            Assertions.assertEquals((byte)component.id(), (byte)result.brokerComponent().id());
            Assertions.assertEquals((Byte)componentHealthStatuses.get(0), (byte)result.componentHealthStatus().id());
        }
    }

    @Test
    public void testAlterBrokerHealthHandlesNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new AlterBrokerHealthResponse(new AlterBrokerHealthResponseData().setErrorCode(Errors.NOT_CONTROLLER.code())), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 1, Collections.emptyList()));
            List<AlterBrokerHealthResponseData.BrokerHealthStatusResult> requestData = Arrays.asList(new AlterBrokerHealthResponseData.BrokerHealthStatusResult().setBrokerId(0).setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.HEALTHY.id()).setErrorCode(Errors.NONE.code()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new AlterBrokerHealthResponse(new AlterBrokerHealthResponseData().setBrokerHealthStatusResults(requestData)), env.cluster().nodeById(1));
            Collection futures = env.adminClient().alterBrokerHealth(new AlterBrokerHealthSpec(new HashSet<Integer>(Arrays.asList(0)), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, "", false), new AlterBrokerHealthOptions()).values().values();
            Assertions.assertEquals((int)1, (int)futures.size());
            for (KafkaFuture future : futures) {
                BrokerHealthStatusResult result = (BrokerHealthStatusResult)future.get();
                Assertions.assertEquals((int)0, (int)result.brokerId());
            }
        }
    }

    @Test
    public void testAlterBrokerHealthExceptionHandling() throws Exception {
        List<Errors> errors = Arrays.asList(Errors.CLUSTER_AUTHORIZATION_FAILED, Errors.INVALID_REQUEST);
        for (Errors error : errors) {
            AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);
            try {
                KafkaAdminClientTest.alterBrokerHealthExceptionHelper(env, error);
            }
            finally {
                if (env == null) continue;
                env.close();
            }
        }
    }

    @Test
    public void testAlterBrokerHealthHandlesTimeoutException() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(new MockTime(1500L), KafkaAdminClientTest.mockCluster(3, 0));){
            KafkaAdminClientTest.alterBrokerHealthExceptionHelper(env, Errors.REQUEST_TIMED_OUT);
        }
    }

    private static void alterBrokerHealthExceptionHelper(AdminClientUnitTestEnv env, Errors error) throws Exception {
        env.kafkaClient().prepareResponse((AbstractResponse)new AlterBrokerHealthResponse(new AlterBrokerHealthResponseData().setErrorCode(error.code())));
        AlterBrokerHealthResult result = env.adminClient().alterBrokerHealth(new AlterBrokerHealthSpec(new HashSet<Integer>(Arrays.asList(1)), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, "demo", false), new AlterBrokerHealthOptions());
        TestUtils.assertFutureThrows(error.exception().getClass(), (Future)result.values().values().toArray()[0]);
    }

    @ParameterizedTest
    @EnumSource(value=BrokerComponent.class, names={"UNSPECIFIED", "STORAGE", "NETWORK"})
    public void testDescribeBrokerHealth(BrokerComponent component) throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            boolean brokerId = false;
            String reason = "reason";
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeBrokerHealthResponse(new DescribeBrokerHealthResponseData().setDegradedBrokers(Collections.singletonList(new DescribeBrokerHealthResponseData.DegradedBroker().setBrokerId(0).setDegradedBrokerComponents(Collections.singletonList(new DescribeBrokerHealthResponseData.DegradedBrokerComponent().setReason("reason").setComponentCode(component.id())))))));
            Collection brokers = (Collection)env.adminClient().describeBrokerHealth(new DescribeBrokerHealthOptions()).future().get();
            Assertions.assertEquals((int)1, (int)brokers.size());
            brokers.forEach(broker -> {
                Assertions.assertEquals((int)0, (int)broker.brokerId());
                Assertions.assertEquals((int)1, (int)broker.degradedBrokerComponents().size());
                Assertions.assertEquals((Object)"reason", (Object)((DegradedBrokerComponent)broker.degradedBrokerComponents().iterator().next()).reason());
                Assertions.assertEquals((Object)component, (Object)((DegradedBrokerComponent)broker.degradedBrokerComponents().iterator().next()).brokerComponent());
            });
        }
    }

    @Test
    public void testDescribeNetwork() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            CloudAdmin adminClient = env.adminClient();
            String tenant = "tenant1";
            String listenerName = "EXTERNAL";
            List<String> ipAddrList = Arrays.asList("1.2.3.4", "10.20.30.40");
            List apiKeys = Collections.emptyList();
            List<DescribeNetworkResponseData.TenantIpAddr> tenantIpAddrList = Arrays.asList(new DescribeNetworkResponseData.TenantIpAddr().setTenantId("tenant1").setIpAddress(ipAddrList.get(0)), new DescribeNetworkResponseData.TenantIpAddr().setTenantId("tenant1").setIpAddress(ipAddrList.get(1)));
            List<DescribeNetworkResponseData.ClientApiKeyIpAddr> failedRequests = Arrays.asList(new DescribeNetworkResponseData.ClientApiKeyIpAddr().setClientApiKey("client-key1").setIpAddress("1.2.3.4"));
            DescribeNetworkResponseData responseData = new DescribeNetworkResponseData().setTenantIpAddrList(tenantIpAddrList).setClientApiKeyIpAddrList(failedRequests);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeNetworkResponse(responseData));
            List<Integer> brokerIds = Arrays.asList(0);
            DescribeNetworkResult result = adminClient.describeNetwork("tenant1", "EXTERNAL", ipAddrList, apiKeys, brokerIds, new DescribeNetworkOptions());
            DescribeNetworkResponseData resultData = (DescribeNetworkResponseData)((KafkaFuture)result.value().get(0)).get();
            Assertions.assertEquals((Object)resultData.clientApiKeyIpAddrList(), failedRequests);
            Assertions.assertEquals((Object)resultData.tenantIpAddrList(), tenantIpAddrList);
        }
    }

    @Test
    public void testDescribeCellLoad() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            CloudAdmin adminClient = env.adminClient();
            List<DescribeCellLoadResponseData.CellLoad> expectedCellLoad = Arrays.asList(new DescribeCellLoadResponseData.CellLoad().setCellId(5).setLoad(1.0), new DescribeCellLoadResponseData.CellLoad().setCellId(7).setLoad(0.8));
            DescribeCellLoadResponseData responseData = new DescribeCellLoadResponseData().setCells(expectedCellLoad);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeCellLoadResponse(responseData));
            CellLoadResult result = adminClient.describeCellLoad((Collection)expectedCellLoad.stream().map(x -> x.cellId()).collect(Collectors.toList()), new DescribeCellLoadOptions());
            List cellLoad = (List)result.value().get();
            Assertions.assertEquals((int)expectedCellLoad.size(), (int)cellLoad.size());
            Assertions.assertEquals(expectedCellLoad, (Object)cellLoad);
        }
    }

    @Test
    public void testDescribeBrokerHealthHandlesNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeBrokerHealthResponse(new DescribeBrokerHealthResponseData().setErrorCode(Errors.NOT_CONTROLLER.code())), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 1, Collections.emptyList()));
            int brokerId = 0;
            String reason = "testing";
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeBrokerHealthResponse(new DescribeBrokerHealthResponseData().setDegradedBrokers(Collections.singletonList(new DescribeBrokerHealthResponseData.DegradedBroker().setBrokerId(brokerId).setDegradedBrokerComponents(Collections.singletonList(new DescribeBrokerHealthResponseData.DegradedBrokerComponent().setReason(reason).setComponentCode(BrokerComponent.UNSPECIFIED.id())))))), env.cluster().nodeById(1));
            Collection brokers = (Collection)env.adminClient().describeBrokerHealth(new DescribeBrokerHealthOptions()).future().get();
            Assertions.assertEquals((int)1, (int)brokers.size());
            brokers.forEach(broker -> {
                Assertions.assertEquals((int)brokerId, (int)broker.brokerId());
                Assertions.assertEquals((int)1, (int)broker.degradedBrokerComponents().size());
                Assertions.assertEquals((Object)reason, (Object)((DegradedBrokerComponent)broker.degradedBrokerComponents().iterator().next()).reason());
                Assertions.assertEquals((Object)BrokerComponent.UNSPECIFIED, (Object)((DegradedBrokerComponent)broker.degradedBrokerComponents().iterator().next()).brokerComponent());
            });
        }
    }

    @Test
    public void testDescribeBrokerHealthHandlesClusterAuthorizationException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            KafkaAdminClientTest.testDescribeBrokerHealthExceptionHelper(env, Errors.CLUSTER_AUTHORIZATION_FAILED);
        }
    }

    @Test
    public void testDescribeBrokerHealthHandlesTimeoutException() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(new MockTime(1500L), KafkaAdminClientTest.mockCluster(3, 0));){
            KafkaAdminClientTest.testDescribeBrokerHealthExceptionHelper(env, Errors.REQUEST_TIMED_OUT);
        }
    }

    @Test
    public void testDescribeBrokerHealthOlderBrokerVersion() throws Exception {
        ApiVersionsResponseData.ApiVersion describeBrokerHealthV0 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.DESCRIBE_BROKER_HEALTH.id).setMinVersion((short)0).setMaxVersion((short)3);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            boolean brokerId = false;
            String reason = "reason";
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Collections.singletonList(describeBrokerHealthV0)));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeBrokerHealthResponse(new DescribeBrokerHealthResponseData().setDegradedBrokers(Collections.singletonList(new DescribeBrokerHealthResponseData.DegradedBroker().setBrokerId(0).setDeprecatedReasonsV0(Collections.singletonList(new DescribeBrokerHealthResponseData.Reason().setReason("reason")))))));
            Collection brokers = (Collection)env.adminClient().describeBrokerHealth(new DescribeBrokerHealthOptions()).future().get();
            Assertions.assertEquals((int)1, (int)brokers.size());
            brokers.forEach(broker -> {
                Assertions.assertEquals((int)0, (int)broker.brokerId());
                Assertions.assertEquals((int)1, (int)broker.degradedBrokerComponents().size());
                Assertions.assertEquals((int)1, (int)broker.reasons().size());
                Assertions.assertEquals((Object)"reason", broker.reasons().get(0));
                Assertions.assertTrue((boolean)broker.degradedBrokerComponents().contains(new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id())));
            });
        }
    }

    @Test
    public void testInterceptor() throws Exception {
        AtomicReference currentInterceptor = new AtomicReference();
        AdminRequestInterceptor.Factory interceptorFactory = requestBuilder -> {
            TestInterceptor interceptor = new TestInterceptor((AbstractRequest.Builder)requestBuilder.apply(10));
            currentInterceptor.set(interceptor);
            return interceptor;
        };
        Uuid topicId = Uuid.randomUuid();
        CreateTopicsResponseData createTopicsResponseData = new CreateTopicsResponseData();
        createTopicsResponseData.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName("myTopic").setTopicId(topicId).setNumPartitions(10).setReplicationFactor((short)3).setErrorCode(Errors.NONE.code()));
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, KafkaAdminClientTest.mockCluster(3, 0), AdminClientUnitTestEnv.clientConfigs(new String[0]), Collections.emptyMap(), interceptorFactory);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("myTopic"), (AbstractResponse)new CreateTopicsResponse(createTopicsResponseData));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2))))).topicId("myTopic");
            Assertions.assertFalse((boolean)future.isDone());
            Assertions.assertNotNull(currentInterceptor.get());
            ((TestInterceptor)currentInterceptor.get()).ready = true;
            Assertions.assertEquals((Object)topicId, (Object)future.get(10L, TimeUnit.SECONDS));
            currentInterceptor.set(null);
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("prefix_myTopic"), (AbstractResponse)new CreateTopicsResponse(createTopicsResponseData));
            future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2))))).topicId("myTopic");
            Assertions.assertFalse((boolean)future.isDone());
            Assertions.assertNotNull(currentInterceptor.get());
            CreateTopicsRequestData.CreatableTopicCollection topics = new CreateTopicsRequestData.CreatableTopicCollection();
            topics.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName("prefix_myTopic"));
            ((TestInterceptor)currentInterceptor.get()).requestBuilder = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topics));
            ((TestInterceptor)currentInterceptor.get()).ready = true;
            Assertions.assertEquals((Object)topicId, (Object)future.get(10L, TimeUnit.SECONDS));
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("myTopic"), (AbstractResponse)new CreateTopicsResponse(createTopicsResponseData));
            future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2))))).topicId("myTopic");
            Assertions.assertFalse((boolean)future.isDone());
            Assertions.assertNotNull(currentInterceptor.get());
            Uuid transformedTopicId = Uuid.randomUuid();
            ((CreateTopicsResponseData.CreatableTopicResult)createTopicsResponseData.topics().iterator().next()).setTopicId(transformedTopicId);
            ((TestInterceptor)currentInterceptor.get()).responseTransformer = unused -> new CreateTopicsResponse(createTopicsResponseData);
            ((TestInterceptor)currentInterceptor.get()).ready = true;
            Assertions.assertEquals((Object)transformedTopicId, (Object)future.get(10L, TimeUnit.SECONDS));
            ListTopicsResult result = env.adminClient().listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(1000)));
            KafkaFuture listingFuture = result.listings();
            Assertions.assertFalse((boolean)listingFuture.isDone());
            Assertions.assertNotNull(currentInterceptor.get());
            MetadataResponseData.MetadataResponseTopicCollection metadataTopics = new MetadataResponseData.MetadataResponseTopicCollection();
            metadataTopics.add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseTopic().setName("myTopic").setTopicId(topicId));
            ((TestInterceptor)currentInterceptor.get()).interceptedResponse = new MetadataResponse(new MetadataResponseData().setTopics(metadataTopics), ApiKeys.METADATA.latestVersion());
            ((TestInterceptor)currentInterceptor.get()).ready = true;
            Set<String> topicListing = Collections.singleton(new TopicListing("myTopic", topicId, false, TopicType.STANDARD).toString());
            Assertions.assertEquals(topicListing, ((Collection)listingFuture.get(10L, TimeUnit.SECONDS)).stream().map(TopicListing::toString).collect(Collectors.toSet()));
            Assertions.assertEquals((int)0, (int)env.kafkaClient().requests().size());
        }
    }

    private static void testDescribeBrokerHealthExceptionHelper(AdminClientUnitTestEnv env, Errors error) throws Exception {
        env.kafkaClient().prepareResponse((AbstractResponse)new DescribeBrokerHealthResponse(new DescribeBrokerHealthResponseData().setErrorCode(error.code())));
        DescribeBrokerHealthResult result = env.adminClient().describeBrokerHealth(new DescribeBrokerHealthOptions());
        TestUtils.assertFutureThrows(error.exception().getClass(), result.future());
    }

    @SafeVarargs
    private static <T> void assertCollectionIs(Collection<T> collection, T ... elements) {
        for (T element : elements) {
            Assertions.assertTrue((boolean)collection.contains(element), (String)("Did not find " + String.valueOf(element)));
        }
        Assertions.assertEquals((int)elements.length, (int)collection.size(), (String)"There are unexpected extra elements in the collection.");
    }

    public static KafkaAdminClient createInternal(AdminClientConfig config, KafkaAdminClient.TimeoutProcessorFactory timeoutProcessorFactory) {
        return KafkaAdminClient.createInternal((AdminClientConfig)config, (KafkaAdminClient.TimeoutProcessorFactory)timeoutProcessorFactory);
    }

    @ParameterizedTest
    @CsvSource(value={"false, false", "false, true", "true, false", "true, true"})
    public void testAddRaftVoterRequest(boolean fail, boolean sendClusterId) throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv("bootstrap.controllers", "dummy");){
            AddRaftVoterResponseData responseData = new AddRaftVoterResponseData();
            if (fail) {
                responseData.setErrorCode(Errors.DUPLICATE_VOTER.code()).setErrorMessage("duplicate");
            }
            AtomicReference requestData = new AtomicReference();
            env.kafkaClient().prepareResponse(request -> {
                if (!(request instanceof AddRaftVoterRequest)) {
                    return false;
                }
                requestData.set((AddRaftVoterRequestData)request.data());
                return true;
            }, (AbstractResponse)new AddRaftVoterResponse(responseData));
            AddRaftVoterOptions options = new AddRaftVoterOptions();
            if (sendClusterId) {
                options.setClusterId(Optional.of("_o_GnDGwQaWu4r-NMzmkTw"));
            }
            AddRaftVoterResult result = env.adminClient().addRaftVoter(1, Uuid.fromString((String)"YAfa4HClT3SIIW2klIUspg"), Collections.singleton(new RaftVoterEndpoint("CONTROLLER", "example.com", 8080)), options);
            Assertions.assertNotNull((Object)result.all());
            if (fail) {
                TestUtils.assertFutureThrows(DuplicateVoterException.class, result.all());
            } else {
                result.all().get();
            }
            if (sendClusterId) {
                Assertions.assertEquals((Object)"_o_GnDGwQaWu4r-NMzmkTw", (Object)((AddRaftVoterRequestData)requestData.get()).clusterId());
            } else {
                Assertions.assertNull((Object)((AddRaftVoterRequestData)requestData.get()).clusterId());
            }
            Assertions.assertEquals((int)1000, (int)((AddRaftVoterRequestData)requestData.get()).timeoutMs());
            Assertions.assertEquals((int)1, (int)((AddRaftVoterRequestData)requestData.get()).voterId());
            Assertions.assertEquals((Object)Uuid.fromString((String)"YAfa4HClT3SIIW2klIUspg"), (Object)((AddRaftVoterRequestData)requestData.get()).voterDirectoryId());
            Assertions.assertEquals((Object)new AddRaftVoterRequestData.Listener().setName("CONTROLLER").setHost("example.com").setPort(8080), (Object)((AddRaftVoterRequestData)requestData.get()).listeners().find("CONTROLLER"));
            if (fail && !sendClusterId) {
                responseData.setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code()).setErrorMessage("test");
                env.kafkaClient().prepareResponse(request -> {
                    if (!(request instanceof AddRaftVoterRequest)) {
                        return false;
                    }
                    requestData.set((AddRaftVoterRequestData)request.data());
                    return true;
                }, (AbstractResponse)new AddRaftVoterResponse(responseData));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Integer.MIN_VALUE, true));
                AddRaftVoterResponseData responseData2 = new AddRaftVoterResponseData();
                env.kafkaClient().prepareResponse(request -> {
                    if (!(request instanceof AddRaftVoterRequest)) {
                        return false;
                    }
                    requestData.set((AddRaftVoterRequestData)request.data());
                    return true;
                }, (AbstractResponse)new AddRaftVoterResponse(responseData2));
                AddRaftVoterResult result2 = env.adminClient().addRaftVoter(1, Uuid.fromString((String)"YAfa4HClT3SIIW2klIUspg"), Collections.singleton(new RaftVoterEndpoint("CONTROLLER", "example.com", 8080)), options);
                result2.all().get();
            }
        }
    }

    @ParameterizedTest
    @CsvSource(value={"false, false", "false, true", "true, false", "true, true"})
    public void testRemoveRaftVoterRequest(boolean fail, boolean sendClusterId) throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv("bootstrap.controllers", "dummy");){
            RemoveRaftVoterResponseData responseData = new RemoveRaftVoterResponseData();
            if (fail) {
                responseData.setErrorCode(Errors.VOTER_NOT_FOUND.code()).setErrorMessage("not found");
            }
            AtomicReference requestData = new AtomicReference();
            env.kafkaClient().prepareResponse(request -> {
                if (!(request instanceof RemoveRaftVoterRequest)) {
                    return false;
                }
                requestData.set((RemoveRaftVoterRequestData)request.data());
                return true;
            }, (AbstractResponse)new RemoveRaftVoterResponse(responseData));
            RemoveRaftVoterOptions options = new RemoveRaftVoterOptions();
            if (sendClusterId) {
                options.setClusterId(Optional.of("_o_GnDGwQaWu4r-NMzmkTw"));
            }
            RemoveRaftVoterResult result = env.adminClient().removeRaftVoter(1, Uuid.fromString((String)"YAfa4HClT3SIIW2klIUspg"), options);
            Assertions.assertNotNull((Object)result.all());
            if (fail) {
                TestUtils.assertFutureThrows(VoterNotFoundException.class, result.all());
            } else {
                result.all().get();
            }
            if (sendClusterId) {
                Assertions.assertEquals((Object)"_o_GnDGwQaWu4r-NMzmkTw", (Object)((RemoveRaftVoterRequestData)requestData.get()).clusterId());
            } else {
                Assertions.assertNull((Object)((RemoveRaftVoterRequestData)requestData.get()).clusterId());
            }
            Assertions.assertEquals((int)1, (int)((RemoveRaftVoterRequestData)requestData.get()).voterId());
            Assertions.assertEquals((Object)Uuid.fromString((String)"YAfa4HClT3SIIW2klIUspg"), (Object)((RemoveRaftVoterRequestData)requestData.get()).voterDirectoryId());
            if (fail && !sendClusterId) {
                responseData.setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code()).setErrorMessage("test");
                env.kafkaClient().prepareResponse(request -> {
                    if (!(request instanceof RemoveRaftVoterRequest)) {
                        return false;
                    }
                    requestData.set((RemoveRaftVoterRequestData)request.data());
                    return true;
                }, (AbstractResponse)new RemoveRaftVoterResponse(responseData));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Integer.MIN_VALUE, true));
                RemoveRaftVoterResponseData responseData2 = new RemoveRaftVoterResponseData();
                env.kafkaClient().prepareResponse(request -> {
                    if (!(request instanceof RemoveRaftVoterRequest)) {
                        return false;
                    }
                    requestData.set((RemoveRaftVoterRequestData)request.data());
                    return true;
                }, (AbstractResponse)new RemoveRaftVoterResponse(responseData2));
                RemoveRaftVoterResult result2 = env.adminClient().removeRaftVoter(1, Uuid.fromString((String)"YAfa4HClT3SIIW2klIUspg"), options);
                result2.all().get();
            }
        }
    }

    @Test
    public void testListShareGroupOffsetsOptionsWithBatchedApi() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            List<TopicPartition> partitions = Collections.singletonList(new TopicPartition("A", 0));
            ListShareGroupOffsetsOptions options = new ListShareGroupOffsetsOptions();
            ListShareGroupOffsetsSpec groupSpec = new ListShareGroupOffsetsSpec().topicPartitions(partitions);
            HashMap<String, ListShareGroupOffsetsSpec> groupSpecs = new HashMap<String, ListShareGroupOffsetsSpec>();
            groupSpecs.put(GROUP_ID, groupSpec);
            env.adminClient().listShareGroupOffsets(groupSpecs, options);
            MockClient mockClient = env.kafkaClient();
            this.waitForRequest(mockClient, ApiKeys.DESCRIBE_SHARE_GROUP_OFFSETS);
            ClientRequest clientRequest = mockClient.requests().peek();
            Assertions.assertNotNull((Object)clientRequest);
            DescribeShareGroupOffsetsRequestData data = ((DescribeShareGroupOffsetsRequest)((DescribeShareGroupOffsetsRequest.Builder)clientRequest.requestBuilder()).build()).data();
            Assertions.assertEquals((int)1, (int)data.groups().size());
            Assertions.assertEquals((Object)GROUP_ID, (Object)((DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestGroup)data.groups().get(0)).groupId());
            Assertions.assertEquals(Collections.singletonList("A"), ((DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestGroup)data.groups().get(0)).topics().stream().map(DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestTopic::topicName).collect(Collectors.toList()));
        }
    }

    @Test
    public void testListShareGroupOffsets() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            TopicPartition myTopicPartition3 = new TopicPartition("my_topic", 3);
            TopicPartition myTopicPartition4 = new TopicPartition("my_topic_1", 4);
            TopicPartition myTopicPartition5 = new TopicPartition("my_topic_2", 6);
            ListShareGroupOffsetsSpec groupSpec = new ListShareGroupOffsetsSpec();
            HashMap<String, ListShareGroupOffsetsSpec> groupSpecs = new HashMap<String, ListShareGroupOffsetsSpec>();
            groupSpecs.put(GROUP_ID, groupSpec);
            DescribeShareGroupOffsetsResponseData data = new DescribeShareGroupOffsetsResponseData().setGroups(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup().setGroupId(GROUP_ID).setTopics(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic().setTopicName("my_topic").setPartitions(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(0).setStartOffset(10L).setLeaderEpoch(0), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(1).setStartOffset(11L).setLeaderEpoch(0), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(2).setStartOffset(40L).setLeaderEpoch(0), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(3).setStartOffset(50L).setLeaderEpoch(1))), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic().setTopicName("my_topic_1").setPartitions(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(4).setStartOffset(100L).setLeaderEpoch(2))), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic().setTopicName("my_topic_2").setPartitions(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(6).setStartOffset(500L).setLeaderEpoch(3)))))));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeShareGroupOffsetsResponse(data));
            ListShareGroupOffsetsResult result = env.adminClient().listShareGroupOffsets(groupSpecs);
            Map partitionToOffsetAndMetadata = (Map)result.partitionsToOffsetAndMetadata(GROUP_ID).get();
            Assertions.assertEquals((int)6, (int)partitionToOffsetAndMetadata.size());
            Assertions.assertEquals((Object)new OffsetAndMetadata(10L, Optional.of(0), ""), partitionToOffsetAndMetadata.get(myTopicPartition0));
            Assertions.assertEquals((Object)new OffsetAndMetadata(11L, Optional.of(0), ""), partitionToOffsetAndMetadata.get(myTopicPartition1));
            Assertions.assertEquals((Object)new OffsetAndMetadata(40L, Optional.of(0), ""), partitionToOffsetAndMetadata.get(myTopicPartition2));
            Assertions.assertEquals((Object)new OffsetAndMetadata(50L, Optional.of(1), ""), partitionToOffsetAndMetadata.get(myTopicPartition3));
            Assertions.assertEquals((Object)new OffsetAndMetadata(100L, Optional.of(2), ""), partitionToOffsetAndMetadata.get(myTopicPartition4));
            Assertions.assertEquals((Object)new OffsetAndMetadata(500L, Optional.of(3), ""), partitionToOffsetAndMetadata.get(myTopicPartition5));
        }
    }

    @Test
    public void testListShareGroupOffsetsMultipleGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareBatchedFindCoordinatorResponse(Errors.NONE, env.cluster().controller(), Set.of(GROUP_ID, "group-1")));
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            TopicPartition myTopicPartition3 = new TopicPartition("my_topic", 3);
            TopicPartition myTopicPartition4 = new TopicPartition("my_topic_1", 4);
            TopicPartition myTopicPartition5 = new TopicPartition("my_topic_2", 6);
            ListShareGroupOffsetsSpec group0Specs = new ListShareGroupOffsetsSpec().topicPartitions(List.of(myTopicPartition0, myTopicPartition1, myTopicPartition2, myTopicPartition3));
            ListShareGroupOffsetsSpec group1Specs = new ListShareGroupOffsetsSpec().topicPartitions(List.of(myTopicPartition4, myTopicPartition5));
            HashMap<String, ListShareGroupOffsetsSpec> groupSpecs = new HashMap<String, ListShareGroupOffsetsSpec>();
            groupSpecs.put(GROUP_ID, group0Specs);
            groupSpecs.put("group-1", group1Specs);
            DescribeShareGroupOffsetsResponseData data = new DescribeShareGroupOffsetsResponseData().setGroups(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup().setGroupId(GROUP_ID).setTopics(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic().setTopicName("my_topic").setPartitions(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(0).setStartOffset(10L).setLeaderEpoch(0), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(1).setStartOffset(11L).setLeaderEpoch(0), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(2).setStartOffset(40L).setLeaderEpoch(0), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(3).setStartOffset(50L).setLeaderEpoch(1))))), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup().setGroupId("group-1").setTopics(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic().setTopicName("my_topic_1").setPartitions(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(4).setStartOffset(100L).setLeaderEpoch(2))), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic().setTopicName("my_topic_2").setPartitions(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(6).setStartOffset(500L).setLeaderEpoch(2)))))));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeShareGroupOffsetsResponse(data));
            ListShareGroupOffsetsResult result = env.adminClient().listShareGroupOffsets(groupSpecs);
            Assertions.assertEquals((int)2, (int)((Map)result.all().get()).size());
            Map partitionToOffsetAndMetadataGroup0 = (Map)result.partitionsToOffsetAndMetadata(GROUP_ID).get();
            Assertions.assertEquals((int)4, (int)partitionToOffsetAndMetadataGroup0.size());
            Assertions.assertEquals((Object)new OffsetAndMetadata(10L, Optional.of(0), ""), partitionToOffsetAndMetadataGroup0.get(myTopicPartition0));
            Assertions.assertEquals((Object)new OffsetAndMetadata(11L, Optional.of(0), ""), partitionToOffsetAndMetadataGroup0.get(myTopicPartition1));
            Assertions.assertEquals((Object)new OffsetAndMetadata(40L, Optional.of(0), ""), partitionToOffsetAndMetadataGroup0.get(myTopicPartition2));
            Assertions.assertEquals((Object)new OffsetAndMetadata(50L, Optional.of(1), ""), partitionToOffsetAndMetadataGroup0.get(myTopicPartition3));
            Map partitionToOffsetAndMetadataGroup1 = (Map)result.partitionsToOffsetAndMetadata("group-1").get();
            Assertions.assertEquals((int)2, (int)partitionToOffsetAndMetadataGroup1.size());
            Assertions.assertEquals((Object)new OffsetAndMetadata(100L, Optional.of(2), ""), partitionToOffsetAndMetadataGroup1.get(myTopicPartition4));
            Assertions.assertEquals((Object)new OffsetAndMetadata(500L, Optional.of(2), ""), partitionToOffsetAndMetadataGroup1.get(myTopicPartition5));
        }
    }

    @Test
    public void testListShareGroupOffsetsEmpty() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            ListShareGroupOffsetsSpec groupSpec = new ListShareGroupOffsetsSpec();
            HashMap<String, ListShareGroupOffsetsSpec> groupSpecs = new HashMap<String, ListShareGroupOffsetsSpec>();
            groupSpecs.put(GROUP_ID, groupSpec);
            DescribeShareGroupOffsetsResponseData data = new DescribeShareGroupOffsetsResponseData().setGroups(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup().setGroupId(GROUP_ID)));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeShareGroupOffsetsResponse(data));
            ListShareGroupOffsetsResult result = env.adminClient().listShareGroupOffsets(groupSpecs);
            Map partitionToOffsetAndMetadata = (Map)result.partitionsToOffsetAndMetadata(GROUP_ID).get();
            Assertions.assertEquals((int)0, (int)partitionToOffsetAndMetadata.size());
        }
    }

    @Test
    public void testListShareGroupOffsetsWithErrorInOnePartition() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic_1", 4);
            TopicPartition myTopicPartition3 = new TopicPartition("my_topic_2", 6);
            ListShareGroupOffsetsSpec groupSpec = new ListShareGroupOffsetsSpec().topicPartitions(List.of(myTopicPartition0, myTopicPartition1, myTopicPartition2, myTopicPartition3));
            HashMap<String, ListShareGroupOffsetsSpec> groupSpecs = new HashMap<String, ListShareGroupOffsetsSpec>();
            groupSpecs.put(GROUP_ID, groupSpec);
            DescribeShareGroupOffsetsResponseData data = new DescribeShareGroupOffsetsResponseData().setGroups(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup().setGroupId(GROUP_ID).setTopics(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic().setTopicName("my_topic").setPartitions(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(0).setStartOffset(10L).setLeaderEpoch(0), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(1).setStartOffset(11L).setLeaderEpoch(1))), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic().setTopicName("my_topic_1").setPartitions(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(4).setErrorCode(Errors.NOT_COORDINATOR.code()).setErrorMessage("Not a Coordinator"))), new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic().setTopicName("my_topic_2").setPartitions(List.of(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex(6).setStartOffset(500L).setLeaderEpoch(2)))))));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeShareGroupOffsetsResponse(data));
            ListShareGroupOffsetsResult result = env.adminClient().listShareGroupOffsets(groupSpecs);
            Map partitionToOffsetAndMetadata = (Map)result.partitionsToOffsetAndMetadata(GROUP_ID).get();
            Assertions.assertEquals((int)3, (int)partitionToOffsetAndMetadata.size());
            Assertions.assertEquals((Object)new OffsetAndMetadata(10L, Optional.of(0), ""), partitionToOffsetAndMetadata.get(myTopicPartition0));
            Assertions.assertEquals((Object)new OffsetAndMetadata(11L, Optional.of(1), ""), partitionToOffsetAndMetadata.get(myTopicPartition1));
            Assertions.assertEquals((Object)new OffsetAndMetadata(500L, Optional.of(2), ""), partitionToOffsetAndMetadata.get(myTopicPartition3));
        }
    }

    @Test
    public void testAlterShareGroupOffsets() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            AlterShareGroupOffsetsResponseData data = new AlterShareGroupOffsetsResponseData().setResponses(new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopicCollection(List.of(new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopic().setTopicName("foo").setPartitions(List.of(new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponsePartition().setPartitionIndex(0), new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponsePartition().setPartitionIndex(1))), new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopic().setTopicName("bar").setPartitions(List.of(new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponsePartition().setPartitionIndex(0)))).iterator()));
            TopicPartition fooTopicPartition0 = new TopicPartition("foo", 0);
            TopicPartition fooTopicPartition1 = new TopicPartition("foo", 1);
            TopicPartition barPartition0 = new TopicPartition("bar", 0);
            TopicPartition zooTopicPartition0 = new TopicPartition("zoo", 0);
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterShareGroupOffsetsResponse(data));
            AlterShareGroupOffsetsResult result = env.adminClient().alterShareGroupOffsets(GROUP_ID, Map.of(fooTopicPartition0, 1L, fooTopicPartition1, 2L, barPartition0, 1L));
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.partitionResult(fooTopicPartition0).get());
            Assertions.assertNull((Object)result.partitionResult(fooTopicPartition1).get());
            Assertions.assertNull((Object)result.partitionResult(barPartition0).get());
            TestUtils.assertFutureThrows(IllegalArgumentException.class, result.partitionResult(zooTopicPartition0));
        }
    }

    @Test
    public void testAlterShareGroupOffsetsWithErrorInOnePartition() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            AlterShareGroupOffsetsResponseData data = new AlterShareGroupOffsetsResponseData().setResponses(new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopicCollection(List.of(new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopic().setTopicName("foo").setPartitions(List.of(new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponsePartition().setPartitionIndex(0), new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponsePartition().setPartitionIndex(1).setErrorCode(Errors.NON_EMPTY_GROUP.code()).setErrorMessage("The group is not empty"))), new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponseTopic().setTopicName("bar").setPartitions(List.of(new AlterShareGroupOffsetsResponseData.AlterShareGroupOffsetsResponsePartition().setPartitionIndex(0)))).iterator()));
            TopicPartition fooTopicPartition0 = new TopicPartition("foo", 0);
            TopicPartition fooTopicPartition1 = new TopicPartition("foo", 1);
            TopicPartition barPartition0 = new TopicPartition("bar", 0);
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterShareGroupOffsetsResponse(data));
            AlterShareGroupOffsetsResult result = env.adminClient().alterShareGroupOffsets(GROUP_ID, Map.of(fooTopicPartition0, 1L, fooTopicPartition1, 2L, barPartition0, 1L));
            TestUtils.assertFutureThrows(GroupNotEmptyException.class, result.all());
            Assertions.assertNull((Object)result.partitionResult(fooTopicPartition0).get());
            TestUtils.assertFutureThrows(GroupNotEmptyException.class, result.partitionResult(fooTopicPartition1));
            Assertions.assertNull((Object)result.partitionResult(barPartition0).get());
        }
    }

    @Test
    public void testDeleteShareGroupOffsetsOptionsWithBatchedApi() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            Set<String> topics = Collections.singleton("A");
            DeleteShareGroupOffsetsOptions options = new DeleteShareGroupOffsetsOptions();
            env.adminClient().deleteShareGroupOffsets(GROUP_ID, topics, options);
            MockClient mockClient = env.kafkaClient();
            this.waitForRequest(mockClient, ApiKeys.DELETE_SHARE_GROUP_OFFSETS);
            ClientRequest clientRequest = mockClient.requests().peek();
            Assertions.assertNotNull((Object)clientRequest);
            DeleteShareGroupOffsetsRequestData data = ((DeleteShareGroupOffsetsRequest)((DeleteShareGroupOffsetsRequest.Builder)clientRequest.requestBuilder()).build()).data();
            Assertions.assertEquals((Object)GROUP_ID, (Object)data.groupId());
            Assertions.assertEquals((int)1, (int)data.topics().size());
            Assertions.assertEquals(Collections.singletonList("A"), data.topics().stream().map(DeleteShareGroupOffsetsRequestData.DeleteShareGroupOffsetsRequestTopic::topicName).collect(Collectors.toList()));
        }
    }

    @Test
    public void testDeleteShareGroupOffsets() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            Uuid fooId = Uuid.randomUuid();
            String fooName = "foo";
            Uuid barId = Uuid.randomUuid();
            String barName = "bar";
            String zooName = "zoo";
            DeleteShareGroupOffsetsResponseData data = new DeleteShareGroupOffsetsResponseData().setResponses(List.of(new DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic().setTopicName(fooName).setTopicId(fooId), new DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic().setTopicName(barName).setTopicId(barId)));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteShareGroupOffsetsResponse(data));
            DeleteShareGroupOffsetsResult result = env.adminClient().deleteShareGroupOffsets(GROUP_ID, Set.of(fooName, barName));
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.topicResult(fooName).get());
            Assertions.assertNull((Object)result.topicResult(barName).get());
            Assertions.assertThrows(IllegalArgumentException.class, () -> result.topicResult(zooName));
        }
    }

    @Test
    public void testDeleteShareGroupOffsetsEmpty() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteShareGroupOffsetsResponseData data = new DeleteShareGroupOffsetsResponseData().setResponses(List.of());
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteShareGroupOffsetsResponse(data));
            DeleteShareGroupOffsetsResult result = env.adminClient().deleteShareGroupOffsets(GROUP_ID, Collections.emptySet());
            Assertions.assertDoesNotThrow(() -> (Void)result.all().get());
        }
    }

    @Test
    public void testDeleteShareGroupOffsetsWithErrorInGroup() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteShareGroupOffsetsResponseData data = new DeleteShareGroupOffsetsResponseData().setErrorCode(Errors.GROUP_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.GROUP_AUTHORIZATION_FAILED.message());
            String fooName = "foo";
            String barName = "bar";
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteShareGroupOffsetsResponse(data));
            DeleteShareGroupOffsetsResult result = env.adminClient().deleteShareGroupOffsets(GROUP_ID, Set.of(fooName, barName));
            TestUtils.assertFutureThrows(Errors.GROUP_AUTHORIZATION_FAILED.exception().getClass(), result.all());
        }
    }

    @Test
    public void testDeleteShareGroupOffsetsWithErrorInOneTopic() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            Uuid fooId = Uuid.randomUuid();
            String fooName = "foo";
            Uuid barId = Uuid.randomUuid();
            String barName = "bar";
            DeleteShareGroupOffsetsResponseData data = new DeleteShareGroupOffsetsResponseData().setResponses(List.of(new DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic().setTopicName(fooName).setTopicId(fooId).setErrorCode(Errors.KAFKA_STORAGE_ERROR.code()).setErrorMessage(Errors.KAFKA_STORAGE_ERROR.message()), new DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic().setTopicName(barName).setTopicId(barId)));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteShareGroupOffsetsResponse(data));
            DeleteShareGroupOffsetsResult result = env.adminClient().deleteShareGroupOffsets(GROUP_ID, Set.of(fooName, barName));
            TestUtils.assertFutureThrows(Errors.KAFKA_STORAGE_ERROR.exception().getClass(), result.all());
            TestUtils.assertFutureThrows(Errors.KAFKA_STORAGE_ERROR.exception().getClass(), result.topicResult(fooName));
            Assertions.assertNull((Object)result.topicResult(barName).get());
        }
    }

    @Test
    public void testDeleteShareGroupOffsetsWithPartitionNotPresentInResult() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            Uuid fooId = Uuid.randomUuid();
            String fooName = "foo";
            String barName = "bar";
            DeleteShareGroupOffsetsResponseData data = new DeleteShareGroupOffsetsResponseData().setResponses(List.of(new DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic().setTopicName(fooName).setTopicId(fooId)));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteShareGroupOffsetsResponse(data));
            DeleteShareGroupOffsetsResult result = env.adminClient().deleteShareGroupOffsets(GROUP_ID, Set.of(fooName));
            Assertions.assertDoesNotThrow(() -> (Void)result.all().get());
            Assertions.assertThrows(IllegalArgumentException.class, () -> result.topicResult(barName));
            Assertions.assertNull((Object)result.topicResult(fooName).get());
        }
    }

    private static StreamsGroupDescribeResponseData makeFullStreamsGroupDescribeResponse() {
        StreamsGroupDescribeResponseData.TaskIds activeTasks1 = new StreamsGroupDescribeResponseData.TaskIds().setSubtopologyId("my_subtopology").setPartitions(Arrays.asList(0, 1, 2));
        StreamsGroupDescribeResponseData.TaskIds standbyTasks1 = new StreamsGroupDescribeResponseData.TaskIds().setSubtopologyId("my_subtopology").setPartitions(Arrays.asList(3, 4, 5));
        StreamsGroupDescribeResponseData.TaskIds warmupTasks1 = new StreamsGroupDescribeResponseData.TaskIds().setSubtopologyId("my_subtopology").setPartitions(Arrays.asList(6, 7, 8));
        StreamsGroupDescribeResponseData.TaskIds activeTasks2 = new StreamsGroupDescribeResponseData.TaskIds().setSubtopologyId("my_subtopology").setPartitions(Arrays.asList(3, 4, 5));
        StreamsGroupDescribeResponseData.TaskIds standbyTasks2 = new StreamsGroupDescribeResponseData.TaskIds().setSubtopologyId("my_subtopology").setPartitions(Arrays.asList(6, 7, 8));
        StreamsGroupDescribeResponseData.TaskIds warmupTasks2 = new StreamsGroupDescribeResponseData.TaskIds().setSubtopologyId("my_subtopology").setPartitions(Arrays.asList(0, 1, 2));
        StreamsGroupDescribeResponseData.Assignment memberAssignment = new StreamsGroupDescribeResponseData.Assignment().setActiveTasks(Collections.singletonList(activeTasks1)).setStandbyTasks(Collections.singletonList(standbyTasks1)).setWarmupTasks(Collections.singletonList(warmupTasks1));
        StreamsGroupDescribeResponseData.Assignment targetAssignment = new StreamsGroupDescribeResponseData.Assignment().setActiveTasks(Collections.singletonList(activeTasks2)).setStandbyTasks(Collections.singletonList(standbyTasks2)).setWarmupTasks(Collections.singletonList(warmupTasks2));
        StreamsGroupDescribeResponseData.Member memberOne = new StreamsGroupDescribeResponseData.Member().setMemberId("0").setMemberEpoch(1).setInstanceId("instance-id").setRackId("rack-id").setClientId("clientId0").setClientHost("clientHost").setTopologyEpoch(0).setProcessId("processId").setUserEndpoint(new StreamsGroupDescribeResponseData.Endpoint().setHost("localhost").setPort(8080)).setClientTags(Collections.singletonList(new StreamsGroupDescribeResponseData.KeyValue().setKey("key").setValue("value"))).setTaskOffsets(Collections.singletonList(new StreamsGroupDescribeResponseData.TaskOffset().setSubtopologyId("my_subtopology").setPartition(0).setOffset(0L))).setTaskEndOffsets(Collections.singletonList(new StreamsGroupDescribeResponseData.TaskOffset().setSubtopologyId("my_subtopology").setPartition(0).setOffset(1L))).setAssignment(memberAssignment).setTargetAssignment(targetAssignment).setIsClassic(true);
        StreamsGroupDescribeResponseData.Member memberTwo = new StreamsGroupDescribeResponseData.Member().setMemberId("1").setMemberEpoch(2).setInstanceId(null).setRackId(null).setClientId("clientId1").setClientHost("clientHost").setTopologyEpoch(1).setProcessId("processId2").setUserEndpoint(null).setClientTags(Collections.emptyList()).setTaskOffsets(Collections.emptyList()).setTaskEndOffsets(Collections.emptyList()).setAssignment(new StreamsGroupDescribeResponseData.Assignment()).setTargetAssignment(new StreamsGroupDescribeResponseData.Assignment()).setIsClassic(false);
        StreamsGroupDescribeResponseData.Subtopology subtopologyDescription = new StreamsGroupDescribeResponseData.Subtopology().setSubtopologyId("my_subtopology").setSourceTopics(Collections.singletonList("my_source_topic")).setRepartitionSinkTopics(Collections.singletonList("my_repartition_sink_topic")).setStateChangelogTopics(Collections.singletonList(new StreamsGroupDescribeResponseData.TopicInfo().setName("my_changelog_topic").setPartitions(0).setReplicationFactor((short)3).setTopicConfigs(Collections.singletonList(new StreamsGroupDescribeResponseData.KeyValue().setKey("key1").setValue("value1"))))).setRepartitionSourceTopics(Collections.singletonList(new StreamsGroupDescribeResponseData.TopicInfo().setName("my_repartition_topic").setPartitions(99).setReplicationFactor((short)0).setTopicConfigs(Collections.emptyList())));
        StreamsGroupDescribeResponseData data = new StreamsGroupDescribeResponseData();
        data.groups().add(new StreamsGroupDescribeResponseData.DescribedGroup().setGroupId(GROUP_ID).setGroupState(GroupState.STABLE.toString()).setMembers(Arrays.asList(memberOne, memberTwo)).setTopology(new StreamsGroupDescribeResponseData.Topology().setEpoch(1).setSubtopologies(Collections.singletonList(subtopologyDescription))).setGroupEpoch(2).setAssignmentEpoch(1));
        return data;
    }

    private static class TestInterceptor
    implements AdminRequestInterceptor {
        AbstractRequest.Builder<?> requestBuilder;
        AbstractResponse interceptedResponse;
        Function<AbstractResponse, AbstractResponse> responseTransformer = Function.identity();
        boolean ready;

        TestInterceptor(AbstractRequest.Builder<?> requestBuilder) {
            this.requestBuilder = requestBuilder;
        }

        public boolean isReady() {
            return this.ready;
        }

        public AbstractRequest.Builder<?> createRequest(String nodeId, int timeoutMs) {
            return this.requestBuilder;
        }

        public AbstractResponse onResponse(AbstractResponse response) {
            return this.responseTransformer.apply(response);
        }

        public Optional<AbstractResponse> interceptedResponse() {
            return Optional.ofNullable(this.interceptedResponse);
        }
    }

    public static class FailureInjectingTimeoutProcessorFactory
    extends KafkaAdminClient.TimeoutProcessorFactory {
        private int numTries = 0;
        private int failuresInjected = 0;

        public KafkaAdminClient.TimeoutProcessor create(long now) {
            return new FailureInjectingTimeoutProcessor(now);
        }

        synchronized boolean shouldInjectFailure() {
            ++this.numTries;
            if (this.numTries == 1) {
                ++this.failuresInjected;
                return true;
            }
            return false;
        }

        public synchronized int failuresInjected() {
            return this.failuresInjected;
        }

        public final class FailureInjectingTimeoutProcessor
        extends KafkaAdminClient.TimeoutProcessor {
            public FailureInjectingTimeoutProcessor(long now) {
                super(now);
            }

            boolean callHasExpired(KafkaAdminClient.Call call) {
                if (!call.isInternal() && FailureInjectingTimeoutProcessorFactory.this.shouldInjectFailure()) {
                    log.debug("Injecting timeout for {}.", (Object)call);
                    return true;
                }
                boolean ret = super.callHasExpired(call);
                log.debug("callHasExpired({}) = {}", (Object)call, (Object)ret);
                return ret;
            }
        }
    }
}

