/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.metrics;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.kafka.clients.consumer.internals.metrics.AsyncConsumerMetrics;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncConsumerMetricsTest {
    private static final long METRIC_VALUE = 123L;
    private final Metrics metrics = new Metrics();
    private AsyncConsumerMetrics consumerMetrics;

    @AfterEach
    public void tearDown() {
        if (this.consumerMetrics != null) {
            this.consumerMetrics.close();
        }
        this.metrics.close();
    }

    @Test
    public void shouldMetricNames() {
        this.consumerMetrics = new AsyncConsumerMetrics(this.metrics);
        HashSet<MetricName> expectedMetrics = new HashSet<MetricName>(Arrays.asList(this.metrics.metricName("last-poll-seconds-ago", "consumer-metrics"), this.metrics.metricName("time-between-poll-avg", "consumer-metrics"), this.metrics.metricName("time-between-poll-max", "consumer-metrics"), this.metrics.metricName("poll-idle-ratio-avg", "consumer-metrics"), this.metrics.metricName("commit-sync-time-ns-total", "consumer-metrics"), this.metrics.metricName("committed-time-ns-total", "consumer-metrics")));
        expectedMetrics.forEach(metricName -> Assertions.assertTrue((boolean)this.metrics.metrics().containsKey(metricName), (String)("Missing metric: " + String.valueOf(metricName))));
        HashSet<MetricName> expectedConsumerMetrics = new HashSet<MetricName>(Arrays.asList(this.metrics.metricName("time-between-network-thread-poll-avg", "consumer-metrics"), this.metrics.metricName("time-between-network-thread-poll-max", "consumer-metrics"), this.metrics.metricName("application-event-queue-size", "consumer-metrics"), this.metrics.metricName("application-event-queue-time-avg", "consumer-metrics"), this.metrics.metricName("application-event-queue-time-max", "consumer-metrics"), this.metrics.metricName("application-event-queue-processing-time-avg", "consumer-metrics"), this.metrics.metricName("application-event-queue-processing-time-max", "consumer-metrics"), this.metrics.metricName("unsent-requests-queue-size", "consumer-metrics"), this.metrics.metricName("unsent-requests-queue-time-avg", "consumer-metrics"), this.metrics.metricName("unsent-requests-queue-time-max", "consumer-metrics"), this.metrics.metricName("background-event-queue-size", "consumer-metrics"), this.metrics.metricName("background-event-queue-time-avg", "consumer-metrics"), this.metrics.metricName("background-event-queue-time-max", "consumer-metrics"), this.metrics.metricName("background-event-queue-processing-time-avg", "consumer-metrics"), this.metrics.metricName("background-event-queue-processing-time-max", "consumer-metrics")));
        expectedConsumerMetrics.forEach(metricName -> Assertions.assertTrue((boolean)this.metrics.metrics().containsKey(metricName), (String)("Missing metric: " + String.valueOf(metricName))));
        this.consumerMetrics.close();
        expectedMetrics.forEach(metricName -> Assertions.assertFalse((boolean)this.metrics.metrics().containsKey(metricName), (String)("Metric present after close: " + String.valueOf(metricName))));
        expectedConsumerMetrics.forEach(metricName -> Assertions.assertFalse((boolean)this.metrics.metrics().containsKey(metricName), (String)("Metric present after close: " + String.valueOf(metricName))));
    }

    @Test
    public void shouldRecordTimeBetweenNetworkThreadPoll() {
        this.consumerMetrics = new AsyncConsumerMetrics(this.metrics);
        this.consumerMetrics.recordTimeBetweenNetworkThreadPoll(123L);
        this.assertMetricValue("time-between-network-thread-poll-avg");
        this.assertMetricValue("time-between-network-thread-poll-max");
    }

    @Test
    public void shouldRecordApplicationEventQueueSize() {
        this.consumerMetrics = new AsyncConsumerMetrics(this.metrics);
        this.consumerMetrics.recordApplicationEventQueueSize(10);
        Assertions.assertEquals((Object)this.metrics.metric(this.metrics.metricName("application-event-queue-size", "consumer-metrics")).metricValue(), (Object)10.0);
    }

    @Test
    public void shouldRecordApplicationEventQueueTime() {
        this.consumerMetrics = new AsyncConsumerMetrics(this.metrics);
        this.consumerMetrics.recordApplicationEventQueueTime(123L);
        this.assertMetricValue("application-event-queue-time-avg");
        this.assertMetricValue("application-event-queue-time-max");
    }

    @Test
    public void shouldRecordApplicationEventQueueProcessingTime() {
        this.consumerMetrics = new AsyncConsumerMetrics(this.metrics);
        this.consumerMetrics.recordApplicationEventQueueProcessingTime(123L);
        this.assertMetricValue("application-event-queue-processing-time-avg");
        this.assertMetricValue("application-event-queue-processing-time-max");
    }

    @Test
    public void shouldRecordUnsentRequestsQueueSize() {
        this.consumerMetrics = new AsyncConsumerMetrics(this.metrics);
        this.consumerMetrics.recordUnsentRequestsQueueSize(10, 100L);
        Assertions.assertEquals((Object)this.metrics.metric(this.metrics.metricName("unsent-requests-queue-size", "consumer-metrics")).metricValue(), (Object)10.0);
    }

    @Test
    public void shouldRecordUnsentRequestsQueueTime() {
        this.consumerMetrics = new AsyncConsumerMetrics(this.metrics);
        this.consumerMetrics.recordUnsentRequestsQueueTime(123L);
        this.assertMetricValue("unsent-requests-queue-time-avg");
        this.assertMetricValue("unsent-requests-queue-time-max");
    }

    @Test
    public void shouldRecordBackgroundEventQueueSize() {
        this.consumerMetrics = new AsyncConsumerMetrics(this.metrics);
        this.consumerMetrics.recordBackgroundEventQueueSize(10);
        Assertions.assertEquals((Object)this.metrics.metric(this.metrics.metricName("background-event-queue-size", "consumer-metrics")).metricValue(), (Object)10.0);
    }

    @Test
    public void shouldRecordBackgroundEventQueueTime() {
        this.consumerMetrics = new AsyncConsumerMetrics(this.metrics);
        this.consumerMetrics.recordBackgroundEventQueueTime(123L);
        this.assertMetricValue("background-event-queue-time-avg");
        this.assertMetricValue("background-event-queue-time-max");
    }

    @Test
    public void shouldRecordBackgroundEventQueueProcessingTime() {
        this.consumerMetrics = new AsyncConsumerMetrics(this.metrics);
        this.consumerMetrics.recordBackgroundEventQueueProcessingTime(123L);
        this.assertMetricValue("background-event-queue-processing-time-avg");
        this.assertMetricValue("background-event-queue-processing-time-avg");
    }

    private void assertMetricValue(String name) {
        Assertions.assertEquals((Object)this.metrics.metric(this.metrics.metricName(name, "consumer-metrics")).metricValue(), (Object)123.0);
    }
}

