/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.internals;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.internals.PluginMetricsImpl;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PluginMetricsImplTest {
    private static final LinkedHashMap<String, String> EXTRA_TAGS = new LinkedHashMap();
    private Map<String, String> tags;
    private Metrics metrics;
    private int initialMetrics;

    @BeforeEach
    void setup() {
        this.metrics = new Metrics();
        this.initialMetrics = this.metrics.metrics().size();
        this.tags = new LinkedHashMap<String, String>();
        this.tags.put("k1", "v1");
        this.tags.put("k2", "v2");
    }

    @Test
    void testMetricName() {
        PluginMetricsImpl pmi = new PluginMetricsImpl(this.metrics, this.tags);
        MetricName metricName = pmi.metricName("name", "description", EXTRA_TAGS);
        Assertions.assertEquals((Object)"name", (Object)metricName.name());
        Assertions.assertEquals((Object)"plugins", (Object)metricName.group());
        Assertions.assertEquals((Object)"description", (Object)metricName.description());
        LinkedHashMap<String, String> expectedTags = new LinkedHashMap<String, String>(this.tags);
        expectedTags.putAll(EXTRA_TAGS);
        Assertions.assertEquals(expectedTags, (Object)metricName.tags());
    }

    @Test
    void testDuplicateTagName() {
        PluginMetricsImpl pmi = new PluginMetricsImpl(this.metrics, this.tags);
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("k1", "value");
        Assertions.assertThrows(IllegalArgumentException.class, () -> pmi.metricName("name", "description", tags));
    }

    @Test
    void testAddRemoveMetrics() {
        PluginMetricsImpl pmi = new PluginMetricsImpl(this.metrics, this.tags);
        MetricName metricName = pmi.metricName("name", "description", EXTRA_TAGS);
        pmi.addMetric(metricName, (MetricValueProvider)((Measurable)(config, now) -> 0.0));
        Assertions.assertEquals((int)(this.initialMetrics + 1), (int)this.metrics.metrics().size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> pmi.addMetric(metricName, (MetricValueProvider)((Measurable)(config, now) -> 0.0)));
        pmi.removeMetric(metricName);
        Assertions.assertEquals((int)this.initialMetrics, (int)this.metrics.metrics().size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> pmi.removeMetric(metricName));
    }

    @Test
    void testAddRemoveSensor() {
        PluginMetricsImpl pmi = new PluginMetricsImpl(this.metrics, this.tags);
        String sensorName = "my-sensor";
        MetricName metricName = pmi.metricName("name", "description", EXTRA_TAGS);
        Sensor sensor = pmi.addSensor(sensorName);
        Assertions.assertEquals((int)this.initialMetrics, (int)this.metrics.metrics().size());
        sensor.add(metricName, (MeasurableStat)new Rate());
        sensor.add(metricName, (MeasurableStat)new Max());
        Assertions.assertEquals((int)(this.initialMetrics + 1), (int)this.metrics.metrics().size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> pmi.addSensor(sensorName));
        pmi.removeSensor(sensorName);
        Assertions.assertEquals((int)this.initialMetrics, (int)this.metrics.metrics().size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> pmi.removeSensor(sensorName));
    }

    @Test
    void testClose() throws IOException {
        PluginMetricsImpl pmi = new PluginMetricsImpl(this.metrics, this.tags);
        String sensorName = "my-sensor";
        MetricName metricName1 = pmi.metricName("name1", "description", EXTRA_TAGS);
        Sensor sensor = pmi.addSensor(sensorName);
        sensor.add(metricName1, (MeasurableStat)new Rate());
        MetricName metricName2 = pmi.metricName("name2", "description", EXTRA_TAGS);
        pmi.addMetric(metricName2, (MetricValueProvider)((Measurable)(config, now) -> 1.0));
        Assertions.assertEquals((int)(this.initialMetrics + 2), (int)this.metrics.metrics().size());
        pmi.close();
        Assertions.assertEquals((int)this.initialMetrics, (int)this.metrics.metrics().size());
    }

    static {
        EXTRA_TAGS.put("my-tag", "my-value");
    }
}

