/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ResourceLeakDetector;
import java.net.InetSocketAddress;
import org.apache.kafka.common.network.netty.DisableSsl;
import org.apache.kafka.common.network.netty.NettyHttp2EchoServer;
import org.apache.kafka.common.network.netty.TestUtils;
import org.apache.kafka.common.network.netty.Utils;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class NettyClientTestBase {
    protected static final LogContext logContext = new LogContext("NettyHttp2Test");
    private static final NettyHttp2EchoServer server = new NettyHttp2EchoServer();
    private static final SslContext acceptAllSslContext = TestUtils.trustAllCertsSSlContext();
    protected EventLoopGroup eventLoopGroup;

    @BeforeEach
    void setup(TestInfo info) throws Exception {
        boolean testSsl = info.getTestMethod().map(m -> !m.isAnnotationPresent(DisableSsl.class)).orElse(true);
        server.start(testSsl);
        this.eventLoopGroup = Utils.createEventLoopGroup((int)4, (String)"test");
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.ADVANCED);
    }

    @AfterEach
    void teardown() {
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully();
        }
    }

    @AfterAll
    void cleanupAll() {
        server.stop();
        ReferenceCountUtil.release((Object)acceptAllSslContext);
    }

    public static InetSocketAddress serverAddress() {
        return server.address();
    }

    public static SslContext acceptAllSslContext() {
        return acceptAllSslContext;
    }
}

