/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http2.DefaultHttp2SettingsFrame;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.netty.NettyHttp2ConnectionInitializer;
import org.apache.kafka.common.network.netty.TestHttp2StreamChannel;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class NettyHttp2ConnectionInitializerTest {
    private static final LogContext logContext = new LogContext("[NettyHttp2ConnectionInitializerTest]");
    private static final String ALPN_HANDLER_NAME = "NettyHttp2ConnectionInitializer$1#0";
    private static final String FIRST_SETTINGS_FRAME_HANDLER_NAME = "NettyHttp2ConnectionInitializer$2#0";
    private Http2Settings http2Settings;
    private EmbeddedChannel channel;

    @BeforeEach
    void setUp() {
        this.http2Settings = new Http2Settings();
        this.channel = new EmbeddedChannel();
    }

    @AfterEach
    void tearDown() {
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
        }
    }

    @ParameterizedTest
    @EnumSource(value=ConnectionMode.class)
    void testInitChannelWithoutSsl(ConnectionMode connectionMode) {
        DefaultChannelGroup trackedChannels = new DefaultChannelGroup((EventExecutor)this.channel.eventLoop());
        NettyHttp2ConnectionInitializer initializer = new NettyHttp2ConnectionInitializer(connectionMode, (ChannelGroup)trackedChannels, null, this.http2Settings, (ChannelHandler)Mockito.mock(ChannelHandler.class), logContext);
        initializer.initChannel((Channel)this.channel);
        ChannelPipeline pipeline = this.channel.pipeline();
        List handlerNames = pipeline.names();
        Assertions.assertNotNull((Object)pipeline.get(Http2FrameCodec.class), (String)"Http2FrameCodec should be added");
        Assertions.assertNotNull((Object)pipeline.get(Http2MultiplexHandler.class), (String)"Http2MultiplexHandler should be added");
        Assertions.assertEquals((Object)"Http2FrameCodec#0", handlerNames.get(0), (String)"Pipeline should contain Http2FrameCodec");
        Assertions.assertEquals((Object)FIRST_SETTINGS_FRAME_HANDLER_NAME, handlerNames.get(1), (String)"Pipeline should contain settings frame handler");
        Assertions.assertEquals((Object)"Http2MultiplexHandler#0", handlerNames.get(2), (String)"Pipeline should contain Http2MultiplexHandler");
        Assertions.assertEquals((Object)"DefaultChannelPipeline$TailContext#0", handlerNames.get(3));
        Assertions.assertEquals((int)4, (int)handlerNames.size());
        Assertions.assertEquals((int)1, (int)initializer.trackedChannels().size());
        Assertions.assertEquals((Object)this.channel, initializer.trackedChannels().iterator().next(), (String)"Channel should be added to the group");
    }

    @ParameterizedTest
    @EnumSource(value=ConnectionMode.class)
    void testInitChannelWithSsl(ConnectionMode connectionMode) throws Exception {
        DefaultChannelGroup trackedChannels = new DefaultChannelGroup((EventExecutor)this.channel.eventLoop());
        SslContext mockSslContext = (SslContext)Mockito.mock(SslContext.class);
        SslHandler mockSslHandler = (SslHandler)Mockito.mock(SslHandler.class);
        Mockito.when((Object)mockSslContext.applicationProtocolNegotiator()).thenReturn(() -> List.of("h2", "http/1.1"));
        Mockito.when((Object)mockSslContext.newHandler((ByteBufAllocator)ArgumentMatchers.any())).thenReturn((Object)mockSslHandler);
        NettyHttp2ConnectionInitializer initializer = new NettyHttp2ConnectionInitializer(connectionMode, (ChannelGroup)trackedChannels, mockSslContext, this.http2Settings, (ChannelHandler)Mockito.mock(ChannelHandler.class), logContext);
        initializer.initChannel((Channel)this.channel);
        ChannelPipeline pipeline = this.channel.pipeline();
        List handlerNames = pipeline.names();
        Assertions.assertInstanceOf(SslHandler.class, (Object)pipeline.first(), (String)"SslHandler should be the first handler");
        Assertions.assertNotNull((Object)pipeline.get(ApplicationProtocolNegotiationHandler.class), (String)"ALPN negotiation handler should be added");
        Assertions.assertNotNull((Object)pipeline.get(Http2FrameCodec.class), (String)"Http2FrameCodec should be added");
        Assertions.assertNotNull((Object)pipeline.get(Http2MultiplexHandler.class), (String)"Http2MultiplexHandler should be added");
        Assertions.assertEquals((Object)"SslHandler#0", handlerNames.get(0));
        Assertions.assertEquals((Object)ALPN_HANDLER_NAME, handlerNames.get(1), (String)"Pipeline should contain alpn handler");
        Assertions.assertEquals((Object)"Http2FrameCodec#0", handlerNames.get(2), (String)"Pipeline should contain Http2FrameCodec");
        Assertions.assertEquals((Object)FIRST_SETTINGS_FRAME_HANDLER_NAME, handlerNames.get(3), (String)"Pipeline should contain settings frame handler");
        Assertions.assertEquals((Object)"Http2MultiplexHandler#0", handlerNames.get(4), (String)"Pipeline should contain Http2MultiplexHandler");
        Assertions.assertEquals((Object)"DefaultChannelPipeline$TailContext#0", handlerNames.get(5));
        Assertions.assertEquals((int)6, (int)handlerNames.size());
        ((SslContext)Mockito.verify((Object)mockSslContext)).newHandler(this.channel.alloc());
        Assertions.assertEquals((int)1, (int)initializer.trackedChannels().size());
        Assertions.assertEquals((Object)this.channel, initializer.trackedChannels().iterator().next(), (String)"Channel should be added to the group");
    }

    @ParameterizedTest
    @EnumSource(value=ConnectionMode.class)
    void testGetHttp2ConnectionRetrievesHttp2ConnectionFromStreamChannel(ConnectionMode connectionMode) {
        EmbeddedChannel parentChannel = new EmbeddedChannel();
        Http2FrameCodec mockFrameCodec = (Http2FrameCodec)Mockito.mock(Http2FrameCodec.class);
        Http2Connection mockConnection = (Http2Connection)Mockito.mock(Http2Connection.class);
        Mockito.when((Object)mockFrameCodec.connection()).thenReturn((Object)mockConnection);
        parentChannel.pipeline().addLast(new ChannelHandler[]{mockFrameCodec});
        TestHttp2StreamChannel streamChannel = new TestHttp2StreamChannel((Channel)parentChannel, 1);
        Http2Connection connection = NettyHttp2ConnectionInitializer.getHttp2Connection((Http2StreamChannel)streamChannel);
        Assertions.assertNotNull((Object)connection, (String)"Http2Connection should not be null");
        Assertions.assertEquals((Object)mockConnection, (Object)connection, (String)"Retrieved connection should match the mocked connection");
    }

    @ParameterizedTest
    @EnumSource(value=ConnectionMode.class)
    void testGetHttp2ConnectionThrowsRuntimeExceptionWhenHttp2FrameCodecNotFound(ConnectionMode connectionMode) {
        EmbeddedChannel parentChannel = new EmbeddedChannel();
        TestHttp2StreamChannel streamChannel = new TestHttp2StreamChannel((Channel)parentChannel, 1);
        streamChannel.parent().pipeline().addLast(new ChannelHandler[]{(ChannelHandler)Mockito.mock(ChannelHandler.class)});
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> NettyHttp2ConnectionInitializer.getHttp2Connection((Http2StreamChannel)streamChannel));
        Assertions.assertEquals((Object)("Failed to get HTTP/2 connection from channel " + String.valueOf((Object)streamChannel)), (Object)exception.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=ConnectionMode.class)
    void testGetHttp2ConnectionRetrievesHttp2ConnectionFromConnectionChannel(ConnectionMode connectionMode) {
        Http2FrameCodec mockFrameCodec = (Http2FrameCodec)Mockito.mock(Http2FrameCodec.class);
        Http2Connection mockConnection = (Http2Connection)Mockito.mock(Http2Connection.class);
        Mockito.when((Object)mockFrameCodec.connection()).thenReturn((Object)mockConnection);
        this.channel.pipeline().addLast(new ChannelHandler[]{mockFrameCodec});
        Http2Connection connection = NettyHttp2ConnectionInitializer.getHttp2Connection((Channel)this.channel);
        Assertions.assertNotNull((Object)connection, (String)"Http2Connection should not be null");
        Assertions.assertEquals((Object)mockConnection, (Object)connection, (String)"Retrieved connection should match the mocked connection");
    }

    @ParameterizedTest
    @EnumSource(value=ConnectionMode.class)
    void testGetHttp2ConnectionThrowsRuntimeExceptionWhenHttp2FrameCodecNotFoundOnChannel(ConnectionMode connectionMode) {
        this.channel.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)Mockito.mock(ChannelHandler.class)});
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> NettyHttp2ConnectionInitializer.getHttp2Connection((Channel)this.channel));
        Assertions.assertEquals((Object)("Failed to get HTTP/2 connection from channel " + String.valueOf(this.channel)), (Object)exception.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=ConnectionMode.class)
    void testServerConnectionWindowUpdateHandlerSucceeded(ConnectionMode connectionMode) throws InterruptedException {
        LogContext logContext = (LogContext)Mockito.mock(LogContext.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logContext.logger((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        DefaultChannelGroup trackedChannels = new DefaultChannelGroup((EventExecutor)this.channel.eventLoop());
        NettyHttp2ConnectionInitializer initializer = new NettyHttp2ConnectionInitializer(connectionMode, (ChannelGroup)trackedChannels, null, this.http2Settings, (ChannelHandler)Mockito.mock(ChannelHandler.class), logContext);
        initializer.initChannel((Channel)this.channel);
        Assertions.assertNotNull((Object)this.channel.pipeline().get(FIRST_SETTINGS_FRAME_HANDLER_NAME));
        final CountDownLatch windowUpdateFrameSentLatch = new CountDownLatch(1);
        final ArrayList outboundFrames = new ArrayList();
        this.channel.pipeline().addAfter("Http2FrameCodec#0", "VerificationHandler", (ChannelHandler)new ChannelOutboundHandlerAdapter(this){
            final /* synthetic */ NettyHttp2ConnectionInitializerTest this$0;
            {
                this.this$0 = this$0;
            }

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                outboundFrames.add(msg);
                if (msg instanceof Http2WindowUpdateFrame) {
                    windowUpdateFrameSentLatch.countDown();
                }
                super.write(ctx, msg, promise);
            }
        });
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{new DefaultHttp2SettingsFrame(this.http2Settings)}));
        this.channel.runPendingTasks();
        Assertions.assertEquals((int)1, (int)this.channel.inboundMessages().size(), (String)"Channel should have one inbound message after processing SETTINGS frame");
        Assertions.assertInstanceOf(DefaultHttp2SettingsFrame.class, (Object)this.channel.readInbound(), (String)"Should read a DefaultHttp2SettingsFrame from the channel");
        Assertions.assertTrue((boolean)initializer.firstSettingsFrameReceived().isDone());
        Assertions.assertFalse((boolean)initializer.firstSettingsFrameReceived().isCancelled());
        Assertions.assertNull((Object)this.channel.pipeline().get(FIRST_SETTINGS_FRAME_HANDLER_NAME));
        Assertions.assertTrue((boolean)windowUpdateFrameSentLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)1, (int)outboundFrames.size());
        Assertions.assertInstanceOf(Http2WindowUpdateFrame.class, outboundFrames.get(0), (String)"Should have sent a Http2WindowUpdateFrame");
        ((Logger)Mockito.verify((Object)logger)).debug((String)ArgumentMatchers.eq((Object)"Expanding HTTP/2 connection window size by {} to {}"), (Object)ArgumentMatchers.eq((int)NettyHttp2ConnectionInitializerTest.expectedIncrement()), (Object)ArgumentMatchers.eq((int)0x1E00000));
        ((Logger)Mockito.verify((Object)logger)).debug((String)ArgumentMatchers.eq((Object)"HTTP/2 connection window size expanded successfully"));
        Assertions.assertEquals((int)1, (int)initializer.trackedChannels().size());
        Assertions.assertEquals((Object)this.channel, initializer.trackedChannels().iterator().next(), (String)"Channel should be added to the group");
        Assertions.assertTrue((boolean)this.channel.isOpen());
    }

    @ParameterizedTest
    @EnumSource(value=ConnectionMode.class)
    void testServerConnectionWindowUpdateHandlerFailedCloseChannel(ConnectionMode connectionMode) {
        DefaultChannelGroup trackedChannels = new DefaultChannelGroup((EventExecutor)this.channel.eventLoop());
        LogContext logContext = (LogContext)Mockito.mock(LogContext.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logContext.logger((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        NettyHttp2ConnectionInitializer initializer = new NettyHttp2ConnectionInitializer(connectionMode, (ChannelGroup)trackedChannels, null, this.http2Settings, (ChannelHandler)Mockito.mock(ChannelHandler.class), logContext);
        initializer.initChannel((Channel)this.channel);
        Assertions.assertNotNull((Object)this.channel.pipeline().get(FIRST_SETTINGS_FRAME_HANDLER_NAME));
        final RuntimeException exception = new RuntimeException("Simulated failure in writing frame");
        this.channel.pipeline().addAfter("Http2FrameCodec#0", "FailingFrameWriteHandler", (ChannelHandler)new ChannelOutboundHandlerAdapter(this){
            final /* synthetic */ NettyHttp2ConnectionInitializerTest this$0;
            {
                this.this$0 = this$0;
            }

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                if (msg instanceof Http2WindowUpdateFrame) {
                    promise.setFailure((Throwable)exception);
                }
                super.write(ctx, msg, promise);
            }
        });
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{new DefaultHttp2SettingsFrame(this.http2Settings)}));
        this.channel.runPendingTasks();
        Assertions.assertEquals((int)1, (int)this.channel.inboundMessages().size(), (String)"Channel should have one inbound message after processing SETTINGS frame");
        Assertions.assertInstanceOf(DefaultHttp2SettingsFrame.class, (Object)this.channel.readInbound(), (String)"Should read a DefaultHttp2SettingsFrame from the channel");
        Assertions.assertTrue((boolean)initializer.firstSettingsFrameReceived().isDone());
        Assertions.assertFalse((boolean)initializer.firstSettingsFrameReceived().isCancelled());
        Assertions.assertNull((Object)this.channel.pipeline().get(FIRST_SETTINGS_FRAME_HANDLER_NAME));
        ((Logger)Mockito.verify((Object)logger)).debug((String)ArgumentMatchers.eq((Object)"Expanding HTTP/2 connection window size by {} to {}"), (Object)ArgumentMatchers.eq((int)NettyHttp2ConnectionInitializerTest.expectedIncrement()), (Object)ArgumentMatchers.eq((int)0x1E00000));
        ((Logger)Mockito.verify((Object)logger)).error((String)ArgumentMatchers.eq((Object)"Failed to expand HTTP/2 connection window size, closing connection {}"), ArgumentMatchers.eq((Object)this.channel), ArgumentMatchers.eq((Object)exception));
        Assertions.assertFalse((boolean)this.channel.isOpen());
        Assertions.assertEquals((int)0, (int)initializer.trackedChannels().size());
    }

    private static int expectedIncrement() {
        int defaultInitialWindowSize = 65536;
        return 31391745;
    }
}

