/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ByteBufferAccessorTest {
    @Test
    public void testReadArray() {
        ByteBuffer buf = ByteBuffer.allocate(1024);
        ByteBufferAccessor accessor = new ByteBufferAccessor(buf);
        byte[] testArray = new byte[]{75, 97, 70};
        accessor.writeByteArray(testArray);
        accessor.writeInt(12345);
        accessor.flip();
        byte[] testArray2 = accessor.readArray(3);
        Assertions.assertArrayEquals((byte[])testArray, (byte[])testArray2);
        Assertions.assertEquals((int)12345, (int)accessor.readInt());
        Assertions.assertEquals((Object)"Error reading byte array of 3 byte(s): only 0 byte(s) available", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> accessor.readArray(3))).getMessage());
    }

    @Test
    public void testReadString() {
        ByteBuffer buf = ByteBuffer.allocate(1024);
        ByteBufferAccessor accessor = new ByteBufferAccessor(buf);
        String testString = "ABC";
        byte[] testArray = testString.getBytes(StandardCharsets.UTF_8);
        accessor.writeByteArray(testArray);
        accessor.flip();
        Assertions.assertEquals((Object)"ABC", (Object)accessor.readString(3));
        Assertions.assertEquals((Object)"Error reading byte array of 2 byte(s): only 0 byte(s) available", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> accessor.readString(2))).getMessage());
    }

    @Test
    public void closeReleasesBufferToMemoryPool() {
        ByteBuffer buf = ByteBuffer.allocate(1024);
        MemoryPool mockMemoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        ByteBufferAccessor accessor = new ByteBufferAccessor(buf, mockMemoryPool);
        accessor.close();
        ((MemoryPool)Mockito.verify((Object)mockMemoryPool)).release(buf);
    }
}

