/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredValidatorCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayableValidateCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DelayableValidateCallbackHandler.class);
    private static final AuthenticateCallbackHandler DELEGATE = new OAuthBearerUnsecuredValidatorCallbackHandler();
    static final String DELAY_MS_CONFIG_NAME = "delayMs";
    static final String INTERRUPT_BEHAVIOR_CONFIG_NAME = "interruptBehavior";
    static final String NUM_DELAY_CONNECTIONS_CONFIG_NAME = "numDelayConnections";
    static final String INTERRUPT_ERROR_MESSAGE = "Interrupted while communicating with external auth system";
    private Long delayMs = 0L;
    private Long numConnectionsDelayed = 0L;
    private Long numConnectionsToDelay = Long.MAX_VALUE;
    private InterruptBehavior interruptBehavior = InterruptBehavior.ignore;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        DELEGATE.configure(configs, saslMechanism, jaasConfigEntries);
        if (configs.containsKey(DELAY_MS_CONFIG_NAME)) {
            this.delayMs = Long.parseLong((String)configs.get(DELAY_MS_CONFIG_NAME));
        }
        if (configs.containsKey(NUM_DELAY_CONNECTIONS_CONFIG_NAME)) {
            this.numConnectionsToDelay = Long.parseLong((String)configs.get(NUM_DELAY_CONNECTIONS_CONFIG_NAME));
        }
        if (configs.containsKey(INTERRUPT_BEHAVIOR_CONFIG_NAME)) {
            this.interruptBehavior = InterruptBehavior.valueOf((String)configs.get(INTERRUPT_BEHAVIOR_CONFIG_NAME));
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks != null) {
            for (Callback c : callbacks) {
                if (!(c instanceof OAuthBearerValidatorCallback) || this.numConnectionsDelayed >= this.numConnectionsToDelay) continue;
                try {
                    Long l = this.numConnectionsDelayed;
                    this.numConnectionsDelayed = this.numConnectionsDelayed + 1L;
                    LOG.debug("handle - before {} ms. sleep", (Object)this.delayMs);
                    Thread.sleep(this.delayMs);
                    LOG.debug("handle - after sleep");
                    break;
                }
                catch (InterruptedException e) {
                    if (this.interruptBehavior == InterruptBehavior.error) {
                        LOG.debug("Interrupt generating error in test callback handler");
                        throw new RuntimeException(INTERRUPT_ERROR_MESSAGE, e);
                    }
                    if (this.interruptBehavior == InterruptBehavior.ignore) {
                        LOG.debug("Interrupt ignored by test callback handler");
                        break;
                    }
                    throw new IllegalArgumentException(String.format("Interrupt behavior %s unexpected", new Object[]{this.interruptBehavior}));
                }
            }
        }
        DELEGATE.handle(callbacks);
    }

    public void close() {
        DELEGATE.close();
    }

    public static enum InterruptBehavior {
        ignore,
        error;

    }
}

