/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.utils.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CollectionUtilsTest {
    @Test
    public void testSubtractMapRemovesSecondMapsKeys() {
        HashMap<String, String> mainMap = new HashMap<String, String>();
        mainMap.put("one", "1");
        mainMap.put("two", "2");
        mainMap.put("three", "3");
        HashMap<String, String> secondaryMap = new HashMap<String, String>();
        secondaryMap.put("one", "4");
        secondaryMap.put("two", "5");
        Map newMap = CollectionUtils.subtractMap(mainMap, secondaryMap);
        Assertions.assertEquals((int)3, (int)mainMap.size());
        Assertions.assertEquals((int)1, (int)newMap.size());
        Assertions.assertTrue((boolean)newMap.containsKey("three"));
        Assertions.assertEquals((Object)"3", newMap.get("three"));
    }

    @Test
    public void testSubtractMapDoesntRemoveAnythingWhenEmptyMap() {
        HashMap<String, String> mainMap = new HashMap<String, String>();
        mainMap.put("one", "1");
        mainMap.put("two", "2");
        mainMap.put("three", "3");
        HashMap secondaryMap = new HashMap();
        Map newMap = CollectionUtils.subtractMap(mainMap, secondaryMap);
        Assertions.assertEquals((int)3, (int)newMap.size());
        Assertions.assertEquals((Object)"1", newMap.get("one"));
        Assertions.assertEquals((Object)"2", newMap.get("two"));
        Assertions.assertEquals((Object)"3", newMap.get("three"));
        Assertions.assertNotSame((Object)newMap, mainMap);
    }
}

