/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;

public class TopicDescription {
    private final String name;
    private final boolean internal;
    private final List<TopicPartitionInfo> partitions;
    private final Set<AclOperation> authorizedOperations;
    private final Uuid topicId;
    private final TopicType topicType;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicDescription that = (TopicDescription)o;
        return this.internal == that.internal && Objects.equals(this.name, that.name) && Objects.equals(this.partitions, that.partitions) && Objects.equals(this.authorizedOperations, that.authorizedOperations) && this.topicType == that.topicType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.internal, this.partitions, this.authorizedOperations, this.topicType});
    }

    public TopicDescription(String name, boolean internal, List<TopicPartitionInfo> partitions) {
        this(name, internal, partitions, Collections.emptySet());
    }

    public TopicDescription(String name, boolean internal, List<TopicPartitionInfo> partitions, Set<AclOperation> authorizedOperations) {
        this(name, internal, partitions, authorizedOperations, Uuid.ZERO_UUID);
    }

    public TopicDescription(String name, boolean internal, List<TopicPartitionInfo> partitions, Set<AclOperation> authorizedOperations, Uuid topicId) {
        this(name, internal, partitions, authorizedOperations, topicId, TopicType.STANDARD);
    }

    public TopicDescription(String name, boolean internal, List<TopicPartitionInfo> partitions, Set<AclOperation> authorizedOperations, Uuid topicId, TopicType topicType) {
        this.name = name;
        this.internal = internal;
        this.partitions = partitions;
        this.authorizedOperations = authorizedOperations;
        this.topicId = topicId;
        this.topicType = topicType;
    }

    public String name() {
        return this.name;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public List<TopicPartitionInfo> partitions() {
        return this.partitions;
    }

    public Set<AclOperation> authorizedOperations() {
        return this.authorizedOperations;
    }

    public TopicType topicType() {
        return this.topicType;
    }

    public String toString() {
        return "(name=" + this.name + ", internal=" + this.internal + ", partitions=" + this.partitions.stream().map(TopicPartitionInfo::toString).collect(Collectors.joining(",")) + ", authorizedOperations=" + String.valueOf(this.authorizedOperations) + ", topicType=" + String.valueOf((Object)this.topicType) + ")";
    }
}

