/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.clients.admin.MemberAssignment;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MemberDescriptionTest {
    private static final String MEMBER_ID = "member_id";
    private static final Optional<String> INSTANCE_ID = Optional.of("instanceId");
    private static final String CLIENT_ID = "client_id";
    private static final String HOST = "host";
    private static final MemberAssignment ASSIGNMENT = new MemberAssignment(Collections.singleton(new TopicPartition("topic", 1)));
    private static final MemberDescription STATIC_MEMBER_DESCRIPTION = new MemberDescription("member_id", INSTANCE_ID, "client_id", "host", ASSIGNMENT, Optional.empty(), Optional.empty(), Optional.empty());

    @Test
    public void testEqualsWithoutGroupInstanceId() {
        MemberDescription dynamicMemberDescription = new MemberDescription(MEMBER_ID, Optional.empty(), CLIENT_ID, HOST, ASSIGNMENT, Optional.empty(), Optional.empty(), Optional.empty());
        MemberDescription identityDescription = new MemberDescription(MEMBER_ID, Optional.empty(), CLIENT_ID, HOST, ASSIGNMENT, Optional.empty(), Optional.empty(), Optional.empty());
        Assertions.assertNotEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)dynamicMemberDescription);
        Assertions.assertNotEquals((int)STATIC_MEMBER_DESCRIPTION.hashCode(), (int)dynamicMemberDescription.hashCode());
        Assertions.assertEquals((Object)dynamicMemberDescription, (Object)dynamicMemberDescription);
        Assertions.assertEquals((Object)dynamicMemberDescription, (Object)identityDescription);
        Assertions.assertEquals((int)dynamicMemberDescription.hashCode(), (int)identityDescription.hashCode());
    }

    @Test
    public void testEqualsWithGroupInstanceId() {
        Assertions.assertEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)STATIC_MEMBER_DESCRIPTION);
        MemberDescription identityDescription = new MemberDescription(MEMBER_ID, INSTANCE_ID, CLIENT_ID, HOST, ASSIGNMENT, Optional.empty(), Optional.empty(), Optional.empty());
        Assertions.assertEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)identityDescription);
        Assertions.assertEquals((int)STATIC_MEMBER_DESCRIPTION.hashCode(), (int)identityDescription.hashCode());
    }

    @Test
    public void testNonEqual() {
        MemberDescription newMemberDescription = new MemberDescription("new_member", INSTANCE_ID, CLIENT_ID, HOST, ASSIGNMENT, Optional.empty(), Optional.empty(), Optional.empty());
        Assertions.assertNotEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)newMemberDescription);
        Assertions.assertNotEquals((int)STATIC_MEMBER_DESCRIPTION.hashCode(), (int)newMemberDescription.hashCode());
        MemberDescription newInstanceDescription = new MemberDescription(MEMBER_ID, Optional.of("new_instance"), CLIENT_ID, HOST, ASSIGNMENT, Optional.empty(), Optional.empty(), Optional.empty());
        Assertions.assertNotEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)newInstanceDescription);
        Assertions.assertNotEquals((int)STATIC_MEMBER_DESCRIPTION.hashCode(), (int)newInstanceDescription.hashCode());
        MemberDescription newTargetAssignmentDescription = new MemberDescription(MEMBER_ID, INSTANCE_ID, CLIENT_ID, HOST, ASSIGNMENT, Optional.of(ASSIGNMENT), Optional.empty(), Optional.empty());
        Assertions.assertNotEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)newTargetAssignmentDescription);
        Assertions.assertNotEquals((int)STATIC_MEMBER_DESCRIPTION.hashCode(), (int)newTargetAssignmentDescription.hashCode());
        MemberDescription newMemberEpochDescription = new MemberDescription(MEMBER_ID, INSTANCE_ID, CLIENT_ID, HOST, ASSIGNMENT, Optional.empty(), Optional.of(1), Optional.empty());
        Assertions.assertNotEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)newMemberEpochDescription);
        Assertions.assertNotEquals((int)STATIC_MEMBER_DESCRIPTION.hashCode(), (int)newMemberEpochDescription.hashCode());
        MemberDescription newIsClassicDescription = new MemberDescription(MEMBER_ID, INSTANCE_ID, CLIENT_ID, HOST, ASSIGNMENT, Optional.empty(), Optional.empty(), Optional.of(false));
        Assertions.assertNotEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)newIsClassicDescription);
        Assertions.assertNotEquals((int)STATIC_MEMBER_DESCRIPTION.hashCode(), (int)newIsClassicDescription.hashCode());
    }
}

