/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyStream;

public class DecoratingNettyHttp2Stream
implements NettyStream {
    protected final NettyHttp2Stream delegate;

    public DecoratingNettyHttp2Stream(NettyStream delegate) {
        if (!(delegate instanceof NettyHttp2Stream)) {
            throw new IllegalArgumentException("Delegate must be an instance of " + NettyHttp2Stream.class.getSimpleName());
        }
        this.delegate = (NettyHttp2Stream)delegate;
    }

    public String streamId() {
        return this.delegate.streamId();
    }

    public SocketAddress remoteAddress() {
        return this.delegate.remoteAddress();
    }

    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    public Future<Void> send(ByteBuf data, boolean flush) {
        return this.delegate.send(data, flush);
    }

    public void flush() {
        this.delegate.flush();
    }

    public void receiveMore() {
        this.delegate.receiveMore();
    }

    public boolean isReadyForSending() {
        return this.delegate.isReadyForSending();
    }

    public Future<Void> closeStream() {
        return this.delegate.closeStream();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public ByteBufAllocator alloc() {
        return this.delegate.alloc();
    }

    public NettyStream.Priority priority() {
        return this.delegate.priority();
    }

    public void setPriority(NettyStream.Priority priority) {
        this.delegate.setPriority(priority);
    }

    public void runOnEventLoop(Runnable op, boolean forceReschedule) {
        this.delegate.runOnEventLoop(op, forceReschedule);
    }

    public boolean inEventLoop() {
        return this.delegate.inEventLoop();
    }

    public ScheduledFuture<?> scheduleWithDelayOnEventLoop(Runnable op, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithDelayOnEventLoop(op, delay, unit);
    }

    public TransferableChannel transferableChannel() {
        return this.delegate.transferableChannel();
    }

    public void setStreamHandler(NettyStream.StreamHandler handler) {
        this.delegate.setStreamHandler(handler);
    }

    public NettyStream.StreamHandler getStreamHandler() {
        return this.delegate.getStreamHandler();
    }

    public Optional<SSLSession> sslSession() {
        return this.delegate.sslSession();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.delegate.toString() + "}";
    }

    public boolean flowControlEnabled() {
        return this.delegate.flowControlEnabled();
    }

    public Http2Connection connection() {
        return this.delegate.connection();
    }

    public Http2Stream http2Stream() {
        return this.delegate.http2Stream();
    }

    public Http2LocalFlowController getLocalFlowController() {
        return (Http2LocalFlowController)this.delegate.connection().local().flowController();
    }
}

