/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.ByteBufReceive;
import org.apache.kafka.common.network.netty.ReadableByteBuf;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ReadableByteBufMultipleRequestBufferTest {
    private static final int MAX_RECEIVE_SIZE = 0x100000;
    private static final int REQUEST_SIZE_BYTES = 4;
    private static final String CLIENT_ID = "test_client_id";
    private static final short API_VERSION = 4;
    private static final ApiVersionsRequest API_VERSIONS_REQUEST = new ApiVersionsRequest.Builder().build((short)4);
    private static final MetadataRequest METADATA_REQUEST = new MetadataRequest.Builder(new MetadataRequestData().setTopics(List.of()).setAllowAutoTopicCreation(true)).build((short)4);
    private static Send apiVersionRequestSend;
    private static Send metadataRequestSend;
    private static ByteBuf serializedRequests;
    private ByteBufReceive requestBuf;

    @BeforeAll
    public static void beforeAll() {
        RequestHeader requestHeader = new RequestHeader(ApiKeys.API_VERSIONS, 4, CLIENT_ID, 100);
        apiVersionRequestSend = API_VERSIONS_REQUEST.toSend(requestHeader);
        requestHeader = new RequestHeader(ApiKeys.METADATA, 4, CLIENT_ID, 102);
        metadataRequestSend = METADATA_REQUEST.toSend(requestHeader);
    }

    @BeforeEach
    public void beforeEach() throws IOException {
        ByteBufferChannel channel = new ByteBufferChannel(apiVersionRequestSend.size() + metadataRequestSend.size());
        apiVersionRequestSend.writeTo((TransferableChannel)channel);
        metadataRequestSend.writeTo((TransferableChannel)channel);
        serializedRequests = Unpooled.wrappedBuffer((byte[])channel.buffer().array());
        this.requestBuf = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        this.requestBuf.readFrom(serializedRequests);
    }

    @AfterEach
    public void afterEach() {
        this.requestBuf.close();
    }

    @Test
    public void testParsesOnlyFirstRequest() {
        int expectedSize = this.requestBuf.requestSize();
        Assertions.assertEquals((long)(apiVersionRequestSend.size() - 4L), (long)expectedSize);
        Assertions.assertTrue((boolean)this.requestBuf.complete());
        ReadableByteBuf payload = this.requestBuf.payload();
        Assertions.assertEquals((int)expectedSize, (int)payload.remaining());
        RequestHeader header = RequestHeader.parse((ByteBuffer)payload.readByteBuffer(expectedSize));
        Assertions.assertEquals((int)0, (int)payload.remaining());
        Assertions.assertEquals((Object)ApiKeys.API_VERSIONS, (Object)header.apiKey());
        Assertions.assertEquals((short)4, (short)header.apiVersion());
        Assertions.assertEquals((Object)CLIENT_ID, (Object)header.clientId());
        Assertions.assertEquals((int)100, (int)header.correlationId());
        payload.position(header.size());
        ApiVersionsRequest parsedApiVersionsRequest = ApiVersionsRequest.parse((Readable)payload, (short)4, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((Object)API_VERSIONS_REQUEST.data(), (Object)parsedApiVersionsRequest.data());
        Assertions.assertEquals((int)0, (int)payload.remaining());
        payload.close();
    }

    @Test
    public void testParseSecondRequest() {
        this.requestBuf.close();
        this.requestBuf = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        this.requestBuf.readFrom(serializedRequests);
        int expectedSize = this.requestBuf.requestSize();
        Assertions.assertEquals((long)(metadataRequestSend.size() - 4L), (long)expectedSize);
        Assertions.assertTrue((boolean)this.requestBuf.complete());
        ReadableByteBuf payload = this.requestBuf.payload();
        Assertions.assertEquals((int)expectedSize, (int)payload.remaining());
        RequestHeader header = RequestHeader.parse((ByteBuffer)payload.readByteBuffer(expectedSize));
        Assertions.assertEquals((int)0, (int)payload.remaining());
        Assertions.assertEquals((Object)ApiKeys.METADATA, (Object)header.apiKey());
        Assertions.assertEquals((short)4, (short)header.apiVersion());
        Assertions.assertEquals((Object)CLIENT_ID, (Object)header.clientId());
        Assertions.assertEquals((int)102, (int)header.correlationId());
        payload.position(header.size());
        MetadataRequest parsedMetadataRequest = MetadataRequest.parse((Readable)payload, (short)4, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((Object)METADATA_REQUEST.data(), (Object)parsedMetadataRequest.data());
        Assertions.assertEquals((int)0, (int)payload.remaining());
        payload.close();
    }
}

