/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.ByteUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndTransactionMarkerTest {
    private final Schema v0Schema = new Schema(new Field[]{new Field("version", (Type)Type.INT16), new Field("coordinator_epoch", (Type)Type.INT32)});
    private static final List<ControlRecordType> VALID_CONTROLLER_RECORD_TYPE = Arrays.asList(ControlRecordType.COMMIT, ControlRecordType.ABORT);

    @Test
    public void testUnknownControlTypeNotAllowed() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new EndTransactionMarker(ControlRecordType.UNKNOWN, 24));
    }

    @Test
    public void testCannotDeserializeUnknownControlType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.UNKNOWN, (ByteBuffer)ByteBuffer.wrap(new byte[0])));
    }

    @Test
    public void testIllegalVersion() {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort((short)-1);
        buffer.flip();
        Assertions.assertThrows(InvalidRecordException.class, () -> EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.ABORT, (ByteBuffer)buffer));
    }

    @Test
    public void testSerde() {
        int coordinatorEpoch = 79;
        EndTransactionMarker marker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        ByteBuffer buffer = marker.serializeValue();
        EndTransactionMarker deserialized = EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.COMMIT, (ByteBuffer)buffer);
        Assertions.assertEquals((int)coordinatorEpoch, (int)deserialized.coordinatorEpoch());
    }

    @Test
    public void testDeserializeNewerVersion() {
        int coordinatorEpoch = 79;
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putShort((short)5);
        buffer.putInt(coordinatorEpoch);
        buffer.putShort((short)0);
        buffer.flip();
        EndTransactionMarker deserialized = EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.COMMIT, (ByteBuffer)buffer);
        Assertions.assertEquals((int)coordinatorEpoch, (int)deserialized.coordinatorEpoch());
    }

    @Test
    public void testSerializeAndDeserialize() {
        for (ControlRecordType type : VALID_CONTROLLER_RECORD_TYPE) {
            for (int version = 0; version <= 0; version = (int)((short)(version + 1))) {
                EndTransactionMarker marker = new EndTransactionMarker(type, 1);
                ByteBuffer buffer = marker.serializeValue();
                EndTransactionMarker deserializedMarker = EndTransactionMarker.deserializeValue((ControlRecordType)type, (ByteBuffer)buffer);
                Assertions.assertEquals((Object)marker, (Object)deserializedMarker);
            }
        }
    }

    @Test
    public void testEndTxnMarkerValueSize() {
        for (ControlRecordType type : VALID_CONTROLLER_RECORD_TYPE) {
            EndTransactionMarker marker = new EndTransactionMarker(type, 1);
            int offsetSize = ByteUtils.sizeOfVarint((int)0);
            int timestampSize = ByteUtils.sizeOfVarlong((long)0L);
            int keySize = 4;
            int valueSize = marker.serializeValue().remaining();
            int headerSize = ByteUtils.sizeOfVarint((int)Record.EMPTY_HEADERS.length);
            int totalSize = 1 + offsetSize + timestampSize + ByteUtils.sizeOfVarint((int)keySize) + keySize + ByteUtils.sizeOfVarint((int)valueSize) + valueSize + headerSize;
            Assertions.assertEquals((int)(ByteUtils.sizeOfVarint((int)totalSize) + totalSize), (int)marker.endTxnMarkerValueSize());
        }
    }

    @Test
    public void testBackwardDeserializeCompatibility() {
        int coordinatorEpoch = 10;
        for (ControlRecordType type : VALID_CONTROLLER_RECORD_TYPE) {
            for (short version = 0; version <= 0; version = (short)(version + 1)) {
                Struct struct = new Struct(this.v0Schema);
                struct.set("version", (Object)version);
                struct.set("coordinator_epoch", (Object)coordinatorEpoch);
                ByteBuffer oldVersionBuffer = ByteBuffer.allocate(struct.sizeOf());
                struct.writeTo(oldVersionBuffer);
                oldVersionBuffer.flip();
                EndTransactionMarker deserializedMarker = EndTransactionMarker.deserializeValue((ControlRecordType)type, (ByteBuffer)oldVersionBuffer);
                Assertions.assertEquals((int)coordinatorEpoch, (int)deserializedMarker.coordinatorEpoch());
                Assertions.assertEquals((Object)type, (Object)deserializedMarker.controlType());
            }
        }
    }

    @Test
    public void testForwardDeserializeCompatibility() {
        int coordinatorEpoch = 10;
        for (ControlRecordType type : VALID_CONTROLLER_RECORD_TYPE) {
            for (int version = 0; version <= 0; version = (int)((short)(version + 1))) {
                EndTransactionMarker marker = new EndTransactionMarker(type, coordinatorEpoch);
                ByteBuffer newVersionBuffer = marker.serializeValue();
                Struct struct = this.v0Schema.read(newVersionBuffer);
                EndTransactionMarker deserializedMarker = new EndTransactionMarker(type, struct.getInt("coordinator_epoch").intValue());
                Assertions.assertEquals((Object)marker, (Object)deserializedMarker);
            }
        }
    }
}

