/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.telemetry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.telemetry.ClientTelemetryState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ClientTelemetryStateTest {
    @Test
    public void testValidateTransitionForSubscriptionNeeded() {
        ArrayList<ClientTelemetryState> validStates = new ArrayList<ClientTelemetryState>();
        validStates.add(ClientTelemetryState.SUBSCRIPTION_IN_PROGRESS);
        validStates.add(ClientTelemetryState.TERMINATED);
        this.testValidateTransition(ClientTelemetryState.SUBSCRIPTION_NEEDED, validStates);
    }

    @Test
    public void testValidateTransitionForSubscriptionInProgress() {
        ArrayList<ClientTelemetryState> validStates = new ArrayList<ClientTelemetryState>();
        validStates.add(ClientTelemetryState.PUSH_NEEDED);
        validStates.add(ClientTelemetryState.SUBSCRIPTION_NEEDED);
        validStates.add(ClientTelemetryState.TERMINATING_PUSH_NEEDED);
        validStates.add(ClientTelemetryState.TERMINATED);
        this.testValidateTransition(ClientTelemetryState.SUBSCRIPTION_IN_PROGRESS, validStates);
    }

    @Test
    public void testValidateTransitionForPushNeeded() {
        ArrayList<ClientTelemetryState> validStates = new ArrayList<ClientTelemetryState>();
        validStates.add(ClientTelemetryState.PUSH_IN_PROGRESS);
        validStates.add(ClientTelemetryState.SUBSCRIPTION_NEEDED);
        validStates.add(ClientTelemetryState.TERMINATING_PUSH_NEEDED);
        validStates.add(ClientTelemetryState.TERMINATED);
        this.testValidateTransition(ClientTelemetryState.PUSH_NEEDED, validStates);
    }

    @Test
    public void testValidateTransitionForPushInProgress() {
        ArrayList<ClientTelemetryState> validStates = new ArrayList<ClientTelemetryState>();
        validStates.add(ClientTelemetryState.PUSH_NEEDED);
        validStates.add(ClientTelemetryState.SUBSCRIPTION_NEEDED);
        validStates.add(ClientTelemetryState.TERMINATING_PUSH_NEEDED);
        validStates.add(ClientTelemetryState.TERMINATED);
        this.testValidateTransition(ClientTelemetryState.PUSH_IN_PROGRESS, validStates);
    }

    @Test
    public void testValidateTransitionForTerminating() {
        ArrayList<ClientTelemetryState> validStates = new ArrayList<ClientTelemetryState>();
        validStates.add(ClientTelemetryState.TERMINATING_PUSH_IN_PROGRESS);
        validStates.add(ClientTelemetryState.TERMINATED);
        this.testValidateTransition(ClientTelemetryState.TERMINATING_PUSH_NEEDED, validStates);
    }

    @Test
    public void testValidateTransitionForTerminatingPushInProgress() {
        this.testValidateTransition(ClientTelemetryState.TERMINATING_PUSH_IN_PROGRESS, Collections.singletonList(ClientTelemetryState.TERMINATED));
    }

    @Test
    public void testValidateTransitionForTerminated() {
        this.testValidateTransition(ClientTelemetryState.TERMINATED, Collections.emptyList());
    }

    private void testValidateTransition(ClientTelemetryState oldState, List<ClientTelemetryState> validStates) {
        for (ClientTelemetryState newState : validStates) {
            oldState.validateTransition(newState);
        }
        ArrayList<ClientTelemetryState> invalidStates = new ArrayList<ClientTelemetryState>(Arrays.asList(ClientTelemetryState.values()));
        invalidStates.removeAll(validStates);
        for (ClientTelemetryState newState : invalidStates) {
            Executable e = () -> oldState.validateTransition(newState);
            String unexpectedSuccessMessage = "Should have thrown an IllegalTelemetryStateException for transitioning from " + String.valueOf(oldState) + " to " + String.valueOf(newState);
            Assertions.assertThrows(IllegalStateException.class, (Executable)e, (String)unexpectedSuccessMessage);
        }
    }
}

