/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

public class EvenClusterLoadPlanBrokerStats {
    private final int brokerId;
    private final String host;
    private final double diskMB;
    private final double diskPercent;
    private final double cpuPercent;
    private final double leaderNetworkInKBps;
    private final double followerNetworkInKBps;
    private final double networkOutKBps;
    private final double potentialNetworkOutKBps;
    private final int leaders;
    private final int replicas;

    public EvenClusterLoadPlanBrokerStats(int brokerId, String host, double diskMB, double diskPercent, double cpuPercent, double leaderNetworkInKBps, double followerNetworkInKBps, double networkOutKBps, double potentialNetworkOutKBps, int leaders, int replicas) {
        this.brokerId = brokerId;
        this.host = host;
        this.diskMB = diskMB;
        this.diskPercent = diskPercent;
        this.cpuPercent = cpuPercent;
        this.leaderNetworkInKBps = leaderNetworkInKBps;
        this.followerNetworkInKBps = followerNetworkInKBps;
        this.networkOutKBps = networkOutKBps;
        this.potentialNetworkOutKBps = potentialNetworkOutKBps;
        this.leaders = leaders;
        this.replicas = replicas;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public String host() {
        return this.host;
    }

    public double diskMB() {
        return this.diskMB;
    }

    public double diskPercent() {
        return this.diskPercent;
    }

    public double cpuPercent() {
        return this.cpuPercent;
    }

    public double leaderNetworkInKBps() {
        return this.leaderNetworkInKBps;
    }

    public double followerNetworkInKBps() {
        return this.followerNetworkInKBps;
    }

    public double networkOutKBps() {
        return this.networkOutKBps;
    }

    public double potentialNetworkOutKBps() {
        return this.potentialNetworkOutKBps;
    }

    public int leaders() {
        return this.leaders;
    }

    public int replicas() {
        return this.replicas;
    }

    public String getPrintableForm() {
        StringBuilder output = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        output.append(String.format("BROKER: {id: %d\t host: %s\t disk: %.2fMB/%.2f%%\t cpu: %.2f%%\t leader network in: %.2fKB/s\t follower network in: %.2fKB/s\t network out: %.2fKB/s\t potential network out: %.2fKB/s\t leaders/replicas: %d/%d}", this.brokerId(), this.host(), this.diskMB(), this.diskPercent(), this.cpuPercent(), this.leaderNetworkInKBps(), this.followerNetworkInKBps(), this.networkOutKBps(), this.potentialNetworkOutKBps(), this.leaders(), this.replicas()));
        output.append(lineSeparator);
        return output.toString();
    }

    public String toString() {
        return "EvenClusterLoadPlanBrokerStats{brokerId=" + this.brokerId + ", host='" + this.host + "', diskMB=" + this.diskMB + ", diskPercent=" + this.diskPercent + ", cpuPercent=" + this.cpuPercent + ", leaderNetworkInKBps=" + this.leaderNetworkInKBps + ", followerNetworkInKBps=" + this.followerNetworkInKBps + ", networkOutKBps=" + this.networkOutKBps + ", potentialNetworkOutKBps=" + this.potentialNetworkOutKBps + ", leaders=" + this.leaders + ", replicas=" + this.replicas + "}";
    }
}

