/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.DegradedBroker;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.common.message.DescribeBrokerHealthResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeBrokerHealthResponse
extends AbstractResponse {
    private final DescribeBrokerHealthResponseData data;

    public DescribeBrokerHealthResponse(DescribeBrokerHealthResponseData data) {
        super(ApiKeys.DESCRIBE_BROKER_HEALTH);
        this.data = data;
    }

    public static void maybeDowngradeResponseData(DescribeBrokerHealthResponseData data, short version) {
        if (version < 1) {
            data.degradedBrokers().stream().forEach(degradedBroker -> {
                degradedBroker.setDeprecatedReasonsV0(DescribeBrokerHealthResponse.reasonsFromDegradedBrokerComponents(degradedBroker.degradedBrokerComponents()));
                degradedBroker.setDegradedBrokerComponents(Collections.emptyList());
            });
        }
    }

    private static List<DescribeBrokerHealthResponseData.Reason> reasonsFromDegradedBrokerComponents(List<DescribeBrokerHealthResponseData.DegradedBrokerComponent> degradedBrokerComponents) {
        return degradedBrokerComponents.stream().map(degradedComponent -> new DescribeBrokerHealthResponseData.Reason().setReason(degradedComponent.reason())).collect(Collectors.toList());
    }

    public List<DegradedBroker> degradedBrokers() {
        return this.data.degradedBrokers().stream().map(broker -> {
            if (broker.degradedBrokerComponents().isEmpty()) {
                return new DegradedBroker(broker.brokerId(), broker.deprecatedReasonsV0().stream().map(reason -> new DegradedBrokerComponent(reason.reason(), BrokerComponent.UNSPECIFIED.id())).collect(Collectors.toSet()));
            }
            return new DegradedBroker(broker.brokerId(), broker.degradedBrokerComponents().stream().map(degradedBrokerComponent -> new DegradedBrokerComponent(degradedBrokerComponent.reason(), degradedBrokerComponent.componentCode())).collect(Collectors.toSet()));
        }).collect(Collectors.toList());
    }

    @Override
    public DescribeBrokerHealthResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static DescribeBrokerHealthResponse parse(Readable readable, short version, MessageContext context) {
        return new DescribeBrokerHealthResponse(new DescribeBrokerHealthResponseData(readable, version, context));
    }
}

