/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Collection;
import org.apache.kafka.common.Tenant;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.node.MetadataLeafNode;
import org.apache.kafka.image.node.MetadataNode;

public class TenantImageNode
implements MetadataNode {
    public static final String NAME = "tenants";
    private final TenantImage image;

    public TenantImageNode(TenantImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        return this.image.tenantIdToTenant().keySet();
    }

    @Override
    public MetadataNode child(String name) {
        Tenant tenant = this.image.tenantIdToTenant().get(name);
        if (tenant == null) {
            return null;
        }
        return new MetadataLeafNode(tenant.toString());
    }
}

