/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.metadata.MetadataEncryptorConfigEntry;

public class MetadataEncryptorSecrets {
    private final Map<String, MetadataEncryptorConfigEntry> entries;

    @JsonCreator
    public MetadataEncryptorSecrets(@JsonProperty(value="encryptors_by_uuid", required=true) Map<String, MetadataEncryptorConfigEntry> entries) {
        this.entries = entries == null ? Map.of() : Collections.unmodifiableMap(entries);
        for (Map.Entry<String, MetadataEncryptorConfigEntry> entry : this.entries.entrySet()) {
            if (entry.getKey() == null) {
                throw new RuntimeException("Invalid null key in map.");
            }
            if (entry.getValue() != null) continue;
            throw new RuntimeException("Invalid null value for " + entry.getKey() + " in map.");
        }
    }

    @JsonProperty(value="encryptors_by_uuid")
    public Map<String, MetadataEncryptorConfigEntry> entries() {
        return this.entries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetadataEncryptorSecrets)) {
            return false;
        }
        MetadataEncryptorSecrets that = (MetadataEncryptorSecrets)o;
        return Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hash(this.entries);
    }
}

