/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;

public enum TransactionVersion implements FeatureVersion
{
    TV_0(0, MetadataVersion.MINIMUM_VERSION, Collections.emptyMap()),
    TV_1(1, MetadataVersion.IBP_4_0_IV2A, Collections.emptyMap()),
    TV_2(2, MetadataVersion.IBP_4_0_IV2A, Collections.emptyMap());

    public static final String FEATURE_NAME = "transaction.version";
    public static final TransactionVersion LATEST_PRODUCTION;
    private final short featureLevel;
    private final MetadataVersion bootstrapMetadataVersion;
    private final Map<String, Short> dependencies;

    private TransactionVersion(int featureLevel, MetadataVersion bootstrapMetadataVersion, Map<String, Short> dependencies) {
        this.featureLevel = (short)featureLevel;
        this.bootstrapMetadataVersion = bootstrapMetadataVersion;
        this.dependencies = dependencies;
    }

    @Override
    public short featureLevel() {
        return this.featureLevel;
    }

    public static TransactionVersion fromFeatureLevel(short version) {
        return (TransactionVersion)Feature.TRANSACTION_VERSION.fromFeatureLevel(version, true);
    }

    public static TransactionVersion transactionVersionForAddPartitionsToTxn(AddPartitionsToTxnRequest request) {
        return request.version() > 3 ? TV_2 : TV_0;
    }

    public static TransactionVersion transactionVersionForEndTxn(EndTxnRequest request) {
        return request.version() > 4 ? TV_2 : TV_0;
    }

    @Override
    public String featureName() {
        return FEATURE_NAME;
    }

    @Override
    public MetadataVersion bootstrapMetadataVersion() {
        return this.bootstrapMetadataVersion;
    }

    @Override
    public Map<String, Short> dependencies() {
        return this.dependencies;
    }

    public short transactionLogValueVersion() {
        return (short)(this.featureLevel >= 1 ? 1 : 0);
    }

    public boolean supportsEpochBump() {
        return this.featureLevel >= 2;
    }

    static {
        LATEST_PRODUCTION = TV_2;
    }
}

