/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import org.apache.kafka.server.quota.ClientQuotaType;

public enum QuotaType {
    FETCH("Fetch"),
    PRODUCE("Produce"),
    REQUEST("Request"),
    CONTROLLER_MUTATION("ControllerMutation"),
    LEADER_REPLICATION("LeaderReplication"),
    FOLLOWER_REPLICATION("FollowerReplication"),
    ALTER_LOG_DIRS_REPLICATION("AlterLogDirsReplication"),
    CLUSTER_LINK_REPLICATION("ClusterLinkReplication"),
    CLUSTER_LINK_REQUEST("ClusterLinkRequest"),
    PRODUCER_ID("ProducerId"),
    RLM_COPY("RLMCopy"),
    RLM_FETCH("RLMFetch");

    private final String name;

    private QuotaType(String name) {
        this.name = name;
    }

    public static ClientQuotaType toClientQuotaType(QuotaType quotaType) {
        switch (quotaType.ordinal()) {
            case 0: {
                return ClientQuotaType.FETCH;
            }
            case 1: {
                return ClientQuotaType.PRODUCE;
            }
            case 2: {
                return ClientQuotaType.REQUEST;
            }
            case 3: {
                return ClientQuotaType.CONTROLLER_MUTATION;
            }
            case 9: {
                return ClientQuotaType.PRODUCER_ID;
            }
            case 8: {
                return ClientQuotaType.LINK_REQUEST;
            }
        }
        throw new IllegalArgumentException("Not a client quota type: " + String.valueOf((Object)quotaType));
    }

    public static QuotaType fromClientQuotaType(ClientQuotaType clientQuotaType) {
        switch (clientQuotaType) {
            case FETCH: {
                return FETCH;
            }
            case PRODUCE: {
                return PRODUCE;
            }
            case REQUEST: {
                return REQUEST;
            }
            case CONTROLLER_MUTATION: {
                return CONTROLLER_MUTATION;
            }
            case PRODUCER_ID: {
                return PRODUCER_ID;
            }
            case LINK_REQUEST: {
                return CLUSTER_LINK_REQUEST;
            }
        }
        throw new IllegalArgumentException("Not a client quota type: " + String.valueOf(clientQuotaType));
    }

    public String toString() {
        return this.name;
    }
}

