/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;

public class SensorAccess {
    private static final Optional<Sensor> DEFAULT_PARENT_SENSOR = Optional.empty();
    private static final Supplier<Boolean> DEFAULT_SENSOR_CREATION_PREDICATE = () -> true;
    private final ReadWriteLock lock;
    private final Metrics metrics;

    public SensorAccess(ReadWriteLock lock, Metrics metrics) {
        this.lock = lock;
        this.metrics = metrics;
    }

    public Sensor getOrCreate(String sensorName, long expirationTime, Consumer<Sensor> registerMetrics, Consumer<Sensor> onExpiration) {
        return this.getOrCreateWithParent(sensorName, expirationTime, DEFAULT_PARENT_SENSOR, registerMetrics, onExpiration);
    }

    public Sensor getOrCreate(String sensorName, long expirationTime, Consumer<Sensor> registerMetrics) {
        return this.getOrCreateWithParent(sensorName, expirationTime, DEFAULT_PARENT_SENSOR, registerMetrics);
    }

    public Sensor getOrCreateWithParent(String sensorName, long expirationTime, Optional<Sensor> parentSensor, Consumer<Sensor> registerMetrics) {
        return this.getOrCreateWithParent(sensorName, expirationTime, parentSensor, registerMetrics, Sensor.EMPTY_REMOVE_CALLBACK);
    }

    public Sensor getOrCreateWithParent(String sensorName, long expirationTime, Optional<Sensor> parentSensor, Consumer<Sensor> registerMetrics, Consumer<Sensor> onExpiration) {
        return this.mayGetOrCreate(sensorName, expirationTime, parentSensor, registerMetrics, DEFAULT_SENSOR_CREATION_PREDICATE, onExpiration).orElseThrow(() -> new IllegalStateException("SensorAccess failed to create the sensor " + sensorName + " with the default sensor creation predicate."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Sensor> mayGetOrCreate(String sensorName, long expirationTime, Optional<Sensor> parentSensor, Consumer<Sensor> registerMetrics, Supplier<Boolean> sensorCreationPredicate, Consumer<Sensor> onExpiration) {
        Sensor sensor;
        block12: {
            this.lock.readLock().lock();
            try {
                sensor = this.metrics.getSensor(sensorName);
            }
            finally {
                this.lock.readLock().unlock();
            }
            if (sensor == null) {
                this.lock.writeLock().lock();
                try {
                    sensor = this.metrics.getSensor(sensorName);
                    if (sensor != null || !sensorCreationPredicate.get().booleanValue()) break block12;
                    Sensor sensor2 = sensor = parentSensor.map(parent -> this.metrics.sensor(sensorName, null, expirationTime, Sensor.RecordingLevel.INFO, onExpiration, new Sensor[]{parent})).orElse(this.metrics.sensor(sensorName, null, expirationTime, Sensor.RecordingLevel.INFO, onExpiration, new Sensor[0]));
                    synchronized (sensor2) {
                        if (this.metrics.getSensor(sensorName) == sensor) {
                            registerMetrics.accept(sensor);
                        }
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
        return Optional.ofNullable(sensor);
    }
}

