/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LockUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T inLock(Lock lock, Supplier<T> supplier) {
        Objects.requireNonNull(lock, "Lock must not be null");
        Objects.requireNonNull(supplier, "Supplier must not be null");
        boolean locked = true;
        lock.lock();
        try {
            T t = supplier.get();
            lock.unlock();
            return t;
        }
        catch (Throwable throwable) {
            try {
                lock.unlock();
                locked = false;
                throw throwable;
            }
            catch (Exception e) {
                if (!locked) throw e;
                LOG.warn("Potential lock issue: exception before unlocking lock " + String.valueOf(lock) + ":", (Throwable)e);
                throw e;
            }
        }
    }
}

