/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Map;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;

public enum StreamsVersion implements FeatureVersion
{
    SV_0(0, MetadataVersion.MINIMUM_VERSION, Map.of()),
    SV_1(1, MetadataVersion.IBP_4_2_IV1A, Map.of());

    public static final String FEATURE_NAME = "streams.version";
    public static final StreamsVersion LATEST_PRODUCTION;
    private final short featureLevel;
    private final MetadataVersion bootstrapMetadataVersion;
    private final Map<String, Short> dependencies;

    private StreamsVersion(int featureLevel, MetadataVersion bootstrapMetadataVersion, Map<String, Short> dependencies) {
        this.featureLevel = (short)featureLevel;
        this.bootstrapMetadataVersion = bootstrapMetadataVersion;
        this.dependencies = dependencies;
    }

    @Override
    public short featureLevel() {
        return this.featureLevel;
    }

    @Override
    public String featureName() {
        return FEATURE_NAME;
    }

    @Override
    public MetadataVersion bootstrapMetadataVersion() {
        return this.bootstrapMetadataVersion;
    }

    @Override
    public Map<String, Short> dependencies() {
        return this.dependencies;
    }

    public boolean streamsGroupSupported() {
        return this.featureLevel >= StreamsVersion.SV_1.featureLevel;
    }

    public static StreamsVersion fromFeatureLevel(short version) {
        return switch (version) {
            case 0 -> SV_0;
            case 1 -> SV_1;
            default -> throw new RuntimeException("Unknown streams feature level: " + version);
        };
    }

    static {
        LATEST_PRODUCTION = SV_1;
    }
}

