/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.network;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.network.GenericConnectionQuotaEntity;

public class ListenerQuotaEntity
implements GenericConnectionQuotaEntity {
    private final String listenerName;

    public ListenerQuotaEntity(String listenerName) {
        this.listenerName = listenerName;
    }

    @Override
    public String rateSensorName() {
        return "Connection-Accept-Rate-" + this.listenerName;
    }

    @Override
    public String countSensorName() {
        return "Connection-Count-" + this.listenerName;
    }

    @Override
    public long sensorExpiration() {
        return Long.MAX_VALUE;
    }

    @Override
    public String quotaMetricName() {
        return "connection-tokens";
    }

    @Override
    public String countMetricName() {
        return "authenticated-unthrottled-connection-count";
    }

    @Override
    public Map<String, String> metricTags() {
        return Collections.singletonMap("listener", this.listenerName);
    }

    @Override
    public String domain() {
        return "listener";
    }

    @Override
    public String entityName() {
        return "listener";
    }
}

