/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import java.util.HashSet;
import org.apache.kafka.common.config.ConfigDef;

public class ReplicationQuotaManagerConfig {
    public static final String ALL_THROTTLED_REPLICAS_VALUE = "*";
    public static final String NO_THROTTLED_REPLICAS_VALUE = "none";
    public static final boolean DEFAULT_ALL_REPLICAS_THROTTLED = false;
    public static final int INACTIVE_SENSOR_EXPIRATION_TIME_SECONDS = 3600;
    public static final String LEADER_REPLICATION_THROTTLED_RATE_PROP = "leader.replication.throttled.rate";
    public static final String FOLLOWER_REPLICATION_THROTTLED_RATE_PROP = "follower.replication.throttled.rate";
    public static final String LEADER_REPLICATION_THROTTLED_REPLICAS_PROP = "leader.replication.throttled.replicas";
    public static final String FOLLOWER_REPLICATION_THROTTLED_REPLICAS_PROP = "follower.replication.throttled.replicas";
    public static final HashSet<String> RECONFIGURABLE_CONFIGS = new HashSet();
    public final long quotaBytesPerSecondDefault;
    public final int numQuotaSamples;
    public final int quotaWindowSizeSeconds;
    public final boolean allReplicasThrottled;

    public ReplicationQuotaManagerConfig(long quotaBytesPerSecondDefault, int numQuotaSamples, int quotaWindowSizeSeconds, boolean allReplicasThrottled) {
        this.quotaBytesPerSecondDefault = quotaBytesPerSecondDefault;
        this.numQuotaSamples = numQuotaSamples;
        this.quotaWindowSizeSeconds = quotaWindowSizeSeconds;
        this.allReplicasThrottled = allReplicasThrottled;
    }

    public ReplicationQuotaManagerConfig(int numQuotaSamples, int quotaWindowSizeSeconds) {
        this(Long.MAX_VALUE, numQuotaSamples, quotaWindowSizeSeconds, false);
    }

    public ReplicationQuotaManagerConfig(long quotaBytesPerSecondDefault) {
        this(quotaBytesPerSecondDefault, 11, 1, false);
    }

    public ReplicationQuotaManagerConfig(boolean allReplicasThrottled) {
        this(Long.MAX_VALUE, 11, 1, allReplicasThrottled);
    }

    public ReplicationQuotaManagerConfig() {
        this(Long.MAX_VALUE, 11, 1, false);
    }

    public static boolean allReplicasThrottled(String throttledReplicas) {
        return ALL_THROTTLED_REPLICAS_VALUE.equals(throttledReplicas);
    }

    public static ConfigDef.Validator throttledReplicasValidator() {
        return ConfigDef.ValidString.in((String[])new String[]{NO_THROTTLED_REPLICAS_VALUE, ALL_THROTTLED_REPLICAS_VALUE});
    }

    static {
        RECONFIGURABLE_CONFIGS.add(LEADER_REPLICATION_THROTTLED_RATE_PROP);
        RECONFIGURABLE_CONFIGS.add(FOLLOWER_REPLICATION_THROTTLED_RATE_PROP);
        RECONFIGURABLE_CONFIGS.add(LEADER_REPLICATION_THROTTLED_REPLICAS_PROP);
        RECONFIGURABLE_CONFIGS.add(FOLLOWER_REPLICATION_THROTTLED_REPLICAS_PROP);
    }
}

