/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.security.authorizer;

import com.yammer.metrics.core.MetricName;
import java.net.InetAddress;
import java.util.Map;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.BrokerFqdnBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizerUtils.class);
    private static final MetricName ACL_COUNT_METRIC_NAME = KafkaMetricsGroup.explicitMetricName((String)"kafka.security.authorizer", (String)"AclMetrics", (String)"AclCount", Map.of());
    private static final KafkaMetricsGroup METRICS_GROUP = new KafkaMetricsGroup(AuthorizerUtils.class);

    public static Plugin<Authorizer> createAuthorizer(String className, Map<String, Object> configs, Metrics metrics, String key, String role) throws ClassNotFoundException {
        Authorizer authorizer = (Authorizer)Utils.newInstance((String)className, Authorizer.class);
        authorizer.configure(configs);
        METRICS_GROUP.newGauge(ACL_COUNT_METRIC_NAME, () -> ((Authorizer)authorizer).aclCount());
        return Plugin.wrapInstance((Object)authorizer, (Metrics)metrics, (String)key, (String)"role", (String)role);
    }

    public static boolean isClusterResource(String name) {
        return name.endsWith("kafka-cluster");
    }

    public static void closeAuthorizer(Plugin<Authorizer> authorizer) {
        Utils.closeQuietly((AutoCloseable)((AutoCloseable)authorizer.get()), (String)"authorizer");
        METRICS_GROUP.removeMetric(ACL_COUNT_METRIC_NAME);
    }

    public static AuthorizableRequestContext sessionToRequestContext(final Session session) {
        return new AuthorizableRequestContext(){

            public String clientId() {
                return "";
            }

            public int requestType() {
                return -1;
            }

            public String listenerName() {
                return "";
            }

            public InetAddress clientAddress() {
                return session.clientAddress;
            }

            public boolean isProxyModeLocal() {
                return false;
            }

            public BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2() {
                return null;
            }

            public KafkaPrincipal principal() {
                return session.principal;
            }

            public SecurityProtocol securityProtocol() {
                return null;
            }

            public int correlationId() {
                return -1;
            }

            public int requestVersion() {
                return -1;
            }
        };
    }
}

