/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.server.AbstractLogReadResult;
import org.apache.kafka.storage.internals.log.FetchDataInfo;

public class LogReadResult
implements AbstractLogReadResult {
    private final FetchDataInfo info;
    private final Optional<FetchResponseData.EpochEndOffset> divergingEpoch;
    private final long highWatermark;
    private final long leaderLogStartOffset;
    private final long leaderLogEndOffset;
    private final long followerLogStartOffset;
    private final long fetchTimeMs;
    private final OptionalLong lastStableOffset;
    private final boolean isReadAllowed;
    private final boolean highOrLowWatermarkUpdated;
    private final OptionalInt preferredReadReplica;
    private final Optional<Throwable> exception;
    private final long readLatencyNanos;

    public LogReadResult(FetchDataInfo info, Optional<FetchResponseData.EpochEndOffset> divergingEpoch, long highWatermark, long leaderLogStartOffset, long leaderLogEndOffset, long followerLogStartOffset, long fetchTimeMs, OptionalLong lastStableOffset, boolean isReadAllowed, boolean highOrLowWatermarkUpdated, OptionalInt preferredReadReplica, Optional<Throwable> exception, long readLatencyNanos) {
        this.info = info;
        this.divergingEpoch = divergingEpoch;
        this.highWatermark = highWatermark;
        this.leaderLogStartOffset = leaderLogStartOffset;
        this.leaderLogEndOffset = leaderLogEndOffset;
        this.followerLogStartOffset = followerLogStartOffset;
        this.fetchTimeMs = fetchTimeMs;
        this.lastStableOffset = lastStableOffset;
        this.isReadAllowed = isReadAllowed;
        this.highOrLowWatermarkUpdated = highOrLowWatermarkUpdated;
        this.preferredReadReplica = preferredReadReplica;
        this.exception = exception;
        this.readLatencyNanos = readLatencyNanos;
    }

    public LogReadResult(FetchDataInfo info, Optional<FetchResponseData.EpochEndOffset> divergingEpoch, long highWatermark, long leaderLogStartOffset, long leaderLogEndOffset, long followerLogStartOffset, long fetchTimeMs, OptionalLong lastStableOffset, boolean isReadAllowed, boolean highOrLowWatermarkUpdated) {
        this(info, divergingEpoch, highWatermark, leaderLogStartOffset, leaderLogEndOffset, followerLogStartOffset, fetchTimeMs, lastStableOffset, isReadAllowed, highOrLowWatermarkUpdated, OptionalInt.empty(), Optional.empty(), 0L);
    }

    public static LogReadResult of(Throwable exception) {
        return new LogReadResult(FetchDataInfo.EMPTY, Optional.empty(), -1L, -1L, -1L, -1L, -1L, OptionalLong.empty(), false, false, OptionalInt.empty(), Optional.of(exception), 0L);
    }

    public FetchDataInfo info() {
        return this.info;
    }

    @Override
    public Optional<FetchResponseData.EpochEndOffset> divergingEpoch() {
        return this.divergingEpoch;
    }

    @Override
    public long highWatermark() {
        return this.highWatermark;
    }

    @Override
    public long leaderLogStartOffset() {
        return this.leaderLogStartOffset;
    }

    @Override
    public long leaderLogEndOffset() {
        return this.leaderLogEndOffset;
    }

    public long followerLogStartOffset() {
        return this.followerLogStartOffset;
    }

    @Override
    public long fetchTimeMs() {
        return this.fetchTimeMs;
    }

    @Override
    public OptionalLong lastStableOffset() {
        return this.lastStableOffset;
    }

    public boolean isReadAllowed() {
        return this.isReadAllowed;
    }

    public boolean highOrLowWatermarkUpdated() {
        return this.highOrLowWatermarkUpdated;
    }

    @Override
    public OptionalInt preferredReadReplica() {
        return this.preferredReadReplica;
    }

    @Override
    public Optional<Throwable> exception() {
        return this.exception;
    }

    @Override
    public long readLatencyNanos() {
        return this.readLatencyNanos;
    }

    @Override
    public Records records() {
        return this.info.records;
    }

    public LogReadResult withEmptyFetchInfo() {
        return new LogReadResult(FetchDataInfo.EMPTY, this.divergingEpoch, this.highWatermark, this.leaderLogStartOffset, this.leaderLogEndOffset, this.followerLogStartOffset, this.fetchTimeMs, this.lastStableOffset, this.isReadAllowed, this.highOrLowWatermarkUpdated, this.preferredReadReplica, this.exception, this.readLatencyNanos);
    }

    public String toString() {
        return "LogReadResult(info=" + String.valueOf(this.info) + ", divergingEpoch=" + String.valueOf(this.divergingEpoch) + ", highWatermark=" + this.highWatermark + ", leaderLogStartOffset=" + this.leaderLogStartOffset + ", leaderLogEndOffset=" + this.leaderLogEndOffset + ", followerLogStartOffset=" + this.followerLogStartOffset + ", fetchTimeMs=" + this.fetchTimeMs + ", readLatencyNanos=" + this.readLatencyNanos + ", isReadAllowed=" + this.isReadAllowed + ", highOrLowWatermarkUpdated=" + this.highOrLowWatermarkUpdated + ", preferredReadReplica=" + String.valueOf(this.preferredReadReplica) + ", lastStableOffset=" + String.valueOf(this.lastStableOffset) + ", error=" + String.valueOf(this.error()) + ")";
    }
}

