/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.durability.events.broker.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.IntVector;
import com.google.flatbuffers.Table;
import io.confluent.kafka.durability.events.serdes.BaseInfo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class EpochChange
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_25_2_10();
    }

    public static EpochChange getRootAsEpochChange(ByteBuffer _bb) {
        return EpochChange.getRootAsEpochChange(_bb, new EpochChange());
    }

    public static EpochChange getRootAsEpochChange(ByteBuffer _bb, EpochChange obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public EpochChange __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public long firstOffset() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public BaseInfo info() {
        return this.info(new BaseInfo());
    }

    public BaseInfo info(BaseInfo obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public int isr(int j) {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int isrLength() {
        int o = this.__offset(8);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector isrVector() {
        return this.isrVector(new IntVector());
    }

    public IntVector isrVector(IntVector obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer isrAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 4);
    }

    public ByteBuffer isrInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 4);
    }

    public int nodeId() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : -1;
    }

    public static void startEpochChange(FlatBufferBuilder builder) {
        builder.startTable(4);
    }

    public static void addFirstOffset(FlatBufferBuilder builder, long firstOffset) {
        builder.addLong(0, firstOffset, 0L);
    }

    public static void addInfo(FlatBufferBuilder builder, int infoOffset) {
        builder.addStruct(1, infoOffset, 0);
    }

    public static void addIsr(FlatBufferBuilder builder, int isrOffset) {
        builder.addOffset(2, isrOffset, 0);
    }

    public static int createIsrVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startIsrVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addNodeId(FlatBufferBuilder builder, int nodeId) {
        builder.addInt(3, nodeId, -1);
    }

    public static int endEpochChange(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishEpochChangeBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedEpochChangeBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public EpochChange get(int j) {
            return this.get(new EpochChange(), j);
        }

        public EpochChange get(EpochChange obj, int j) {
            return obj.__assign(EpochChange.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

