/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import io.confluent.kafka.storage.checksum.ChecksumAlgorithm;
import io.confluent.kafka.storage.checksum.ChecksumHeader;
import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.ChecksumStoreReaderWriter;
import io.confluent.kafka.storage.checksum.E2EChecksumMetrics;
import io.confluent.kafka.storage.checksum.algorithms.CRC64;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.kafka.common.utils.Time;

public class Crc64ChecksumStore
extends ChecksumStore {
    private static final int VERSION = 1;

    public Crc64ChecksumStore(long storeEntryTTL, Time time, ChecksumStoreReaderWriter storeReaderWriter, E2EChecksumMetrics metrics) {
        super(new ChecksumHeader(1, ChecksumAlgorithm.CRC64), storeEntryTTL, time, storeReaderWriter, metrics);
    }

    @Override
    protected ChecksumAlgorithm algorithm() {
        return ChecksumAlgorithm.CRC64;
    }

    @Override
    public Checksum emptyChecksum() {
        return new CRC64();
    }

    @Override
    protected Checksum convertLongToChecksum(long crcValue) {
        return new CRC64(crcValue);
    }

    @Override
    protected Checksum truncate(Checksum checksum, ByteBuffer bytesToTruncate) {
        throw new UnsupportedOperationException();
    }
}

