/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.state;

import java.util.HashMap;
import java.util.Map;

public enum TierPartitionStatus {
    UNINITIALIZED(0),
    INIT(1),
    CATCHUP(2),
    ONLINE(3),
    DISK_OFFLINE(4),
    ERROR(5),
    READ_ONLY(6),
    FROZEN_LOG_START_OFFSET(7),
    PENDING_DELETION(8),
    DISCOVER(9),
    DISCOVER_ERROR(10);

    final byte value;
    private static final Map<Byte, TierPartitionStatus> VALUE_TO_STATUS;

    private TierPartitionStatus(byte value) {
        this.value = value;
    }

    public boolean isOpen() {
        return this == ERROR || this == DISCOVER_ERROR || this == READ_ONLY || this == FROZEN_LOG_START_OFFSET || this.isOpenForWrite();
    }

    public boolean isOpenForWrite() {
        return this == INIT || this == DISCOVER || this == CATCHUP || this == ONLINE || this.isPendingDeletion();
    }

    public boolean isOpenForSnapshotMaterialization(TierPartitionStatus currentPhase) {
        return currentPhase == DISCOVER && (this == DISCOVER || this == ERROR || this == DISCOVER_ERROR);
    }

    public boolean isPendingDeletion() {
        return this == PENDING_DELETION;
    }

    public boolean hasError() {
        return this == ERROR || this == FROZEN_LOG_START_OFFSET || this == DISCOVER_ERROR;
    }

    public static byte toByte(TierPartitionStatus status) {
        return status.value;
    }

    public static TierPartitionStatus fromByte(byte value) {
        TierPartitionStatus status = VALUE_TO_STATUS.get(value);
        if (status == null) {
            throw new IllegalArgumentException("Unknown TierPartitionStatus byte value " + value);
        }
        return status;
    }

    static {
        VALUE_TO_STATUS = new HashMap<Byte, TierPartitionStatus>();
        for (TierPartitionStatus status : TierPartitionStatus.values()) {
            TierPartitionStatus oldStatus = VALUE_TO_STATUS.put(status.value, status);
            if (oldStatus == null) continue;
            throw new ExceptionInInitializerError("value reused for VALUE_TO_STATUS " + String.valueOf((Object)oldStatus) + " and " + String.valueOf((Object)status));
        }
    }
}

