/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.matchhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.matchhighlight.MatchRegionRetriever;
import org.apache.lucene.search.matchhighlight.OffsetRange;
import org.apache.lucene.search.matchhighlight.OffsetsRetrievalStrategy;

public final class OffsetsFromMatchIterator
implements OffsetsRetrievalStrategy {
    private final String field;

    OffsetsFromMatchIterator(String field) {
        this.field = field;
    }

    @Override
    public List<OffsetRange> get(MatchesIterator matchesIterator, MatchRegionRetriever.FieldValueProvider doc) throws IOException {
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        while (matchesIterator.next()) {
            int from = matchesIterator.startOffset();
            int to = matchesIterator.endOffset();
            if (from < 0 || to < 0) {
                throw new IOException("Matches API returned negative offsets for field: " + this.field);
            }
            ranges.add(new OffsetRange(from, to));
        }
        return ranges;
    }
}

